/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Random;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.Activity;
import org.glite.ce.creamapi.activitymanagement.db.ActivityDB;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityTableInterface;

public class ActivityTable
implements ActivityTableInterface {
    private static final Logger logger = Logger.getLogger((String)ActivityTable.class.getName());
    private static final String insertSP = "{call insertActivityTable (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
    private static final String selectSP = "{call selectActivityTable (?, ?)}";
    private static final String deleteSP = "{call deleteActivityTable (?, ?)}";
    private static final String selectActivityUserIdSP = "{call selectActivityUserId (?, ?)}";
    private static final Random activityIdGenerator = new Random();

    private synchronized String generateActivityId() {
        String suffix = "000000000" + activityIdGenerator.nextInt(1000000000);
        suffix = suffix.substring(suffix.length() - 9);
        return "CR_ES" + suffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String executeInsert(Activity activity, String userId, Connection connection) throws SQLException {
        String activityId = null;
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(2, userId);
            if (activity.getActivityIdentification() != null) {
                insertCS.setString(3, activity.getActivityIdentification().getName());
                insertCS.setString(4, activity.getActivityIdentification().getDescription());
                insertCS.setString(5, activity.getActivityIdentification().getType() != null ? activity.getActivityIdentification().getType().value() : null);
            } else {
                insertCS.setString(3, null);
                insertCS.setString(4, null);
                insertCS.setString(5, null);
            }
            if (activity.getApplication() != null) {
                insertCS.setString(6, activity.getApplication().getInput());
                insertCS.setString(7, activity.getApplication().getOutput());
                insertCS.setString(8, activity.getApplication().getError());
                if (activity.getApplication().getExpirationTime() != null) {
                    XMLGregorianCalendar expiration_time_date = activity.getApplication().getExpirationTime().getValue();
                    insertCS.setTimestamp(9, new Timestamp(expiration_time_date.toGregorianCalendar().getTimeInMillis()));
                    insertCS.setBoolean(10, activity.getApplication().getExpirationTime().isOptional());
                } else {
                    insertCS.setTimestamp(9, null);
                    insertCS.setBoolean(10, false);
                }
                if (activity.getApplication().getWipeTime() != null) {
                    Duration duration = activity.getApplication().getWipeTime().getValue();
                    insertCS.setString(11, duration.toString());
                    insertCS.setBoolean(12, activity.getApplication().getWipeTime().isOptional());
                } else {
                    insertCS.setString(11, null);
                    insertCS.setBoolean(12, false);
                }
            }
            if (activity.getDataStaging() != null && activity.getDataStaging().isClientDataPush() != null) {
                insertCS.setBoolean(13, (boolean)activity.getDataStaging().isClientDataPush());
            } else {
                insertCS.setBoolean(13, false);
            }
            if (activity.getResources() == null || activity.getResources().getQueueName() == null) {
                throw new SQLException("QueueName must be set.");
            }
            insertCS.setString(14, activity.getResources().getQueueName());
            boolean inserted = false;
            int attempt = 1;
            while (!inserted) {
                try {
                    activityId = this.generateActivityId();
                    insertCS.setString(1, activityId);
                    insertCS.execute();
                    inserted = true;
                    logger.debug((Object)"insert into ActivityTable done");
                }
                catch (SQLException se) {
                    if (++attempt <= 5) continue;
                    throw se;
                    return activityId;
                }
            }
        }
        catch (SQLException se) {
            logger.error((Object)se.getMessage());
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public ActivityDB executeSelect(String activityId, String userId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ActivityDB activityDB = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setString(1, activityId);
            selectCS.setString(2, userId);
            if (selectCS.execute()) {
                activityDB = new ActivityDB();
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    activityDB.setActivityId(activityId);
                    activityDB.setUserId(userId);
                    activityDB.setName(resultSet.getString("name"));
                    activityDB.setDescription(resultSet.getString("description"));
                    activityDB.setType(resultSet.getString("type"));
                    activityDB.setInput(resultSet.getString("input"));
                    activityDB.setOutput(resultSet.getString("output"));
                    activityDB.setError(resultSet.getString("error"));
                    Timestamp timeStampField = null;
                    Calendar calendar = null;
                    timeStampField = resultSet.getTimestamp("expiration_time_date");
                    if (timeStampField != null) {
                        calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(timeStampField.getTime());
                        activityDB.setExpirationTimeDate(calendar);
                    }
                    activityDB.setExpirationTimeOptional(resultSet.getBoolean("expiration_time_optional"));
                    String durationString = resultSet.getString("wipe_time_duration");
                    if (durationString != null) {
                        try {
                            activityDB.setWipeTimeDuration(DatatypeFactory.newInstance().newDurationDayTime(durationString));
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error in WipeTimeDuration: " + e.getMessage()));
                            throw new SQLException("Error in WipeTimeDuration: " + e.getMessage());
                        }
                    }
                    activityDB.setWipeTimeOptional(resultSet.getBoolean("wipe_time_optional"));
                    activityDB.setClientDataPush(resultSet.getBoolean("client_data_push"));
                    activityDB.setQueueName(resultSet.getString("queue_name"));
                }
            }
            logger.debug((Object)"select ActivityTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return activityDB;
    }

    public void executeDelete(String activityId, String userId, Connection connection) throws SQLException {
        CallableStatement deleteCS = null;
        int rowCount = 0;
        try {
            deleteCS = connection.prepareCall(deleteSP);
            deleteCS.setString(1, activityId);
            deleteCS.setString(2, userId);
            rowCount = deleteCS.executeUpdate();
            logger.info((Object)("activityId = " + activityId + " deleted."));
        }
        catch (SQLException se) {
            logger.error((Object)se.getMessage());
            throw se;
        }
        finally {
            try {
                if (deleteCS != null) {
                    deleteCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public ActivityTableInterface.UserEnabledForActivity isUserEnabled(String activityId, String userId, Connection connection) {
        logger.debug((Object)("Begin isUserEnabled for userID = " + userId));
        CallableStatement selectActivityUserIdCS = null;
        ActivityTableInterface.UserEnabledForActivity userEnabledForActivity = ActivityTableInterface.UserEnabledForActivity.NO;
        if (userId == null) {
            userEnabledForActivity = ActivityTableInterface.UserEnabledForActivity.YES;
        } else {
            try {
                selectActivityUserIdCS = connection.prepareCall(selectActivityUserIdSP);
                selectActivityUserIdCS.setString(1, activityId);
                selectActivityUserIdCS.registerOutParameter(2, 12);
                selectActivityUserIdCS.execute();
                String userIdFromDB = selectActivityUserIdCS.getString(2);
                logger.debug((Object)("userIdFromDB = " + userIdFromDB + " for activityId = " + activityId));
                if (userIdFromDB == null) {
                    userEnabledForActivity = ActivityTableInterface.UserEnabledForActivity.NO_FOR_ACTIVITY_NOT_FOUND;
                } else if (userId.equals(userIdFromDB)) {
                    userEnabledForActivity = ActivityTableInterface.UserEnabledForActivity.YES;
                }
            }
            catch (SQLException sqle) {
                logger.error((Object)("Problem to retrieve userId from DB : " + sqle.getMessage()));
            }
        }
        logger.debug((Object)("End isUserEnabled for userID = " + userId));
        return userEnabledForActivity;
    }
}

