/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityExecutableTypeTableInterface;

public class ActivityExecutableTypeTable
implements ActivityExecutableTypeTableInterface {
    private static final Logger logger = Logger.getLogger((String)ActivityExecutableTypeTable.class.getName());
    private static final String insertSP = "{call insertActivityExecutableTypeTable (?, ?, ?)}";
    private static final String selectSP = "{call selectActivityExecutableTypeTable (?, ?)}";

    public void executeInsert(String activityId, long executableTypeId, String type, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(1, activityId);
            insertCS.setLong(2, executableTypeId);
            insertCS.setString(3, type);
            insertCS.execute();
            logger.debug((Object)"insert into ActivityExecutableTypeTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<Long> executeSelect(String activityId, String type, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<Long> executableTypeIdList = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setString(1, activityId);
            selectCS.setString(2, type);
            if (selectCS.execute()) {
                executableTypeIdList = new ArrayList<Long>(0);
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    executableTypeIdList.add(resultSet.getLong("executable_type_id"));
                }
            }
            logger.debug((Object)"select ActivityExecutableTypeTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return executableTypeIdList;
    }
}

