/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.commonj.db.DatasourceManager;
import org.glite.ce.commonj.utils.CEUtils;
import org.glite.ce.cream.activitymanagement.db.table.ActivityCommandTable;
import org.glite.ce.cream.activitymanagement.db.table.ActivityExecutableTypeTable;
import org.glite.ce.cream.activitymanagement.db.table.ActivityPropertyTable;
import org.glite.ce.cream.activitymanagement.db.table.ActivityStatusAttributeTable;
import org.glite.ce.cream.activitymanagement.db.table.ActivityStatusTable;
import org.glite.ce.cream.activitymanagement.db.table.ActivityTable;
import org.glite.ce.cream.activitymanagement.db.table.AnnotationTable;
import org.glite.ce.cream.activitymanagement.db.table.EnvironmentTable;
import org.glite.ce.cream.activitymanagement.db.table.ExecutableTypeArgumentTable;
import org.glite.ce.cream.activitymanagement.db.table.ExecutableTypeTable;
import org.glite.ce.cream.activitymanagement.db.table.InputFileTable;
import org.glite.ce.cream.activitymanagement.db.table.NotificationOnStateTable;
import org.glite.ce.cream.activitymanagement.db.table.NotificationTable;
import org.glite.ce.cream.activitymanagement.db.table.OutputFileTable;
import org.glite.ce.cream.activitymanagement.db.table.RecipientTable;
import org.glite.ce.cream.activitymanagement.db.table.RemoteLoggingTable;
import org.glite.ce.creamapi.activitymanagement.Activity;
import org.glite.ce.creamapi.activitymanagement.ActivityCommand;
import org.glite.ce.creamapi.activitymanagement.ActivityStatus;
import org.glite.ce.creamapi.activitymanagement.ListActivitiesResult;
import org.glite.ce.creamapi.activitymanagement.db.ActivityDB;
import org.glite.ce.creamapi.activitymanagement.db.ActivityDBInterface;
import org.glite.ce.creamapi.activitymanagement.db.NotificationDB;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityCommandTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityExecutableTypeTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityPropertyTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityStatusAttributeTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityStatusTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.AnnotationTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.EnvironmentTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.ExecutableTypeArgumentTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.ExecutableTypeTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.InputFileTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.NotificationOnStateTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.NotificationTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.OutputFileTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.RecipientTableInterface;
import org.glite.ce.creamapi.activitymanagement.db.table.RemoteLoggingTableInterface;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ActivityIdentification;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ActivityTypeEnumeration;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.Application;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.DataStaging;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ExecutableType;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.InputFile;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.Notification;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionType;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionalDuration;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionalTime;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OutputFile;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.RemoteLogging;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.Resources;
import org.glite.ce.creamapi.activitymanagement.wrapper.creation.types.PrimaryActivityStatus;

public class ActivityDBImplementation
implements ActivityDBInterface {
    private static final Logger logger = Logger.getLogger((String)ActivityDBImplementation.class.getName());
    private ActivityTableInterface activityTable = new ActivityTable();
    private ActivityStatusTableInterface activityStatusTable = new ActivityStatusTable();
    private ActivityCommandTableInterface activityCommandTable = new ActivityCommandTable();
    private ActivityPropertyTableInterface activityPropertyTable = new ActivityPropertyTable();
    private ActivityStatusAttributeTableInterface activityStatusAttributeTable = new ActivityStatusAttributeTable();
    private ActivityExecutableTypeTableInterface activityExecutableTypeTable = new ActivityExecutableTypeTable();
    private ExecutableTypeTableInterface executableTypeTable = new ExecutableTypeTable();
    private ExecutableTypeArgumentTableInterface executableTypeArgumentTable = new ExecutableTypeArgumentTable();
    private EnvironmentTableInterface environmentTable = new EnvironmentTable();
    private RemoteLoggingTableInterface remoteLoggingTable = new RemoteLoggingTable();
    private AnnotationTableInterface annotationTable = new AnnotationTable();
    private NotificationTableInterface notificationTable = new NotificationTable();
    private RecipientTableInterface recipientTable = new RecipientTable();
    private NotificationOnStateTableInterface notificationOnStateTable = new NotificationOnStateTable();
    private InputFileTableInterface inputFileTable = new InputFileTable();
    private OutputFileTableInterface outputFileTable = new OutputFileTable();

    public String insertActivity(Activity activity) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin insert ActivityDescription");
        if (activity == null) {
            throw new IllegalArgumentException("activityDescription is null.");
        }
        if (activity.getUserId() == null) {
            throw new IllegalArgumentException("userId is null.");
        }
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        String activityId = null;
        try {
            activityId = this.activityTable.executeInsert(activity, activity.getUserId(), connection);
            if (activity.getStates() != null) {
                long activityStatusId = 0L;
                for (ActivityStatus activityStatus : activity.getStates()) {
                    activityStatusId = this.activityStatusTable.executeInsert(activityId, activityStatus, connection);
                    activityStatus.setId(activityStatusId);
                    if (activityStatus.getStatusAttributes() == null || activityStatus.getStatusAttributes().isEmpty()) continue;
                    this.activityStatusAttributeTable.executeInsert(activityStatusId, activityStatus.getStatusAttributes(), connection);
                }
            }
            if (activity.getCommands() != null && !activity.getCommands().isEmpty()) {
                for (ActivityCommand activityCommand : activity.getCommands()) {
                    this.activityCommandTable.executeInsert(activityId, activityCommand, connection);
                }
            }
            if (activity.getProperties() != null && !activity.getProperties().isEmpty()) {
                this.activityPropertyTable.executeInsert(activityId, activity.getProperties(), connection);
            }
            if (activity.getActivityIdentification() != null && activity.getActivityIdentification().getAnnotation() != null) {
                for (String annotation : activity.getActivityIdentification().getAnnotation()) {
                    this.annotationTable.executeInsert(activityId, annotation, connection);
                }
            }
            long executableTypeId = 0L;
            if (activity.getApplication() != null) {
                if (activity.getApplication().getExecutable() != null) {
                    executableTypeId = this.executableTypeTable.executeInsert(activity.getApplication().getExecutable(), connection);
                    this.activityExecutableTypeTable.executeInsert(activityId, executableTypeId, "EXEC", connection);
                    if (activity.getApplication().getExecutable().getArgument() != null) {
                        for (String argument : activity.getApplication().getExecutable().getArgument()) {
                            this.executableTypeArgumentTable.executeInsert(executableTypeId, argument, connection);
                        }
                    }
                }
                if (activity.getApplication().getPreExecutable() != null) {
                    for (ExecutableType executableType : activity.getApplication().getPreExecutable()) {
                        executableTypeId = this.executableTypeTable.executeInsert(executableType, connection);
                        this.activityExecutableTypeTable.executeInsert(activityId, executableTypeId, "PRE", connection);
                        if (executableType.getArgument() == null) continue;
                        for (String argument : executableType.getArgument()) {
                            this.executableTypeArgumentTable.executeInsert(executableTypeId, argument, connection);
                        }
                    }
                }
                if (activity.getApplication().getPostExecutable() != null) {
                    for (ExecutableType executableType : activity.getApplication().getPostExecutable()) {
                        executableTypeId = this.executableTypeTable.executeInsert(executableType, connection);
                        this.activityExecutableTypeTable.executeInsert(activityId, executableTypeId, "POST", connection);
                        if (executableType.getArgument() == null) continue;
                        for (String argument : executableType.getArgument()) {
                            this.executableTypeArgumentTable.executeInsert(executableTypeId, argument, connection);
                        }
                    }
                }
                if (activity.getApplication().getEnvironment() != null) {
                    for (OptionType optionType : activity.getApplication().getEnvironment()) {
                        this.environmentTable.executeInsert(activityId, optionType, connection);
                    }
                }
                if (activity.getApplication().getRemoteLogging() != null) {
                    for (RemoteLogging remoteLogging : activity.getApplication().getRemoteLogging()) {
                        this.remoteLoggingTable.executeInsert(activityId, remoteLogging, connection);
                    }
                }
                if (activity.getApplication().getNotification() != null) {
                    long notificationId = 0L;
                    for (Notification notification : activity.getApplication().getNotification()) {
                        notificationId = this.notificationTable.executeInsert(activityId, notification, connection);
                        if (notification.getRecipient() != null) {
                            for (String recipient : notification.getRecipient()) {
                                this.recipientTable.executeInsert(notificationId, recipient, connection);
                            }
                        }
                        if (notification.getOnState() == null) continue;
                        for (PrimaryActivityStatus primaryActivityStatus : notification.getOnState()) {
                            this.notificationOnStateTable.executeInsert(notificationId, primaryActivityStatus, connection);
                        }
                    }
                }
            }
            if (activity.getDataStaging() != null) {
                for (InputFile inputFile : activity.getDataStaging().getInputFile()) {
                    this.inputFileTable.executeInsert(activityId, inputFile, connection);
                }
                for (OutputFile outputFile : activity.getDataStaging().getOutputFile()) {
                    this.outputFileTable.executeInsert(activityId, outputFile, connection);
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
            }
            throw new DatabaseException("Rollback is fault. ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)("End insert ActivityDescription, userId = " + activity.getUserId()));
        return activityId;
    }

    public Activity getActivity(String activityId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)("Begin getActivity, activityId = " + activityId + ", userId = " + userId));
        if (activityId == null) {
            throw new IllegalArgumentException("activityId is null.");
        }
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        switch (this.activityTable.isUserEnabled(activityId, userId, connection)) {
            case NO: {
                throw new IllegalArgumentException("UserId = " + userId + " is not enabled for that operation!");
            }
            case NO_FOR_ACTIVITY_NOT_FOUND: {
                throw new IllegalArgumentException("Activity not found!");
            }
        }
        Activity activity = null;
        ActivityIdentification activityIdentification = null;
        Application application = null;
        DataStaging dataStaging = null;
        Resources resources = null;
        try {
            ActivityDB activityDB = this.activityTable.executeSelect(activityId, userId, connection);
            if (activityDB != null) {
                activity = new Activity();
                activity.setId(activityId);
                List annotation = this.annotationTable.executeSelect(activityId, connection);
                if (this.isNotNull(activityDB.getName()) || this.isNotNull(activityDB.getDescription()) || this.isNotNull(activityDB.getType()) || this.isNotNull(annotation)) {
                    activityIdentification = new ActivityIdentification();
                    activityIdentification.setName(activityDB.getName());
                    activityIdentification.setDescription(activityDB.getDescription());
                    if (this.isNotNull(activityDB.getType())) {
                        activityIdentification.setType(ActivityTypeEnumeration.fromValue((String)activityDB.getType()));
                    }
                    if (this.isNotNull(annotation)) {
                        activityIdentification.getAnnotation().addAll(annotation);
                    }
                }
                activity.setActivityIdentification(activityIdentification);
                List activityStatusList = null;
                activityStatusList = this.activityStatusTable.executeSelect(activityId, userId, connection);
                if (activityStatusList != null) {
                    for (ActivityStatus activityStatus : activityStatusList) {
                        List statusAttributeNameList = null;
                        statusAttributeNameList = this.activityStatusAttributeTable.executeSelect(activityStatus.getId(), connection);
                        activityStatus.getStatusAttributes().addAll(statusAttributeNameList);
                    }
                }
                activity.setStates(activityStatusList);
                List activityCommandList = null;
                activityCommandList = this.activityCommandTable.executeSelect(activityId, userId, connection);
                activity.setCommands(activityCommandList);
                activity.setProperties(this.activityPropertyTable.executeSelect(activityId, connection));
                List preExecutableTypeIdList = null;
                preExecutableTypeIdList = this.activityExecutableTypeTable.executeSelect(activityId, "PRE", connection);
                List executableTypeIdList = null;
                executableTypeIdList = this.activityExecutableTypeTable.executeSelect(activityId, "EXEC", connection);
                List postExecutableTypeIdList = null;
                postExecutableTypeIdList = this.activityExecutableTypeTable.executeSelect(activityId, "POST", connection);
                List environment = this.environmentTable.executeSelect(activityId, connection);
                List remoteLoggingList = null;
                remoteLoggingList = this.remoteLoggingTable.executeSelect(activityId, connection);
                List notificationDBList = null;
                notificationDBList = this.notificationTable.executeSelect(activityId, connection);
                if (this.isNotNull(activityDB.getInput()) || this.isNotNull(activityDB.getOutput()) || this.isNotNull(activityDB.getError()) || this.isNotNull(activityDB.getExpirationTimeDate()) || this.isNotNull(activityDB.getWipeTimeDuration()) || this.isNotNull(preExecutableTypeIdList) || this.isNotNull(executableTypeIdList) || this.isNotNull(postExecutableTypeIdList) || this.isNotNull(environment) || this.isNotNull(remoteLoggingList) || this.isNotNull(notificationDBList)) {
                    application = new Application();
                    application.setInput(activityDB.getInput());
                    application.setOutput(activityDB.getOutput());
                    application.setError(activityDB.getError());
                    if (this.isNotNull(activityDB.getExpirationTimeDate())) {
                        OptionalTime optionalTime = new OptionalTime();
                        optionalTime.setValue(CEUtils.getXMLGregorianCalendar((Calendar)activityDB.getExpirationTimeDate()));
                        optionalTime.setOptional(Boolean.valueOf(activityDB.isExpirationTimeOptional()));
                        application.setExpirationTime(optionalTime);
                    }
                    if (this.isNotNull(activityDB.getWipeTimeDuration())) {
                        OptionalDuration optionalduration = new OptionalDuration();
                        optionalduration.setValue(activityDB.getWipeTimeDuration());
                        optionalduration.setOptional(Boolean.valueOf(activityDB.isWipeTimeOptional()));
                        application.setWipeTime(optionalduration);
                    }
                    application.getEnvironment().addAll(environment);
                    application.getRemoteLogging().addAll(remoteLoggingList);
                    ExecutableType executableType = null;
                    List argumentList = null;
                    if (preExecutableTypeIdList != null) {
                        for (Long executableTypeId : preExecutableTypeIdList) {
                            executableType = this.executableTypeTable.executeSelect(executableTypeId.longValue(), connection);
                            argumentList = this.executableTypeArgumentTable.executeSelect(executableTypeId.longValue(), connection);
                            executableType.getArgument().addAll(argumentList);
                            application.getPreExecutable().add(executableType);
                        }
                    }
                    if (executableTypeIdList != null) {
                        executableType = this.executableTypeTable.executeSelect(((Long)executableTypeIdList.get(0)).longValue(), connection);
                        argumentList = this.executableTypeArgumentTable.executeSelect(((Long)executableTypeIdList.get(0)).longValue(), connection);
                        executableType.getArgument().addAll(argumentList);
                        application.setExecutable(executableType);
                    }
                    if (postExecutableTypeIdList != null) {
                        for (Long executableTypeId : postExecutableTypeIdList) {
                            executableType = this.executableTypeTable.executeSelect(executableTypeId.longValue(), connection);
                            argumentList = this.executableTypeArgumentTable.executeSelect(executableTypeId.longValue(), connection);
                            executableType.getArgument().addAll(argumentList);
                            application.getPostExecutable().add(executableType);
                        }
                    }
                    ArrayList<Notification> notificationList = null;
                    if (notificationDBList != null) {
                        notificationList = new ArrayList<Notification>(0);
                        List recipient = null;
                        List onstateList = null;
                        for (NotificationDB notificationDB : notificationDBList) {
                            recipient = this.recipientTable.executeSelect(notificationDB.getId(), connection);
                            onstateList = this.notificationOnStateTable.executeSelect(notificationDB.getId(), connection);
                            notificationDB.getNotification().getRecipient().addAll(recipient);
                            notificationDB.getNotification().getOnState().addAll(onstateList);
                            notificationList.add(notificationDB.getNotification());
                        }
                    }
                    application.getNotification().addAll(notificationList);
                    activity.setApplication(application);
                }
                List inputFileList = null;
                inputFileList = this.inputFileTable.executeSelect(activityId, connection);
                List outputFileList = null;
                outputFileList = this.outputFileTable.executeSelect(activityId, connection);
                if (this.isNotNull(inputFileList) || this.isNotNull(outputFileList)) {
                    dataStaging = new DataStaging();
                    dataStaging.setClientDataPush(Boolean.valueOf(activityDB.isClientDataPush()));
                    dataStaging.getInputFile().addAll(inputFileList);
                    dataStaging.getOutputFile().addAll(outputFileList);
                    activity.setDataStaging(dataStaging);
                }
                if (this.isNotNull(activityDB.getQueueName())) {
                    resources = new Resources();
                    resources.setQueueName(activityDB.getQueueName());
                    activity.setResources(resources);
                }
            } else {
                logger.info((Object)("Activity not found for activityId = " + activityId + " and userId = " + userId));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage()));
            throw new DatabaseException("ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        catch (Exception e1) {
            logger.error((Object)("ERROR: " + e1.getMessage()), (Throwable)e1);
            throw new DatabaseException(e1.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)("End getActivity, activityId = " + activityId + ", userId = " + userId));
        return activity;
    }

    public void deleteActivity(String activityId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)("Begin deleteActivity for activityId = " + activityId));
        if (activityId == null) {
            throw new IllegalArgumentException("activityId is null.");
        }
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        switch (this.activityTable.isUserEnabled(activityId, userId, connection)) {
            case NO: {
                throw new IllegalArgumentException("UserId = " + userId + " is not enabled for that operation!");
            }
            case NO_FOR_ACTIVITY_NOT_FOUND: {
                throw new IllegalArgumentException("Activity not found!");
            }
        }
        try {
            this.activityTable.executeDelete(activityId, userId, connection);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
            }
            throw new DatabaseException("Rollback is fault. ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)("End deleteActivity for activityId = " + activityId));
    }

    private boolean isNotNull(Object o) {
        return o != null;
    }

    public ListActivitiesResult listActivities(XMLGregorianCalendar fromDate, XMLGregorianCalendar toDate, List<ActivityStatus> statusList, int limit, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin listActivities");
        ListActivitiesResult listActivitiesResult = null;
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        try {
            listActivitiesResult = this.activityStatusTable.executeListActivities(fromDate, toDate, statusList, limit, userId, connection);
        }
        catch (SQLException e) {
            logger.error((Object)("ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage()));
            throw new DatabaseException("ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End listActivities");
        return listActivitiesResult;
    }

    public void insertActivityStatus(String activityId, ActivityStatus activityStatus) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)("Begin insertActivityStatus for activityId = " + activityId));
        if (activityId == null) {
            throw new IllegalArgumentException("activityId is null.");
        }
        if (activityStatus == null) {
            throw new IllegalArgumentException("activityStatus is null.");
        }
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        long activityStatusId = 0L;
        try {
            activityStatusId = this.activityStatusTable.executeInsert(activityId, activityStatus, connection);
            if (activityStatus.getStatusAttributes() != null && !activityStatus.getStatusAttributes().isEmpty()) {
                this.activityStatusAttributeTable.executeInsert(activityStatusId, activityStatus.getStatusAttributes(), connection);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
            }
            throw new DatabaseException("Rollback is fault. ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)("End insertActivityStatus for activityId = " + activityId));
    }

    public void insertActivityCommand(String activityId, ActivityCommand activityCommand) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)("Begin insertActivityCommand for activityId = " + activityId));
        if (activityId == null) {
            throw new IllegalArgumentException("activityId is null.");
        }
        if (activityCommand == null) {
            throw new IllegalArgumentException("activityCommand is null.");
        }
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        try {
            this.activityCommandTable.executeInsert(activityId, activityCommand, connection);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
            }
            throw new DatabaseException("Rollback is fault. ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)("End insertActivityCommand for activityId = " + activityId));
    }

    public void updateActivity(Activity activity) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin updateActivity");
        if (activity == null) {
            throw new IllegalArgumentException("activity is null.");
        }
        if (activity.getId() == null) {
            throw new IllegalArgumentException("activityId is null.");
        }
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        try {
            this.activityPropertyTable.executeUpdate(activity.getId(), activity.getProperties(), connection);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
            }
            throw new DatabaseException("Rollback is fault. ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End updateActivity");
    }

    public void updateActivityCommand(ActivityCommand activityCommand) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin updateActivityCommand");
        if (activityCommand == null) {
            throw new IllegalArgumentException("ActivityCommand is null.");
        }
        if (activityCommand.getId() == 0L) {
            throw new IllegalArgumentException("CommandId not initialized.");
        }
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        try {
            this.activityCommandTable.executeUpdate(activityCommand, connection);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
            }
            throw new DatabaseException("Rollback is fault. ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End updateActivityCommand");
    }

    public void updateActivityStatus(ActivityStatus activityStatus) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin updateActivityStatus");
        if (activityStatus == null) {
            throw new IllegalArgumentException("ActivityStatus is null.");
        }
        if (activityStatus.getId() == 0L) {
            throw new IllegalArgumentException("StatusId not initialized.");
        }
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        try {
            this.activityStatusTable.executeUpdate(activityStatus, connection);
            this.activityStatusAttributeTable.executeUpdate(activityStatus.getId(), activityStatus.getStatusAttributes(), connection);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
            }
            throw new DatabaseException("Rollback is fault. ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End updateActivityStatus");
    }

    public String retrieveOlderActivityId(List<ActivityStatus.StatusName> statusList, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin retrieveOlderActivityId");
        if (statusList == null || statusList.size() == 0) {
            throw new IllegalArgumentException("statusList is empty.");
        }
        String activityId = null;
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        try {
            activityId = this.activityStatusTable.executeRetrieveOlderActivityId(statusList, userId, connection);
        }
        catch (SQLException e) {
            logger.error((Object)("ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage()));
            throw new DatabaseException("ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End retrieveOlderActivityId");
        return activityId;
    }

    public List<String> listActivitiesForStatus(List<ActivityStatus.StatusName> statusList, String userId, int dateValue) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin listActivitiesForStatus");
        if (statusList == null || statusList.size() == 0) {
            throw new IllegalArgumentException("statusList is empty.");
        }
        if (dateValue < 0) {
            throw new IllegalArgumentException("DateValue must be >= 0.");
        }
        List listActivityId = null;
        Connection connection = DatasourceManager.getConnection((String)"datasource_esdb");
        try {
            listActivityId = this.activityStatusTable.executeListActivitiesForStatus(statusList, userId, dateValue, connection);
        }
        catch (SQLException e) {
            logger.error((Object)("ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage()));
            throw new DatabaseException("ERRORCODE = " + e.getErrorCode() + " Message =  " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End listActivitiesForStatus");
        return listActivityId;
    }
}

