/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.cmdexecutor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.glite.ce.cream.activitymanagement.db.ActivityDBImplementation;
import org.glite.ce.creamapi.activitymanagement.Activity;
import org.glite.ce.creamapi.activitymanagement.ActivityStatus;

public final class StdHandler
extends Thread {
    private static Logger logger = Logger.getLogger(StdHandler.class);
    private boolean terminate = false;
    private final Queue<String> activityIdQueue = new LinkedBlockingQueue<String>();

    public StdHandler() {
        super("StdHandler");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String activityId) {
        logger.debug((Object)("added activityId " + activityId));
        boolean result = this.activityIdQueue.add(activityId);
        if (result) {
            Queue<String> queue = this.activityIdQueue;
            synchronized (queue) {
                this.activityIdQueue.notifyAll();
            }
        }
        return result;
    }

    public boolean remove(String activityId) {
        logger.debug((Object)("removed activityId " + activityId));
        return this.activityIdQueue.remove(activityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFile(String filePath, String userId) throws IllegalArgumentException, InterruptedException, IOException {
        String message = "";
        if (filePath == null) {
            throw new IllegalArgumentException("stdErrorFilePath not specified");
        }
        if (userId == null) {
            throw new IllegalArgumentException("userId not specified!");
        }
        Process proc = null;
        BufferedReader readIn = null;
        try {
            proc = Runtime.getRuntime().exec(new String[]{"sudo", "-S", "-n", "-u", userId, "/bin/cat", filePath});
            readIn = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String strLine = null;
            while ((strLine = readIn.readLine()) != null) {
                message = message + strLine + " ";
            }
        }
        catch (Throwable e) {
            if (proc != null) {
                proc.destroy();
            }
        }
        finally {
            if (proc != null) {
                proc.waitFor();
                StringBuffer errorMessage = null;
                if (proc.exitValue() != 0) {
                    BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    errorMessage = new StringBuffer();
                    String inputLine = null;
                    try {
                        while ((inputLine = readErr.readLine()) != null) {
                            errorMessage.append(inputLine);
                        }
                    }
                    catch (IOException ioe) {
                        logger.error((Object)ioe.getMessage());
                    }
                    finally {
                        readErr.close();
                    }
                    if (errorMessage.length() > 0) {
                        errorMessage.append("\n");
                    }
                }
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ioe) {}
                if (errorMessage != null) {
                    throw new IOException(errorMessage.toString());
                }
            }
            try {
                readIn.close();
            }
            catch (IOException ioe) {}
        }
        if (message.length() == 0) {
            throw new FileNotFoundException("file \"" + filePath + " not found!");
        }
        return message.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug((Object)"BEGIN StdHandler");
        boolean works = true;
        String path = null;
        String exitCode = null;
        String pattern = "activity exit status = ";
        String activityId = null;
        String description = null;
        String stdErrorMessage = null;
        long delay = 0L;
        long timeElapsed = -1L;
        Activity activity = null;
        ActivityDBImplementation activityDB = null;
        try {
            activityDB = new ActivityDBImplementation();
        }
        catch (Throwable t) {
            logger.error((Object)("ActivityDB initialization failed: " + t.getMessage()));
        }
        while (!this.terminate) {
            while ((activityId = this.activityIdQueue.peek()) != null && works && !this.terminate) {
                ActivityStatus status;
                try {
                    activity = activityDB.getActivity(activityId, null);
                }
                catch (Throwable t) {
                    logger.warn((Object)t.getMessage());
                }
                if (activity == null || (status = (ActivityStatus)activity.getStates().last()).getStatusName() != ActivityStatus.StatusName.TERMINAL) continue;
                timeElapsed = Calendar.getInstance().getTimeInMillis() - status.getTimestamp().toGregorianCalendar().getTimeInMillis();
                if (timeElapsed < 60000L) {
                    delay = 60000L - timeElapsed;
                    works = false;
                    continue;
                }
                delay = 0L;
                this.activityIdQueue.remove(activityId);
                exitCode = (String)activity.getProperties().get("EXIT_CODE");
                if (!activity.getProperties().containsKey("EXIT_CODE")) {
                    int index;
                    path = (String)activity.getProperties().get("SANDBOX_PATH") + File.separator + "StandardOutput";
                    logger.debug((Object)("activity " + activity.getId() + ": retrieving the exit code from " + path));
                    try {
                        exitCode = this.readFile(path, (String)activity.getProperties().get("LOCAL_USER"));
                    }
                    catch (Throwable t) {
                        logger.error((Object)("cannot get the exit code from " + path + ": " + t.getMessage()));
                        continue;
                    }
                    if (exitCode == null) {
                        exitCode = "N/A";
                    }
                    if ((index = exitCode.indexOf(pattern)) > -1) {
                        exitCode = exitCode.substring(index + pattern.length());
                        exitCode = exitCode.substring(0, exitCode.indexOf(" "));
                        exitCode = exitCode.trim();
                    } else {
                        exitCode = "N/A";
                    }
                    activity.getProperties().put("EXIT_CODE", exitCode);
                    logger.debug((Object)("activity " + activity.getId() + ": exit code retrieved from " + path + ": " + exitCode));
                    try {
                        activityDB.updateActivity(activity);
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("cannot update the activity " + activity.getId() + ":" + t.getMessage()));
                    }
                }
                if (!status.getStatusAttributes().contains(ActivityStatus.StatusAttributeName.PROCESSING_CANCEL) && !status.getStatusAttributes().contains(ActivityStatus.StatusAttributeName.APP_FAILURE)) continue;
                path = (String)activity.getProperties().get("SANDBOX_PATH") + File.separator + "StandardError";
                logger.debug((Object)("activity " + activity.getId() + ": retrieving the failure reason from " + path));
                try {
                    stdErrorMessage = this.readFile(path, (String)activity.getProperties().get("LOCAL_USER"));
                }
                catch (Exception e) {
                    stdErrorMessage = "cannot get the failure reason from " + path + ": " + e.getMessage();
                }
                if (stdErrorMessage == null || stdErrorMessage.equals("")) {
                    stdErrorMessage = "cannot get the failure reason from " + path;
                }
                if ((description = status.getDescription()) == null) {
                    status.setDescription(stdErrorMessage);
                } else if (description.indexOf(stdErrorMessage) < 0) {
                    status.setDescription(description + "; " + stdErrorMessage);
                }
                logger.debug((Object)("activity " + activity.getId() + ": failure reason retrieved from " + path + ": " + status.getDescription()));
                try {
                    activityDB.updateActivityStatus(status);
                }
                catch (Throwable t) {
                    logger.warn((Object)("cannot update the activity " + activity.getId() + " status:" + t.getMessage()));
                }
            }
            StdHandler stdHandler = this;
            synchronized (stdHandler) {
                try {
                    logger.debug((Object)("waiting " + delay + "..."));
                    this.wait(delay);
                    logger.debug((Object)("waiting " + delay + "... done!"));
                    works = true;
                    delay = 0L;
                }
                catch (InterruptedException e) {
                    this.terminate = true;
                }
            }
        }
        logger.debug((Object)"END StdHandler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        logger.info((Object)"teminate invoked!");
        this.terminate = true;
        StdHandler stdHandler = this;
        synchronized (stdHandler) {
            this.notifyAll();
        }
        logger.info((Object)"teminated!");
    }
}

