/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.cmdexecutor;

import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.UnsignedInt;
import org.apache.axis2.databinding.types.UnsignedLong;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.ws.es.glue.AccessPolicy_t;
import org.glite.ce.creamapi.ws.es.glue.ApplicationEnvironment_t;
import org.glite.ce.creamapi.ws.es.glue.ApplicationEnvironments_type0;
import org.glite.ce.creamapi.ws.es.glue.Associations_type12;
import org.glite.ce.creamapi.ws.es.glue.BenchmarkType_t;
import org.glite.ce.creamapi.ws.es.glue.Benchmark_t;
import org.glite.ce.creamapi.ws.es.glue.Capability_t;
import org.glite.ce.creamapi.ws.es.glue.ComputingEndpoint_t;
import org.glite.ce.creamapi.ws.es.glue.ComputingManagerType_t;
import org.glite.ce.creamapi.ws.es.glue.ComputingManager_t;
import org.glite.ce.creamapi.ws.es.glue.ComputingService;
import org.glite.ce.creamapi.ws.es.glue.ComputingService_t;
import org.glite.ce.creamapi.ws.es.glue.ComputingShare_t;
import org.glite.ce.creamapi.ws.es.glue.DN_t;
import org.glite.ce.creamapi.ws.es.glue.EndpointHealthState_t;
import org.glite.ce.creamapi.ws.es.glue.EndpointTechnology_t;
import org.glite.ce.creamapi.ws.es.glue.ExtendedBoolean_t;
import org.glite.ce.creamapi.ws.es.glue.InterfaceName_t;
import org.glite.ce.creamapi.ws.es.glue.JobDescription_t;
import org.glite.ce.creamapi.ws.es.glue.MappingPolicy_t;
import org.glite.ce.creamapi.ws.es.glue.PolicyScheme_t;
import org.glite.ce.creamapi.ws.es.glue.QualityLevel_t;
import org.glite.ce.creamapi.ws.es.glue.ReservationPolicy_t;
import org.glite.ce.creamapi.ws.es.glue.SchedulingPolicy_t;
import org.glite.ce.creamapi.ws.es.glue.ServiceType_t;
import org.glite.ce.creamapi.ws.es.glue.ServingState_t;
import org.glite.ce.creamapi.ws.es.glue.Staging_t;
import org.glite.ce.creamapi.ws.es.glue.ToStorageService_t;

public class GLUE2Handler
extends Thread {
    private static Logger logger = Logger.getLogger(GLUE2Handler.class);
    private int rate = -1;
    private boolean terminate = false;
    private OMElement computingServiceElement = null;
    private ComputingService_t computingService = null;
    private DirContext ctx = null;

    public static void main(String[] args) {
        GLUE2Handler glue2Handler = null;
        try {
            glue2Handler = new GLUE2Handler("ldap://cream-36.pd.infn.it:2170", 60);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ComputingService_t computingS = glue2Handler.getComputingService();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new FileWriter("/tmp/pippo3.xml"));
            computingS.serialize(ComputingService.MY_QNAME, writer);
            writer.flush();
            writer.close();
            System.out.println(ComputingService.MY_QNAME.getLocalPart());
            System.out.println(ComputingService.MY_QNAME.getPrefix());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            List selectedNode = glue2Handler.executeXPathQuery("/ComputingService/ComputingShare");
            System.out.println(selectedNode.size());
            for (int i = 0; i < selectedNode.size(); ++i) {
                if (selectedNode.get(i) instanceof OMAttribute) {
                    System.out.println(((OMAttribute)selectedNode.get(i)).getAttributeValue());
                    continue;
                }
                if (!(selectedNode.get(i) instanceof OMElement)) continue;
                ((OMElement)selectedNode.get(i)).serialize((OutputStream)System.out);
                System.out.println();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        glue2Handler.terminate();
    }

    public GLUE2Handler(String url, int rate) throws Exception {
        this.setDaemon(true);
        this.rate = rate <= 0 ? 3600000 : rate * 60000;
        logger.info((Object)("[url=" + url + " rate=" + rate + "]"));
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        this.ctx = new InitialDirContext(env);
        this.start();
    }

    public List executeXPathQuery(String query) throws Exception {
        logger.debug((Object)"BEGIN executeXPathQuery");
        if (query == null || query.length() == 0) {
            throw new IllegalArgumentException("xpath query not defined!");
        }
        if (this.computingServiceElement == null) {
            throw new Exception("GLUE2 not yet available!");
        }
        AXIOMXPath xpathExpression = new AXIOMXPath(query);
        xpathExpression.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        List selectedNode = xpathExpression.selectNodes((Object)this.computingServiceElement);
        logger.debug((Object)("END executeXPathQuery: found " + selectedNode.size() + " items"));
        return selectedNode;
    }

    private BenchmarkType_t getAttributeValueAsBenchmarkType(Attribute attribute) {
        BenchmarkType_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new BenchmarkType_t();
                value.setBenchmarkType_t((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private BenchmarkType_t[] getAttributeValueAsBenchmarkTypeArray(Attribute attribute) {
        BenchmarkType_t[] value = null;
        if (attribute != null && attribute.size() > 0) {
            value = new BenchmarkType_t[attribute.size()];
            try {
                for (int i = 0; i < attribute.size(); ++i) {
                    value[i] = new BenchmarkType_t();
                    value[i].setBenchmarkType_t((String)attribute.get(0));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private Capability_t[] getAttributeValueAsCapability(Attribute attribute) {
        Capability_t[] value = null;
        if (attribute != null && attribute.size() > 0) {
            value = new Capability_t[attribute.size()];
            try {
                for (int i = 0; i < attribute.size(); ++i) {
                    value[i] = new Capability_t();
                    value[i].setCapability_t((String)attribute.get(i));
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private ComputingManagerType_t getAttributeValueAsComputingManagerType(Attribute attribute) {
        ComputingManagerType_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new ComputingManagerType_t();
                value.setComputingManagerType_t((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private Calendar getAttributeValueAsDateTime(Attribute attribute) {
        Calendar dateTime = null;
        if (attribute != null && attribute.size() > 0) {
            dateTime = GregorianCalendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setCalendar(dateTime);
            String value = null;
            try {
                value = (String)attribute.get(0);
                dateFormat.parse(value);
            }
            catch (NamingException e) {
                logger.error((Object)("getAttributeValueAsDateTime: found wrong datetime value (" + value + ")"));
            }
            catch (ParseException e) {
                logger.error((Object)("getAttributeValueAsDateTime: cannot parse the datetime value (" + value + ")"));
            }
        }
        return dateTime;
    }

    private DN_t getAttributeValueAsDN(Attribute attribute) {
        DN_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new DN_t();
                value.setDN_t((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private DN_t[] getAttributeValueAsDNArray(Attribute attribute) {
        DN_t[] value = null;
        if (attribute != null && attribute.size() > 0) {
            value = new DN_t[attribute.size()];
            try {
                for (int i = 0; i < attribute.size(); ++i) {
                    value[i] = new DN_t();
                    value[i].setDN_t((String)attribute.get(i));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private EndpointHealthState_t getAttributeValueAsEndpointHealthState(Attribute attribute) {
        EndpointHealthState_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = EndpointHealthState_t.Factory.fromValue((String)((String)attribute.get(0)));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private EndpointTechnology_t getAttributeValueAsEndpointTechnology(Attribute attribute) {
        EndpointTechnology_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new EndpointTechnology_t();
                value.setEndpointTechnology_t((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private ExtendedBoolean_t getAttributeValueAsExtendedBoolean(Attribute attribute) {
        ExtendedBoolean_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = ExtendedBoolean_t.Factory.fromValue((String)((String)attribute.get(0)));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private Float getAttributeValueAsFloat(Attribute attribute) {
        Float value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = Float.valueOf((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private InterfaceName_t getAttributeValueAsInterfaceName(Attribute attribute) {
        InterfaceName_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new InterfaceName_t();
                value.setInterfaceName_t((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private JobDescription_t[] getAttributeValueAsJobDescriptionArray(Attribute attribute) {
        JobDescription_t[] value = null;
        if (attribute != null && attribute.size() > 0) {
            value = new JobDescription_t[attribute.size()];
            try {
                for (int i = 0; i < attribute.size(); ++i) {
                    value[i] = new JobDescription_t();
                    value[i].setJobDescription_t((String)attribute.get(i));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private PolicyScheme_t getAttributeValueAsPolicyScheme(Attribute attribute) {
        PolicyScheme_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new PolicyScheme_t();
                value.setPolicyScheme_t((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private QualityLevel_t getAttributeValueAsQualityLevel(Attribute attribute) {
        QualityLevel_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = QualityLevel_t.Factory.fromValue((String)((String)attribute.get(0)));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private ReservationPolicy_t getAttributeValueAsReservationPolicy(Attribute attribute) {
        ReservationPolicy_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = ReservationPolicy_t.Factory.fromValue((String)((String)attribute.get(0)));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private SchedulingPolicy_t getAttributeValueAsSchedulingPolicy(Attribute attribute) {
        SchedulingPolicy_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new SchedulingPolicy_t();
                value.setSchedulingPolicy_t((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private ServiceType_t getAttributeValueAsServiceType(Attribute attribute) {
        ServiceType_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new ServiceType_t();
                value.setServiceType_t((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private ServingState_t getAttributeValueAsServingState(Attribute attribute) {
        ServingState_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = ServingState_t.Factory.fromValue((String)((String)attribute.get(0)));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private Staging_t getAttributeValueAsStaging(Attribute attribute) {
        Staging_t value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = Staging_t.Factory.fromValue((String)((String)attribute.get(0)));
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private String getAttributeValueAsString(Attribute attribute) {
        String value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = (String)attribute.get(0);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private String[] getAttributeValueAsStringArray(Attribute attribute) {
        String[] value = null;
        if (attribute != null && attribute.size() > 0) {
            value = new String[attribute.size()];
            try {
                for (int i = 0; i < attribute.size(); ++i) {
                    value[i] = (String)attribute.get(i);
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private UnsignedInt getAttributeValueAsUnsignedInt(Attribute attribute) {
        UnsignedInt value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new UnsignedInt((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private UnsignedLong getAttributeValueAsUnsignedLong(Attribute attribute) {
        UnsignedLong value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new UnsignedLong((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private URI getAttributeValueAsURI(Attribute attribute) {
        URI value = null;
        if (attribute != null && attribute.size() > 0) {
            try {
                value = new URI((String)attribute.get(0));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    private URI[] getAttributeValueAsURIArray(Attribute attribute) {
        URI[] value = null;
        if (attribute != null && attribute.size() > 0) {
            value = new URI[attribute.size()];
            try {
                for (int i = 0; i < attribute.size(); ++i) {
                    value[i] = new URI((String)attribute.get(i));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComputingService_t getComputingService() throws Exception {
        ComputingService_t computingService_t = this.computingService;
        synchronized (computingService_t) {
            if (this.computingService == null) {
                throw new Exception("GLUE2 not yet available!");
            }
            return this.computingService;
        }
    }

    private AccessPolicy_t[] makeAccessPolicies(DirContext ctx, String computingEndpointId) throws NamingException {
        Attributes attributes = null;
        SearchResult searchResult = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search("o=glue", "(&(GLUE2AccessPolicyEndpointForeignKey=" + computingEndpointId + ")(objectclass=GLUE2AccessPolicy))", ctls);
        AccessPolicy_t accessPolicy = null;
        ArrayList<AccessPolicy_t> accessPolicies = new ArrayList<AccessPolicy_t>(0);
        while (answer.hasMoreElements()) {
            searchResult = (SearchResult)answer.nextElement();
            attributes = searchResult.getAttributes();
            if (attributes == null) continue;
            accessPolicy = new AccessPolicy_t();
            accessPolicy.setBaseType("Policy");
            accessPolicy.setCreationTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EntityCreationTime")));
            accessPolicy.setID(this.getAttributeValueAsURI(attributes.get("GLUE2PolicyID")));
            accessPolicy.setName(this.getAttributeValueAsString(attributes.get("GLUE2EntityName")));
            accessPolicy.setOtherInfo(this.getAttributeValueAsStringArray(attributes.get("GLUE2EntityOtherInfo")));
            accessPolicy.setRule(this.getAttributeValueAsStringArray(attributes.get("GLUE2PolicyRule")));
            accessPolicy.setScheme(this.getAttributeValueAsPolicyScheme(attributes.get("GLUE2PolicyScheme")));
            accessPolicy.setValidity(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2EntityValidity")));
            accessPolicies.add(accessPolicy);
        }
        AccessPolicy_t[] result = null;
        if (accessPolicies.size() > 0) {
            result = new AccessPolicy_t[accessPolicies.size()];
            result = accessPolicies.toArray(result);
        }
        return result;
    }

    private ApplicationEnvironment_t[] makeApplicationEnvironments(DirContext ctx, String computingManagerId) throws NamingException {
        Attributes attributes = null;
        SearchResult searchResult = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search("o=glue", "(&(GLUE2ApplicationEnvironmentComputingManagerForeignKey=" + computingManagerId + ")(objectclass=GLUE2ApplicationEnvironment))", ctls);
        ApplicationEnvironment_t applicationEnvironment = null;
        ArrayList<ApplicationEnvironment_t> applicationEnvironments = new ArrayList<ApplicationEnvironment_t>(0);
        while (answer.hasMoreElements()) {
            searchResult = (SearchResult)answer.nextElement();
            attributes = searchResult.getAttributes();
            if (attributes == null) continue;
            applicationEnvironment = new ApplicationEnvironment_t();
            applicationEnvironment.setAppName(this.getAttributeValueAsString(attributes.get("GLUE2ApplicationEnvironmentAppName")));
            applicationEnvironment.setAppVersion(this.getAttributeValueAsString(attributes.get("GLUE2ApplicationEnvironmentAppVersion")));
            applicationEnvironment.setBestBenchmark(this.getAttributeValueAsBenchmarkTypeArray(attributes.get("GLUE2ApplicationEnvironmentBestBenchmark")));
            applicationEnvironment.setCreationTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EntityCreationTime")));
            applicationEnvironment.setDescription(this.getAttributeValueAsString(attributes.get("GLUE2ApplicationEnvironmentDescription")));
            applicationEnvironment.setFreeJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ApplicationEnvironmentFreeJobs")));
            applicationEnvironment.setFreeSlots(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ApplicationEnvironmentFreeSlots")));
            applicationEnvironment.setFreeUserSeats(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ApplicationEnvironmentFreeUserSeats")));
            applicationEnvironment.setID(this.getAttributeValueAsURI(attributes.get("GLUE2ApplicationEnvironmentID")));
            applicationEnvironment.setMaxJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ApplicationEnvironmentMaxJobs")));
            applicationEnvironment.setMaxSlots(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ApplicationEnvironmentMaxSlots")));
            applicationEnvironment.setMaxUserSeats(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ApplicationEnvironmentMaxUserSeats")));
            applicationEnvironment.setName(this.getAttributeValueAsString(attributes.get("GLUE2EntityName")));
            applicationEnvironment.setOtherInfo(this.getAttributeValueAsStringArray(attributes.get("GLUE2EntityOtherInfo")));
            applicationEnvironment.setRemovalDate(this.getAttributeValueAsDateTime(attributes.get("GLUE2ApplicationEnvironmentRemovalDate")));
            applicationEnvironment.setValidity(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2EntityValidity")));
            applicationEnvironments.add(applicationEnvironment);
        }
        ApplicationEnvironment_t[] result = null;
        if (applicationEnvironments.size() > 0) {
            result = new ApplicationEnvironment_t[applicationEnvironments.size()];
            result = applicationEnvironments.toArray(result);
        }
        return result;
    }

    private Benchmark_t[] makeBenchmarks(DirContext ctx, String computingManagerId) throws NamingException {
        Attributes attributes = null;
        SearchResult searchResult = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search("o=glue", "(&(GLUE2BenchmarkComputingManagerForeignKey=" + computingManagerId + ")(objectclass=GLUE2Benchmark))", ctls);
        Benchmark_t benchmark = null;
        ArrayList<Benchmark_t> benchmarks = new ArrayList<Benchmark_t>(0);
        while (answer.hasMoreElements()) {
            searchResult = (SearchResult)answer.nextElement();
            attributes = searchResult.getAttributes();
            if (attributes == null) continue;
            benchmark = new Benchmark_t();
            benchmark.setCreationTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EntityCreationTime")));
            benchmark.setID(this.getAttributeValueAsURI(attributes.get("GLUE2BenchmarkID")));
            benchmark.setName(this.getAttributeValueAsString(attributes.get("GLUE2EntityName")));
            benchmark.setOtherInfo(this.getAttributeValueAsStringArray(attributes.get("GLUE2EntityOtherInfo")));
            benchmark.setType(this.getAttributeValueAsBenchmarkType(attributes.get("GLUE2BenchmarkType")));
            benchmark.setValidity(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2EntityValidity")));
            benchmark.setValue(this.getAttributeValueAsFloat(attributes.get("GLUE2BenchmarkValue")).floatValue());
            benchmarks.add(benchmark);
        }
        Benchmark_t[] result = null;
        if (benchmarks.size() > 0) {
            result = new Benchmark_t[benchmarks.size()];
            result = benchmarks.toArray(result);
        }
        return result;
    }

    private ComputingEndpoint_t[] makeComputingEndpoints(DirContext ctx, String computingServiceId) throws NamingException {
        Attributes attributes = null;
        SearchResult searchResult = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search("o=glue", "(&(GLUE2EndpointServiceForeignKey=" + computingServiceId + ")(objectclass=GLUE2ComputingEndpoint))", ctls);
        ComputingEndpoint_t computingEndpoint = null;
        ArrayList<ComputingEndpoint_t> computingEndpoints = new ArrayList<ComputingEndpoint_t>(0);
        while (answer.hasMoreElements()) {
            searchResult = (SearchResult)answer.nextElement();
            attributes = searchResult.getAttributes();
            if (attributes == null) continue;
            computingEndpoint = new ComputingEndpoint_t();
            computingEndpoint.setBaseType("Endpoint");
            computingEndpoint.setCapability(this.getAttributeValueAsCapability(attributes.get("GLUE2EndpointCapability")));
            computingEndpoint.setCreationTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EntityCreationTime")));
            computingEndpoint.setDowntimeAnnounce(this.getAttributeValueAsDateTime(attributes.get("GLUE2EndpointDowntimeAnnounce")));
            computingEndpoint.setDowntimeEnd(this.getAttributeValueAsDateTime(attributes.get("GLUE2EndpointDowntimeEnd")));
            computingEndpoint.setDowntimeInfo(this.getAttributeValueAsString(attributes.get("GLUE2EndpointDowntimeInfo")));
            computingEndpoint.setDowntimeStart(this.getAttributeValueAsDateTime(attributes.get("GLUE2EndpointDowntimeStart")));
            computingEndpoint.setHealthState(this.getAttributeValueAsEndpointHealthState(attributes.get("GLUE2EndpointHealthState")));
            computingEndpoint.setHealthStateInfo(this.getAttributeValueAsString(attributes.get("GLUE2EndpointHealthStateInfo")));
            computingEndpoint.setID(this.getAttributeValueAsURI(attributes.get("GLUE2EndpointID")));
            computingEndpoint.setImplementationName(this.getAttributeValueAsString(attributes.get("GLUE2EndpointImplementationName")));
            computingEndpoint.setImplementationVersion(this.getAttributeValueAsString(attributes.get("GLUE2EndpointImplementationVersion")));
            computingEndpoint.setImplementor(this.getAttributeValueAsString(attributes.get("GLUE2EndpointImplementor")));
            computingEndpoint.setInterfaceExtension(this.getAttributeValueAsURIArray(attributes.get("GLUE2EndpointInterfaceExtension")));
            computingEndpoint.setInterfaceName(this.getAttributeValueAsInterfaceName(attributes.get("GLUE2EndpointInterfaceName")));
            computingEndpoint.setInterfaceVersion(this.getAttributeValueAsStringArray(attributes.get("GLUE2EndpointInterfaceVersion")));
            computingEndpoint.setIssuerCA(this.getAttributeValueAsDN(attributes.get("GLUE2EndpointIssuerCA")));
            computingEndpoint.setJobDescription(this.getAttributeValueAsJobDescriptionArray(attributes.get("GLUE2ComputingEndpointJobDescription")));
            computingEndpoint.setName(this.getAttributeValueAsString(attributes.get("GLUE2EntityName")));
            computingEndpoint.setOtherInfo(this.getAttributeValueAsStringArray(attributes.get("GLUE2EntityOtherInfo")));
            computingEndpoint.setPreLRMSWaitingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2EndpointPreLRMSWaitingJobs")));
            computingEndpoint.setQualityLevel(this.getAttributeValueAsQualityLevel(attributes.get("GLUE2EndpointQualityLevel")));
            computingEndpoint.setRunningJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingEndpointRunningJobs")));
            computingEndpoint.setSemantics(this.getAttributeValueAsURIArray(attributes.get("GLUE2EndpointSemantics")));
            computingEndpoint.setServingState(this.getAttributeValueAsServingState(attributes.get("GLUE2EndpointServingState")));
            computingEndpoint.setStaging(this.getAttributeValueAsStaging(attributes.get("GLUE2ComputingEndpointStaging")));
            computingEndpoint.setStagingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingEndpointStagingJobs")));
            computingEndpoint.setStartTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EndpointStartTime")));
            computingEndpoint.setSupportedProfile(this.getAttributeValueAsURIArray(attributes.get("GLUE2EndpointSupportedProfile")));
            computingEndpoint.setSuspendedJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingEndpointSuspendedJobs")));
            computingEndpoint.setTechnology(this.getAttributeValueAsEndpointTechnology(attributes.get("GLUE2EndpointTechnology")));
            computingEndpoint.setTotalJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingEndpointTotalJobs")));
            computingEndpoint.setTrustedCA(this.getAttributeValueAsDNArray(attributes.get("GLUE2EndpointTrustedCA")));
            computingEndpoint.setURL(this.getAttributeValueAsURI(attributes.get("GLUE2EndpointURL")));
            computingEndpoint.setValidity(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2EntityValidity")));
            computingEndpoint.setWaitingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingEndpointWaitingJobs")));
            computingEndpoint.setWSDL(this.getAttributeValueAsURIArray(attributes.get("GLUE2EndpointWSDL")));
            computingEndpoint.setAccessPolicy(this.makeAccessPolicies(ctx, computingEndpoint.getID().toString()));
            computingEndpoints.add(computingEndpoint);
        }
        ComputingEndpoint_t[] result = null;
        if (computingEndpoints.size() > 0) {
            result = new ComputingEndpoint_t[computingEndpoints.size()];
            result = computingEndpoints.toArray(result);
        }
        return result;
    }

    private ComputingManager_t[] makeComputingManagers(DirContext ctx, String computingServiceId) throws NamingException {
        Attributes attributes = null;
        SearchResult searchResult = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search("o=glue", "(&(GLUE2ComputingManagerComputingServiceForeignKey=" + computingServiceId + ")(objectclass=GLUE2ComputingManager))", ctls);
        ComputingManager_t computingManager = null;
        ArrayList<ComputingManager_t> computingManagers = new ArrayList<ComputingManager_t>(0);
        while (answer.hasMoreElements()) {
            searchResult = (SearchResult)answer.nextElement();
            attributes = searchResult.getAttributes();
            if (attributes == null) continue;
            computingManager = new ComputingManager_t();
            computingManager.setBaseType("Manager");
            computingManager.setID(this.getAttributeValueAsURI(attributes.get("GLUE2ManagerID")));
            computingManager.setApplicationDir(this.getAttributeValueAsString(attributes.get("GLUE2ComputingManagerApplicationDir")));
            ApplicationEnvironments_type0 applicationEnvironments = new ApplicationEnvironments_type0();
            applicationEnvironments.setApplicationEnvironment(this.makeApplicationEnvironments(ctx, computingManager.getID().toString()));
            computingManager.setApplicationEnvironments(applicationEnvironments);
            computingManager.setBenchmark(this.makeBenchmarks(ctx, computingManager.getID().toString()));
            computingManager.setBulkSubmission(this.getAttributeValueAsExtendedBoolean(attributes.get("GLUE2ComputingManagerBulkSubmission")));
            computingManager.setCacheFree(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingManagerCacheFree")));
            computingManager.setCacheTotal(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingManagerCacheTotal")));
            computingManager.setCreationTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EntityCreationTime")));
            computingManager.setHomogeneous(this.getAttributeValueAsExtendedBoolean(attributes.get("GLUE2ComputingManagerHomogeneous")));
            computingManager.setLogicalCPUDistribution(this.getAttributeValueAsString(attributes.get("GLUE2ComputingManagerLogicalCPUDistribution")));
            computingManager.setName(this.getAttributeValueAsString(attributes.get("GLUE2EntityName")));
            computingManager.setOtherInfo(this.getAttributeValueAsStringArray(attributes.get("GLUE2EntityOtherInfo")));
            computingManager.setProductName(this.getAttributeValueAsComputingManagerType(attributes.get("GLUE2ManagerProductName")));
            computingManager.setProductVersion(this.getAttributeValueAsString(attributes.get("GLUE2ManagerProductVersion")));
            computingManager.setScratchDir(this.getAttributeValueAsString(attributes.get("GLUE2ComputingManagerScratchDir")));
            computingManager.setSlotsUsedByGridJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingManagerSlotsUsedByGridJobs")));
            computingManager.setSlotsUsedByLocalJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingManagerSlotsUsedByLocalJobs")));
            computingManager.setTmpDir(this.getAttributeValueAsString(attributes.get("GLUE2ComputingManagerTmpDir")));
            computingManager.setTotalLogicalCPUs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingManagerTotalLogicalCPUs")));
            computingManager.setTotalPhysicalCPUs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingManagerTotalPhysicalCPUs")));
            computingManager.setTotalSlots(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingManagerTotalSlots")));
            computingManager.setValidity(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2EntityValidity")));
            computingManager.setWorkingAreaFree(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingManagerWorkingAreaFree")));
            computingManager.setWorkingAreaGuaranteed(this.getAttributeValueAsExtendedBoolean(attributes.get("GLUE2ComputingManagerWorkingAreaGuaranteed")));
            computingManager.setWorkingAreaLifeTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingManagerWorkingAreaLifeTime")));
            computingManager.setWorkingAreaMultiSlotFree(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingManagerWorkingAreaMultiSlotFree")));
            computingManager.setWorkingAreaMultiSlotLifeTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingManagerWorkingMultiSlotLifeTime")));
            computingManager.setWorkingAreaMultiSlotTotal(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingManagerWorkingMultiSlotTotal")));
            computingManager.setWorkingAreaShared(this.getAttributeValueAsExtendedBoolean(attributes.get("GLUE2ComputingManagerWorkingAreaShared")));
            computingManager.setWorkingAreaTotal(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingManagerWorkingAreaTotal")));
            computingManagers.add(computingManager);
        }
        ComputingManager_t[] result = null;
        if (computingManagers.size() > 0) {
            result = new ComputingManager_t[computingManagers.size()];
            result = computingManagers.toArray(result);
        }
        return result;
    }

    private ComputingService_t makeComputingService(DirContext ctx) throws NamingException {
        Attributes attributes = null;
        SearchResult searchResult = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search("o=glue", "(&(objectClass=GLUE2ComputingService)(GLUE2ServiceType=org.ogf.emies))", ctls);
        ComputingService_t computingService = null;
        if (answer.hasMoreElements()) {
            computingService = new ComputingService_t();
        }
        while (answer.hasMoreElements()) {
            searchResult = (SearchResult)answer.nextElement();
            attributes = searchResult.getAttributes();
            if (attributes == null) continue;
            computingService.setBaseType("Service");
            computingService.setID(this.getAttributeValueAsURI(attributes.get("GLUE2ServiceID")));
            computingService.setCapability(this.getAttributeValueAsCapability(attributes.get("GLUE2ServiceCapability")));
            computingService.setComplexity(this.getAttributeValueAsString(attributes.get("GLUE2ServiceComplexity")));
            computingService.setComputingEndpoint(this.makeComputingEndpoints(ctx, computingService.getID().toString()));
            computingService.setComputingManager(this.makeComputingManagers(ctx, computingService.getID().toString()));
            computingService.setComputingShare(this.makeComputingShares(ctx, computingService.getID().toString()));
            computingService.setCreationTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EntityCreationTime")));
            computingService.setName(this.getAttributeValueAsString(attributes.get("GLUE2EntityName")));
            computingService.setOtherInfo(this.getAttributeValueAsStringArray(attributes.get("GLUE2EntityOtherInfo")));
            computingService.setPreLRMSWaitingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingServicePreLRMSWaitingJobs")));
            computingService.setQualityLevel(this.getAttributeValueAsQualityLevel(attributes.get("GLUE2ServiceQualityLevel")));
            computingService.setRunningJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingServiceRunningJobs")));
            computingService.setStagingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingServiceStagingJobs")));
            computingService.setStatusInfo(this.getAttributeValueAsURIArray(attributes.get("GLUE2ServiceStatusInfo")));
            computingService.setSuspendedJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingServiceSuspendedJobs")));
            computingService.setToStorageService(this.makeToStorageService(ctx, computingService.getID().toString()));
            computingService.setTotalJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingServiceTotalJobs")));
            computingService.setType(this.getAttributeValueAsServiceType(attributes.get("GLUE2ServiceType")));
            computingService.setValidity(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2EntityValidity")));
            computingService.setWaitingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingServiceWaitingJobs")));
        }
        return computingService;
    }

    private ComputingShare_t[] makeComputingShares(DirContext ctx, String computingServiceId) throws NamingException {
        Attributes attributes = null;
        SearchResult searchResult = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search("o=glue", "(&(GLUE2ComputingShareComputingServiceForeignKey=" + computingServiceId + ")(objectclass=GLUE2ComputingShare))", ctls);
        ComputingShare_t computingShare = null;
        ArrayList<ComputingShare_t> computingShares = new ArrayList<ComputingShare_t>(0);
        while (answer.hasMoreElements()) {
            searchResult = (SearchResult)answer.nextElement();
            attributes = searchResult.getAttributes();
            if (attributes == null) continue;
            computingShare = new ComputingShare_t();
            computingShare.setBaseType("Share");
            computingShare.setCreationTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EntityCreationTime")));
            computingShare.setDefaultCPUTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareDefaultCPUTime")));
            computingShare.setDefaultStorageService(this.getAttributeValueAsURI(attributes.get("GLUE2ComputingShareDefaultStorageService")));
            computingShare.setDefaultWallTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareDefaultWallTime")));
            computingShare.setDescription(this.getAttributeValueAsString(attributes.get("GLUE2ShareDescription")));
            computingShare.setEstimatedAverageWaitingTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareEstimatedAverageWaitingTime")));
            computingShare.setEstimatedWorstWaitingTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareEstimatedWorstWaitingTime")));
            computingShare.setFreeSlots(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareFreeSlots")));
            computingShare.setFreeSlotsWithDuration(this.getAttributeValueAsString(attributes.get("GLUE2ComputingShareFreeSlotsWithDuration")));
            computingShare.setGuaranteedMainMemory(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareGuaranteedMainMemory")));
            computingShare.setGuaranteedVirtualMemory(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareGuaranteedVirtualMemory")));
            computingShare.setID(this.getAttributeValueAsURI(attributes.get("GLUE2ShareID")));
            computingShare.setLocalRunningJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareLocalRunningJobs")));
            computingShare.setLocalSuspendedJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareLocalSuspendedJobs")));
            computingShare.setLocalWaitingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareLocalWaitingJobs")));
            computingShare.setMappingPolicy(this.makeMappingPolicies(ctx, computingShare.getID().toString()));
            computingShare.setMappingQueue(this.getAttributeValueAsString(attributes.get("GLUE2ComputingShareMappingQueue")));
            computingShare.setMaxCPUTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareMaxCPUTime")));
            computingShare.setMaxDiskSpace(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareMaxDiskSpace")));
            computingShare.setMaxMainMemory(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareMaxMainMemory")));
            computingShare.setMaxMultiSlotWallTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareMaxMultiSlotWallTime")));
            computingShare.setMaxPreLRMSWaitingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareMaxPreLRMSWaitingJobs")));
            computingShare.setMaxRunningJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareMaxRunningJobs")));
            computingShare.setMaxSlotsPerJob(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareMaxSlotsPerJob")));
            computingShare.setMaxStageOutStreams(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareMaxStageOutStreams")));
            computingShare.setMaxStateInStreams(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareMaxStateInStreams")));
            computingShare.setMaxTotalCPUTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareMaxTotalCPUTime")));
            computingShare.setMaxTotalJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareMaxTotalJobs")));
            computingShare.setMaxUserRunningJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareMaxUserRunningJobs")));
            computingShare.setMaxVirtualMemory(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareMaxVirtualMemory")));
            computingShare.setMaxWaitingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareMaxWaitingJobs")));
            computingShare.setMaxWallTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareMaxWallTime")));
            computingShare.setMinCPUTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareMinCPUTime")));
            computingShare.setMinWallTime(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2ComputingShareMinWallTime")));
            computingShare.setName(this.getAttributeValueAsString(attributes.get("GLUE2EntityName")));
            computingShare.setOtherInfo(this.getAttributeValueAsStringArray(attributes.get("GLUE2EntityOtherInfo")));
            computingShare.setPreemption(this.getAttributeValueAsExtendedBoolean(attributes.get("GLUE2ComputingSharePreemption")));
            computingShare.setPreLRMSWaitingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingSharePreLRMSWaitingJobs")));
            computingShare.setRequestedSlots(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareRequestedSlots")));
            computingShare.setReservationPolicy(this.getAttributeValueAsReservationPolicy(attributes.get("GLUE2ComputingShareReservationPolicy")));
            computingShare.setRunningJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareRunningJobs")));
            computingShare.setSchedulingPolicy(this.getAttributeValueAsSchedulingPolicy(attributes.get("GLUE2ComputingShareSchedulingPolicy")));
            computingShare.setServingState(this.getAttributeValueAsServingState(attributes.get("GLUE2ComputingShareServingState")));
            computingShare.setStagingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareStagingJobs")));
            computingShare.setSuspendedJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareSuspendedJobs")));
            computingShare.setTag(this.getAttributeValueAsStringArray(attributes.get("GLUE2ComputingShareTag")));
            computingShare.setTotalJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareTotalJobs")));
            computingShare.setUsedSlots(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareUsedSlots")));
            computingShare.setValidity(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2EntityValidity")));
            computingShare.setWaitingJobs(this.getAttributeValueAsUnsignedInt(attributes.get("GLUE2ComputingShareWaitingJobs")));
            computingShares.add(computingShare);
        }
        ComputingShare_t[] result = null;
        if (computingShares.size() > 0) {
            result = new ComputingShare_t[computingShares.size()];
            result = computingShares.toArray(result);
        }
        return result;
    }

    private MappingPolicy_t[] makeMappingPolicies(DirContext ctx, String computingShareId) throws NamingException {
        Attributes attributes = null;
        SearchResult searchResult = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search("o=glue", "(&(GLUE2MappingPolicyShareForeignKey=" + computingShareId + ")(objectclass=GLUE2MappingPolicy))", ctls);
        MappingPolicy_t mappingPolicy = null;
        ArrayList<MappingPolicy_t> mappingPolicies = new ArrayList<MappingPolicy_t>(0);
        while (answer.hasMoreElements()) {
            searchResult = (SearchResult)answer.nextElement();
            attributes = searchResult.getAttributes();
            if (attributes == null) continue;
            mappingPolicy = new MappingPolicy_t();
            mappingPolicy.setBaseType("Policy");
            mappingPolicy.setCreationTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EntityCreationTime")));
            mappingPolicy.setID(this.getAttributeValueAsURI(attributes.get("GLUE2PolicyID")));
            mappingPolicy.setName(this.getAttributeValueAsString(attributes.get("GLUE2EntityName")));
            mappingPolicy.setOtherInfo(this.getAttributeValueAsStringArray(attributes.get("GLUE2EntityOtherInfo")));
            mappingPolicy.setRule(this.getAttributeValueAsStringArray(attributes.get("GLUE2PolicyRule")));
            mappingPolicy.setScheme(this.getAttributeValueAsPolicyScheme(attributes.get("GLUE2PolicyScheme")));
            mappingPolicy.setValidity(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2EntityValidity")));
            mappingPolicies.add(mappingPolicy);
        }
        MappingPolicy_t[] result = null;
        if (mappingPolicies.size() > 0) {
            result = new MappingPolicy_t[mappingPolicies.size()];
            result = mappingPolicies.toArray(result);
        }
        return result;
    }

    private ToStorageService_t makeToStorageService(DirContext ctx, String computingServiceId) throws NamingException {
        Attributes attributes = null;
        SearchResult searchResult = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        NamingEnumeration<SearchResult> answer = ctx.search("o=glue", "(&(GLUE2ToStorageServiceComputingServiceForeignKey=" + computingServiceId + ")(objectclass=GLUE2ToStorageService))", ctls);
        ToStorageService_t toStorageService = null;
        ArrayList computingShares = new ArrayList(0);
        if (answer.hasMoreElements() && (attributes = (searchResult = (SearchResult)answer.nextElement()).getAttributes()) != null) {
            toStorageService = new ToStorageService_t();
            toStorageService.setCreationTime(this.getAttributeValueAsDateTime(attributes.get("GLUE2EntityCreationTime")));
            toStorageService.setID(this.getAttributeValueAsURI(attributes.get("GLUE2ToStorageServiceID")));
            toStorageService.setLocalPath(this.getAttributeValueAsString(attributes.get("GLUE2ToStorageServiceLocalPath")));
            toStorageService.setName(this.getAttributeValueAsString(attributes.get("GLUE2EntityName")));
            toStorageService.setOtherInfo(this.getAttributeValueAsStringArray(attributes.get("GLUE2EntityOtherInfo")));
            toStorageService.setRemotePath(this.getAttributeValueAsString(attributes.get("GLUE2ToStorageServiceRemotePath")));
            toStorageService.setValidity(this.getAttributeValueAsUnsignedLong(attributes.get("GLUE2EntityValidity")));
            Associations_type12 associations = new Associations_type12();
            associations.setStorageServiceID(this.getAttributeValueAsURI(attributes.get("GLUE2ToStorageServiceStorageServiceForeignKey")));
            toStorageService.setAssociations(associations);
        }
        return toStorageService;
    }

    private void printAttributes(Attributes attributes) {
        Attribute attribute = null;
        NamingEnumeration<? extends Attribute> attr = attributes.getAll();
        while (attr.hasMoreElements()) {
            attribute = (Attribute)attr.nextElement();
            try {
                NamingEnumeration<?> vals = attribute.getAll();
                while (vals.hasMoreElements()) {
                    System.out.println("\t" + attribute.getID() + " = " + vals.nextElement());
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug((Object)"BEGIN GLUE2Handler");
        ComputingService_t service = null;
        while (!this.terminate) {
            Object t2;
            if (this.ctx != null) {
                try {
                    logger.debug((Object)"making the ComputingService_t...");
                    service = this.makeComputingService(this.ctx);
                    logger.debug((Object)"making the ComputingService_t... done");
                }
                catch (Throwable t2) {
                    logger.error((Object)t2.getMessage());
                }
            }
            if (this.computingService == null) {
                this.computingService = service;
            }
            if (service == null) {
                logger.warn((Object)"ComputingService_t not available!");
            } else {
                t2 = this.computingService;
                synchronized (t2) {
                    this.computingService = service;
                    try {
                        String ns = "xmlns=\"http://schemas.ogf.org/glue/2009/03/spec_2.0_r1\"";
                        String xmlStream = this.computingService.getOMElement(ComputingService.MY_QNAME, OMAbstractFactory.getOMFactory()).toString();
                        int index = xmlStream.indexOf(ns);
                        if (index > 0) {
                            xmlStream = xmlStream.substring(0, index) + xmlStream.substring(index + ns.length() + 1);
                        }
                        StAXOMBuilder builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(xmlStream.getBytes()));
                        this.computingServiceElement = builder.getDocumentElement();
                    }
                    catch (Throwable t3) {
                        logger.error((Object)t3.getMessage());
                    }
                }
            }
            t2 = this;
            synchronized (t2) {
                try {
                    logger.debug((Object)("waiting " + this.rate + " minutes..."));
                    this.wait(this.rate);
                    logger.debug((Object)("waiting " + this.rate + " minutes... done!"));
                }
                catch (InterruptedException e) {
                    this.terminate = true;
                }
            }
        }
        try {
            this.ctx.close();
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage());
        }
        logger.debug((Object)"END GLUE2Handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        logger.info((Object)"teminate invoked!");
        this.terminate = true;
        GLUE2Handler gLUE2Handler = this;
        synchronized (gLUE2Handler) {
            this.notifyAll();
        }
        logger.info((Object)"teminated!");
    }
}

