/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.cmdexecutor;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.cream.activitymanagement.db.ActivityDBImplementation;
import org.glite.ce.cream.blahmanagement.BLAHClient;
import org.glite.ce.cream.blahmanagement.BLAHNotifierClient;
import org.glite.ce.creamapi.activitymanagement.ActivityStatus;

public final class ActivityStatusMonitor
extends Thread {
    private static Logger logger = Logger.getLogger(ActivityStatusMonitor.class);
    private boolean terminate = false;
    private long rate = 6L;
    private int statusAge = 24;
    private String lrms = null;
    private BLAHClient blahClient = null;

    public ActivityStatusMonitor(BLAHClient blahClient, String lrms, long rate, int statusAge) {
        super("ActivityStatusMonitor");
        this.setDaemon(true);
        this.blahClient = blahClient;
        this.lrms = lrms;
        this.rate = rate;
        this.statusAge = statusAge;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)("starting: lrms=" + this.lrms + "; rate=" + this.rate + " hour(s); statusAge=" + this.statusAge + " hour(s)"));
        List activityIdList = null;
        ArrayList<ActivityStatus.StatusName> statusList = new ArrayList<ActivityStatus.StatusName>(2);
        statusList.add(ActivityStatus.StatusName.PROCESSING_QUEUED);
        statusList.add(ActivityStatus.StatusName.PROCESSING_RUNNING);
        ActivityDBImplementation activityDB = null;
        try {
            activityDB = new ActivityDBImplementation();
        }
        catch (Throwable t) {
            logger.error((Object)("ActivityDB initialization failed: " + t.getMessage()));
        }
        BLAHNotifierClient blahNotifierClient = this.blahClient.getBLAHNotifierClient(this.lrms);
        if (blahNotifierClient == null) {
            logger.error((Object)("BLAHNotifier for " + this.lrms + " not found!"));
            this.terminate = true;
        }
        while (!this.terminate) {
            try {
                activityIdList = activityDB.listActivitiesForStatus(statusList, null, this.statusAge * 60);
            }
            catch (Throwable t) {
                logger.warn((Object)t.getMessage());
            }
            if (activityIdList != null && activityIdList.size() > 0) {
                try {
                    blahNotifierClient.sendStartNotifyJobListCommand(activityIdList);
                }
                catch (Throwable t) {
                    logger.error((Object)t.getMessage());
                }
                activityIdList.clear();
            }
            ActivityStatusMonitor activityStatusMonitor = this;
            synchronized (activityStatusMonitor) {
                try {
                    logger.debug((Object)("waiting " + this.rate + " hour(s)..."));
                    this.wait(this.rate * 3600000L);
                    logger.debug((Object)("waiting " + this.rate + " hour(s)... done"));
                }
                catch (InterruptedException e) {
                    this.terminate = true;
                }
            }
        }
        logger.info((Object)"exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        logger.info((Object)"teminate invoked!");
        this.terminate = true;
        ActivityStatusMonitor activityStatusMonitor = this;
        synchronized (activityStatusMonitor) {
            this.notifyAll();
        }
        logger.info((Object)"teminated!");
    }
}

