/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.cmdexecutor;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedSet;
import javax.sql.DataSource;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.commonj.db.DatasourceManager;
import org.glite.ce.commonj.utils.CEUtils;
import org.glite.ce.cream.activitymanagement.ActivityCmd;
import org.glite.ce.cream.activitymanagement.cmdexecutor.ActivityStatusMonitor;
import org.glite.ce.cream.activitymanagement.cmdexecutor.ActivityWrapper;
import org.glite.ce.cream.activitymanagement.cmdexecutor.GLUE2Handler;
import org.glite.ce.cream.activitymanagement.cmdexecutor.StdHandler;
import org.glite.ce.cream.activitymanagement.db.ActivityDBImplementation;
import org.glite.ce.cream.blahmanagement.BLAHClient;
import org.glite.ce.cream.blahmanagement.BLAHException;
import org.glite.ce.cream.blahmanagement.BLAHJob;
import org.glite.ce.cream.blahmanagement.BLAHJobStatus;
import org.glite.ce.cream.blahmanagement.BLAHJobStatusChangeListener;
import org.glite.ce.cream.configuration.ServiceConfig;
import org.glite.ce.creamapi.activitymanagement.Activity;
import org.glite.ce.creamapi.activitymanagement.ActivityCommand;
import org.glite.ce.creamapi.activitymanagement.ActivityStatus;
import org.glite.ce.creamapi.activitymanagement.ListActivitiesResult;
import org.glite.ce.creamapi.activitymanagement.db.ActivityDBInterface;
import org.glite.ce.creamapi.activitymanagement.wrapper.activitymanagement.types.NotifyMessageType;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ActivityDescription;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.InputFile;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OutputFile;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ParallelEnvironment;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ProcessesPerHost;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.Resources;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.SlotRequirement;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.SlotsPerHost;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ThreadsPerProcess;
import org.glite.ce.creamapi.cmdmanagement.AbstractCommandExecutor;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.cmdmanagement.CommandException;
import org.glite.ce.creamapi.cmdmanagement.CommandExecutorException;
import org.glite.ce.creamapi.jobmanagement.db.DBInfoManager;

public class ActivityExecutor
extends AbstractCommandExecutor
implements BLAHJobStatusChangeListener {
    private static final Logger logger = Logger.getLogger((String)ActivityExecutor.class.getName());
    public static final String ACTIVITY_STATUS_MONITOR_AGE = "ACTIVITY_STATUS_MONITOR_AGE";
    public static final String ACTIVITY_STATUS_MONITOR_RATE = "ACTIVITY_STATUS_MONITOR_RATE";
    public static final String ACTIVITY_WRAPPER_TEMPLATE_PATH = "ACTIVITY_WRAPPER_TEMPLATE_PATH";
    public static final String BDII_URI = "BDII_URI";
    public static final String BDII_RATE = "BDII_RATE";
    public static final String BLAH_BIN_PATH = "BLAH_BIN_PATH";
    public static final String BLAH_COMMAND_TIMEOUT = "BLAH_COMMAND_TIMEOUT";
    public static final String BLAH_PREFIX = "BLAH_PREFIX";
    public static final String BLAH_NOTIFICATION_LISTENER_PORT = "BLAH_NOTIFICATION_LISTENER_PORT";
    public static final String BLAH_NOTIFIER_RETRY_COUNT = "BLAH_NOTIFIER_RETRY_COUNT";
    public static final String BLAH_NOTIFIER_RETRY_DELAY = "BLAH_NOTIFIER_RETRY_DELAY";
    public static final String COPY_PROXY_MIN_RETRY_WAIT = "COPY_PROXY_MIN_RETRY_WAIT";
    public static final String COPY_RETRY_COUNT_ISB = "COPY_RETRY_COUNT_ISB";
    public static final String COPY_RETRY_COUNT_OSB = "COPY_RETRY_COUNT_OSB";
    public static final String COPY_RETRY_FIRST_WAIT_ISB = "COPY_RETRY_FIRST_WAIT_ISB";
    public static final String COPY_RETRY_FIRST_WAIT_OSB = "COPY_RETRY_FIRST_WAIT_OSB";
    public static final String CREATE_SANDBOX_BIN_PATH = "CREATE_SANDBOX_BIN_PATH";
    public static final String CREATE_WRAPPER_BIN_PATH = "CREATE_WRAPPER_BIN_PATH";
    public static final String DEFAULT_LRMS_NAME = "DEFAULT_LRMS_NAME";
    public static final String DEFAULT_QUEUE_NAME = "DEFAULT_QUEUE_NAME";
    public static final String DELEGATION_TIME_SLOT = "DELEGATION_TIME_SLOT";
    public static final String HOST_NAME = "HOST_NAME";
    public static final String LIMIT_FOR_LIST_ACTIVITIES = "LIMIT_FOR_LIST_ACTIVITIES";
    public static final String NOT_AVAILABLE_VALUE = "N/A";
    public static final String SANDBOX_DIR = "SANDBOX_DIR";
    public static final String SERVICE_URL = "SERVICE_URL";
    public static final String SERVICE_GSI_URL = "SERVICE_GSI_URL";
    public static final String PURGE_SANDBOX_BIN_PATH = "PURGE_SANDBOX_BIN_PATH";
    private static String hostAddress = null;
    private static String hostName = null;
    private static String serviceUrl = null;
    private static String serviceGSIUrl = null;
    private static String delegationSuffix = null;
    private static String activityWrapperNotificationStatusURI = null;
    private static BLAHClient blahClient = null;
    private boolean initialized = false;
    private static ActivityDBInterface activityDB = null;
    private static int limitForListActivities = 1000;
    private static int bdiiRate = 60;
    private static StdHandler stdHandler = null;
    private static GLUE2Handler glue2Handler = null;
    private static ActivityStatusMonitor activityStatusMonitor = null;

    public ActivityExecutor() throws CommandExecutorException {
        super("ActivityExecutor", "ACTIVITY_MANAGEMENT");
        this.setCommands(ActivityCmd.ActivityCommandName.toArrayList());
        this.addParameter(SANDBOX_DIR, "/var/cream-es_sandbox");
        this.addParameter(BLAH_BIN_PATH, "/usr/bin/blahpd");
        this.dataSourceName = "datasource_esdb";
    }

    private void cancelActivity(Command command) throws CommandException {
        logger.debug((Object)"BEGIN cancelActivity");
        Activity activity = this.getActivity(command);
        SortedSet states = activity.getStates();
        if (states.isEmpty()) {
            throw new CommandException("none status available");
        }
        ActivityStatus status = (ActivityStatus)states.last();
        if (ActivityStatus.StatusName.TERMINAL == status.getStatusName()) {
            throw new CommandException("invalid state (terminal)");
        }
        String localUser = (String)activity.getProperties().get("LOCAL_USER");
        if (localUser == null) {
            throw new CommandException("LOCAL_USER not speficied!");
        }
        if (this.isActivityCheckOn(command)) {
            return;
        }
        Boolean isSuccess = Boolean.TRUE;
        if (ActivityStatus.StatusName.ACCEPTED == status.getStatusName() || ActivityStatus.StatusName.PREPROCESSING == status.getStatusName()) {
            ActivityStatus activityStatus = new ActivityStatus();
            activityStatus.setStatusName(ActivityStatus.StatusName.TERMINAL);
            activityStatus.setTimestamp(this.newXMLGregorianCalendar(Calendar.getInstance()));
            activityStatus.setDescription("cancelled by the user");
            if (ActivityStatus.StatusName.PREPROCESSING == status.getStatusName()) {
                activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.PREPROCESSING_CANCEL);
            }
            try {
                activityDB.insertActivityStatus(activity.getId(), activityStatus);
                logger.info((Object)("activity " + activity.getId() + " status changed => " + activityStatus.toString()));
                activityDB.insertActivityCommand(activity.getId(), this.makeActivityCommand(command.getName(), isSuccess));
            }
            catch (Throwable t) {
                throw new CommandException(t.getMessage());
            }
        }
        try {
            String lrmsId = (String)activity.getProperties().get("LRMS_ABS_LAYER_ID");
            if (lrmsId == null) {
                throw new CommandException("LRMS_ABS_LAYER_ID not speficied!");
            }
            blahClient.cancel(lrmsId, localUser);
        }
        catch (Throwable e) {
            isSuccess = Boolean.FALSE;
            throw new CommandException("blah error: " + e.getMessage());
        }
        finally {
            try {
                activityDB.insertActivityCommand(activity.getId(), this.makeActivityCommand(command.getName(), isSuccess));
            }
            catch (Throwable t) {
                throw new CommandException(t.getMessage());
            }
        }
        logger.debug((Object)"END cancelActivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createActivity(Command command) throws CommandException {
        logger.debug((Object)"BEGIN createActivity");
        if (command.getUserId() == null) {
            throw new CommandException("userId not specified!");
        }
        String activityId = null;
        String gsiURL = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.SERVICE_GSI_URL, true);
        String userDN_X500 = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.USER_DN_X500, true);
        String userDN_RFC2253 = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.USER_DN_RFC2253, true);
        String userFQAN = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.USER_FQAN, true);
        String localUser = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.LOCAL_USER, true);
        String localUserGroup = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.LOCAL_USER_GROUP, true);
        String virtualOrganisation = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.VIRTUAL_ORGANISATION, false);
        String activitySandboxDir = NOT_AVAILABLE_VALUE;
        String sandboxDir = this.getParameterValueAsString(SANDBOX_DIR);
        String createSandboxBinPath = this.getParameterValueAsString(CREATE_SANDBOX_BIN_PATH);
        String delegationSandboxPath = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.DELEGATION_SANDBOX_PATH, false);
        String serviceURL = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.SERVICE_URL, true);
        Runtime runtime = Runtime.getRuntime();
        BufferedReader in = null;
        BufferedReader readErr = null;
        Process proc = null;
        ActivityDescription activityDescription = (ActivityDescription)this.getParameterValue(command, ActivityCmd.ActivityCommandField.ACTIVITY_DESCRIPTION, true);
        Activity activity = new Activity();
        activity.setUserId(command.getUserId());
        activity.setActivityIdentification(activityDescription.getActivityIdentification());
        activity.setApplication(activityDescription.getApplication());
        activity.setDataStaging(activityDescription.getDataStaging());
        activity.setResources(activityDescription.getResources());
        activity.getCommands().add(this.makeActivityCommand(command.getName(), Boolean.TRUE));
        activity.getStates().add(this.makeActivityStatus(ActivityStatus.StatusName.ACCEPTED));
        activity.getProperties().put("USER_DN_X500", userDN_X500);
        activity.getProperties().put("USER_DN_RFC2253", userDN_RFC2253);
        activity.getProperties().put("USER_FQAN", userFQAN);
        activity.getProperties().put("LOCAL_USER", localUser);
        activity.getProperties().put("LOCAL_USER_GROUP", localUserGroup);
        activity.getProperties().put(SERVICE_URL, serviceURL);
        if (virtualOrganisation != null) {
            activity.getProperties().put("VIRTUAL_ORGANISATION", virtualOrganisation);
        }
        if (delegationSandboxPath != null) {
            activity.getProperties().put("DELEGATION_SANDBOX_PATH", delegationSandboxPath);
            activity.getProperties().put("DELEGATION_SANDBOX_URI", gsiURL + delegationSandboxPath);
        }
        String queueName = null;
        Resources resources = activity.getResources();
        if (resources == null) {
            queueName = this.getParameterValueAsString(DEFAULT_QUEUE_NAME);
            resources = new Resources();
            resources.setQueueName(queueName);
            activity.setResources(resources);
        } else {
            ParallelEnvironment parallelEnvironment;
            if (resources.getQueueName() == null) {
                queueName = this.getParameterValueAsString(DEFAULT_QUEUE_NAME);
                resources.setQueueName(queueName);
            } else {
                queueName = resources.getQueueName();
            }
            SlotRequirement slotRequirement = resources.getSlotRequirement();
            if (slotRequirement != null) {
                SlotsPerHost slotsPerHost = slotRequirement.getSlotsPerHost();
                if (slotsPerHost != null) {
                    if (slotsPerHost.isUseNumberOfSlots()) {
                        activity.getProperties().put("NUMBER_OF_SLOTS", "" + slotRequirement.getNumberOfSlots());
                    } else {
                        activity.getProperties().put("SLOTS_PER_HOST", "" + slotsPerHost.getNumberOfSlotsPerHost());
                    }
                    activity.getProperties().put("EXCLUSIVE_EXECUTION", "" + slotRequirement.isExclusiveExecution());
                } else {
                    activity.getProperties().put("NUMBER_OF_SLOTS", "" + slotRequirement.getNumberOfSlots());
                }
            }
            if ((parallelEnvironment = resources.getParallelEnvironment()) != null) {
                ThreadsPerProcess threadsPerProcess;
                ProcessesPerHost processesPerHost;
                if (parallelEnvironment.getType() != null) {
                    activity.getProperties().put("PARALLEL_ENVIRONMENT_TYPE", parallelEnvironment.getType());
                }
                if ((processesPerHost = parallelEnvironment.getProcessesPerHost()) != null && !processesPerHost.isUseSlotsPerHost()) {
                    activity.getProperties().put("PARALLEL_ENVIRONMENT_PROCESSES_PER_HOST", "" + processesPerHost.getProcessesPerHost());
                }
                if ((threadsPerProcess = parallelEnvironment.getThreadsPerProcess()) != null && !threadsPerProcess.isUseSlotsPerHost()) {
                    activity.getProperties().put("PARALLEL_ENVIRONMENT_THREADS_PER_PROCESSES", "" + threadsPerProcess.getThreadsPerProcess());
                }
            }
        }
        try {
            activityId = activityDB.insertActivity(activity);
            logger.info((Object)("new activity " + activityId + " created! " + activity.getStates().last()));
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
            throw new CommandException("cannot store the activity: " + t.getMessage());
        }
        activity.setId(activityId);
        ActivityStatus activityStatus = null;
        try {
            logger.debug((Object)("createActivity [localUser=" + localUser + "; createSandboxBinPath=" + createSandboxBinPath + "; sandboxDir=" + sandboxDir + "; userId=" + command.getUserId() + "; activityId=" + activity.getId() + "; gsiURL=" + gsiURL + "]"));
            String[] cmd = new String[]{"sudo", "-S", "-n", "-u", localUser, createSandboxBinPath, sandboxDir, command.getUserId(), activity.getId(), "true"};
            proc = runtime.exec(cmd);
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            activitySandboxDir = in.readLine();
            if (activitySandboxDir == null) {
                throw new CommandException("cannot get the activity sandbox dir path");
            }
            activityStatus = this.makeActivityStatus(ActivityStatus.StatusName.PREPROCESSING);
            if (activity.getDataStaging() != null && activity.getDataStaging().isClientDataPush().booleanValue()) {
                activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.CLIENT_STAGEIN_POSSIBLE);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
            activityStatus = this.makeActivityStatus(ActivityStatus.StatusName.TERMINAL);
            activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.PREPROCESSING_FAILURE);
            activityStatus.setDescription(t.getMessage());
            if (proc != null) {
                proc.destroy();
            }
        }
        finally {
            if (proc != null) {
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {}
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ioe) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
                in = null;
            }
            if (readErr != null) {
                try {
                    readErr.close();
                }
                catch (IOException ex) {}
                readErr = null;
            }
            try {
                activityDB.insertActivityStatus(activity.getId(), activityStatus);
                logger.info((Object)("activity " + activityId + " status changed => " + activityStatus.toString()));
            }
            catch (Throwable t) {
                throw new CommandException(t.getMessage());
            }
        }
        String stageInDir = gsiURL + activitySandboxDir + "/ISB";
        String stageOutDir = gsiURL + activitySandboxDir + "/OSB";
        activity.getProperties().put("SANDBOX_PATH", activitySandboxDir);
        activity.getProperties().put("STAGE_IN_URI", stageInDir);
        activity.getProperties().put("STAGE_OUT_URI", stageOutDir);
        try {
            activityDB.updateActivity(activity);
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
            throw new CommandException("cannot store the activity: " + t.getMessage());
        }
        command.getResult().addParameter(ActivityCmd.ActivityCommandField.ACTIVITY_STATUS.name(), (Object)activityStatus);
        command.getResult().addParameter(ActivityCmd.ActivityCommandField.ACTIVITY_ID.name(), (Object)activityId);
        command.getResult().addParameter(ActivityCmd.ActivityCommandField.STAGE_IN_URI.name(), (Object)stageInDir);
        command.getResult().addParameter(ActivityCmd.ActivityCommandField.STAGE_OUT_URI.name(), (Object)stageOutDir);
        logger.debug((Object)"END createActivity");
    }

    public void destroy() {
        logger.info((Object)"destroy invoked!");
        blahClient.terminate();
        stdHandler.terminate();
        glue2Handler.terminate();
        activityStatusMonitor.terminate();
        super.destroy();
        logger.info((Object)"destroyed!");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doOnJobStatusChange(BLAHJobStatus status) {
        block27: {
            if (status == null) break block27;
            ActivityExecutor.logger.debug((Object)("doOnJobStatusChange: new status received " + status.toString()));
            activityStatus = new ActivityStatus();
            activityStatus.setTimestamp(this.newXMLGregorianCalendar(status.getChangeTime()));
            workerNode = null;
            activity = null;
            try {
                activity = ActivityExecutor.activityDB.getActivity("CR_ES" + status.getClientJobId(), null);
                if (activity == null) {
                    throw new Exception("activity CR_ES" + status.getClientJobId() + " not found!");
                }
            }
            catch (Throwable t) {
                ActivityExecutor.logger.warn((Object)t.getMessage());
                return;
            }
            switch (status.getStatus()) {
                case 1: {
                    for (ActivityStatus s : activity.getStates()) {
                        if (s.getStatusName() != ActivityStatus.StatusName.PROCESSING_QUEUED) continue;
                        return;
                    }
                    activityStatus.setStatusName(ActivityStatus.StatusName.PROCESSING_QUEUED);
                    break;
                }
                case 2: {
                    activityStatus.setStatusName(ActivityStatus.StatusName.PROCESSING_RUNNING);
                    workerNode = status.getWorkerNode();
                    break;
                }
                case 11: {
                    activityStatus.setStatusName(ActivityStatus.StatusName.PROCESSING_RUNNING);
                    activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.APP_RUNNING);
                    break;
                }
                case 3: {
                    activityStatus.setStatusName(ActivityStatus.StatusName.TERMINAL);
                    activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.PROCESSING_CANCEL);
                    activityStatus.setDescription("cancelled by the admin");
                    for (ActivityCommand activityCommand : activity.getCommands()) {
                        if (!ActivityCmd.ActivityCommandName.CANCEL_ACTIVITY.name().equals(activityCommand.getName())) continue;
                        activityStatus.setDescription("cancelled by the user");
                        break;
                    }
                    ActivityExecutor.stdHandler.add(activity.getId());
                    break;
                }
                case 5: {
                    activityStatus.setStatusName(ActivityStatus.StatusName.PROCESSING_RUNNING);
                    found = false;
                    for (ActivityCommand activityCommand : activity.getCommands()) {
                        if (!ActivityCmd.ActivityCommandName.PAUSE_ACTIVITY.name().equals(activityCommand.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.CLIENT_PAUSED);
                        break;
                    }
                    activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.SERVER_PAUSED);
                    break;
                }
                case 4: {
                    reason = status.getReason();
                    exitCode = status.getExitCode();
                    activityStatus.setStatusName(ActivityStatus.StatusName.TERMINAL);
                    activityStatus.setDescription(reason);
                    activityStatus.setIsTransient(Boolean.valueOf(status.getSource() == 1));
                    if (reason != null && !reason.endsWith("reason=0")) ** GOTO lbl70
                    for (OutputFile outputFile : activity.getDataStaging().getOutputFile()) {
                        if (outputFile.getTarget().size() != 0) continue;
                        activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.CLIENT_STAGEOUT_POSSIBLE);
                        ** GOTO lbl86
                    }
                    ** GOTO lbl86
lbl70:
                    // 1 sources

                    if (!reason.endsWith("reason=999")) ** GOTO lbl74
                    exitCode = "999";
                    activityStatus.setDescription("reason=999 (job not found)");
                    ** GOTO lbl86
lbl74:
                    // 1 sources

                    if (!reason.equals("Job has been terminated (got SIGTERM)")) ** GOTO lbl82
                    activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.PROCESSING_CANCEL);
                    for (ActivityCommand activityCommand : activity.getCommands()) {
                        if (!ActivityCmd.ActivityCommandName.CANCEL_ACTIVITY.name().equals(activityCommand.getName())) continue;
                        activityStatus.setDescription("cancelled by the user");
                        ** GOTO lbl84
                    }
                    ** GOTO lbl84
lbl82:
                    // 1 sources

                    activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.APP_FAILURE);
lbl84:
                    // 3 sources

                    ActivityExecutor.stdHandler.add(activity.getId());
lbl86:
                    // 4 sources

                    if (exitCode == null) break;
                    try {
                        activity.getProperties().put("EXIT_CODE", exitCode);
                        ActivityExecutor.activityDB.updateActivity(activity);
                        break;
                    }
                    catch (Throwable t) {
                        ActivityExecutor.logger.warn((Object)t.getMessage(), t);
                        return;
                    }
                }
            }
            try {
                if (workerNode != null) {
                    activity.getProperties().put("WORKER_NODE", workerNode);
                    ActivityExecutor.activityDB.updateActivity(activity);
                }
                if (!activity.getStates().contains(activityStatus)) {
                    ActivityExecutor.activityDB.insertActivityStatus(activity.getId(), activityStatus);
                    info = new StringBuffer();
                    info.append("activity ").append(activity.getId());
                    info.append(" status changed => ").append(activityStatus.toString());
                    if (activity.getProperties().containsKey("WORKER_NODE")) {
                        info.append("; workerNode=").append((String)activity.getProperties().get("WORKER_NODE"));
                    }
                    if (activity.getProperties().containsKey("LRMS_ABS_LAYER_ID")) {
                        info.append("; lrsmsId=").append((String)activity.getProperties().get("LRMS_ABS_LAYER_ID"));
                    }
                    if (status.getSource() == 0) {
                        info.append("; source=BLAH_NOTIFIER");
                    } else {
                        info.append("; source=ACTIVITY_WRAPPER");
                    }
                    ActivityExecutor.logger.info((Object)info);
                }
            }
            catch (Throwable t) {
                ActivityExecutor.logger.warn((Object)("activity CR_ES" + status.getClientJobId() + " not found!: " + t.getMessage()), t);
            }
        }
    }

    public void execute(Command command) throws CommandExecutorException, CommandException {
        logger.debug((Object)"BEGIN execute");
        if (!this.initialized) {
            throw new CommandExecutorException(this.getName() + " not initialized!");
        }
        if (command == null) {
            throw new IllegalArgumentException("command not defined!");
        }
        if (!command.getCategory().equalsIgnoreCase(this.getCategory())) {
            throw new CommandException("command category mismatch: found \"" + command.getCategory() + "\" required \"" + this.getCategory() + "\"");
        }
        if (command.containsParameterKey("USER_DN")) {
            command.addParameter("USER_DN", (Serializable)((Object)this.normalize(command.getParameterAsString("USER_DN"))));
        }
        try {
            switch (ActivityCmd.ActivityCommandName.valueOf(command.getName())) {
                case CANCEL_ACTIVITY: {
                    this.cancelActivity(command);
                    break;
                }
                case CREATE_ACTIVITY: {
                    this.createActivity(command);
                    break;
                }
                case START_ACTIVITY: {
                    this.startActivity(command);
                    break;
                }
                case GET_ACTIVITY_INFO: {
                    this.getActivityInfo(command);
                    break;
                }
                case GET_ACTIVITY_STATUS: {
                    this.getActivityStatus(command);
                    break;
                }
                case GET_DATABASE_VERSION: {
                    this.getDatabaseVersion(command);
                    break;
                }
                case GET_RESOURCE_INFO: {
                    this.getResourceInfo(command);
                    break;
                }
                case LIST_ACTIVITIES: {
                    this.listActivities(command);
                    break;
                }
                case NOTIFY_SERVICE: {
                    this.notifyService(command);
                    break;
                }
                case PAUSE_ACTIVITY: {
                    this.pauseActivity(command);
                    break;
                }
                case QUERY_RESOURCE_INFO: {
                    this.queryResourceInfo(command);
                    break;
                }
                case RESTART_ACTIVITY: {
                    this.restartActivity(command);
                    break;
                }
                case RESUME_ACTIVITY: {
                    this.resumeActivity(command);
                    break;
                }
                case WIPE_ACTIVITY: {
                    this.wipeActivity(command);
                    break;
                }
                default: {
                    logger.error((Object)("command \"" + command.getName() + "\" not found!"));
                    throw new CommandExecutorException("command \"" + command.getName() + "\" not found!");
                }
            }
        }
        catch (CommandException ex) {
            logger.error((Object)("Execution of the command \"" + command.getName() + "\" failed: " + ex.getMessage()));
            throw ex;
        }
        logger.debug((Object)"END execute");
    }

    public void execute(List<Command> commandList) throws CommandExecutorException, CommandException {
        if (commandList == null) {
            return;
        }
        for (Command command : commandList) {
            this.execute(command);
        }
    }

    private Activity getActivity(Command command) throws CommandException {
        if (command.getUserId() == null) {
            throw new CommandException("userId not specified!");
        }
        Activity activity = null;
        String activityId = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.ACTIVITY_ID, true);
        try {
            activity = activityDB.getActivity(activityId, command.getUserId());
        }
        catch (Throwable t) {
            if (t.getMessage() == null) {
                throw new CommandException(NOT_AVAILABLE_VALUE);
            }
            if (t.getMessage().indexOf("is not enabled for that operation") != -1) {
                throw new CommandException("activity " + activityId + " not found!");
            }
            throw new CommandException(t.getMessage());
        }
        return activity;
    }

    private void getActivityInfo(Command command) throws CommandException {
        logger.debug((Object)"BEGIN getActivityInfo");
        command.getResult().addParameter(ActivityCmd.ActivityCommandField.ACTIVITY_DESCRIPTION.name(), (Object)this.getActivity(command));
        logger.debug((Object)"END getActivityInfo");
    }

    private void getActivityStatus(Command command) throws CommandException {
        logger.debug((Object)"BEGIN getActivityStatus");
        Activity activity = this.getActivity(command);
        if (activity.getStates().isEmpty()) {
            throw new CommandException("none status available");
        }
        command.getResult().addParameter(ActivityCmd.ActivityCommandField.ACTIVITY_STATUS.name(), activity.getStates().last());
        logger.debug((Object)"END getActivityStatus");
    }

    private String getDatabaseVersion(Command command) throws CommandException {
        logger.debug((Object)"BEGIN getDatabaseVersion");
        String version = NOT_AVAILABLE_VALUE;
        try {
            version = DBInfoManager.getDBVersion((String)this.dataSourceName);
        }
        catch (Exception e) {
            throw new CommandException("Failure on storage interaction: " + e.getMessage());
        }
        command.getResult().addParameter("DATABASE_VERSION", (Object)version);
        logger.debug((Object)"END getDatabaseVersion");
        return version;
    }

    private Object getParameterValue(Command command, ActivityCmd.ActivityCommandField field, boolean throwException) throws CommandException {
        if (command == null) {
            throw new CommandException("command not specified!");
        }
        if (field == null) {
            throw new CommandException("paramenter key not specified!");
        }
        Object value = command.getParameter(field.name());
        if (value == null && throwException) {
            throw new CommandException("parameter \"" + field.name() + "\" not specified!");
        }
        return value;
    }

    private String getParameterValueAsString(Command command, ActivityCmd.ActivityCommandField field, boolean throwException) throws CommandException {
        if (command == null) {
            throw new CommandException("command not specified!");
        }
        if (field == null) {
            throw new CommandException("paramenter key not specified!");
        }
        Object value = command.getParameter(field.name());
        if (throwException) {
            if (value == null) {
                throw new CommandException("parameter \"" + field.name() + "\" not specified!");
            }
            if (!(value instanceof String)) {
                throw new CommandException("the value of the parameter \"" + field.name() + "\" is not an instance of the String type!");
            }
        }
        return (String)value;
    }

    private void getResourceInfo(Command command) throws CommandException {
        try {
            command.getResult().addParameter(ActivityCmd.ActivityCommandField.COMPUTING_SERVICE.name(), (Object)glue2Handler.getComputingService());
        }
        catch (Throwable t) {
            throw new CommandException(t.getMessage());
        }
    }

    public void initExecutor() throws CommandExecutorException {
        logger.debug((Object)"BEGIN initExecutor");
        if (!this.initialized) {
            logger.info((Object)("initalizing the " + this.getName() + " executor..."));
            ServiceConfig serviceConfig = ServiceConfig.getConfiguration();
            if (serviceConfig == null) {
                throw new CommandExecutorException("Configuration error: cannot initialize the ServiceConfig");
            }
            HashMap dataSources = serviceConfig.getDataSources();
            if (dataSources == null) {
                throw new CommandExecutorException("Datasource is empty!");
            }
            if (dataSources.containsKey(this.dataSourceName)) {
                if (DatasourceManager.addDataSource((String)this.dataSourceName, (DataSource)((DataSource)dataSources.get(this.dataSourceName)))) {
                    logger.info((Object)("new dataSource \"" + this.dataSourceName + "\" added to the DatasourceManager"));
                } else {
                    logger.info((Object)("the dataSource \"" + this.dataSourceName + "\" already exist!"));
                }
            } else {
                throw new CommandExecutorException("Datasource \"" + this.dataSourceName + "\" not found!");
            }
            if (dataSources.containsKey("datasource_delegationdb")) {
                if (DatasourceManager.addDataSource((String)"datasource_delegationdb", (DataSource)((DataSource)dataSources.get("datasource_delegationdb")))) {
                    logger.info((Object)"new dataSource \"datasource_delegationdb\" added to the DatasourceManager");
                } else {
                    logger.info((Object)"the dataSource \"datasource_delegationdb\" already exist!");
                }
            } else {
                throw new CommandExecutorException("Datasource \"datasource_delegationdb\" not found!");
            }
            try {
                delegationSuffix = DBInfoManager.getDelegationSuffix((String)"datasource_delegationdb");
            }
            catch (Throwable t) {
                throw new CommandExecutorException("cannot get instance of DelegationManager: " + t.getMessage());
            }
            if (delegationSuffix == null || delegationSuffix.equals("")) {
                throw new CommandExecutorException("delegationSuffix not defined!");
            }
            try {
                activityDB = new ActivityDBImplementation();
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
                throw new CommandExecutorException("ActivityDB initialization failed: " + t.getMessage());
            }
            if (!this.containsParameterKey(LIMIT_FOR_LIST_ACTIVITIES)) {
                logger.info((Object)("LIMIT_FOR_LIST_ACTIVITIES parameter not defined: using the default value (" + limitForListActivities + ")"));
            } else {
                try {
                    limitForListActivities = Integer.parseInt(this.getParameterValueAsString(LIMIT_FOR_LIST_ACTIVITIES));
                }
                catch (Throwable t) {
                    throw new CommandExecutorException("wrong value for the LIMIT_FOR_LIST_ACTIVITIES parameter found: " + t.getMessage());
                }
            }
            if (!this.containsParameterKey(DEFAULT_LRMS_NAME)) {
                throw new CommandExecutorException("DEFAULT_LRMS_NAME parameter not defined!");
            }
            if (!this.containsParameterKey(DEFAULT_QUEUE_NAME)) {
                throw new CommandExecutorException("DEFAULT_QUEUE_NAME parameter not defined!");
            }
            if (!this.containsParameterKey(DELEGATION_TIME_SLOT)) {
                throw new CommandExecutorException("DELEGATION_TIME_SLOT parameter not defined!");
            }
            if (!this.containsParameterKey(SANDBOX_DIR)) {
                throw new CommandExecutorException("SANDBOX_DIR parameter not defined!");
            }
            if (!this.containsParameterKey(PURGE_SANDBOX_BIN_PATH)) {
                throw new CommandExecutorException("PURGE_SANDBOX_BIN_PATH parameter not defined!");
            }
            if (!this.containsParameterKey(ACTIVITY_WRAPPER_TEMPLATE_PATH)) {
                this.addParameter(ACTIVITY_WRAPPER_TEMPLATE_PATH, ServiceConfig.getConfiguration().getConfigurationDirectory());
            }
            if (!this.containsParameterKey(CREATE_SANDBOX_BIN_PATH)) {
                throw new CommandExecutorException("CREATE_SANDBOX_BIN_PATH parameter not defined!");
            }
            if (!this.containsParameterKey(CREATE_WRAPPER_BIN_PATH)) {
                throw new CommandExecutorException("CREATE_WRAPPER_BIN_PATH parameter not defined!");
            }
            if (!this.containsParameterKey(BDII_URI)) {
                throw new CommandExecutorException("BDII_URI parameter not defined!");
            }
            if (!this.containsParameterKey(BDII_RATE)) {
                logger.info((Object)("BDII_RATE parameter not defined: using the default value (" + bdiiRate + "sec)"));
            } else {
                try {
                    bdiiRate = Integer.parseInt(this.getParameterValueAsString(BDII_RATE));
                }
                catch (Throwable t) {
                    throw new CommandExecutorException("wrong value for the BDII_RATE parameter found: " + t.getMessage());
                }
            }
            try {
                glue2Handler = new GLUE2Handler(this.getParameterValueAsString(BDII_URI), bdiiRate);
            }
            catch (Exception e) {
                throw new CommandExecutorException("cannot instantiate the GLUE2Handler: " + e.getMessage());
            }
            stdHandler = new StdHandler();
            blahClient = new BLAHClient();
            blahClient.setJobStatusChangeListener(this);
            if (this.containsParameterKey(BLAH_BIN_PATH)) {
                blahClient.setExecutablePath(this.getParameterValueAsString(BLAH_BIN_PATH));
            }
            if (this.containsParameterKey(BLAH_NOTIFICATION_LISTENER_PORT)) {
                try {
                    blahClient.setNotificationListenerPort(Integer.parseInt(this.getParameterValueAsString(BLAH_NOTIFICATION_LISTENER_PORT)));
                }
                catch (Throwable t) {
                    logger.warn((Object)("Found a wrong value for the BLAH_NOTIFICATION_LISTENER_PORT parameter: using the default (" + blahClient.getNotificationListenerPort() + ")"));
                }
            }
            if (this.containsParameterKey(BLAH_COMMAND_TIMEOUT)) {
                try {
                    blahClient.setCommandTimeout(Integer.parseInt(this.getParameterValueAsString(BLAH_COMMAND_TIMEOUT)));
                }
                catch (Throwable t) {
                    logger.warn((Object)("Found a wrong value for the BLAH_COMMAND_TIMEOUT parameter: using the default (" + blahClient.getCommandTimeout() + ")"));
                }
            }
            if (this.containsParameterKey(BLAH_NOTIFIER_RETRY_COUNT)) {
                try {
                    blahClient.setNotifierRetryCount(Integer.parseInt(this.getParameterValueAsString(BLAH_NOTIFIER_RETRY_COUNT)));
                }
                catch (Throwable t) {
                    logger.warn((Object)("Found a wrong value for the BLAH_NOTIFIER_RETRY_COUNT parameter: using the default (" + blahClient.getNotifierRetryCount() + ")"));
                }
            }
            if (this.containsParameterKey(BLAH_NOTIFIER_RETRY_DELAY)) {
                try {
                    blahClient.setNotifierRetryDelay(Integer.parseInt(this.getParameterValueAsString(BLAH_NOTIFIER_RETRY_DELAY)));
                }
                catch (Throwable t) {
                    logger.warn((Object)("Found a wrong value for the BLAH_NOTIFIER_RETRY_DELAY parameter: using the default (" + blahClient.getNotifierRetryDelay() + ")"));
                }
            }
            if (this.containsParameterKey(BLAH_PREFIX)) {
                blahClient.setPrefix(this.getParameterValueAsString(BLAH_PREFIX));
            }
            try {
                blahClient.init();
            }
            catch (BLAHException e) {
                throw new CommandExecutorException("blahClient initialization failed: " + e.getMessage());
            }
            try {
                hostName = this.containsParameterKey(HOST_NAME) ? this.getParameterValueAsString(HOST_NAME) : InetAddress.getLocalHost().getCanonicalHostName();
                hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new CommandExecutorException("cannot get the host's address: " + e.getMessage());
            }
            activityWrapperNotificationStatusURI = hostAddress + ":" + blahClient.getNotificationListenerPort();
            long activityStatusMonitorRate = 0L;
            if (!this.containsParameterKey(ACTIVITY_STATUS_MONITOR_RATE)) {
                throw new CommandExecutorException("ACTIVITY_STATUS_MONITOR_RATE parameter not defined!");
            }
            try {
                activityStatusMonitorRate = Long.parseLong(this.getParameterValueAsString(ACTIVITY_STATUS_MONITOR_RATE));
            }
            catch (Throwable t) {
                throw new CommandExecutorException("wrong value for the ACTIVITY_STATUS_MONITOR_RATE parameter found: " + t.getMessage());
            }
            if (activityStatusMonitorRate < 0L) {
                throw new CommandExecutorException("wrong value for the ACTIVITY_STATUS_MONITOR_RATE parameter found: negative");
            }
            int activityStatusMonitorAge = 0;
            if (!this.containsParameterKey(ACTIVITY_STATUS_MONITOR_AGE)) {
                throw new CommandExecutorException("ACTIVITY_STATUS_MONITOR_AGE parameter not defined!");
            }
            try {
                activityStatusMonitorAge = Integer.parseInt(this.getParameterValueAsString(ACTIVITY_STATUS_MONITOR_AGE));
            }
            catch (Throwable t) {
                throw new CommandExecutorException("wrong value for the ACTIVITY_STATUS_MONITOR_AGE parameter found: " + t.getMessage());
            }
            if (activityStatusMonitorAge < 0) {
                throw new CommandExecutorException("wrong value for the ACTIVITY_STATUS_MONITOR_AGE parameter found: negative");
            }
            activityStatusMonitor = new ActivityStatusMonitor(blahClient, this.getParameterValueAsString(DEFAULT_LRMS_NAME), activityStatusMonitorRate, activityStatusMonitorAge);
            this.initialized = true;
            logger.info((Object)(this.getName() + " executor initialized!"));
        }
        logger.debug((Object)"END initExecutor");
    }

    private boolean isActivityCheckOn(Command command) {
        boolean result = false;
        if (command.containsParameterKey(ActivityCmd.ActivityCommandField.ACTIVITY_CHECK.name())) {
            result = ActivityCmd.ActivityCommandField.ACTIVITY_CHECK_ON == (ActivityCmd.ActivityCommandField)((Object)command.getParameter(ActivityCmd.ActivityCommandField.ACTIVITY_CHECK.name()));
        }
        return result;
    }

    private void listActivities(Command command) throws CommandException {
        Calendar fromDate = (Calendar)this.getParameterValue(command, ActivityCmd.ActivityCommandField.FROM_DATE, false);
        Calendar toDate = (Calendar)this.getParameterValue(command, ActivityCmd.ActivityCommandField.TO_DATE, false);
        List activityStatusList = null;
        int limit = limitForListActivities;
        activityStatusList = command.containsParameterKey(ActivityCmd.ActivityCommandField.ACTIVITY_STATUS_LIST.name()) ? (List)this.getParameterValue(command, ActivityCmd.ActivityCommandField.ACTIVITY_STATUS_LIST, false) : new ArrayList(0);
        if (command.containsParameterKey(ActivityCmd.ActivityCommandField.LIMIT.name())) {
            limit = ((BigInteger)this.getParameterValue(command, ActivityCmd.ActivityCommandField.LIMIT, false)).intValue();
            limit = Math.min(limit, limitForListActivities);
        }
        try {
            ListActivitiesResult result = activityDB.listActivities(CEUtils.getXMLGregorianCalendar((Calendar)fromDate), CEUtils.getXMLGregorianCalendar((Calendar)toDate), activityStatusList, limit, command.getUserId());
            command.getResult().addParameter(ActivityCmd.ActivityCommandField.ACTIVITY_ID_LIST.name(), (Object)result.getActivityIdList());
            command.getResult().addParameter(ActivityCmd.ActivityCommandField.IS_TRUNCATED.name(), (Object)result.isTruncated());
        }
        catch (Throwable t) {
            throw new CommandException(t.getMessage());
        }
    }

    private ActivityCommand makeActivityCommand(String name, Boolean isSuccess) {
        ActivityCommand activityCommand = new ActivityCommand(name);
        activityCommand.setTimestamp(this.newXMLGregorianCalendar());
        activityCommand.setIsSuccess(isSuccess);
        return activityCommand;
    }

    private ActivityStatus makeActivityStatus(ActivityStatus.StatusName name) {
        ActivityStatus activityStatus = new ActivityStatus(name);
        activityStatus.setTimestamp(this.newXMLGregorianCalendar());
        return activityStatus;
    }

    private XMLGregorianCalendar newXMLGregorianCalendar() {
        return this.newXMLGregorianCalendar(null);
    }

    private XMLGregorianCalendar newXMLGregorianCalendar(Calendar date) {
        XMLGregorianCalendar timestamp = null;
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            if (date != null) {
                gregorianCalendar.setTimeInMillis(date.getTimeInMillis());
            }
            timestamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
        }
        catch (DatatypeConfigurationException ex) {
            logger.warn((Object)ex.getMessage());
        }
        return timestamp;
    }

    private String normalize(String s) {
        if (s != null) {
            return s.replaceAll("\\W", "_");
        }
        return null;
    }

    private void notifyService(Command command) throws CommandException {
        logger.debug((Object)"BEGIN notifyService");
        String activityId = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.ACTIVITY_ID, true);
        String message = this.getParameterValueAsString(command, ActivityCmd.ActivityCommandField.NOTIFY_MESSAGE, true);
        NotifyMessageType notifyMessageType = NotifyMessageType.fromValue((String)message);
        Activity activity = this.getActivity(command);
        if (activity.getStates().isEmpty()) {
            throw new CommandException("none status found about the activity " + activityId);
        }
        ActivityStatus status = (ActivityStatus)activity.getStates().last();
        if (NotifyMessageType.CLIENT_DATAPULL_DONE != notifyMessageType && NotifyMessageType.CLIENT_DATAPUSH_DONE != notifyMessageType) {
            throw new CommandException("message type not supported!");
        }
        if (NotifyMessageType.CLIENT_DATAPUSH_DONE == notifyMessageType) {
            if (ActivityStatus.StatusName.PREPROCESSING != status.getStatusName()) {
                throw new CommandException("invalid state (" + status.getStatusName() + ")");
            }
            List attributes = status.getStatusAttributes();
            if (attributes == null || !attributes.contains(ActivityStatus.StatusAttributeName.CLIENT_STAGEIN_POSSIBLE)) {
                throw new CommandException("invalid state (activity not in client-stagein-possible state)");
            }
            if (this.isActivityCheckOn(command)) {
                return;
            }
            String localUser = (String)activity.getProperties().get("LOCAL_USER");
            String stageInDir = (String)activity.getProperties().get("SANDBOX_PATH") + File.separator + "ISB";
            ArrayList<String> inputFileList = new ArrayList<String>(0);
            Runtime runtime = Runtime.getRuntime();
            BufferedReader in = null;
            BufferedReader readErr = null;
            Process proc = null;
            String[] cmd = new String[]{"sudo", "-S", "-n", "-u", localUser, "/bin/ls", stageInDir};
            try {
                proc = runtime.exec(cmd);
                in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                String s = null;
                while ((s = in.readLine()) != null) {
                    inputFileList.add(s);
                }
                s = readErr.readLine();
                if (s != null) {
                    throw new Exception(s);
                }
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
                if (proc != null) {
                    proc.destroy();
                }
                throw new CommandException("cannot list the stage-in directory: " + t.getMessage());
            }
            finally {
                if (proc != null) {
                    try {
                        proc.waitFor();
                    }
                    catch (InterruptedException e) {}
                    try {
                        proc.getInputStream().close();
                    }
                    catch (IOException ioe) {}
                    try {
                        proc.getErrorStream().close();
                    }
                    catch (IOException ioe) {}
                    try {
                        proc.getOutputStream().close();
                    }
                    catch (IOException ioe) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                    in = null;
                }
                if (readErr != null) {
                    try {
                        readErr.close();
                    }
                    catch (IOException ex) {}
                    readErr = null;
                }
            }
            for (InputFile inputFile : activity.getDataStaging().getInputFile()) {
                inputFileList.remove(inputFile.getName());
            }
            InputFile inputFile = null;
            for (String file : inputFileList) {
                inputFile = new InputFile();
                inputFile.setName(file);
                inputFile.setIsExecutable(Boolean.FALSE);
                activity.getDataStaging().getInputFile().add(inputFile);
            }
            this.submitActivity(activity, command.getName());
        } else {
            if (ActivityStatus.StatusName.TERMINAL != status.getStatusName()) {
                throw new CommandException("invalid state (" + status.getStatusName() + ")");
            }
            List attributes = status.getStatusAttributes();
            if (attributes == null || !attributes.contains(ActivityStatus.StatusAttributeName.CLIENT_STAGEOUT_POSSIBLE)) {
                throw new CommandException("invalid state (activity not in client-stageout-possible state)");
            }
            attributes.remove(ActivityStatus.StatusAttributeName.CLIENT_STAGEOUT_POSSIBLE);
            try {
                activityDB.updateActivityStatus(status);
                logger.info((Object)("activity " + activity.getId() + " status updated => " + status.toString()));
            }
            catch (Throwable t) {
                throw new CommandException(t.getMessage());
            }
        }
        logger.debug((Object)"END notifyService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitActivity(Activity activity, String commandName) throws CommandException {
        String userDNX500 = (String)activity.getProperties().get("USER_DN_X500");
        String userFQAN = (String)activity.getProperties().get("USER_FQAN");
        String localUser = (String)activity.getProperties().get("LOCAL_USER");
        String activitySandboxDir = (String)activity.getProperties().get("SANDBOX_PATH");
        String lrmsName = this.getParameterValueAsString(DEFAULT_LRMS_NAME);
        String queueName = activity.getResources().getQueueName();
        String virtualOrganisation = (String)activity.getProperties().get("VIRTUAL_ORGANISATION");
        activity.getVolatileProperties().put("CE_ID", hostAddress + ":8443/cream-" + lrmsName + "-" + queueName);
        activity.getVolatileProperties().put("CE_HOSTNAME", hostName);
        activity.getVolatileProperties().put("TEMPLATE_PATH", this.getParameterValueAsString(ACTIVITY_WRAPPER_TEMPLATE_PATH));
        activity.getVolatileProperties().put("ACTIVITY_WRAPPER_NOTIFICATION_STATUS_URI", activityWrapperNotificationStatusURI);
        activity.getVolatileProperties().put(DELEGATION_TIME_SLOT, this.getParameterValueAsString(DELEGATION_TIME_SLOT));
        activity.getVolatileProperties().put("DELEGATION_FILE_NAME_SUFFIX", delegationSuffix);
        if (this.containsParameterKey(COPY_PROXY_MIN_RETRY_WAIT)) {
            activity.getVolatileProperties().put(COPY_PROXY_MIN_RETRY_WAIT, this.getParameterValueAsString(COPY_PROXY_MIN_RETRY_WAIT));
        }
        if (this.containsParameterKey(COPY_RETRY_COUNT_ISB)) {
            activity.getVolatileProperties().put(COPY_RETRY_COUNT_ISB, this.getParameterValueAsString(COPY_RETRY_COUNT_ISB));
        }
        if (this.containsParameterKey(COPY_RETRY_FIRST_WAIT_ISB)) {
            activity.getVolatileProperties().put(COPY_RETRY_FIRST_WAIT_ISB, this.getParameterValueAsString(COPY_RETRY_FIRST_WAIT_ISB));
        }
        if (this.containsParameterKey(COPY_RETRY_COUNT_OSB)) {
            activity.getVolatileProperties().put(COPY_RETRY_COUNT_OSB, this.getParameterValueAsString(COPY_RETRY_COUNT_OSB));
        }
        if (this.containsParameterKey(COPY_RETRY_FIRST_WAIT_OSB)) {
            activity.getVolatileProperties().put(COPY_RETRY_FIRST_WAIT_OSB, this.getParameterValueAsString(COPY_RETRY_FIRST_WAIT_OSB));
        }
        Runtime runtime = Runtime.getRuntime();
        BufferedReader in = null;
        FilterOutputStream os = null;
        BufferedReader readErr = null;
        Process proc = null;
        String[] cmd = new String[]{"sudo", "-S", "-n", "-u", localUser, this.getParameterValueAsString(CREATE_WRAPPER_BIN_PATH), activitySandboxDir + File.separator + activity.getId() + "_activityWrapper.sh"};
        try {
            proc = runtime.exec(cmd);
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            os = new BufferedOutputStream(proc.getOutputStream());
            readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            os.write(ActivityWrapper.buildWrapper(activity).getBytes());
            ((BufferedOutputStream)os).flush();
            os.close();
            os = null;
        }
        catch (Throwable t) {
            ActivityStatus activityStatus = this.makeActivityStatus(ActivityStatus.StatusName.TERMINAL);
            activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.PREPROCESSING_FAILURE);
            activityStatus.setDescription(t.getMessage());
            try {
                activityDB.insertActivityStatus(activity.getId(), activityStatus);
                logger.info((Object)("activity " + activity.getId() + " status changed => " + activityStatus.toString()));
            }
            catch (Throwable t1) {
                logger.error((Object)t1.getMessage(), t1);
            }
            logger.error((Object)t.getMessage(), t);
            if (proc != null) {
                proc.destroy();
            }
            throw new CommandException("cannot create the activity wrapper: " + t.getMessage());
        }
        finally {
            if (proc != null) {
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {}
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ioe) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
                in = null;
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ioe) {}
                os = null;
            }
            if (readErr != null) {
                try {
                    readErr.close();
                }
                catch (IOException ex) {}
                readErr = null;
            }
        }
        BLAHJob blahJob = new BLAHJob();
        blahJob.setUserDN(userDNX500);
        blahJob.setUserFQAN(userFQAN);
        blahJob.setIwd(activitySandboxDir);
        blahJob.setJobId(activity.getId());
        blahJob.setLocalUser(localUser);
        blahJob.setExecutableFile(activitySandboxDir + File.separator + activity.getId() + "_activityWrapper.sh");
        blahJob.setStandardErrorFile(activitySandboxDir + File.separator + "StandardError");
        blahJob.setStandardOuputFile(activitySandboxDir + File.separator + "StandardOutput");
        blahJob.setLRMS(lrmsName);
        blahJob.setQueue(queueName);
        blahJob.setVirtualOrganisation(virtualOrganisation);
        blahJob.setTransferInput((String)activity.getProperties().get("TRANSFER_INPUT"));
        blahJob.setTransferOutput((String)activity.getProperties().get("TRANSFER_OUTPUT"));
        blahJob.setTransferOutputRemaps((String)activity.getProperties().get("TRANSFER_OUTPUT_REMAPS"));
        Hashtable properties = activity.getProperties();
        if (properties.containsKey("NUMBER_OF_SLOTS")) {
            blahJob.setNodeNumber(Integer.parseInt((String)properties.get("NUMBER_OF_SLOTS")));
        }
        if (properties.containsKey("SLOTS_PER_HOST")) {
            blahJob.setSmpGranularity(Integer.parseInt((String)properties.get("SLOTS_PER_HOST")));
        }
        if (properties.containsKey("EXCLUSIVE_EXECUTION")) {
            blahJob.setWholeNodes(Boolean.parseBoolean((String)properties.get("EXCLUSIVE_EXECUTION")));
        }
        activity.getProperties().remove("TRANSFER_INPUT");
        activity.getProperties().remove("TRANSFER_OUTPUT");
        activity.getProperties().remove("TRANSFER_OUTPUT_REMAPS");
        activity.getProperties().remove("DELEGATION_SANDBOX_PATH");
        String failureReason = null;
        ActivityStatus status = null;
        try {
            status = this.makeActivityStatus(ActivityStatus.StatusName.PROCESSING_ACCEPTING);
            activityDB.insertActivityStatus(activity.getId(), status);
            logger.info((Object)("activity " + activity.getId() + " status changed => " + status.toString()));
        }
        catch (Throwable t) {
            throw new CommandException(t.getMessage());
        }
        String blahId = null;
        for (int i = 1; i < 4 && blahId == null; ++i) {
            failureReason = null;
            try {
                blahId = blahClient.submit(blahJob);
                continue;
            }
            catch (BLAHException be) {
                logger.warn((Object)("submission to BLAH failed [activityId=" + activity.getId() + "; reason=" + failureReason + "; retry count=" + i + "/3]"));
                failureReason = be.getMessage();
                ActivityStatus activityStatus = status;
                synchronized (activityStatus) {
                    try {
                        logger.debug((Object)"sleeping 10 sec...");
                        status.wait(10000L);
                        logger.debug((Object)"sleeping 10 sec... done");
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        if (blahId == null) {
            try {
                failureReason = "submission to BLAH failed [retry count=3]" + (failureReason != null ? ": " + failureReason : "");
                ActivityStatus activityStatus = this.makeActivityStatus(ActivityStatus.StatusName.TERMINAL);
                activityStatus.setDescription(failureReason);
                activityStatus.getStatusAttributes().add(ActivityStatus.StatusAttributeName.PREPROCESSING_FAILURE);
                activityDB.insertActivityStatus(activity.getId(), activityStatus);
                logger.info((Object)("activity " + activity.getId() + " status changed => " + activityStatus.toString()));
            }
            catch (Throwable t) {
                throw new CommandException(t.getMessage());
            }
            throw new CommandException(failureReason);
        }
        activity.getProperties().put("LRMS_ABS_LAYER_ID", blahId);
        try {
            status = this.makeActivityStatus(ActivityStatus.StatusName.PROCESSING_QUEUED);
            activityDB.insertActivityStatus(activity.getId(), status);
            logger.info((Object)("activity " + activity.getId() + " status changed => " + status.toString() + "; lrsmsId=" + blahId));
            activityDB.insertActivityCommand(activity.getId(), this.makeActivityCommand(commandName, blahId != null));
            activityDB.updateActivity(activity);
        }
        catch (Throwable t) {
            throw new CommandException(t.getMessage());
        }
    }

    private void pauseActivity(Command command) throws CommandException {
        logger.debug((Object)"BEGIN pauseActivity");
        Activity activity = this.getActivity(command);
        SortedSet states = activity.getStates();
        if (states.isEmpty()) {
            throw new CommandException("none status available");
        }
        ActivityStatus status = (ActivityStatus)states.last();
        if (ActivityStatus.StatusName.TERMINAL == status.getStatusName()) {
            throw new CommandException("invalid state (terminal)");
        }
        if (status.getStatusAttributes().contains(ActivityStatus.StatusAttributeName.CLIENT_PAUSED)) {
            throw new CommandException("invalid state (" + status.getStatusName() + ":client-paused)");
        }
        if (status.getStatusAttributes().contains(ActivityStatus.StatusAttributeName.SERVER_PAUSED)) {
            throw new CommandException("invalid state (" + status.getStatusName() + ":server-paused)");
        }
        String localUser = (String)activity.getProperties().get("LOCAL_USER");
        if (localUser == null) {
            throw new CommandException("LOCAL_USER not speficied!");
        }
        if (this.isActivityCheckOn(command)) {
            return;
        }
        Boolean isSuccess = Boolean.TRUE;
        if (ActivityStatus.StatusName.ACCEPTED == status.getStatusName()) {
            status.setTimestamp(this.newXMLGregorianCalendar(Calendar.getInstance()));
            status.getStatusAttributes().add(ActivityStatus.StatusAttributeName.CLIENT_PAUSED);
            try {
                activityDB.updateActivityStatus(status);
                logger.info((Object)("activity " + activity.getId() + " status updated => " + status.toString()));
                activityDB.insertActivityCommand(activity.getId(), this.makeActivityCommand(command.getName(), isSuccess));
            }
            catch (Throwable t) {
                throw new CommandException(t.getMessage());
            }
        }
        try {
            String lrmsId = (String)activity.getProperties().get("LRMS_ABS_LAYER_ID");
            if (lrmsId == null) {
                throw new CommandException("LRMS_ABS_LAYER_ID not speficied!");
            }
            blahClient.suspend(lrmsId, localUser);
        }
        catch (Throwable e) {
            isSuccess = Boolean.FALSE;
            throw new CommandException("blah error: " + e.getMessage());
        }
        finally {
            try {
                activityDB.insertActivityCommand(activity.getId(), this.makeActivityCommand(command.getName(), isSuccess));
            }
            catch (Throwable t) {
                throw new CommandException(t.getMessage());
            }
        }
        logger.debug((Object)"END pauseActivity");
    }

    private void queryResourceInfo(Command command) throws CommandException {
        try {
            command.getResult().addParameter(ActivityCmd.ActivityCommandField.ACTIVITY_GLUE2_ATTRIBUTE_LIST.name(), (Object)glue2Handler.executeXPathQuery(command.getParameterAsString(ActivityCmd.ActivityCommandField.XPATH_QUERY.name())));
        }
        catch (Throwable t) {
            throw new CommandException(t.getMessage());
        }
    }

    private void restartActivity(Command command) throws CommandException {
        throw new CommandException("operation not yet implemented!");
    }

    private void resumeActivity(Command command) throws CommandException {
        logger.debug((Object)"BEGIN resumeActivity");
        Activity activity = this.getActivity(command);
        SortedSet states = activity.getStates();
        if (states.isEmpty()) {
            throw new CommandException("none status available");
        }
        ActivityStatus status = (ActivityStatus)states.last();
        if (ActivityStatus.StatusName.TERMINAL == status.getStatusName()) {
            throw new CommandException("invalid state (terminal)");
        }
        if (!status.getStatusAttributes().contains(ActivityStatus.StatusAttributeName.CLIENT_PAUSED) && !status.getStatusAttributes().contains(ActivityStatus.StatusAttributeName.SERVER_PAUSED)) {
            throw new CommandException("invalid state (activity not paused)");
        }
        String localUser = (String)activity.getProperties().get("LOCAL_USER");
        if (localUser == null) {
            throw new CommandException("LOCAL_USER not speficied!");
        }
        if (this.isActivityCheckOn(command)) {
            return;
        }
        Boolean isSuccess = Boolean.TRUE;
        if (ActivityStatus.StatusName.ACCEPTED == status.getStatusName()) {
            status.setTimestamp(this.newXMLGregorianCalendar(Calendar.getInstance()));
            status.getStatusAttributes().remove(ActivityStatus.StatusAttributeName.CLIENT_PAUSED);
            try {
                activityDB.updateActivityStatus(status);
                logger.info((Object)("activity " + activity.getId() + " status updated => " + status.toString()));
                activityDB.insertActivityCommand(activity.getId(), this.makeActivityCommand(command.getName(), isSuccess));
            }
            catch (Throwable t) {
                throw new CommandException(t.getMessage());
            }
        }
        try {
            String lrmsId = (String)activity.getProperties().get("LRMS_ABS_LAYER_ID");
            if (lrmsId == null) {
                throw new CommandException("LRMS_ABS_LAYER_ID not speficied!");
            }
            blahClient.resume(lrmsId, localUser);
        }
        catch (Throwable e) {
            isSuccess = Boolean.FALSE;
            throw new CommandException("blah error: " + e.getMessage());
        }
        finally {
            try {
                activityDB.insertActivityCommand(activity.getId(), this.makeActivityCommand(command.getName(), isSuccess));
            }
            catch (Throwable t) {
                throw new CommandException(t.getMessage());
            }
        }
        logger.debug((Object)"END resumeActivity");
    }

    private void startActivity(Command command) throws CommandException {
        logger.debug((Object)"BEGIN startActivity");
        Activity activity = this.getActivity(command);
        if (!(((ActivityStatus)activity.getStates().last()).getStatusAttributes().contains(ActivityStatus.StatusAttributeName.CLIENT_PAUSED) || activity.getDataStaging() != null && activity.getDataStaging().isClientDataPush().booleanValue())) {
            this.submitActivity(activity, command.getName());
        }
        logger.debug((Object)"END startActivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void wipeActivity(Command command) throws CommandException {
        logger.debug((Object)"BEGIN wipeActivity");
        Activity activity = this.getActivity(command);
        SortedSet states = activity.getStates();
        if (states.isEmpty()) {
            throw new CommandException("none status available");
        }
        ActivityStatus status = (ActivityStatus)states.last();
        if (ActivityStatus.StatusName.TERMINAL != status.getStatusName()) {
            throw new CommandException("invalid state (" + status.getStatusName() + ")");
        }
        String localUser = (String)activity.getProperties().get("LOCAL_USER");
        if (localUser == null) {
            throw new CommandException("LOCAL_USER not speficied!");
        }
        String sandboxPath = (String)activity.getProperties().get("SANDBOX_PATH");
        if (sandboxPath == null) {
            throw new CommandException("SANDBOX_PATH not speficied!");
        }
        if (this.isActivityCheckOn(command)) {
            return;
        }
        Process proc = null;
        try {
            String[] cmd = new String[]{"sudo", "-S", "-n", "-u", localUser, this.getParameterValueAsString(PURGE_SANDBOX_BIN_PATH), sandboxPath};
            proc = Runtime.getRuntime().exec(cmd);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
        finally {
            block70: {
                StringBuffer errorMessage;
                block71: {
                    block72: {
                        if (proc == null) break block70;
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {}
                        errorMessage = null;
                        if (proc.exitValue() == 0) break block71;
                        BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        errorMessage = new StringBuffer();
                        String inputLine = null;
                        while ((inputLine = readErr.readLine()) != null) {
                            errorMessage.append(inputLine);
                        }
                        try {
                            readErr.close();
                        }
                        catch (IOException ioe) {}
                        break block72;
                        catch (IOException ioe) {
                            try {
                                logger.error((Object)ioe.getMessage());
                            }
                            catch (Throwable throwable) {
                                try {
                                    readErr.close();
                                }
                                catch (IOException ioe2) {}
                                throw throwable;
                            }
                            try {
                                readErr.close();
                            }
                            catch (IOException ioe3) {}
                        }
                    }
                    if (errorMessage.length() > 0) {
                        errorMessage.append("\n");
                    }
                }
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ioe) {}
                if (errorMessage != null) {
                    throw new CommandException(errorMessage.toString());
                }
            }
        }
        try {
            activityDB.deleteActivity(activity.getId(), null);
        }
        catch (DatabaseException e) {
            logger.error((Object)e.getMessage());
            throw new CommandException(e.getMessage());
        }
        logger.debug((Object)"END wipeActivity");
    }
}

