/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.db.table.LeaseTableJobTableJobStatusInterface;

public class LeaseTableJobTableJobStatusTable
implements LeaseTableJobTableJobStatusInterface {
    private static final Logger logger = Logger.getLogger(LeaseTableJobTableJobStatusTable.class);

    public LeaseTableJobTableJobStatusTable() throws SQLException {
        logger.debug((Object)"Call LeaseTableJobTableJobStatusTable constructor");
    }

    public List<String> executeSelectToRetrieveJobIdByLease(int[] jobStatusType, String leaseId, Calendar maxLeaseTime, String userId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobIdByLease");
        ArrayList<String> jobIdList = new ArrayList<String>();
        PreparedStatement selectToRetrieveJobIdPreparedStatement = connection.prepareStatement(LeaseTableJobTableJobStatusTable.getSelectToRetrieveJobIdQuery(jobStatusType, leaseId, maxLeaseTime, userId));
        ResultSet rs = selectToRetrieveJobIdPreparedStatement.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                jobIdList.add(rs.getString("id"));
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobIdByLease");
        return jobIdList;
    }

    public static String getSelectToRetrieveJobIdQuery(int[] jobStatusType, String leaseId, Calendar maxLeaseTime, String userId) {
        StringBuffer selectToRetrieveJobIdQuery = new StringBuffer();
        selectToRetrieveJobIdQuery.append("select ");
        selectToRetrieveJobIdQuery.append("job.id AS id");
        selectToRetrieveJobIdQuery.append(" from job");
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToRetrieveJobIdQuery.append(", job_status AS job_status LEFT OUTER JOIN job_status AS jslatest ");
            selectToRetrieveJobIdQuery.append("ON jslatest.jobId = job_status.jobId");
            selectToRetrieveJobIdQuery.append(" and job_status.id < jslatest.id");
        }
        if (maxLeaseTime != null) {
            selectToRetrieveJobIdQuery.append(", job_lease");
        }
        selectToRetrieveJobIdQuery.append(" where true ");
        if (userId != null) {
            selectToRetrieveJobIdQuery.append(" and job.userId = '" + userId + "'");
        }
        if (leaseId != null) {
            selectToRetrieveJobIdQuery.append(" and job.leaseId = '" + leaseId + "'");
        }
        if (maxLeaseTime != null) {
            selectToRetrieveJobIdQuery.append(" and job.leaseId = job_lease.leaseId");
            Timestamp maxLeaseTimestampField = new Timestamp(maxLeaseTime.getTimeInMillis());
            selectToRetrieveJobIdQuery.append(" and leaseTime <= '" + maxLeaseTimestampField.toString() + "'");
        }
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToRetrieveJobIdQuery.append(" and jslatest.id IS NULL");
            StringBuffer jobStatusTypeList = new StringBuffer();
            for (int i = 0; i < jobStatusType.length; ++i) {
                jobStatusTypeList.append(", '" + jobStatusType[i] + "'");
            }
            jobStatusTypeList.deleteCharAt(0);
            selectToRetrieveJobIdQuery.append(" and job_status.type IN (" + jobStatusTypeList.toString() + ")");
            selectToRetrieveJobIdQuery.append(" and job_status.jobId = job.id");
        }
        logger.debug((Object)("selectToRetrieveJobIdQuery = " + selectToRetrieveJobIdQuery.toString()));
        return selectToRetrieveJobIdQuery.toString();
    }
}

