/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.Lease;
import org.glite.ce.creamapi.jobmanagement.db.table.LeaseTableInterface;

public class LeaseTable
implements LeaseTableInterface {
    public static final String NAME_TABLE = "job_lease";
    public static final String LEASE_ID_FIELD = "leaseId";
    public static final String LEASE_TIME_FIELD = "leaseTime";
    public static final String USER_ID_FIELD = "userId";
    private static final String insertQuery = LeaseTable.getInsertQuery();
    private static final String updateQuery = LeaseTable.getUpdateQuery();
    private static final String deleteQuery = LeaseTable.getDeleteQuery();
    private static final Logger logger = Logger.getLogger(LeaseTable.class);

    public LeaseTable() throws SQLException {
        logger.debug((Object)"Call LeaseTable constructor");
    }

    public int executeDelete(String leaseId, String userId, Connection connection) throws SQLException {
        logger.debug((Object)("Begin executeDelete for leaseId = " + leaseId));
        PreparedStatement deletePreparedStatement = null;
        int rowCount = 0;
        try {
            deletePreparedStatement = connection.prepareStatement(deleteQuery);
            deletePreparedStatement = this.fillDeletePreparedStatement(leaseId, userId, deletePreparedStatement);
            rowCount = deletePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)("End executeDelete for leaseId = " + leaseId));
        return rowCount;
    }

    public int executeUpdate(Lease jobLease, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeUpdate");
        logger.debug((Object)("updateQuery (LeaseTable)= " + updateQuery));
        PreparedStatement updatePreparedStatement = null;
        int rowCount = 0;
        try {
            updatePreparedStatement = connection.prepareStatement(updateQuery);
            updatePreparedStatement = this.fillUpdatePreparedStatement(jobLease, updatePreparedStatement);
            rowCount = updatePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (updatePreparedStatement != null) {
                try {
                    updatePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeUpdate");
        return rowCount;
    }

    private PreparedStatement fillDeletePreparedStatement(String leaseId, String userId, PreparedStatement deletePreparedStatement) throws SQLException {
        deletePreparedStatement.setString(1, leaseId);
        deletePreparedStatement.setString(2, userId);
        return deletePreparedStatement;
    }

    public int executeInsert(Lease jobLease, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeInsert");
        PreparedStatement insertPreparedStatement = null;
        int rowCount = 0;
        if (jobLease != null) {
            logger.debug((Object)("UserId    = " + jobLease.getUserId()));
            logger.debug((Object)("LeaseId   = " + jobLease.getLeaseId()));
            logger.debug((Object)("LeaseTime = " + jobLease.getLeaseTime()));
        }
        try {
            insertPreparedStatement = connection.prepareStatement(insertQuery);
            insertPreparedStatement = this.fillInsertPreparedStatement(jobLease, insertPreparedStatement);
            logger.debug((Object)("Insert query = " + insertPreparedStatement.toString()));
            rowCount = insertPreparedStatement.executeUpdate();
            logger.debug((Object)("Rows inserted: " + rowCount));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (insertPreparedStatement != null) {
                try {
                    insertPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeInsert");
        return rowCount;
    }

    private PreparedStatement fillInsertPreparedStatement(Lease jobLease, PreparedStatement insertPreparedStatement) throws SQLException {
        insertPreparedStatement.setString(1, jobLease.getLeaseId());
        insertPreparedStatement.setTimestamp(2, new Timestamp(jobLease.getLeaseTime().getTimeInMillis()));
        insertPreparedStatement.setString(3, jobLease.getUserId());
        return insertPreparedStatement;
    }

    private PreparedStatement fillUpdatePreparedStatement(Lease jobLease, PreparedStatement updatePreparedStatement) throws SQLException {
        updatePreparedStatement.setTimestamp(1, new Timestamp(jobLease.getLeaseTime().getTimeInMillis()));
        updatePreparedStatement.setString(2, jobLease.getUserId());
        updatePreparedStatement.setString(3, jobLease.getLeaseId());
        return updatePreparedStatement;
    }

    public List<Lease> executeSelect(String leaseId, String userId, Calendar leaseTime, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelect");
        ArrayList<Lease> leaseList = new ArrayList<Lease>();
        Lease lease = null;
        PreparedStatement selectPreparedStatement = connection.prepareStatement(LeaseTable.getSelectQuery(leaseTime, leaseId, userId));
        ResultSet rs = selectPreparedStatement.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                lease = new Lease();
                lease.setLeaseId(rs.getString(LEASE_ID_FIELD));
                lease.setUserId(rs.getString(USER_ID_FIELD));
                Timestamp timeStampField = rs.getTimestamp(LEASE_TIME_FIELD);
                Calendar calendar = null;
                calendar = Calendar.getInstance();
                calendar.setTimeInMillis(timeStampField.getTime());
                lease.setLeaseTime(calendar);
                leaseList.add(lease);
            }
        }
        logger.debug((Object)"End executeSelect");
        return leaseList;
    }

    private static String getInsertQuery() {
        StringBuffer insertQuery = new StringBuffer();
        insertQuery.append("insert into ");
        insertQuery.append(NAME_TABLE);
        insertQuery.append(" ( ");
        insertQuery.append("leaseId, ");
        insertQuery.append("leaseTime, ");
        insertQuery.append(USER_ID_FIELD);
        insertQuery.append(" ) ");
        insertQuery.append("values(?, ?, ?)");
        return insertQuery.toString();
    }

    private static String getDeleteQuery() {
        StringBuffer deleteQuery = new StringBuffer();
        deleteQuery.append("delete from ");
        deleteQuery.append(NAME_TABLE);
        deleteQuery.append(" where ");
        deleteQuery.append("leaseId = ? ");
        deleteQuery.append(" and userId = ? ");
        return deleteQuery.toString();
    }

    private static String getUpdateQuery() {
        StringBuffer deleteQuery = new StringBuffer();
        deleteQuery.append("update ");
        deleteQuery.append(NAME_TABLE);
        deleteQuery.append(" set leaseTime = ? ");
        deleteQuery.append(" where ");
        deleteQuery.append("userId = ? ");
        deleteQuery.append(" and leaseId = ? ");
        return deleteQuery.toString();
    }

    private static String getSelectQuery(Calendar leaseTime, String leaseId, String userId) {
        StringBuffer selectQuery = new StringBuffer();
        selectQuery.append("select ");
        selectQuery.append("leaseId, ");
        selectQuery.append("userId, ");
        selectQuery.append(LEASE_TIME_FIELD);
        selectQuery.append(" from job_lease");
        selectQuery.append(" where true ");
        if (userId != null) {
            selectQuery.append(" and userId = '" + userId + "'");
        }
        if (leaseId != null) {
            selectQuery.append(" and leaseId = '" + leaseId + "'");
        }
        if (leaseTime != null) {
            selectQuery.append(" and leaseTime <= '" + new Timestamp(leaseTime.getTimeInMillis()).toString() + "'");
        }
        return selectQuery.toString();
    }
}

