/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.eventmanagement.Event;
import org.glite.ce.creamapi.eventmanagement.Property;
import org.glite.ce.creamapi.jobmanagement.JobStatus;
import org.glite.ce.creamapi.jobmanagement.db.table.JobStatusTableInterface;

public class JobStatusTable
implements JobStatusTableInterface {
    public static final String NAME_TABLE = "job_status";
    public static final String TYPE_FIELD = "type";
    public static final String EXIT_CODE_FIELD = "exitCode";
    public static final String FAILURE_REASON_FIELD = "failureReason";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String TIMESTAMP_FIELD = "time_stamp";
    public static final String JOB_ID_FIELD = "jobId";
    public static final String ID_FIELD = "id";
    private static final String JOB_STATUS_SEQUENCE_NAME = "job_status_id_seq";
    private static final String GET_SEQUENCE_QUERY = "select nextVal('job_status_id_seq ')";
    private static final String insertQuery = JobStatusTable.getInsertQuery();
    private static final String deleteQuery = JobStatusTable.getDeleteQuery();
    private static final String selectHistoryQuery = JobStatusTable.getSelectHistoryQuery();
    private static final String updateQuery = JobStatusTable.getUpdateQuery();
    private static final Logger logger = Logger.getLogger((String)JobStatusTable.class.getName());

    public JobStatusTable() throws SQLException {
        logger.debug((Object)"Call JobStatusTable constructor");
    }

    public int executeInsert(List<JobStatus> jobStatusList, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeInsert");
        PreparedStatement insertPreparedStatement = null;
        ResultSet rset = null;
        int rowCountTot = 0;
        try {
            insertPreparedStatement = connection.prepareStatement(insertQuery, 1);
            int rowCount = 0;
            for (int index = 0; index < jobStatusList.size(); ++index) {
                insertPreparedStatement = this.fillInsertPreparedStatement(jobStatusList.get(index), insertPreparedStatement);
                rowCount = insertPreparedStatement.executeUpdate();
                long statusId = -1L;
                rset = insertPreparedStatement.getGeneratedKeys();
                if (!rset.next()) {
                    throw new SQLException("Problem in retrieving autogenerated keys");
                }
                statusId = rset.getLong(1);
                jobStatusList.get(index).setId(statusId);
                insertPreparedStatement.clearParameters();
                rowCountTot += rowCount;
            }
            logger.debug((Object)("Rows inserted: " + rowCountTot));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (insertPreparedStatement != null) {
                try {
                    insertPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeInsert");
        return rowCountTot;
    }

    private PreparedStatement fillInsertPreparedStatement(JobStatus jobStatus, PreparedStatement insertPreparedStatement) throws SQLException {
        insertPreparedStatement.setInt(1, jobStatus.getType());
        insertPreparedStatement.setString(2, jobStatus.getExitCode());
        insertPreparedStatement.setString(3, jobStatus.getFailureReason());
        insertPreparedStatement.setString(4, jobStatus.getDescription());
        insertPreparedStatement.setTimestamp(5, new Timestamp(jobStatus.getTimestamp().getTimeInMillis()));
        insertPreparedStatement.setString(6, jobStatus.getJobId());
        return insertPreparedStatement;
    }

    public int executeDelete(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeDelete");
        PreparedStatement deletePreparedStatement = null;
        int rowCount = 0;
        try {
            deletePreparedStatement = connection.prepareStatement(deleteQuery);
            deletePreparedStatement = this.fillDeletePreparedStatement(jobId, deletePreparedStatement);
            rowCount = deletePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeDelete");
        return rowCount;
    }

    private PreparedStatement fillDeletePreparedStatement(String jobId, PreparedStatement deletePreparedStatement) throws SQLException {
        deletePreparedStatement.setString(1, jobId);
        return deletePreparedStatement;
    }

    public JobStatus executeSelectLastJobStatus(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectLastJobStatus");
        List<JobStatus> jobStatusList = null;
        JobStatus jobStatus = null;
        jobStatusList = this.executeSelectJobStatusHistory(jobId, connection);
        if (jobStatusList.size() > 0) {
            logger.debug((Object)("jobStatusList.size() = " + jobStatusList.size()));
            jobStatus = jobStatusList.get(jobStatusList.size() - 1);
        }
        logger.debug((Object)"End executeSelectLastJobStatus");
        return jobStatus;
    }

    public List<JobStatus> executeSelectJobStatusHistory(String jobId, Connection connection) throws SQLException {
        return this.selectJobStatusHistory(jobId, connection);
    }

    private List<JobStatus> selectJobStatusHistory(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin selectJobStatusHistory");
        List<JobStatus> jobStatusDBList = null;
        PreparedStatement selectHistoryPreparedStatement = null;
        try {
            selectHistoryPreparedStatement = connection.prepareStatement(selectHistoryQuery);
            selectHistoryPreparedStatement = this.fillSelectHistoryPreparedStatement(jobId, selectHistoryPreparedStatement);
            ResultSet rs = selectHistoryPreparedStatement.executeQuery();
            if (rs != null) {
                jobStatusDBList = this.buildJobStatusDBList(rs);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectHistoryPreparedStatement != null) {
                try {
                    selectHistoryPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End selectJobStatusHistory");
        return jobStatusDBList;
    }

    public void executeUpdateJobStatus(JobStatus jobStatus, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeUpdateJobStatus");
        PreparedStatement updatePreparedStatement = null;
        try {
            updatePreparedStatement = connection.prepareStatement(updateQuery);
            updatePreparedStatement = this.fillUpdatePreparedStatement(jobStatus, updatePreparedStatement);
            updatePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (updatePreparedStatement != null) {
                try {
                    updatePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeUpdateJobStatus");
    }

    private PreparedStatement fillUpdatePreparedStatement(JobStatus jobStatus, PreparedStatement updatePreparedStatement) throws SQLException {
        updatePreparedStatement.setInt(1, jobStatus.getType());
        updatePreparedStatement.setString(2, jobStatus.getExitCode());
        updatePreparedStatement.setString(3, jobStatus.getFailureReason());
        updatePreparedStatement.setString(4, jobStatus.getDescription());
        if (jobStatus.getTimestamp() != null) {
            updatePreparedStatement.setTimestamp(5, new Timestamp(jobStatus.getTimestamp().getTimeInMillis()));
        } else {
            updatePreparedStatement.setTimestamp(5, null);
        }
        updatePreparedStatement.setLong(6, jobStatus.getId());
        updatePreparedStatement.setString(7, jobStatus.getJobId());
        return updatePreparedStatement;
    }

    private PreparedStatement fillSelectHistoryPreparedStatement(String jobId, PreparedStatement selectHistoryPreparedStatement) throws SQLException {
        selectHistoryPreparedStatement.setString(1, jobId);
        return selectHistoryPreparedStatement;
    }

    private long getIDSequence(Connection connection) throws SQLException {
        long id;
        block11: {
            id = -1L;
            PreparedStatement sequencePreparedStatement = null;
            try {
                sequencePreparedStatement = connection.prepareStatement(GET_SEQUENCE_QUERY);
                ResultSet rs = sequencePreparedStatement.executeQuery();
                if (rs != null && rs.next()) {
                    id = rs.getLong(1);
                    break block11;
                }
                throw new SQLException("Impossible retrieve sequence id for job_status");
            }
            catch (SQLException sqle) {
                throw sqle;
            }
            finally {
                if (sequencePreparedStatement != null) {
                    try {
                        sequencePreparedStatement.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
            }
        }
        return id;
    }

    private List<JobStatus> buildJobStatusDBList(ResultSet rs) throws SQLException {
        ArrayList<JobStatus> jobStatusDBList = new ArrayList<JobStatus>();
        while (rs.next()) {
            jobStatusDBList.add(this.buildJobStatusDB(rs));
        }
        return jobStatusDBList;
    }

    private JobStatus buildJobStatusDB(ResultSet rs) throws SQLException {
        JobStatus jobStatus = null;
        jobStatus = new JobStatus(rs.getInt(TYPE_FIELD));
        jobStatus.setExitCode(rs.getString(EXIT_CODE_FIELD));
        jobStatus.setFailureReason(rs.getString(FAILURE_REASON_FIELD));
        jobStatus.setDescription(rs.getString(DESCRIPTION_FIELD));
        Timestamp timeStampField = rs.getTimestamp(TIMESTAMP_FIELD);
        Calendar calendar = null;
        calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeStampField.getTime());
        jobStatus.setTimestamp(calendar);
        jobStatus.setJobId(rs.getString(JOB_ID_FIELD));
        int id = rs.getInt(ID_FIELD);
        jobStatus.setId((long)id);
        return jobStatus;
    }

    private static String getInsertQuery() {
        StringBuffer queryInsertJobStatusTable = new StringBuffer();
        queryInsertJobStatusTable.append("insert into ");
        queryInsertJobStatusTable.append(NAME_TABLE);
        queryInsertJobStatusTable.append(" (");
        queryInsertJobStatusTable.append("type, ");
        queryInsertJobStatusTable.append("exitCode, ");
        queryInsertJobStatusTable.append("failureReason, ");
        queryInsertJobStatusTable.append("description, ");
        queryInsertJobStatusTable.append("time_stamp, ");
        queryInsertJobStatusTable.append(JOB_ID_FIELD);
        queryInsertJobStatusTable.append(") ");
        queryInsertJobStatusTable.append("values(?, ?, ?, ?, ?, ?)");
        return queryInsertJobStatusTable.toString();
    }

    private static String getSelectHistoryQuery() {
        StringBuffer selectLastJobStatusQuery = new StringBuffer();
        selectLastJobStatusQuery.append("select ");
        selectLastJobStatusQuery.append("type AS type, ");
        selectLastJobStatusQuery.append("exitCode AS exitCode, ");
        selectLastJobStatusQuery.append("failureReason AS failureReason, ");
        selectLastJobStatusQuery.append("description AS description, ");
        selectLastJobStatusQuery.append("time_stamp AS time_stamp, ");
        selectLastJobStatusQuery.append("jobId AS jobId, ");
        selectLastJobStatusQuery.append("id AS id");
        selectLastJobStatusQuery.append(" from job_status");
        selectLastJobStatusQuery.append(" where ");
        selectLastJobStatusQuery.append("jobId = ? ORDER BY ");
        selectLastJobStatusQuery.append(ID_FIELD);
        return selectLastJobStatusQuery.toString();
    }

    private static String getSelectToRetrieveJobStatusQuery(String fromJobStatusId, String toJobStatusId, Calendar fromDate, Calendar toDate, int maxEvents, String iceId, String userId) {
        StringBuffer selectToRetrieveJobStatusQuery = new StringBuffer();
        selectToRetrieveJobStatusQuery.append("select ");
        selectToRetrieveJobStatusQuery.append("job_status.type AS type, ");
        selectToRetrieveJobStatusQuery.append("job_status.exitCode AS exitCode, ");
        selectToRetrieveJobStatusQuery.append("job_status.failureReason AS failureReason, ");
        selectToRetrieveJobStatusQuery.append("job_status.description AS description, ");
        selectToRetrieveJobStatusQuery.append("job_status.time_stamp AS time_stamp, ");
        selectToRetrieveJobStatusQuery.append("job_status.jobId AS jobId, ");
        selectToRetrieveJobStatusQuery.append("job_status.id AS id");
        selectToRetrieveJobStatusQuery.append(" from job_status");
        selectToRetrieveJobStatusQuery.append(", job");
        selectToRetrieveJobStatusQuery.append(" where job_status.jobId = job.id");
        if (!JobStatusTable.isEmptyField(userId)) {
            selectToRetrieveJobStatusQuery.append(" and job.userId = '" + userId + "'");
        }
        if (!JobStatusTable.isEmptyField(iceId)) {
            selectToRetrieveJobStatusQuery.append(" and job.iceId = '" + iceId + "'");
        }
        if (!JobStatusTable.isEmptyField(fromJobStatusId)) {
            selectToRetrieveJobStatusQuery.append(" and job_status.id >= " + fromJobStatusId);
        }
        if (!JobStatusTable.isEmptyField(toJobStatusId)) {
            selectToRetrieveJobStatusQuery.append(" and job_status.id <= " + toJobStatusId);
        }
        if (fromDate != null) {
            Timestamp fromDateTimestampField = new Timestamp(fromDate.getTimeInMillis());
            selectToRetrieveJobStatusQuery.append(" and time_stamp >= '" + fromDateTimestampField.toString() + "'");
        }
        if (toDate != null) {
            Timestamp toDateTimestampField = new Timestamp(toDate.getTimeInMillis());
            selectToRetrieveJobStatusQuery.append(" and time_stamp <= '" + toDateTimestampField.toString() + "'");
        }
        selectToRetrieveJobStatusQuery.append(" ORDER BY job_status.id");
        selectToRetrieveJobStatusQuery.append(" limit " + maxEvents);
        logger.debug((Object)("selectToRetrieveJobStatusQuery = " + selectToRetrieveJobStatusQuery.toString()));
        return selectToRetrieveJobStatusQuery.toString();
    }

    private static String getSelectToRetrieveJobStatusAsEventQuery(String fromJobStatusId, String toJobStatusId, Calendar fromDate, Calendar toDate, int[] jobStatusType, int maxEvents, String iceId, String userId) {
        StringBuffer selectToRetrieveJobStatusTableJobTableAsEventQuery = new StringBuffer();
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("select ");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("job_status.type AS type,");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("job_status.exitCode AS exitCode,");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("job_status.failureReason AS failureReason,");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("job_status.description AS description,");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("job_status.time_stamp AS time_stamp,");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("job_status.jobId AS jobId,");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("job_status.id AS id,");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("job.gridJobId AS gridJobId,");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append("job.workerNode AS workerNode");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" from job_status, job");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" where job_status.jobId = job.id");
        if (jobStatusType != null && jobStatusType.length > 0) {
            StringBuffer jobStatusTypeList = new StringBuffer();
            for (int i = 0; i < jobStatusType.length; ++i) {
                jobStatusTypeList.append(", '" + jobStatusType[i] + "'");
            }
            jobStatusTypeList.deleteCharAt(0);
            selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" and job_status.type IN (" + jobStatusTypeList.toString() + ")");
        }
        if (!JobStatusTable.isEmptyField(userId)) {
            selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" and job.userId = '" + userId + "'");
        }
        if (!JobStatusTable.isEmptyField(iceId)) {
            selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" and job.iceId = '" + iceId + "'");
        }
        if (!JobStatusTable.isEmptyField(fromJobStatusId)) {
            selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" and job_status.id >= " + fromJobStatusId);
        }
        if (!JobStatusTable.isEmptyField(toJobStatusId)) {
            selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" and job_status.id <= " + toJobStatusId);
        }
        if (fromDate != null) {
            Timestamp fromDateTimestampField = new Timestamp(fromDate.getTimeInMillis());
            selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" and time_stamp >= '" + fromDateTimestampField.toString() + "'");
        }
        if (toDate != null) {
            Timestamp toDateTimestampField = new Timestamp(toDate.getTimeInMillis());
            selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" and time_stamp <= '" + toDateTimestampField.toString() + "'");
        }
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" ORDER BY job_status.id");
        selectToRetrieveJobStatusTableJobTableAsEventQuery.append(" limit " + maxEvents);
        logger.debug((Object)("selectToRetrieveJobStatusQuery = " + selectToRetrieveJobStatusTableJobTableAsEventQuery.toString()));
        return selectToRetrieveJobStatusTableJobTableAsEventQuery.toString();
    }

    private static String getUpdateQuery() {
        StringBuffer queryUpdateJobStatusTable = new StringBuffer();
        queryUpdateJobStatusTable.append("update ");
        queryUpdateJobStatusTable.append(NAME_TABLE);
        queryUpdateJobStatusTable.append(" set ");
        queryUpdateJobStatusTable.append("type = ?, ");
        queryUpdateJobStatusTable.append("exitCode = ?, ");
        queryUpdateJobStatusTable.append("failureReason = ?, ");
        queryUpdateJobStatusTable.append("description = ?, ");
        queryUpdateJobStatusTable.append("time_stamp = ? ");
        queryUpdateJobStatusTable.append(" where ");
        queryUpdateJobStatusTable.append("id = ? ");
        queryUpdateJobStatusTable.append(" and jobId = ?");
        return queryUpdateJobStatusTable.toString();
    }

    private static String getDeleteQuery() {
        StringBuffer queryInsertJobStatusTable = new StringBuffer();
        queryInsertJobStatusTable.append("delete from ");
        queryInsertJobStatusTable.append(NAME_TABLE);
        queryInsertJobStatusTable.append(" where ");
        queryInsertJobStatusTable.append("jobId = ? ");
        return queryInsertJobStatusTable.toString();
    }

    public void executeUpdateStatusHistory(String jobId, List<JobStatus> jobStatusList, Connection connection) throws SQLException {
        logger.debug((Object)("Begin executeUpdateStatusHistory for jobid = " + jobId));
        List<JobStatus> jobStatusDBList = this.selectJobStatusHistory(jobId, connection);
        if (jobStatusList.size() != jobStatusDBList.size()) {
            String errorMsg = "Error updating StatusHistory for jobid = " + jobId + ". Num status in db = " + jobStatusDBList.size() + " Num status in updating = " + jobStatusList.size();
            logger.error((Object)errorMsg);
            throw new SQLException(errorMsg);
        }
        for (int index = 0; index < jobStatusDBList.size(); ++index) {
            this.executeUpdateJobStatus(jobStatusDBList.get(index), connection);
        }
        logger.debug((Object)("End executeUpdateStatusHistory for jobid = " + jobId));
    }

    public List<JobStatus> executeSelectToRetrieveJobStatus(String fromJobStatusId, String toJobStatusId, Calendar fromDate, Calendar toDate, int maxElements, String iceId, String userId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobStatus");
        List<JobStatus> jobStatusDBList = null;
        Statement selectToRetrieveJobStatusPreparedStatement = null;
        try {
            selectToRetrieveJobStatusPreparedStatement = connection.prepareStatement(JobStatusTable.getSelectToRetrieveJobStatusQuery(fromJobStatusId, toJobStatusId, fromDate, toDate, maxElements, iceId, userId));
            ResultSet rs = selectToRetrieveJobStatusPreparedStatement.executeQuery();
            if (rs != null) {
                jobStatusDBList = this.buildJobStatusDBList(rs);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectToRetrieveJobStatusPreparedStatement != null) {
                try {
                    selectToRetrieveJobStatusPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobStatus");
        return jobStatusDBList;
    }

    public List<Event> executeSelectToRetrieveJobStatusAsEvent(String fromJobStatusId, String toJobStatusId, Calendar fromDate, Calendar toDate, int[] jobStatusType, int maxElements, String iceId, String userId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobStatusAsEvent");
        List<Event> eventList = null;
        Statement selectToRetrieveJobStatusAsEventPreparedStatement = null;
        try {
            selectToRetrieveJobStatusAsEventPreparedStatement = connection.prepareStatement(JobStatusTable.getSelectToRetrieveJobStatusAsEventQuery(fromJobStatusId, toJobStatusId, fromDate, toDate, jobStatusType, maxElements, iceId, userId));
            ResultSet rs = selectToRetrieveJobStatusAsEventPreparedStatement.executeQuery();
            if (rs != null) {
                eventList = this.buildEventsFromJobStatusAsEvent(rs);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectToRetrieveJobStatusAsEventPreparedStatement != null) {
                try {
                    selectToRetrieveJobStatusAsEventPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobStatusAsEvent");
        return eventList;
    }

    private List<Event> buildEventsFromJobStatusAsEvent(ResultSet rs) throws SQLException {
        ArrayList<Event> eventList = new ArrayList<Event>(0);
        while (rs.next()) {
            eventList.add(this.buildEventFromJobStatusAsEvent(rs));
        }
        return eventList;
    }

    private Event buildEventFromJobStatusAsEvent(ResultSet rs) throws SQLException {
        Calendar timeStampEvent = null;
        timeStampEvent = Calendar.getInstance();
        timeStampEvent.setTimeInMillis(rs.getTimestamp(TIMESTAMP_FIELD).getTime());
        Event event = new Event(String.valueOf(rs.getInt(ID_FIELD)), "JOBSTATUS", timeStampEvent);
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(new Property(JOB_ID_FIELD, (Object)rs.getString(JOB_ID_FIELD), "String"));
        properties.add(new Property(FAILURE_REASON_FIELD, (Object)rs.getString(FAILURE_REASON_FIELD), "String"));
        properties.add(new Property(EXIT_CODE_FIELD, (Object)rs.getString(EXIT_CODE_FIELD), "String"));
        properties.add(new Property(DESCRIPTION_FIELD, (Object)rs.getString(DESCRIPTION_FIELD), "String"));
        properties.add(new Property(TYPE_FIELD, (Object)("" + rs.getInt(TYPE_FIELD)), "String"));
        properties.add(new Property("gridJobId", (Object)rs.getString("gridJobId"), "String"));
        properties.add(new Property("workerNode", (Object)rs.getString("workerNode"), "String"));
        event.setProperty(properties);
        return event;
    }

    private static boolean isEmptyField(String field) {
        return field == null || "".equals(field.trim());
    }
}

