/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.command.JobCommand;
import org.glite.ce.creamapi.jobmanagement.db.table.JobCommandTableInterface;

public class JobCommandTable
implements JobCommandTableInterface {
    private static final Logger logger = Logger.getLogger((String)JobCommandTable.class.getName());
    public static final String NAME_TABLE = "job_command";
    public static final String ID_FIELD = "id";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String STATUS_TYPE_FIELD = "statusType";
    public static final String FAILURE_REASON_FIELD = "failureReason";
    public static final String JOB_ID_FIELD = "jobId";
    public static final String CMD_EXECUTOR_NAME_FIELD = "cmdExecutorName";
    public static final String USER_ID_FIELD = "userId";
    public static final String START_SCHEDULING_TIME_FIELD = "startSchedulingTime";
    public static final String START_PROCESSING_TIME_FIELD = "startProcessingTime";
    public static final String EXECUTION_COMPLETED_TIME_FIELD = "executionCompletedTime";
    public static final String CREATION_TIME_FIELD = "creationTime";
    public static final String TYPE_FIELD = "type";
    public static final String USERID_ADMINISTRATOR = "ADMINISTRATOR";
    private static final String JOB_COMMAND_SEQUENCE_NAME = "job_command_id_seq";
    private static final String GET_SEQUENCE_QUERY = "select nextVal('job_command_id_seq ')";
    private static final String insertQuery = JobCommandTable.getInsertQuery();
    private static final String deleteQuery = JobCommandTable.getDeleteQuery();
    private static final String selectHistoryQuery = JobCommandTable.getSelectHistoryQuery();
    private static final String updateQuery = JobCommandTable.getUpdateQuery();

    private static String getDeleteQuery() {
        StringBuffer queryInsertJobStatusTable = new StringBuffer();
        queryInsertJobStatusTable.append("delete from ");
        queryInsertJobStatusTable.append(NAME_TABLE);
        queryInsertJobStatusTable.append(" where ");
        queryInsertJobStatusTable.append("jobId = ? ");
        return queryInsertJobStatusTable.toString();
    }

    private static String getInsertQuery() {
        StringBuffer queryInsertJobCommandQuery = new StringBuffer();
        queryInsertJobCommandQuery.append("insert into ");
        queryInsertJobCommandQuery.append(NAME_TABLE);
        queryInsertJobCommandQuery.append(" ( ");
        queryInsertJobCommandQuery.append("description, ");
        queryInsertJobCommandQuery.append("statusType, ");
        queryInsertJobCommandQuery.append("failureReason, ");
        queryInsertJobCommandQuery.append("jobId, ");
        queryInsertJobCommandQuery.append("cmdExecutorName, ");
        queryInsertJobCommandQuery.append("userId, ");
        queryInsertJobCommandQuery.append("startSchedulingTime, ");
        queryInsertJobCommandQuery.append("startProcessingTime, ");
        queryInsertJobCommandQuery.append("executionCompletedTime, ");
        queryInsertJobCommandQuery.append("creationTime, ");
        queryInsertJobCommandQuery.append(TYPE_FIELD);
        queryInsertJobCommandQuery.append(" ) ");
        queryInsertJobCommandQuery.append("values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return queryInsertJobCommandQuery.toString();
    }

    private static String getSelectHistoryQuery() {
        StringBuffer selectLastJobCommandQuery = new StringBuffer();
        selectLastJobCommandQuery.append("select ");
        selectLastJobCommandQuery.append("description AS description,");
        selectLastJobCommandQuery.append("statusType AS statusType,");
        selectLastJobCommandQuery.append("failureReason AS failureReason,");
        selectLastJobCommandQuery.append("jobId AS jobId,");
        selectLastJobCommandQuery.append("cmdExecutorName AS cmdExecutorName,");
        selectLastJobCommandQuery.append("userId AS userId,");
        selectLastJobCommandQuery.append("startSchedulingTime AS startSchedulingTime,");
        selectLastJobCommandQuery.append("startProcessingTime AS startProcessingTime,");
        selectLastJobCommandQuery.append("executionCompletedTime AS executionCompletedTime,");
        selectLastJobCommandQuery.append("creationTime AS creationTime,");
        selectLastJobCommandQuery.append("type AS type,");
        selectLastJobCommandQuery.append("id AS id");
        selectLastJobCommandQuery.append(" from job_command");
        selectLastJobCommandQuery.append(" where ");
        selectLastJobCommandQuery.append("jobId = ? ");
        selectLastJobCommandQuery.append(" ORDER BY id");
        return selectLastJobCommandQuery.toString();
    }

    private static String getSelectQuery(List<String> jobId, String userId, Calendar startDate, Calendar endDate) {
        StringBuffer selectJobCommandQuery = new StringBuffer();
        selectJobCommandQuery.append("select ");
        selectJobCommandQuery.append("jobId AS jobId");
        selectJobCommandQuery.append(" from job_command");
        selectJobCommandQuery.append(" where ");
        selectJobCommandQuery.append("type = 0 ");
        if (startDate != null) {
            Timestamp startDateTimestampField = new Timestamp(startDate.getTimeInMillis());
            selectJobCommandQuery.append(" and creationTime >= '" + startDateTimestampField.toString() + "'");
        }
        if (endDate != null) {
            Timestamp endDateTimestampField = new Timestamp(endDate.getTimeInMillis());
            selectJobCommandQuery.append(" and creationTime <= '" + endDateTimestampField.toString() + "'");
        }
        if (userId != null) {
            selectJobCommandQuery.append(" and userId = '" + userId + "' ");
        }
        if (jobId != null && jobId.size() > 0) {
            StringBuffer jobIdList = new StringBuffer();
            for (int i = 0; i < jobId.size(); ++i) {
                jobIdList.append(", '" + jobId.get(i) + "'");
            }
            jobIdList.deleteCharAt(0);
            selectJobCommandQuery.append(" and jobId IN (" + jobIdList.toString() + ")");
        }
        return selectJobCommandQuery.toString();
    }

    private static String getUpdateQuery() {
        StringBuffer updateQuery = new StringBuffer();
        updateQuery.append("update ");
        updateQuery.append(NAME_TABLE);
        updateQuery.append(" set description = ? , ");
        updateQuery.append("statusType = ? , ");
        updateQuery.append("failureReason = ? , ");
        updateQuery.append("cmdExecutorName = ? , ");
        updateQuery.append("startSchedulingTime = ? , ");
        updateQuery.append("startProcessingTime = ? , ");
        updateQuery.append("executionCompletedTime = ? , ");
        updateQuery.append("creationTime = ? , ");
        updateQuery.append("type = ? ");
        updateQuery.append("where ");
        updateQuery.append("id = ? ");
        updateQuery.append(" and jobId = ? ");
        return updateQuery.toString();
    }

    public JobCommandTable() throws SQLException {
        logger.debug((Object)"Call JobCommandTable constructor");
    }

    private JobCommand buildJobCommand(ResultSet rs) throws SQLException {
        JobCommand jobCommand = null;
        jobCommand = new JobCommand(rs.getInt(TYPE_FIELD));
        jobCommand.setStatus(rs.getInt(STATUS_TYPE_FIELD));
        jobCommand.setDescription(rs.getString(DESCRIPTION_FIELD));
        jobCommand.setFailureReason(rs.getString(FAILURE_REASON_FIELD));
        jobCommand.setJobId(rs.getString(JOB_ID_FIELD));
        jobCommand.setCommandExecutorName(rs.getString(CMD_EXECUTOR_NAME_FIELD));
        jobCommand.setUserId(rs.getString(USER_ID_FIELD));
        Timestamp timeStampField = null;
        Calendar calendar = null;
        timeStampField = rs.getTimestamp(START_SCHEDULING_TIME_FIELD);
        if (timeStampField != null) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(timeStampField.getTime());
            jobCommand.setStartSchedulingTime(calendar);
        }
        if ((timeStampField = rs.getTimestamp(START_PROCESSING_TIME_FIELD)) != null) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(timeStampField.getTime());
            jobCommand.setStartProcessingTime(calendar);
        }
        if ((timeStampField = rs.getTimestamp(EXECUTION_COMPLETED_TIME_FIELD)) != null) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(timeStampField.getTime());
            jobCommand.setExecutionCompletedTime(calendar);
        }
        if ((timeStampField = rs.getTimestamp(CREATION_TIME_FIELD)) != null) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(timeStampField.getTime());
            jobCommand.setCreationTime(calendar);
        }
        int id = rs.getInt(ID_FIELD);
        jobCommand.setId((long)id);
        return jobCommand;
    }

    private List<JobCommand> buildJobCommandDBList(ResultSet rs) throws SQLException {
        ArrayList<JobCommand> jobCommandList = new ArrayList<JobCommand>();
        while (rs.next()) {
            jobCommandList.add(this.buildJobCommand(rs));
        }
        return jobCommandList;
    }

    public int executeDelete(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeDelete");
        PreparedStatement deletePreparedStatement = null;
        int rowCount = 0;
        try {
            deletePreparedStatement = connection.prepareStatement(deleteQuery);
            deletePreparedStatement = this.fillDeletePreparedStatement(jobId, deletePreparedStatement);
            rowCount = deletePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeDelete");
        return rowCount;
    }

    public int executeInsert(List<JobCommand> jobCommandList, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeInsert");
        PreparedStatement insertPreparedStatement = null;
        ResultSet rset = null;
        int rowCountTot = 0;
        try {
            insertPreparedStatement = connection.prepareStatement(insertQuery, 1);
            int rowCount = 0;
            for (int index = 0; index < jobCommandList.size(); ++index) {
                insertPreparedStatement = this.fillInsertPreparedStatement(jobCommandList.get(index), insertPreparedStatement);
                logger.debug((Object)("insertCommand query = " + insertPreparedStatement.toString()));
                rowCount = insertPreparedStatement.executeUpdate();
                long commandId = -1L;
                rset = insertPreparedStatement.getGeneratedKeys();
                if (!rset.next()) {
                    throw new SQLException("Problem in retrieving autogenerated keys");
                }
                commandId = rset.getLong(1);
                jobCommandList.get(index).setId(commandId);
                insertPreparedStatement.clearParameters();
                rowCountTot += rowCount;
            }
            logger.debug((Object)("Rows inserted: " + rowCountTot));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (insertPreparedStatement != null) {
                try {
                    insertPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeInsert");
        return rowCountTot;
    }

    public List<JobCommand> executeSelectJobCommandHistory(String jobId, Connection connection) throws SQLException {
        return this.selectJobCommandHistory(jobId, connection);
    }

    public JobCommand executeSelectLastJobCommmand(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectLastJobCommmand");
        List<JobCommand> jobCommandList = null;
        JobCommand jobCommand = null;
        jobCommandList = this.executeSelectJobCommandHistory(jobId, connection);
        if (jobCommandList.size() > 0) {
            logger.debug((Object)("jobStatusList.size() = " + jobCommandList.size()));
            jobCommand = jobCommandList.get(jobCommandList.size() - 1);
        }
        logger.debug((Object)"End executeSelectLastJobCommmand");
        return jobCommand;
    }

    public List<String> executeSelectToRetrieveJobIdByDate(List<String> jobId, String userId, Calendar startDate, Calendar endDate, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobIdByDate");
        ArrayList<String> jobIdList = new ArrayList<String>();
        String selectQuery = JobCommandTable.getSelectQuery(jobId, userId, startDate, endDate);
        logger.debug((Object)("selectQuery (JobCommandTable)= " + selectQuery));
        PreparedStatement selectPreparedStatement = null;
        try {
            selectPreparedStatement = connection.prepareStatement(selectQuery);
            ResultSet rs = selectPreparedStatement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    jobIdList.add(rs.getString(JOB_ID_FIELD));
                }
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectPreparedStatement != null) {
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobIdByDate");
        return jobIdList;
    }

    public void executeUpdateCommandHistory(String jobId, List<JobCommand> jobCommandList, Connection connection) throws SQLException {
        logger.debug((Object)("Begin executeUpdateCommandHistory for jobid = " + jobId));
        List<JobCommand> jobCommandDBList = this.selectJobCommandHistory(jobId, connection);
        if (jobCommandList.size() != jobCommandDBList.size()) {
            String errorMsg = "Error updating CommandHistory for jobid = " + jobId + ". Num Commands in db = " + jobCommandDBList.size() + " Num Commands in updating = " + jobCommandList.size();
            logger.error((Object)errorMsg);
            throw new SQLException(errorMsg);
        }
        for (int index = 0; index < jobCommandDBList.size(); ++index) {
            this.updateJobCommand(jobCommandDBList.get(index), connection);
        }
        logger.debug((Object)("End executeUpdateCommandHistory for jobid = " + jobId));
    }

    public void executeUpdateJobCommand(JobCommand jobCommand, Connection connection) throws SQLException {
        this.updateJobCommand(jobCommand, connection);
    }

    private PreparedStatement fillDeletePreparedStatement(String jobId, PreparedStatement deletePreparedStatement) throws SQLException {
        deletePreparedStatement.setString(1, jobId);
        return deletePreparedStatement;
    }

    private PreparedStatement fillInsertPreparedStatement(JobCommand jobCommand, PreparedStatement insertPreparedStatement) throws SQLException {
        insertPreparedStatement.setString(1, jobCommand.getDescription());
        insertPreparedStatement.setInt(2, jobCommand.getStatus());
        insertPreparedStatement.setString(3, jobCommand.getFailureReason());
        insertPreparedStatement.setString(4, jobCommand.getJobId());
        insertPreparedStatement.setString(5, jobCommand.getCommandExecutorName());
        String userId = jobCommand.getUserId();
        if (userId == null) {
            userId = USERID_ADMINISTRATOR;
        }
        insertPreparedStatement.setString(6, userId);
        if (jobCommand.getStartSchedulingTime() != null) {
            insertPreparedStatement.setTimestamp(7, new Timestamp(jobCommand.getStartSchedulingTime().getTimeInMillis()));
        } else {
            insertPreparedStatement.setTimestamp(7, null);
        }
        if (jobCommand.getStartProcessingTime() != null) {
            insertPreparedStatement.setTimestamp(8, new Timestamp(jobCommand.getStartProcessingTime().getTimeInMillis()));
        } else {
            insertPreparedStatement.setTimestamp(8, null);
        }
        if (jobCommand.getExecutionCompletedTime() != null) {
            insertPreparedStatement.setTimestamp(9, new Timestamp(jobCommand.getExecutionCompletedTime().getTimeInMillis()));
        } else {
            insertPreparedStatement.setTimestamp(9, null);
        }
        if (jobCommand.getCreationTime() != null) {
            insertPreparedStatement.setTimestamp(10, new Timestamp(jobCommand.getCreationTime().getTimeInMillis()));
        } else {
            insertPreparedStatement.setTimestamp(10, null);
        }
        insertPreparedStatement.setInt(11, jobCommand.getType());
        return insertPreparedStatement;
    }

    private PreparedStatement fillSelectHistoryPreparedStatement(String jobId, PreparedStatement selectHistoryPreparedStatement) throws SQLException {
        selectHistoryPreparedStatement.setString(1, jobId);
        return selectHistoryPreparedStatement;
    }

    private PreparedStatement fillUpdatePreparedStatement(JobCommand jobCommand, PreparedStatement updatePreparedStatement) throws SQLException {
        updatePreparedStatement.setString(1, jobCommand.getDescription());
        updatePreparedStatement.setInt(2, jobCommand.getStatus());
        updatePreparedStatement.setString(3, jobCommand.getFailureReason());
        updatePreparedStatement.setString(4, jobCommand.getCommandExecutorName());
        if (jobCommand.getStartSchedulingTime() != null) {
            updatePreparedStatement.setTimestamp(5, new Timestamp(jobCommand.getStartSchedulingTime().getTimeInMillis()));
        } else {
            updatePreparedStatement.setTimestamp(5, null);
        }
        if (jobCommand.getStartProcessingTime() != null) {
            updatePreparedStatement.setTimestamp(6, new Timestamp(jobCommand.getStartProcessingTime().getTimeInMillis()));
        } else {
            updatePreparedStatement.setTimestamp(6, null);
        }
        if (jobCommand.getExecutionCompletedTime() != null) {
            updatePreparedStatement.setTimestamp(7, new Timestamp(jobCommand.getExecutionCompletedTime().getTimeInMillis()));
        } else {
            updatePreparedStatement.setTimestamp(7, null);
        }
        if (jobCommand.getCreationTime() != null) {
            updatePreparedStatement.setTimestamp(8, new Timestamp(jobCommand.getCreationTime().getTimeInMillis()));
        } else {
            updatePreparedStatement.setTimestamp(8, null);
        }
        updatePreparedStatement.setInt(9, jobCommand.getType());
        updatePreparedStatement.setLong(10, jobCommand.getId());
        updatePreparedStatement.setString(11, jobCommand.getJobId());
        return updatePreparedStatement;
    }

    private long getIDSequence(Connection connection) throws SQLException {
        long id;
        block11: {
            id = -1L;
            PreparedStatement sequencePreparedStatement = null;
            try {
                sequencePreparedStatement = connection.prepareStatement(GET_SEQUENCE_QUERY);
                ResultSet rs = sequencePreparedStatement.executeQuery();
                if (rs != null && rs.next()) {
                    id = rs.getLong(1);
                    break block11;
                }
                throw new SQLException("Impossible to retrieve sequence id for job_command");
            }
            catch (SQLException sqle) {
                throw sqle;
            }
            finally {
                if (sequencePreparedStatement != null) {
                    try {
                        sequencePreparedStatement.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
            }
        }
        return id;
    }

    private List<JobCommand> selectJobCommandHistory(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin selectJobCommandHistory");
        List<JobCommand> jobCommandList = null;
        PreparedStatement selectHistoryPreparedStatement = null;
        try {
            selectHistoryPreparedStatement = connection.prepareStatement(selectHistoryQuery);
            selectHistoryPreparedStatement = this.fillSelectHistoryPreparedStatement(jobId, selectHistoryPreparedStatement);
            ResultSet rs = selectHistoryPreparedStatement.executeQuery();
            if (rs != null) {
                jobCommandList = this.buildJobCommandDBList(rs);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectHistoryPreparedStatement != null) {
                try {
                    selectHistoryPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End selectJobCommandHistory");
        return jobCommandList;
    }

    private void updateJobCommand(JobCommand jobCommand, Connection connection) throws SQLException {
        logger.debug((Object)"Begin updateJobCommand");
        PreparedStatement updatePreparedStatement = null;
        try {
            updatePreparedStatement = connection.prepareStatement(updateQuery);
            updatePreparedStatement = this.fillUpdatePreparedStatement(jobCommand, updatePreparedStatement);
            updatePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (updatePreparedStatement != null) {
                try {
                    updatePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End updateJobCommand");
    }

    public int executeUpdateAllUnterminatedJobCommandQuery(int newStatus, int[] oldStatus, String failureReason, Calendar executionCompletedTime, Connection connection) throws SQLException {
        int result;
        logger.debug((Object)"Begin executeUpdateAllUnterminatedJobCommandQuery");
        StringBuffer updateQuery = new StringBuffer();
        updateQuery.append("update ");
        updateQuery.append(NAME_TABLE);
        updateQuery.append(" set statusType = '" + newStatus + "'");
        if (failureReason != null) {
            updateQuery.append(", failureReason = '" + failureReason + "'");
        }
        if (executionCompletedTime != null) {
            updateQuery.append(", executionCompletedTime = '" + new Timestamp(executionCompletedTime.getTimeInMillis()).toString() + "'");
        }
        updateQuery.append(" where ");
        updateQuery.append("statusType IN (");
        for (int i = 0; i < oldStatus.length; ++i) {
            updateQuery.append("'" + oldStatus[i] + "'");
            if (i >= oldStatus.length - 1) continue;
            updateQuery.append(", ");
        }
        updateQuery.append(")");
        PreparedStatement updatePreparedStatement = null;
        try {
            updatePreparedStatement = connection.prepareStatement(updateQuery.toString());
            result = updatePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (updatePreparedStatement != null) {
                try {
                    updatePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeUpdateAllUnterminatedJobCommandQuery");
        return result;
    }
}

