/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.db.table.EnviromentTableInterface;

public class EnviromentTable
implements EnviromentTableInterface {
    public static final String NAME_TABLE = "environment";
    public static final String NAME_FIELD = "name";
    public static final String VALUE_FIELD = "value";
    public static final String JOB_ID_FIELD = "jobId";
    private static final String insertQuery = EnviromentTable.getInsertQuery();
    private static final String selectQuery = EnviromentTable.getSelectQuery();
    private static final String deleteQuery = EnviromentTable.getDeleteQuery();
    private static final Logger logger = Logger.getLogger(EnviromentTable.class);

    public EnviromentTable() throws SQLException {
        logger.debug((Object)"Call EnviromentTable constructor");
    }

    public int executeInsert(String jobId, Hashtable<String, String> enviroment, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeInsert");
        int rowCountTot = 0;
        PreparedStatement insertPreparedStatement = null;
        try {
            insertPreparedStatement = connection.prepareStatement(insertQuery);
            int rowCount = 0;
            String name = null;
            String value = null;
            Enumeration<String> e = enviroment.keys();
            while (e.hasMoreElements()) {
                name = e.nextElement();
                value = enviroment.get(name);
                insertPreparedStatement = this.fillInsertPreparedStatement(jobId, name, value, insertPreparedStatement);
                rowCount = insertPreparedStatement.executeUpdate();
                insertPreparedStatement.clearParameters();
                rowCountTot += rowCount;
            }
            logger.debug((Object)("Rows inserted: " + rowCountTot));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (insertPreparedStatement != null) {
                try {
                    insertPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeInsert");
        return rowCountTot;
    }

    public Hashtable<String, String> executeSelect(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelect");
        Hashtable<String, String> nameAndValueHash = new Hashtable<String, String>();
        PreparedStatement selectPreparedStatement = null;
        try {
            selectPreparedStatement = connection.prepareStatement(selectQuery);
            selectPreparedStatement = this.fillSelectPreparedStatement(jobId, selectPreparedStatement);
            ResultSet resultSet = selectPreparedStatement.executeQuery();
            String name = null;
            String value = null;
            while (resultSet.next()) {
                name = resultSet.getString(NAME_FIELD);
                value = resultSet.getString(VALUE_FIELD);
                nameAndValueHash.put(name, value);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectPreparedStatement != null) {
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeSelect");
        return nameAndValueHash;
    }

    public int executeDelete(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeDelete");
        PreparedStatement deletePreparedStatement = null;
        int rowCount = 0;
        try {
            deletePreparedStatement = connection.prepareStatement(deleteQuery);
            deletePreparedStatement = this.fillDeletePreparedStatement(jobId, deletePreparedStatement);
            rowCount = deletePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeDelete");
        return rowCount;
    }

    private PreparedStatement fillInsertPreparedStatement(String jobId, String name, String value, PreparedStatement insertPreparedStatement) throws SQLException {
        insertPreparedStatement.setString(1, name);
        insertPreparedStatement.setString(2, value);
        insertPreparedStatement.setString(3, jobId);
        return insertPreparedStatement;
    }

    private PreparedStatement fillDeletePreparedStatement(String jobId, PreparedStatement deletePreparedStatement) throws SQLException {
        deletePreparedStatement.setString(1, jobId);
        return deletePreparedStatement;
    }

    private PreparedStatement fillSelectPreparedStatement(String jobId, PreparedStatement selectPreparedStatement) throws SQLException {
        selectPreparedStatement.setString(1, jobId);
        return selectPreparedStatement;
    }

    private static String getInsertQuery() {
        StringBuffer insertQuery = new StringBuffer();
        insertQuery.append("insert into ");
        insertQuery.append(NAME_TABLE);
        insertQuery.append(" ( ");
        insertQuery.append("name, ");
        insertQuery.append("value, ");
        insertQuery.append(JOB_ID_FIELD);
        insertQuery.append(" ) ");
        insertQuery.append("values(?, ?, ?)");
        return insertQuery.toString();
    }

    private static String getDeleteQuery() {
        StringBuffer deleteQuery = new StringBuffer();
        deleteQuery.append("delete from ");
        deleteQuery.append(NAME_TABLE);
        deleteQuery.append(" where ");
        deleteQuery.append("jobId = ?");
        return deleteQuery.toString();
    }

    private static String getSelectQuery() {
        StringBuffer selectQuery = new StringBuffer();
        selectQuery.append("select ");
        selectQuery.append("name, ");
        selectQuery.append(VALUE_FIELD);
        selectQuery.append(" from environment");
        selectQuery.append(" where ");
        selectQuery.append("jobId = ?");
        return selectQuery.toString();
    }
}

