/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.commonj.db.DatasourceManager;
import org.glite.ce.cream.jobmanagement.db.table.ArgumentTable;
import org.glite.ce.cream.jobmanagement.db.table.EnviromentTable;
import org.glite.ce.cream.jobmanagement.db.table.ExtraAttributeTable;
import org.glite.ce.cream.jobmanagement.db.table.InputFileTable;
import org.glite.ce.cream.jobmanagement.db.table.JobChildTable;
import org.glite.ce.cream.jobmanagement.db.table.JobCommandTable;
import org.glite.ce.cream.jobmanagement.db.table.JobStatusTable;
import org.glite.ce.cream.jobmanagement.db.table.JobTable;
import org.glite.ce.cream.jobmanagement.db.table.JobTableJobStatusTable;
import org.glite.ce.cream.jobmanagement.db.table.JobTableJobStatusTableJobCommandTable;
import org.glite.ce.cream.jobmanagement.db.table.LeaseTable;
import org.glite.ce.cream.jobmanagement.db.table.LeaseTableJobTable;
import org.glite.ce.cream.jobmanagement.db.table.LeaseTableJobTableJobStatusTable;
import org.glite.ce.cream.jobmanagement.db.table.OutputFileTable;
import org.glite.ce.cream.jobmanagement.db.table.OutputSandboxDestURITable;
import org.glite.ce.creamapi.eventmanagement.Event;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.JobStatus;
import org.glite.ce.creamapi.jobmanagement.Lease;
import org.glite.ce.creamapi.jobmanagement.command.JobCommand;
import org.glite.ce.creamapi.jobmanagement.db.table.ArgumentTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.EnviromentTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.ExtraAttributeTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.InputFileTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobChildTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobCommandTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobStatusTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobTableJobStatusInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobTableJobStatusJobCommandInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.LeaseTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.LeaseTableJobTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.LeaseTableJobTableJobStatusInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.OutputFileTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.OutputSandboxDestURITableInterface;

public class JobDBManager {
    private static final Logger logger = Logger.getLogger((String)JobDBManager.class.getName());
    private JobTableInterface jobTable = null;
    private JobStatusTableInterface jobStatusTable = null;
    private JobTableJobStatusInterface jobTableJobStatusTable = null;
    private JobTableJobStatusJobCommandInterface jobTableJobStatusJobCommandTable = null;
    private JobCommandTableInterface jobCommandTable = null;
    private EnviromentTableInterface environmentTable = null;
    private ExtraAttributeTableInterface extraAttributeTable = null;
    private ArgumentTableInterface argumentTable = null;
    private JobChildTableInterface jobChildTable = null;
    private InputFileTableInterface inputFileTable = null;
    private OutputFileTableInterface outputFileTable = null;
    private OutputSandboxDestURITableInterface outputSandboxDestURITable = null;
    private LeaseTableInterface leaseTable = null;
    private LeaseTableJobTableJobStatusInterface leaseTableJobTableJobStatus = null;
    private LeaseTableJobTableInterface leaseTableJobTable = null;
    private String datasourceName = null;

    public JobDBManager(String datasourceName) throws IllegalArgumentException, DatabaseException {
        if (datasourceName == null) {
            throw new IllegalArgumentException("datasourceName not specified!");
        }
        try {
            this.datasourceName = datasourceName;
            this.jobTable = new JobTable();
            this.jobStatusTable = new JobStatusTable();
            this.jobTableJobStatusTable = new JobTableJobStatusTable();
            this.jobTableJobStatusJobCommandTable = new JobTableJobStatusTableJobCommandTable();
            this.jobCommandTable = new JobCommandTable();
            this.environmentTable = new EnviromentTable();
            this.extraAttributeTable = new ExtraAttributeTable();
            this.argumentTable = new ArgumentTable();
            this.jobChildTable = new JobChildTable();
            this.inputFileTable = new InputFileTable();
            this.outputFileTable = new OutputFileTable();
            this.outputSandboxDestURITable = new OutputSandboxDestURITable();
            this.leaseTable = new LeaseTable();
            this.leaseTableJobTableJobStatus = new LeaseTableJobTableJobStatusTable();
            this.leaseTableJobTable = new LeaseTableJobTable();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void deleteJob(String jobId, String userId) throws DatabaseException {
        logger.debug((Object)"Begin deleteJob");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            if (!this.jobTable.isUserEnable(jobId, userId, connection)) {
                throw new IllegalArgumentException("UserId = " + userId + " is not enable for that operation!");
            }
            this.jobTable.executeDelete(jobId, connection);
            connection.commit();
            logger.debug((Object)"job deleted");
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
            }
            throw new DatabaseException("Rollback executed due to: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End deleteJob");
    }

    public void deleteJobLease(String leaseId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin deleteJobLease");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            this.leaseTable.executeDelete(leaseId, userId, connection);
            connection.commit();
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle.getMessage());
            throw new DatabaseException(sqle.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End deleteJobLease");
    }

    public List<Lease> executeSelectJobLease(String leaseId, String userId, Calendar leaseTime) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin executeSelectJobLease");
        List leaseList = null;
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            leaseList = this.leaseTable.executeSelect(leaseId, userId, leaseTime, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeSelectJobLease");
        return leaseList;
    }

    public long executeSelectToJobCountByStatus(int[] jobStatusType, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin executeSelectToJobCountByStatus");
        long jobCountByStatus = 0L;
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            jobCountByStatus = this.jobTableJobStatusTable.executeSelectToJobCountByStatus(jobStatusType, userId, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeSelectToJobCountByStatus");
        return jobCountByStatus;
    }

    public String executeSelectToOlderJobId(int[] jobStatusType, String batchSystem, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin executeSelectToOlderJobId");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        String jobId = null;
        try {
            jobId = this.jobTableJobStatusTable.executeSelectToRetrieveOlderJobIdQuery(jobStatusType, batchSystem, userId, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeSelectToOlderJobId");
        return jobId;
    }

    public List<String> executeSelectToRetrieveJobId(String userId, List<String> jobId, String leaseId, String delegationId, List<String> gridJobId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobId");
        List jobIdList = null;
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            jobIdList = this.jobTable.executeSelectToRetrieveJobId(userId, jobId, leaseId, delegationId, gridJobId, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobId");
        return jobIdList;
    }

    public List<String> executeSelectToRetrieveJobId(String userId, String delegationId, int[] jobStatusType, Calendar startStatusDate, Calendar endStatusDate, String leaseId, Calendar registerCommandStartDate, Calendar registerCommandEndDate) throws DatabaseException, IllegalArgumentException {
        List jobIdList = null;
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            jobIdList = this.jobTableJobStatusJobCommandTable.executeSelectToRetrieveJobId(userId, delegationId, jobStatusType, leaseId, startStatusDate, endStatusDate, registerCommandStartDate, registerCommandEndDate, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobId");
        return jobIdList;
    }

    public List<String> executeSelectToRetrieveJobIdByDate(List<String> jobId, String userId, Calendar startDate, Calendar endDate) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobIdByDate");
        List jobIdList = null;
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            jobIdList = this.jobCommandTable.executeSelectToRetrieveJobIdByDate(jobId, userId, startDate, endDate, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobIdByDate");
        return jobIdList;
    }

    public List<String> executeSelectToRetrieveJobIdByLease(int[] jobStatusType, String leaseId, Calendar maxLeaseTime, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobIdByLease");
        List jobIdList = null;
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            jobIdList = maxLeaseTime == null ? this.jobTableJobStatusTable.executeSelectToRetrieveJobId(userId, null, null, jobStatusType, leaseId, null, null, null, null, connection) : this.leaseTableJobTableJobStatus.executeSelectToRetrieveJobIdByLease(jobStatusType, leaseId, maxLeaseTime, userId, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobIdByLease");
        return jobIdList;
    }

    public List<String> executeSelectToRetrieveJobIdByLeaseTimeExpired(String userId, String delegationId, int[] jobStatusType) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobIdByLeaseTimeExpired");
        List jobIdList = null;
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            jobIdList = this.jobTableJobStatusTable.executeSelectToRetrieveJobIdByLeaseTimeExpiredQuery(userId, delegationId, jobStatusType, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobIdByLeaseTimeExpired");
        return jobIdList;
    }

    public List<String> executeSelectToRetrieveJobIdByStatus(String userId, List<String> jobId, String delegationId, int[] jobStatusType, Calendar startStatusDate, Calendar endStatusDate, String queueName, String batchSystem) throws DatabaseException, IllegalArgumentException {
        List jobIdList = null;
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            jobIdList = this.jobTableJobStatusTable.executeSelectToRetrieveJobId(userId, jobId, delegationId, jobStatusType, null, startStatusDate, endStatusDate, queueName, batchSystem, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobIdByStatus");
        return jobIdList;
    }

    public int executeUpdateAllUnterminatedJobCommand() throws DatabaseException {
        int result;
        logger.debug((Object)"Begin executeUpdateAllUnterminatedJobCommand");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            result = this.jobCommandTable.executeUpdateAllUnterminatedJobCommandQuery(8, new int[]{4}, "command ABORTED because its execution has been interrupted by the CREAM shutdown.", Calendar.getInstance(), connection);
            connection.commit();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeUpdateAllUnterminatedJobCommand");
        return result;
    }

    public void executeUpdateJobLease(Lease jobLease) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin executeUpdateJobLease");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            this.leaseTable.executeUpdate(jobLease, connection);
            connection.commit();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeUpdateJobLease");
    }

    public void insertJob(Job job) throws DatabaseException {
        logger.debug((Object)"Begin insertJob");
        Connection connection = null;
        if (job != null) {
            connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                List leaseList;
                this.jobTable.executeInsert(job, connection);
                if (job.getLease() != null && (leaseList = this.leaseTable.executeSelect(job.getLease().getLeaseId(), job.getLease().getUserId(), null, connection)).size() == 0) {
                    this.leaseTable.executeInsert(job.getLease(), connection);
                }
                if (job.getStatusHistory() != null && job.getStatusHistory().size() > 0) {
                    this.jobStatusTable.executeInsert(job.getStatusHistory(), connection);
                }
                if (job.getCommandHistory() != null && job.getCommandHistory().size() > 0) {
                    this.jobCommandTable.executeInsert(job.getCommandHistory(), connection);
                }
                if (job.getEnvironment() != null && job.getEnvironment().size() > 0) {
                    this.environmentTable.executeInsert(job.getId(), job.getEnvironment(), connection);
                }
                if (job.getExtraAttribute() != null && job.getExtraAttribute().size() > 0) {
                    this.extraAttributeTable.executeInsert(job.getId(), job.getExtraAttribute(), connection);
                }
                if (job.getArguments() != null && job.getArguments().size() > 0) {
                    this.argumentTable.executeInsert(job.getId(), job.getArguments(), connection);
                }
                if (job.getChildJobId() != null && job.getChildJobId().size() > 0) {
                    this.jobChildTable.executeInsert(job.getId(), job.getChildJobId(), connection);
                }
                if (job.getInputFiles() != null && job.getInputFiles().size() > 0) {
                    this.inputFileTable.executeInsert(job.getId(), job.getInputFiles(), connection);
                }
                if (job.getOutputFiles() != null && job.getOutputFiles().size() > 0) {
                    this.outputFileTable.executeInsert(job.getId(), job.getOutputFiles(), connection);
                }
                if (job.getOutputSandboxDestURI() != null && job.getOutputSandboxDestURI().size() > 0) {
                    this.outputSandboxDestURITable.executeInsert(job.getId(), job.getOutputSandboxDestURI(), connection);
                }
                connection.commit();
                logger.debug((Object)"Job committed");
            }
            catch (Exception e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sqle) {
                    throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
                }
                throw new DatabaseException("Rollback executed due to: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End insertJob");
    }

    public void insertJobCommand(JobCommand jobCommand) throws DatabaseException, IllegalArgumentException {
        block11: {
            logger.debug((Object)"Begin insertJobCommand");
            Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                if (this.jobTable.isUserEnable(jobCommand.getJobId(), jobCommand.getUserId(), connection)) {
                    ArrayList<JobCommand> jobCommandList = new ArrayList<JobCommand>(1);
                    jobCommandList.add(jobCommand);
                    this.jobCommandTable.executeInsert(jobCommandList, connection);
                    connection.commit();
                    break block11;
                }
                throw new IllegalArgumentException("UserId = " + jobCommand.getUserId() + " is not enable for that operation!");
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End insertJobCommand");
    }

    public void insertJobCommand(JobCommand jobCommand, String delegationId, int[] jobStatusType) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN insertJobCommand");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            this.jobTableJobStatusJobCommandTable.executeInsert(jobCommand, delegationId, jobStatusType, connection);
            connection.commit();
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End insertJobCommand");
    }

    public void insertJobLease(Lease jobLease) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin insertJobLease");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            this.leaseTable.executeInsert(jobLease, connection);
            connection.commit();
        }
        catch (SQLException sqle) {
            throw new DatabaseException(sqle.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End insertJobLease");
    }

    public void insertStatus(JobStatus status, String userId) throws DatabaseException, IllegalArgumentException {
        block13: {
            logger.debug((Object)"Begin insertStatus");
            Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                if (this.jobTable.isUserEnable(status.getJobId(), userId, connection)) {
                    ArrayList<JobStatus> jobStatusList = new ArrayList<JobStatus>();
                    jobStatusList.add(status);
                    this.jobStatusTable.executeInsert(jobStatusList, connection);
                    connection.commit();
                    break block13;
                }
                throw new IllegalArgumentException("UserId = " + userId + " is not enable for that operation!");
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sqle) {
                    throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
                }
                throw new DatabaseException("Rollback executed due to: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End insertStatus");
    }

    public Job retrieveJob(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        Job job;
        block15: {
            logger.debug((Object)"Begin retrieveJob");
            Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
            job = null;
            try {
                List jobCommandList = null;
                if (this.jobTable.isUserEnable(jobId, userId, connection)) {
                    job = this.jobTable.executeSelectJobTable(jobId, userId, connection);
                    if (job != null) {
                        Lease lease = job.getLease();
                        if (lease != null && lease.getLeaseTime() == null) {
                            List leaseList = this.leaseTable.executeSelect(lease.getLeaseId(), lease.getUserId(), null, connection);
                            if (leaseList.size() != 1) {
                                String msg = "LeaseId = " + lease.getLeaseId() + " and userId = " + lease.getUserId() + " no one entry in " + "job_lease" + " table";
                                logger.error((Object)msg);
                                throw new DatabaseException(msg);
                            }
                            job.setLease((Lease)leaseList.get(0));
                        }
                        job.setStatusHistory(this.jobStatusTable.executeSelectJobStatusHistory(jobId, connection));
                        job.setInputFiles(this.inputFileTable.executeSelect(jobId, connection));
                        job.setOutputFiles(this.outputFileTable.executeSelect(jobId, connection));
                        job.setOutputSandboxDestURI(this.outputSandboxDestURITable.executeSelect(jobId, connection));
                        job.setEnvironment(this.environmentTable.executeSelect(jobId, connection));
                        job.setExtraAttribute(this.extraAttributeTable.executeSelect(jobId, connection));
                        job.setArguments(this.argumentTable.executeSelect(jobId, connection));
                        job.setChildJobId(this.jobChildTable.executeSelect(jobId, connection));
                        jobCommandList = this.jobCommandTable.executeSelectJobCommandHistory(jobId, connection);
                        job.setCommandHistory(jobCommandList);
                        if (jobCommandList != null && jobCommandList.size() == 0) {
                            logger.debug((Object)("Job with jobId = " + job.getId() + " has been deleted."));
                            job = null;
                        }
                    }
                    break block15;
                }
                throw new IllegalArgumentException("UserId = " + userId + " is not enabled for that operation!");
            }
            catch (SQLException sqle) {
                logger.error((Object)sqle.getMessage());
                throw new DatabaseException(sqle.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End retrieveJob");
        return job;
    }

    public List<JobCommand> retrieveJobCommandHistory(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        List jobCommandList;
        block11: {
            logger.debug((Object)"Begin retrieveJobCommandHistory");
            jobCommandList = null;
            Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                if (this.jobTable.isUserEnable(jobId, userId, connection)) {
                    jobCommandList = this.jobCommandTable.executeSelectJobCommandHistory(jobId, connection);
                    break block11;
                }
                throw new IllegalArgumentException("UserId = " + userId + " is not enable for that operation!");
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End retrieveJobStatusHistory");
        return jobCommandList;
    }

    public List<JobStatus> retrieveJobStatus(String fromJobStatusId, String toJobStatusId, Calendar fromDate, Calendar toDate, int maxElements, String iceId, String userId) throws DatabaseException {
        logger.debug((Object)"Begin retrieveJobStatus");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        List jobStatusList = null;
        try {
            jobStatusList = this.jobStatusTable.executeSelectToRetrieveJobStatus(fromJobStatusId, toJobStatusId, fromDate, toDate, maxElements, iceId, userId, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End retrieveJobStatus");
        return jobStatusList;
    }

    public List<Event> retrieveJobStatusAsEvent(String fromJobStatusId, String toJobStatusId, Calendar fromDate, Calendar toDate, int[] jobStatusType, int maxElements, String iceId, String userId) throws DatabaseException {
        logger.debug((Object)"Begin retrieveJobStatusAsEvent");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        List eventList = null;
        try {
            eventList = this.jobStatusTable.executeSelectToRetrieveJobStatusAsEvent(fromJobStatusId, toJobStatusId, fromDate, toDate, jobStatusType, maxElements, iceId, userId, connection);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End retrieveJobStatusAsEvent");
        return eventList;
    }

    public List<JobStatus> retrieveJobStatusHistory(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        List jobStatusList;
        block11: {
            logger.debug((Object)"Begin retrieveJobStatusHistory");
            jobStatusList = null;
            Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                if (this.jobTable.isUserEnable(jobId, userId, connection)) {
                    jobStatusList = this.jobStatusTable.executeSelectJobStatusHistory(jobId, connection);
                    break block11;
                }
                throw new IllegalArgumentException("UserId = " + userId + " is not enable for that operation!");
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End retrieveJobStatusHistory");
        return jobStatusList;
    }

    public JobCommand retrieveLastJobCommand(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        JobCommand jobCommand;
        block11: {
            logger.debug((Object)"Begin retrieveLastJobCommand");
            jobCommand = null;
            Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                if (this.jobTable.isUserEnable(jobId, userId, connection)) {
                    jobCommand = this.jobCommandTable.executeSelectLastJobCommmand(jobId, connection);
                    break block11;
                }
                throw new IllegalArgumentException("UserId = " + userId + " is not enable for that operation!");
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End retrieveLastJobCommand");
        return jobCommand;
    }

    public JobStatus retrieveLastJobStatus(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        JobStatus jobStatus;
        block11: {
            logger.debug((Object)"Begin retrieveLastJobStatus");
            jobStatus = null;
            Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                if (this.jobTable.isUserEnable(jobId, userId, connection)) {
                    jobStatus = this.jobStatusTable.executeSelectLastJobStatus(jobId, connection);
                    break block11;
                }
                throw new IllegalArgumentException("UserId = " + userId + " is not enable for that operation!");
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End retrieveLastJobStatus");
        return jobStatus;
    }

    public void setLeaseExpired(Lease jobLease) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin setLeaseExpired");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            this.jobTable.setLeaseExpired(null, jobLease, connection);
            connection.commit();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End setLeaseExpired");
    }

    public void setLeaseExpired(String jobId, Lease jobLease) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)("Begin setLeaseExpired. JobId= " + jobId));
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            this.jobTable.setLeaseExpired(jobId, jobLease, connection);
            connection.commit();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)("End setLeaseExpired. JobId= " + jobId));
    }

    public void setLeaseId(String leaseId, String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin setLeaseId");
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        int numLeaseIdUpdated = 0;
        try {
            numLeaseIdUpdated = this.leaseTableJobTable.setLeaseId(leaseId, jobId, userId, connection);
            connection.commit();
            logger.debug((Object)("numLeaseIdUpdated = " + numLeaseIdUpdated));
            if (numLeaseIdUpdated == 0) {
                String reasonFaultSetLeaseId = this.jobTable.getReasonFaultSetLeaseId(jobId, userId, connection);
                if ("LEASEID_EXPIRED".equals(reasonFaultSetLeaseId)) {
                    logger.warn((Object)("LeaseId '" + leaseId + "' not found! (JobId = " + jobId + ")"));
                    throw new DatabaseException("LeaseId '" + leaseId + "' not found/or expired!");
                }
                if ("JOB_NOT_FOUND".equals(reasonFaultSetLeaseId)) {
                    logger.warn((Object)("LeaseId cannot be set. JobId = " + jobId + "doesn't exist on the database. "));
                    throw new DatabaseException("LeaseId cannot be set. JobId = " + jobId + "doesn't exist on the database. ");
                }
                logger.warn((Object)("LeaseId cannot be set for JobId = " + jobId + ". Error setting LeaseId field on the database. "));
                throw new DatabaseException("LeaseId cannot be set for JobId = " + jobId + ". Error setting LeaseId field on the database. ");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException(e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End setLeaseId");
    }

    public void updateJob(Job job) throws DatabaseException {
        logger.debug((Object)"Begin updateJob");
        Connection connection = null;
        if (job != null) {
            connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                if (!this.jobTable.isUserEnable(job.getId(), job.getUserId(), connection)) {
                    throw new IllegalArgumentException("UserId = " + job.getUserId() + " is not enable for that operation!");
                }
                this.jobTable.executeUpdate(job, connection);
                Hashtable extraAttribute = job.getExtraAttribute();
                if (extraAttribute != null) {
                    String name = null;
                    String value = null;
                    int rowUpdated = 0;
                    Enumeration e = extraAttribute.keys();
                    while (e.hasMoreElements()) {
                        name = (String)e.nextElement();
                        value = (String)extraAttribute.get(name);
                        rowUpdated = this.extraAttributeTable.executeUpdate(job.getId(), name, value, connection);
                        if (rowUpdated != 0) continue;
                        this.extraAttributeTable.executeInsert(job.getId(), name, value, connection);
                    }
                }
                connection.commit();
                logger.debug((Object)"Job updated");
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sqle) {
                    throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
                }
                throw new DatabaseException("Rollback executed due to: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End updateJob");
    }

    public void updateJobCommand(JobCommand jobCommand) throws DatabaseException, IllegalArgumentException {
        block13: {
            logger.debug((Object)"Begin updateJobCommand");
            Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                if (this.jobTable.isUserEnable(jobCommand.getJobId(), jobCommand.getUserId(), connection)) {
                    ArrayList<JobCommand> jobCommandList = new ArrayList<JobCommand>();
                    jobCommandList.add(jobCommand);
                    this.jobCommandTable.executeUpdateJobCommand(jobCommand, connection);
                    connection.commit();
                    break block13;
                }
                throw new IllegalArgumentException("UserId = " + jobCommand.getUserId() + " is not enable for that operation!");
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sqle) {
                    throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
                }
                throw new DatabaseException("Rollback executed due to: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End updateJobCommand");
    }

    public void updateStatus(JobStatus status, String userId) throws DatabaseException, IllegalArgumentException {
        block13: {
            logger.debug((Object)"Begin updateLastStatus");
            Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
            try {
                if (this.jobTable.isUserEnable(status.getJobId(), userId, connection)) {
                    ArrayList<JobStatus> jobStatusList = new ArrayList<JobStatus>();
                    jobStatusList.add(status);
                    this.jobStatusTable.executeUpdateJobStatus(status, connection);
                    connection.commit();
                    break block13;
                }
                throw new IllegalArgumentException("UserId = " + userId + " is not enable for that operation!");
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException sqle) {
                    throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
                }
                throw new DatabaseException("Rollback executed due to: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
            }
        }
        logger.debug((Object)"End updateStatus");
    }

    public void executeUpdateDelegationProxyInfo(String delegationId, String delegationProxyInfo, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"Begin executeUpdateDelegationProxyInfo");
        if (delegationId == null || "".equals(delegationId)) {
            logger.error((Object)"delegationId not specified!");
            throw new IllegalArgumentException("delegationId not specified!");
        }
        if (delegationProxyInfo == null || "".equals(delegationProxyInfo)) {
            logger.error((Object)"delegationProxyInfo not specified!");
            throw new IllegalArgumentException("delegationProxyInfo not specified!");
        }
        if (userId == null || "".equals(userId)) {
            logger.error((Object)"userId not specified!");
            throw new IllegalArgumentException("userId not specified!");
        }
        Connection connection = DatasourceManager.getConnection((String)this.datasourceName);
        try {
            this.jobTableJobStatusTable.executeUpdateDelegationProxyInfo(delegationId, delegationProxyInfo, userId, connection);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new DatabaseException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + " Message =  " + sqle.getMessage());
            }
            throw new DatabaseException("Rollback executed due to: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
        }
        logger.debug((Object)"End executeUpdateDelegationProxyInfo");
    }
}

