/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.cream.jobmanagement.db.JobDBManager;
import org.glite.ce.creamapi.eventmanagement.Event;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.JobStatus;
import org.glite.ce.creamapi.jobmanagement.Lease;
import org.glite.ce.creamapi.jobmanagement.command.JobCommand;
import org.glite.ce.creamapi.jobmanagement.db.JobDBInterface;

public class JobDBImplementation
implements JobDBInterface {
    private static final Logger logger = Logger.getLogger((String)JobDBImplementation.class.getName());
    private static JobDBImplementation jobDBImplementation = null;
    private JobDBManager jobDBManager = null;

    public static JobDBInterface getInstance() throws DatabaseException {
        if (jobDBImplementation == null) {
            jobDBImplementation = new JobDBImplementation();
        }
        return jobDBImplementation;
    }

    private JobDBImplementation() throws DatabaseException {
        try {
            this.jobDBManager = new JobDBManager("datasource_creamdb");
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void delete(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)("BEGIN delete for: jobId = " + jobId + " userId = " + userId));
        if (jobId == null) {
            logger.error((Object)"jobId mustn't be null!");
            throw new IllegalArgumentException("jobId mustn't be null!");
        }
        this.jobDBManager.deleteJob(jobId, userId);
        logger.debug((Object)("END delete for: jobId = " + jobId + " userId = " + userId));
    }

    public void deleteJobLease(String leaseId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN deleteJobLease");
        if (userId == null) {
            logger.error((Object)"UserId mustn't be null!");
            throw new IllegalArgumentException("UserId mustn't be null!");
        }
        if (leaseId == null || "".equals(leaseId)) {
            logger.error((Object)"LeaseId mustn't be null or empty!");
            throw new IllegalArgumentException("LeaseId mustn't be null or empty!");
        }
        this.jobDBManager.deleteJobLease(leaseId, userId);
        logger.debug((Object)"END deleteJobLease");
    }

    public void insert(Job job) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN insert");
        if (job == null) {
            logger.error((Object)"job mustn't be null!");
            throw new IllegalArgumentException("job mustn't be null!");
        }
        this.jobDBManager.insertJob(job);
        logger.debug((Object)"END insert");
    }

    public void insertJobCommand(JobCommand jobCommand) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN insertJobCommand");
        if (jobCommand == null) {
            logger.error((Object)"jobCommand mustn't be null!");
            throw new IllegalArgumentException("jobCommand mustn't be null!");
        }
        this.jobDBManager.insertJobCommand(jobCommand);
        logger.debug((Object)"END insertJobCommand");
    }

    public void insertJobCommand(JobCommand jobCommand, String delegationId, int[] jobStatusType) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN insertJobCommand");
        if (jobCommand == null) {
            logger.error((Object)"jobCommand mustn't be null!");
            throw new IllegalArgumentException("jobCommand mustn't be null!");
        }
        if (delegationId == null) {
            logger.error((Object)"delegationId mustn't be null!");
            throw new IllegalArgumentException("delegationId mustn't be null!");
        }
        this.jobDBManager.insertJobCommand(jobCommand, delegationId, jobStatusType);
        logger.debug((Object)"END insertJobCommand");
    }

    public void insertJobLease(Lease jobLease) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN insertJobLease");
        if (jobLease == null) {
            logger.error((Object)"jobLease mustn't be null!");
            throw new IllegalArgumentException("jobLease mustn't be null!");
        }
        if (jobLease.getUserId() == null) {
            logger.error((Object)"userId mustn't be null!");
            throw new IllegalArgumentException("userId mustn't be null!");
        }
        if (jobLease.getLeaseId() == null || "".equals(jobLease.getLeaseId())) {
            logger.error((Object)"leaseId mustn't be null or empty!");
            throw new IllegalArgumentException("leaseId mustn't be null or empty!");
        }
        if (jobLease.getLeaseTime() == null) {
            logger.error((Object)"leaseTime mustn't be null!");
            throw new IllegalArgumentException("leaseTime mustn't be null!");
        }
        this.jobDBManager.insertJobLease(jobLease);
        logger.debug((Object)"END insertJobLease");
    }

    public void insertStatus(JobStatus status, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN insertStatus");
        if (status == null) {
            logger.error((Object)"status mustn't be null!");
            throw new IllegalArgumentException("status mustn't be null!");
        }
        this.jobDBManager.insertStatus(status, userId);
        logger.debug((Object)"END insertStatus");
    }

    public long jobCountByStatus(int[] jobStatusType, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN jobCountByStatus");
        long countByStatus = 0L;
        countByStatus = this.jobDBManager.executeSelectToJobCountByStatus(jobStatusType, userId);
        logger.debug((Object)"END jobCountByStatus");
        return countByStatus;
    }

    public List<String> retrieveByDate(List<String> jobId, String userId, Calendar startDate, Calendar endDate) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveByDate");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobIdByDate(jobId, userId, startDate, endDate);
        logger.debug((Object)"END retrieveByDate");
        return jobIdList;
    }

    public List<JobCommand> retrieveCommandHistory(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveCommandHistory");
        if (jobId == null) {
            logger.error((Object)"jobId mustn't be null!");
            throw new IllegalArgumentException("jobId mustn't be null!");
        }
        List<JobCommand> jobCommandList = null;
        jobCommandList = this.jobDBManager.retrieveJobCommandHistory(jobId, userId);
        logger.debug((Object)"END retrieveCommandHistory");
        return jobCommandList;
    }

    public Job retrieveJob(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJob");
        if (jobId == null) {
            logger.error((Object)"jobId mustn't be null!");
            throw new IllegalArgumentException("jobId mustn't be null!");
        }
        Job job = null;
        job = this.jobDBManager.retrieveJob(jobId, userId);
        logger.debug((Object)"END retrieveJob");
        return job;
    }

    public List<String> retrieveJobId(int[] jobStatusType, String queueName, String batchSystem, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobId");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobIdByStatus(userId, null, null, jobStatusType, null, null, queueName, batchSystem);
        logger.debug((Object)"END retrieveJobId");
        return jobIdList;
    }

    public List<String> retrieveJobId(List<String> jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobId");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobId(userId, jobId, null, null, null);
        logger.debug((Object)"END retrieveJobId");
        return jobIdList;
    }

    public List<String> retrieveJobId(List<String> jobId, String userId, int[] jobStatusType, Calendar startStatusDate, Calendar endStatusDate) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobId");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobIdByStatus(userId, jobId, null, jobStatusType, startStatusDate, endStatusDate, null, null);
        logger.debug((Object)"END retrieveJobId");
        return jobIdList;
    }

    public List<String> retrieveJobId(List<String> jobId, String delegId, String leaseId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobId");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobId(userId, jobId, leaseId, delegId, null);
        logger.debug((Object)"END retrieveJobId");
        return jobIdList;
    }

    public List<String> retrieveJobId(String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobId");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobId(userId, null, null, null, null);
        logger.debug((Object)"END retrieveJobId");
        return jobIdList;
    }

    public List<String> retrieveJobId(String delegId, int[] jobStatusType, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobId");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobIdByStatus(userId, null, delegId, jobStatusType, null, null, null, null);
        logger.debug((Object)"END retrieveJobId");
        return jobIdList;
    }

    public List<String> retrieveJobId(String delegId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobId");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobId(userId, null, null, delegId, null);
        logger.debug((Object)"END retrieveJobId");
        return jobIdList;
    }

    public List<String> retrieveJobId(String userId, String delegationId, int[] jobStatusType, Calendar startStatusDate, Calendar endStatusDate, String leaseId, Calendar registerCommandStartDate, Calendar registerCommandEndDate) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobId");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobId(userId, delegationId, jobStatusType, startStatusDate, endStatusDate, leaseId, registerCommandStartDate, registerCommandEndDate);
        logger.debug((Object)"END retrieveJobId");
        return jobIdList;
    }

    public List<String> retrieveJobIdByGridJobId(List<String> gridJobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobIdByGridJobId");
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobId(userId, null, null, null, gridJobId);
        logger.debug((Object)"BEGIN retrieveJobIdByGridJobId");
        return jobIdList;
    }

    public List<String> retrieveJobIdByLease(int[] jobStatusType, Calendar maxLeaseTime, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobIdByLease");
        if (jobStatusType == null || jobStatusType.length == 0) {
            logger.error((Object)"jobStatusType mustn't be null or empty!");
            throw new IllegalArgumentException("jobStatusType mustn't be null or empty!");
        }
        if (maxLeaseTime == null) {
            logger.error((Object)"maxLeaseTime mustn't be null!");
            throw new IllegalArgumentException("maxLeaseTime mustn't be null!");
        }
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobIdByLease(jobStatusType, null, maxLeaseTime, userId);
        logger.debug((Object)"END retrieveJobIdByLease");
        return jobIdList;
    }

    public List<String> retrieveJobIdByLease(int[] jobStatusType, String leaseId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobIdByLease");
        if (jobStatusType == null || jobStatusType.length == 0) {
            logger.error((Object)"jobStatusType mustn't be null or empty!");
            throw new IllegalArgumentException("jobStatusType mustn't be null or empty!");
        }
        if (leaseId == null) {
            logger.error((Object)"leaseId mustn't be null!");
            throw new IllegalArgumentException("leaseId mustn't be null!");
        }
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobIdByLease(jobStatusType, leaseId, null, userId);
        logger.debug((Object)"END retrieveJobIdByLease");
        return jobIdList;
    }

    public List<String> retrieveJobIdLeaseTimeExpired(int[] jobStatusType, String delegationId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobIdLeaseTimeExpired");
        if (jobStatusType == null || jobStatusType.length == 0) {
            logger.error((Object)"jobStatusType mustn't be null or empty!");
            throw new IllegalArgumentException("jobStatusType mustn't be null or empty!");
        }
        List<String> jobIdList = null;
        jobIdList = this.jobDBManager.executeSelectToRetrieveJobIdByLeaseTimeExpired(userId, delegationId, jobStatusType);
        logger.debug((Object)"END retrieveJobIdLeaseTimeExpired");
        return jobIdList;
    }

    public List<Lease> retrieveJobLease(Calendar maxLeaseTime, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobLease");
        List<Lease> leaseList = null;
        leaseList = this.jobDBManager.executeSelectJobLease(null, userId, maxLeaseTime);
        logger.debug((Object)"END retrieveJobLease");
        return leaseList;
    }

    public List<Lease> retrieveJobLease(String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobLease");
        List<Lease> leaseList = null;
        leaseList = this.jobDBManager.executeSelectJobLease(null, userId, null);
        logger.debug((Object)"END retrieveJobLease");
        return leaseList;
    }

    public Lease retrieveJobLease(String leaseId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobLease");
        if (userId == null) {
            logger.error((Object)"userId mustn't be null!");
            throw new IllegalArgumentException("userId mustn't be null!");
        }
        if (leaseId == null || "".equals(leaseId)) {
            logger.error((Object)"leaseId mustn't be null or empty!");
            throw new IllegalArgumentException("leaseId mustn't be null or empty!");
        }
        List<Lease> leaseList = null;
        Lease lease = null;
        leaseList = this.jobDBManager.executeSelectJobLease(leaseId, userId, null);
        if (leaseList.size() > 0) {
            lease = leaseList.get(0);
        }
        logger.debug((Object)"END retrieveJobLease");
        return lease;
    }

    public List<JobStatus> retrieveJobStatusHistory(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveJobStatusHistory");
        List<JobStatus> jobStatusList = null;
        jobStatusList = this.jobDBManager.retrieveJobStatusHistory(jobId, userId);
        logger.debug((Object)"END retrieveJobStatusHistory");
        return jobStatusList;
    }

    public JobCommand retrieveLastCommand(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveLastCommand");
        JobCommand jobCommand = null;
        jobCommand = this.jobDBManager.retrieveLastJobCommand(jobId, userId);
        logger.debug((Object)"END retrieveLastCommand");
        return jobCommand;
    }

    public List<JobStatus> retrieveLastJobStatus(List<String> jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveLastJobStatus on list");
        if (jobId == null) {
            logger.error((Object)"jobId mustn't be null!");
            throw new IllegalArgumentException("jobId mustn't be null!");
        }
        ArrayList<JobStatus> jobStatusList = new ArrayList<JobStatus>();
        JobStatus jobStatus = null;
        for (String id : jobId) {
            try {
                jobStatus = this.retrieveLastJobStatus(id, userId);
                if (jobStatus == null) continue;
                jobStatusList.add(jobStatus);
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
        }
        logger.debug((Object)"END retrieveLastJobStatus on list");
        return jobStatusList;
    }

    public JobStatus retrieveLastJobStatus(String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveLastJobStatus");
        JobStatus jobStatus = null;
        jobStatus = this.jobDBManager.retrieveLastJobStatus(jobId, userId);
        logger.debug((Object)"END retrieveLastJobStatus");
        return jobStatus;
    }

    public String retrieveOlderJobId(int[] jobStatusType, String batchSystem, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN retrieveOlderJobId");
        String jobId = this.jobDBManager.executeSelectToOlderJobId(jobStatusType, batchSystem, userId);
        logger.debug((Object)"END retrieveOlderJobId");
        return jobId;
    }

    public void setLeaseExpired(Lease jobLease) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN setLeaseExpired");
        if (jobLease == null) {
            logger.error((Object)"jobLease mustn't be null!");
            throw new IllegalArgumentException("jobLease mustn't be null!");
        }
        if (jobLease.getUserId() == null) {
            logger.error((Object)"userId mustn't be null!");
            throw new IllegalArgumentException("userId mustn't be null!");
        }
        if (jobLease.getLeaseId() == null || "".equals(jobLease.getLeaseId())) {
            logger.error((Object)"leaseId mustn't be null or empty!");
            throw new IllegalArgumentException("leaseId mustn't be null or empty!");
        }
        if (jobLease.getLeaseTime() == null) {
            logger.error((Object)"leaseTime mustn't be null!");
            throw new IllegalArgumentException("leaseTime mustn't be null!");
        }
        this.jobDBManager.setLeaseExpired(jobLease);
        logger.debug((Object)"END setLeaseExpired");
    }

    public void setLeaseExpired(String jobId, Lease jobLease) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)("BEGIN setLeaseExpired. JobId= " + jobId));
        if (jobId == null) {
            logger.error((Object)"jobId mustn't be null!");
            throw new IllegalArgumentException("jobId mustn't be null!");
        }
        if (jobLease == null) {
            logger.error((Object)"jobLease mustn't be null!");
            throw new IllegalArgumentException("jobLease mustn't be null!");
        }
        if (jobLease.getUserId() == null) {
            logger.error((Object)"userId mustn't be null!");
            throw new IllegalArgumentException("userId mustn't be null!");
        }
        if (jobLease.getLeaseId() == null || "".equals(jobLease.getLeaseId())) {
            logger.error((Object)"leaseId mustn't be null or empty!");
            throw new IllegalArgumentException("leaseId mustn't be null or empty!");
        }
        if (jobLease.getLeaseTime() == null) {
            logger.error((Object)"leaseTime mustn't be null!");
            throw new IllegalArgumentException("leaseTime mustn't be null!");
        }
        this.jobDBManager.setLeaseExpired(jobId, jobLease);
        logger.debug((Object)("END setLeaseExpired. JobId= " + jobId));
    }

    public void setLeaseId(String leaseId, String jobId, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)("BEGIN setLeaseId: leaseId = " + leaseId + " jobId = " + jobId + " userId = " + userId));
        if (jobId == null) {
            logger.error((Object)"jobId mustn't be null!");
            throw new IllegalArgumentException("jobId mustn't be null!");
        }
        if (userId == null) {
            logger.error((Object)"userId mustn't be null!");
            throw new IllegalArgumentException("userId mustn't be null!");
        }
        if ("".equals(leaseId)) {
            logger.error((Object)"leaseId mustn't be empty!");
            throw new IllegalArgumentException("leaseId mustn't be empty!");
        }
        this.jobDBManager.setLeaseId(leaseId, jobId, userId);
        logger.debug((Object)("END setLeaseId: leaseId = " + leaseId + " jobId = " + jobId + " userId = " + userId));
    }

    public void update(Job job) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN update");
        if (job == null) {
            logger.error((Object)"job mustn't be null!");
            throw new IllegalArgumentException("job mustn't be null!");
        }
        this.jobDBManager.updateJob(job);
        logger.debug((Object)"END update");
    }

    public int updateAllUnterminatedJobCommand() throws DatabaseException {
        logger.debug((Object)"BEGIN updateAllUnterminatedJobCommand");
        int result = this.jobDBManager.executeUpdateAllUnterminatedJobCommand();
        logger.debug((Object)"END updateAllUnterminatedJobCommand");
        return result;
    }

    public void updateJobCommand(JobCommand jobCommand) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN updateJobCommand");
        if (jobCommand == null) {
            logger.error((Object)"jobCommand mustn't be null!");
            throw new IllegalArgumentException("jobCommand mustn't be null!");
        }
        this.jobDBManager.updateJobCommand(jobCommand);
        logger.debug((Object)"END updateJobCommand");
    }

    public void updateJobLease(Lease jobLease) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN updateJobLease");
        if (jobLease == null) {
            logger.error((Object)"jobLease mustn't be null!");
            throw new IllegalArgumentException("jobLease mustn't be null!");
        }
        if (jobLease.getUserId() == null) {
            logger.error((Object)"userId mustn't be null!");
            throw new IllegalArgumentException("userId mustn't be null!");
        }
        if (jobLease.getLeaseId() == null || "".equals(jobLease.getLeaseId())) {
            logger.error((Object)"leaseId mustn't be null or empty!");
            throw new IllegalArgumentException("leaseId mustn't be null or empty!");
        }
        if (jobLease.getLeaseTime() == null) {
            logger.error((Object)"leaseTime mustn't be null!");
            throw new IllegalArgumentException("leaseTime mustn't be null!");
        }
        this.jobDBManager.executeUpdateJobLease(jobLease);
        logger.debug((Object)"END updateJobLease");
    }

    public void updateDelegationProxyInfo(String delegationId, String delegationProxyInfo, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN updateDelegationProxyInfo");
        if (delegationId == null || "".equals(delegationId)) {
            logger.error((Object)"delegationId not specified!");
            throw new IllegalArgumentException("delegationId not specified!");
        }
        if (delegationProxyInfo == null || "".equals(delegationProxyInfo)) {
            logger.error((Object)"delegationProxyInfonot specified!");
            throw new IllegalArgumentException("delegationProxyInfo not specified!");
        }
        if (userId == null || "".equals(userId)) {
            logger.error((Object)"userId not specified!");
            throw new IllegalArgumentException("userId not specified!");
        }
        this.jobDBManager.executeUpdateDelegationProxyInfo(delegationId, delegationProxyInfo, userId);
        logger.debug((Object)"END updateDelegationProxyInfo");
    }

    public void updateStatus(JobStatus status, String userId) throws DatabaseException, IllegalArgumentException {
        logger.debug((Object)"BEGIN updateStatus");
        if (status == null) {
            logger.error((Object)"status mustn't be null!");
            throw new IllegalArgumentException("status mustn't be null!");
        }
        this.jobDBManager.updateStatus(status, userId);
        logger.debug((Object)"END updateStatus");
    }

    public List<JobStatus> retrieveJobStatus(String fromJobStatusId, String toJobStatusId, Calendar fromDate, Calendar toDate, int maxElements, String userId) throws DatabaseException, IllegalArgumentException {
        String iceId = null;
        int index = userId.indexOf("@");
        if (userId != null && index != -1) {
            iceId = userId.substring(index + 1);
            userId = userId.substring(0, index);
        }
        return this.jobDBManager.retrieveJobStatus(fromJobStatusId, toJobStatusId, fromDate, toDate, maxElements, iceId, userId);
    }

    public List<Event> retrieveJobStatusAsEvent(String fromJobStatusId, String toJobStatusId, Calendar fromDate, Calendar toDate, int[] jobStatusType, int maxElements, String userId) throws DatabaseException, IllegalArgumentException {
        String iceId = null;
        int index = userId.indexOf("@");
        if (userId != null && index != -1) {
            iceId = userId.substring(index + 1);
            userId = userId.substring(0, index);
        }
        return this.jobDBManager.retrieveJobStatusAsEvent(fromJobStatusId, toJobStatusId, fromDate, toDate, jobStatusType, maxElements, iceId, userId);
    }
}

