/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.cmdexecutor.blah;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.commonj.utils.BooleanLock;
import org.glite.ce.cream.jobmanagement.cmdexecutor.blah.BLAHException;
import org.glite.ce.cream.jobmanagement.cmdexecutor.blah.BLAHExecutor;
import org.glite.ce.cream.jobmanagement.cmdexecutor.blah.LRMSEventsProcessor;
import org.glite.ce.creamapi.cmdmanagement.CommandException;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.JobStatus;
import org.glite.ce.creamapi.jobmanagement.db.JobDBInterface;

public class BLParserClient
extends Thread {
    private static final Logger logger = Logger.getLogger((String)BLParserClient.class.getName());
    private String lrmsName;
    private String blParserHost = null;
    private String jobIdPrefix = null;
    private int blParserPort = -1;
    private int blParserRetryCount = -1;
    private int blParserRetryDelay = -1;
    private BLAHExecutor blahExec = null;
    private LRMSEventsProcessor processor = null;
    private SocketChannel socketChannel = null;
    private BooleanLock isNTFDATEfinished = null;
    private PrintWriter out;
    private BufferedReader breader;
    private JobDBInterface jobDB = null;
    private boolean working = true;

    public BLParserClient(BLAHExecutor blahExec, LRMSEventsProcessor processor, String jobIdPrefix, String lrmsName, String blParserHost, String blParserPort, int blParserRetryCount, int blParserRetryDelay, JobDBInterface jobDB) throws BLAHException {
        super("BLParserClient");
        this.setDaemon(true);
        if (lrmsName == null) {
            throw new BLAHException("LRMS name not specified");
        }
        this.isNTFDATEfinished = new BooleanLock(false);
        this.blahExec = blahExec;
        this.processor = processor;
        this.jobIdPrefix = jobIdPrefix;
        this.lrmsName = lrmsName;
        this.blParserHost = blParserHost;
        this.blParserRetryCount = blParserRetryCount;
        this.blParserRetryDelay = blParserRetryDelay;
        if (jobDB == null) {
            throw new BLAHException("jobDB not specified");
        }
        this.jobDB = jobDB;
        try {
            this.blParserPort = Integer.parseInt(blParserPort);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void initBLParserClient() throws Exception {
        this.start();
    }

    public Calendar getOlderJobTime() throws Exception {
        Calendar olderJobTime = Calendar.getInstance();
        int[] jobStatusType = new int[]{6, 2, 4, 3};
        try {
            JobStatus jobStatus;
            String jobId = this.jobDB.retrieveOlderJobId(jobStatusType, this.lrmsName, null);
            if (jobId != null && (jobStatus = this.jobDB.retrieveLastJobStatus(jobId, null)) != null) {
                if (jobStatus.getType() == 4) {
                    Job job = this.jobDB.retrieveJob(jobId, null);
                    if (job == null) {
                        logger.error((Object)("getOlderJobTime error: jobId " + jobId + " not found!"));
                    } else {
                        jobStatus = job.getStatusAt(job.getStatusCount() - 2);
                    }
                }
                if (jobStatus != null && jobStatus.getTimestamp().before(olderJobTime)) {
                    olderJobTime = jobStatus.getTimestamp();
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new CommandException("BLParserClient error: " + e.getMessage());
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            throw new CommandException("BLParserClient error: " + e.getMessage());
        }
        return olderJobTime;
    }

    public boolean isInitialized() {
        return this.isNTFDATEfinished.isTrue();
    }

    public void terminate() {
        logger.info((Object)("terminate invoked! [" + this.blParserHost + ":" + this.blParserPort + "]"));
        this.working = false;
        try {
            if (this.socketChannel != null && this.socketChannel.socket() != null) {
                this.socketChannel.socket().close();
            }
            if (this.breader != null) {
                this.breader.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            logger.info((Object)("terminated! [" + this.blParserHost + ":" + this.blParserPort + "]"));
        }
        catch (Throwable t) {
            logger.error((Object)("failure on terminating the BLParserClient [" + this.blParserHost + ":" + this.blParserPort + "]: " + t.getMessage()));
        }
        this.blParserHost = null;
        this.blParserPort = -1;
    }

    private void initializeConnection(int maxRetryCount) throws BLAHException {
        boolean forever;
        int i = maxRetryCount;
        boolean connected = false;
        boolean bl = forever = i < 0;
        while (this.blParserHost == null && (forever || i-- > 0)) {
            String[] blahHostPort = this.blahExec.getBlahHostPort(this.lrmsName);
            if (blahHostPort != null && blahHostPort[2] != null) {
                this.blParserHost = blahHostPort[1];
                this.blParserPort = Integer.parseInt(blahHostPort[2]);
                continue;
            }
            logger.info((Object)("initializeConnection: getting info about BLParser (" + this.lrmsName + ") from BLAH (retry count=" + i + "/" + maxRetryCount + ")"));
            try {
                BLParserClient.sleep(this.blParserRetryDelay);
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (this.blParserHost == null) {
            throw new BLAHException("initializeConnection error: cannot get BLParser (" + this.lrmsName + ") HOST:PORT information from BLAH. Please, be sure that BLAH is properly configured and RESTART the CREAM service.");
        }
        i = maxRetryCount;
        while (!connected && (forever || i-- > 0)) {
            try {
                connected = this.getBLParserConnection();
            }
            catch (Exception e) {
                logger.info((Object)("Retries left: " + i + ":   " + e.getMessage()));
                try {
                    BLParserClient.sleep(this.blParserRetryDelay);
                }
                catch (InterruptedException ie) {
                    logger.error((Object)ie.getMessage());
                }
            }
        }
        if (!connected) {
            throw new BLAHException("initializeConnection " + this.lrmsName + " error: max retry count reached. Please, be sure that remote log supplier is running at " + this.blParserHost + ":" + this.blParserPort + " then restart CREAM, or use a local LRMS log.");
        }
    }

    private boolean getBLParserConnection() throws Exception {
        this.isNTFDATEfinished.setValue(false);
        InetSocketAddress isa = new InetSocketAddress(this.blParserHost, this.blParserPort);
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.connect(isa);
            Socket sc = this.socketChannel.socket();
            this.out = new PrintWriter(sc.getOutputStream(), true);
            this.breader = new BufferedReader(new InputStreamReader(sc.getInputStream()));
            logger.info((Object)("Connection with BLParser (" + this.lrmsName + ") correctly established."));
            if (sc.isConnected()) {
                String filterResult;
                if (this.jobIdPrefix != null) {
                    logger.debug((Object)("sending: CREAMFILTER/" + this.jobIdPrefix));
                    this.out.println("CREAMFILTER/" + this.jobIdPrefix);
                    this.out.flush();
                    filterResult = this.breader.readLine();
                    logger.debug((Object)("received: " + filterResult));
                    if (filterResult.indexOf("ERROR") > 0) {
                        throw new Exception("getBLParserConnection() error");
                    }
                }
                logger.debug((Object)"sending: PARSERVERSION/");
                this.out.println("PARSERVERSION/");
                this.out.flush();
                filterResult = this.breader.readLine();
                logger.debug((Object)("received: " + filterResult));
                if (filterResult == null) {
                    throw new Exception("getBLParserConnection() error: PARSERVERSION command not supported?!?");
                }
                List jobList = this.jobDB.retrieveJobId(new int[]{6, 2, 4, 3}, null, this.lrmsName, null);
                if (jobList.size() > 0) {
                    StringBuffer cmd = new StringBuffer("STARTNOTIFYJOBLIST/");
                    if (filterResult.endsWith("__0")) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        cmd.append(dateFormat.format(this.getOlderJobTime().getTime())).append(";");
                    } else if (!filterResult.endsWith("__1")) {
                        throw new Exception("getBLParserConnection() error: PARSERVERSION returned a wrong parser version!");
                    }
                    for (String jobId : jobList) {
                        cmd.append(this.jobIdPrefix).append(jobId.substring(5, jobId.length())).append(",");
                    }
                    cmd.deleteCharAt(cmd.length() - 1);
                    jobList.clear();
                    jobList = null;
                    logger.info((Object)("sending: " + cmd));
                    this.out.println(cmd);
                    this.out.flush();
                }
                logger.info((Object)"sending: STARTNOTIFYJOBEND/");
                this.out.println("STARTNOTIFYJOBEND/");
                this.out.flush();
            }
            return true;
        }
        catch (IOException e) {
            throw new Exception("Connection with remote BLParser at " + this.blParserHost + ":" + this.blParserPort + " cannot be established.");
        }
        catch (AlreadyConnectedException e) {
            throw new Exception("Connection with remote BLParser at " + this.blParserHost + ":" + this.blParserPort + " already established.");
        }
        catch (ConnectionPendingException e) {
            throw new Exception("Connection with remote BLParser at " + this.blParserHost + ":" + this.blParserPort + " is pending.");
        }
        catch (SecurityException e) {
            throw new Exception("Connection with remote BLParser at " + this.blParserHost + ":" + this.blParserPort + " error: " + e.getMessage());
        }
    }

    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isOpen() && this.socketChannel.isConnected() && this.breader != null && !this.socketChannel.socket().isClosed();
    }

    @Override
    public void run() {
        logger.info((Object)"BLParserClient started!");
        while (this.working) {
            block10: {
                try {
                    this.initializeConnection(this.blParserRetryCount);
                }
                catch (BLAHException e1) {
                    logger.error((Object)e1.getMessage());
                    if (e1.getMessage().indexOf("max retry count reached") <= 0) break block10;
                    this.interrupt();
                    this.working = false;
                }
            }
            String line = null;
            String event = null;
            try {
                while (this.working) {
                    line = this.breader.readLine();
                    if (line == null) {
                        throw new Exception("Connection with remote BLParser at " + this.blParserHost + ":" + this.blParserPort + " is down!");
                    }
                    logger.debug((Object)("line = " + line));
                    if (line.startsWith("NTFDATE/END")) {
                        logger.info((Object)"done!");
                        this.isNTFDATEfinished.setValue(true);
                    } else {
                        event = event + line;
                        if (line.endsWith("]")) {
                            logger.debug((Object)("event = " + event));
                            this.processor.processEvent(event);
                            event = null;
                        }
                    }
                    line = null;
                }
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage());
            }
        }
        logger.info((Object)"BLParserclient interrupted");
    }

    public String getBlParserHost() {
        return this.blParserHost;
    }

    public void setBlParserHost(String blParserHost) {
        this.blParserHost = blParserHost;
    }

    public int getBlParserPort() {
        return this.blParserPort;
    }

    public void setBlParserPort(int blParserPort) {
        this.blParserPort = blParserPort;
    }

    public int getBlParserRetryCount() {
        return this.blParserRetryCount;
    }

    public void setBlParserRetryCount(int blParserRetryCount) {
        this.blParserRetryCount = blParserRetryCount;
    }

    public int getBlParserRetryDelay() {
        return this.blParserRetryDelay;
    }

    public void setBlParserRetryDelay(int blParserRetryDelay) {
        this.blParserRetryDelay = blParserRetryDelay;
    }
}

