/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.delegationmanagement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.commonj.db.DatasourceManager;
import org.glite.ce.commonj.utils.CEUtils;
import org.glite.ce.cream.delegationmanagement.DelegationPurger;
import org.glite.ce.creamapi.delegationmanagement.Delegation;
import org.glite.ce.creamapi.delegationmanagement.DelegationException;
import org.glite.ce.creamapi.delegationmanagement.DelegationManagerException;
import org.glite.ce.creamapi.delegationmanagement.DelegationManagerInterface;
import org.glite.ce.creamapi.delegationmanagement.DelegationRequest;
import org.glite.ce.creamapi.jobmanagement.db.DBInfoManager;

public class DelegationManager
implements DelegationManagerInterface {
    private static final Logger logger = Logger.getLogger((String)DelegationManager.class.getName());
    private static final String DELEGATION_TABLE = "delegation";
    private static final String DELEGATION_REQUEST_TABLE = "delegation_request";
    private static final String ID_FIELD = "id";
    private static final String DN_FIELD = "dn";
    private static final String VO_FIELD = "vo";
    private static final String FQAN_FIELD = "fqan";
    private static final String INFO_FIELD = "info";
    private static final String VOMS_ATTRIBUTE_FIELD = "vomsAttribute";
    private static final String LOCAL_USER_FIELD = "localUser";
    private static final String LOCAL_USER_GROUP_FIELD = "localUserGroup";
    private static final String CERTIFICATE_FIELD = "certificate";
    private static final String CERTIFICATE_REQUEST_FIELD = "certificateRequest";
    private static final String START_TIME_FIELD = "startTime";
    private static final String EXPIRATION_TIME_FIELD = "expirationTime";
    private static final String LAST_UPDATE_TIME_FIELD = "lastUpdateTime";
    private static final String TIMESTAMP_FIELD = "timestamp";
    private static final String PUBLIC_KEY_FIELD = "publicKey";
    private static final String PRIVATE_KEY_FIELD = "privateKey";
    private static boolean terminated = false;
    private static DelegationManager delegationManager = null;

    public static DelegationManager getInstance() throws DelegationManagerException {
        if (terminated) {
            throw new DelegationManagerException("DelegationManager already terminated!");
        }
        if (delegationManager == null) {
            delegationManager = new DelegationManager();
            delegationManager.init();
        }
        return delegationManager;
    }

    public static void main(String[] args) {
        try {
            DelegationManager dm = DelegationManager.getInstance();
            DelegationRequest req = new DelegationRequest("delegId2");
            ArrayList<String> vomsAttr = new ArrayList<String>(2);
            vomsAttr.add("attr1");
            vomsAttr.add("attr2");
            req.setDN("/C=IT/O=INFN/OU=Personal Certificate/L=Padova/CN=Luigi Zangrando");
            req.setCertificateRequest(CERTIFICATE_REQUEST_FIELD);
            req.setPrivateKey("primaryKey");
            req.setVOMSAttributes(vomsAttr);
            req.setLocalUser("lisa");
            Delegation deleg = new Delegation("delegId2");
            deleg.setCertificate(CERTIFICATE_FIELD);
            deleg.setDN("/C=IT/O=INFN/OU=Personal Certificate/L=Padova/CN=Luigi Zangrando");
            deleg.setExpirationTime(Calendar.getInstance().getTime());
            deleg.setStartTime(Calendar.getInstance().getTime());
            deleg.setFQAN(FQAN_FIELD);
            deleg.setLocalUser("lisa");
            deleg.setLocalUserGroup("lisa group");
            deleg.setInfo("CIAO");
            deleg.setVO("VO");
            deleg.setVOMSAttributes(vomsAttr);
            Delegation dd = dm.getDelegation("delegId2", "/C=IT/O=INFN/OU=Personal Certificate/L=Padova/CN=Luigi Zangrando", "lisa");
            System.out.println(dd.getId());
            System.out.println(dd.getDN());
            System.out.println(dd.getInfo());
            System.out.println(dd.getFQAN());
            System.out.println(dd.getLocalUser());
            System.out.println(dd.getLocalUserGroup());
            System.out.println(dd.getStartTime());
            System.out.println(dd.getExpirationTime());
            System.out.println(dd.getLastUpdateTime());
            System.out.println(dd.getVO());
            System.out.println(dd.getVOMSAttributes().size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createDelegationTable() throws DelegationManagerException {
        logger.debug((Object)"BEGIN createDelegationTable");
        Statement pstmt = null;
        Connection connection = null;
        try {
            int result = 0;
            connection = this.getConnection();
            StringBuffer query = new StringBuffer("create table if not exists ");
            query.append(DELEGATION_TABLE).append(" (");
            query.append(ID_FIELD).append(" VARCHAR(255) NOT NULL, ");
            query.append(DN_FIELD).append(" VARCHAR(255) NOT NULL, ");
            query.append(FQAN_FIELD).append(" VARCHAR(255) NULL, ");
            query.append(VO_FIELD).append(" VARCHAR(50) NOT NULL, ");
            query.append(VOMS_ATTRIBUTE_FIELD).append(" TEXT NOT NULL, ");
            query.append(CERTIFICATE_FIELD).append(" TEXT NOT NULL, ");
            query.append(INFO_FIELD).append(" TEXT NULL, ");
            query.append(LOCAL_USER_FIELD).append(" VARCHAR(100) NOT NULL, ");
            query.append(LOCAL_USER_GROUP_FIELD).append(" VARCHAR(100) NOT NULL, ");
            query.append(START_TIME_FIELD).append(" DATETIME NOT NULL, ");
            query.append(EXPIRATION_TIME_FIELD).append(" DATETIME NOT NULL, ");
            query.append(LAST_UPDATE_TIME_FIELD).append(" DATETIME NULL, primary key (");
            query.append(ID_FIELD).append(", ").append(DN_FIELD).append(")) engine=InnoDB");
            pstmt = connection.prepareStatement(query.toString());
            result = pstmt.executeUpdate();
            if (result > 0) {
                logger.info((Object)"delegation table created");
            }
            query = new StringBuffer("create table if not exists ");
            query.append(DELEGATION_REQUEST_TABLE).append(" (");
            query.append(ID_FIELD).append(" VARCHAR(255) NOT NULL, ");
            query.append(DN_FIELD).append(" VARCHAR(255) NOT NULL, ");
            query.append(LOCAL_USER_FIELD).append(" VARCHAR(100) NOT NULL, ");
            query.append(CERTIFICATE_REQUEST_FIELD).append(" TEXT NOT NULL, ");
            query.append(PUBLIC_KEY_FIELD).append(" TEXT NOT NULL, ");
            query.append(PRIVATE_KEY_FIELD).append(" TEXT NOT NULL, ");
            query.append(TIMESTAMP_FIELD).append(" DATETIME NOT NULL, ");
            query.append(VOMS_ATTRIBUTE_FIELD).append(" TEXT NOT NULL, primary key ( ");
            query.append(ID_FIELD).append(", ").append(DN_FIELD).append(")) engine=InnoDB");
            pstmt = connection.prepareStatement(query.toString());
            result = pstmt.executeUpdate();
            if (result > 0) {
                logger.info((Object)"delegation_request table created");
            }
            connection.commit();
        }
        catch (SQLException sqle) {
            String rollbackMessage = null;
            if (connection != null) {
                try {
                    connection.rollback();
                    rollbackMessage = " (rollback performed)";
                }
                catch (SQLException sqle1) {
                    rollbackMessage = " (rollback failed: " + sqle1.getMessage() + ")";
                }
            }
            logger.error((Object)("createDelegationTable failed: cannot create the delegation table: " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : "")));
            throw new DelegationManagerException("Cannot create the delegation table: " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : ""));
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle2) {
                    logger.error((Object)("Problem in closing connection: " + sqle2.getMessage()));
                    throw new DelegationManagerException("Problem in closing connection: " + sqle2.getMessage());
                }
            }
        }
        logger.debug((Object)"END createDelegationTable");
    }

    public void delete(Delegation delegation) throws DelegationException, DelegationManagerException {
        if (delegation == null) {
            throw new DelegationException("delegation not specified!");
        }
        if (delegation.getId() == null || delegation.getId().length() == 0) {
            throw new DelegationException("delegationId not specified!");
        }
        if (delegation.getDN() == null || delegation.getDN().length() == 0) {
            throw new DelegationException("user DN not specified!");
        }
        if (delegation.getLocalUser() == null || delegation.getLocalUser().length() == 0) {
            throw new DelegationException("localUser not specified!");
        }
        logger.debug((Object)("BEGIN deleteDelegation for delegationId=" + delegation.getId() + " dn=" + delegation.getDN() + " localUser=" + delegation.getLocalUser()));
        Connection connection = this.getConnection();
        Statement deletePreparedStatement = null;
        try {
            StringBuffer query = new StringBuffer("delete from ");
            query.append(DELEGATION_TABLE).append(" where ");
            query.append(ID_FIELD).append(" = ? and ");
            query.append(DN_FIELD).append(" = ? and ");
            query.append(LOCAL_USER_FIELD).append(" = ?");
            deletePreparedStatement = connection.prepareStatement(query.toString());
            deletePreparedStatement.setString(1, delegation.getId());
            deletePreparedStatement.setString(2, delegation.getDN());
            deletePreparedStatement.setString(3, delegation.getLocalUser());
            deletePreparedStatement.executeUpdate();
            query = new StringBuffer("delete from ");
            query.append(DELEGATION_REQUEST_TABLE).append(" where ");
            query.append(ID_FIELD).append(" = ? and ");
            query.append(DN_FIELD).append(" = ? and ");
            query.append(LOCAL_USER_FIELD).append(" = ?");
            deletePreparedStatement = connection.prepareStatement(query.toString());
            deletePreparedStatement.setString(1, delegation.getId());
            deletePreparedStatement.setString(2, delegation.getDN());
            deletePreparedStatement.setString(3, delegation.getLocalUser());
            deletePreparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on db interaction", (Throwable)sqle);
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            throw new DelegationException("Failure on db interaction: " + sqle.getMessage());
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)("END deleteDelegation for delegationId=" + delegation.getId() + " dn=" + delegation.getDN() + " localUser=" + delegation.getLocalUser()));
    }

    public void delete(DelegationRequest delegationRequest) throws DelegationException, DelegationManagerException {
        if (delegationRequest == null) {
            throw new DelegationException("delegation not specified!");
        }
        if (delegationRequest.getId() == null || delegationRequest.getId().length() == 0) {
            throw new DelegationException("delegationId not specified!");
        }
        if (delegationRequest.getDN() == null || delegationRequest.getDN().length() == 0) {
            throw new DelegationException("user DN not specified!");
        }
        if (delegationRequest.getLocalUser() == null || delegationRequest.getLocalUser().length() == 0) {
            throw new DelegationException("localUser not specified!");
        }
        logger.debug((Object)("BEGIN deleteDelegationRequest for delegationId=" + delegationRequest.getId() + " dn=" + delegationRequest.getDN() + " localUser=" + delegationRequest.getLocalUser()));
        Connection connection = this.getConnection();
        Statement deletePreparedStatement = null;
        try {
            StringBuffer query = new StringBuffer("delete from ");
            query.append(DELEGATION_REQUEST_TABLE).append(" where ");
            query.append(ID_FIELD).append(" = ? and ");
            query.append(DN_FIELD).append(" = ? and ");
            query.append(LOCAL_USER_FIELD).append(" = ?");
            deletePreparedStatement = connection.prepareStatement(query.toString());
            deletePreparedStatement.setString(1, delegationRequest.getId());
            deletePreparedStatement.setString(2, delegationRequest.getDN());
            deletePreparedStatement.setString(3, delegationRequest.getLocalUser());
            deletePreparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on db interaction", (Throwable)sqle);
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            throw new DelegationException("Failure on db interaction: " + sqle.getMessage());
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)("END deleteDelegationRequest for delegationId=" + delegationRequest.getId() + " dn=" + delegationRequest.getDN() + " localUser=" + delegationRequest.getLocalUser()));
    }

    public int deleteDelegationRequestsToDate(Calendar timestamp) throws DelegationException, DelegationManagerException {
        logger.debug((Object)"BEGIN deleteDelegationRequestsToDate");
        Connection connection = this.getConnection();
        Statement deletePreparedStatement = null;
        ResultSet rs = null;
        int rowCount = 0;
        try {
            StringBuffer query = new StringBuffer("delete from ");
            query.append(DELEGATION_REQUEST_TABLE).append(" where ").append(TIMESTAMP_FIELD).append(" < ?");
            deletePreparedStatement = connection.prepareStatement(query.toString());
            deletePreparedStatement.setTimestamp(1, new Timestamp(Calendar.getInstance().getTimeInMillis()));
            rowCount = deletePreparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on db interaction", (Throwable)sqle);
            throw new DelegationException("Failure on db interaction: " + sqle.getMessage());
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)("END deleteDelegationRequestsToDate (deleted " + rowCount + " delegation requests created before " + timestamp.getTime() + ")"));
        return rowCount;
    }

    private void deleteDelegationTable() throws DelegationManagerException {
        logger.debug((Object)"BEGIN deleteDelegationTable");
        Connection connection = this.getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement("drop table if exists delegation");
            pstmt.executeUpdate();
            logger.debug((Object)"delegation table dropped!");
            pstmt = connection.prepareStatement("drop table if exists delegation_request");
            pstmt.executeUpdate();
            logger.debug((Object)"delegation_request table dropped!");
            connection.commit();
            logger.info((Object)"delegation and delegation_request tables dropped!");
        }
        catch (SQLException sqle) {
            String rollbackMessage = null;
            if (connection != null) {
                try {
                    connection.rollback();
                    rollbackMessage = " (rollback performed)";
                }
                catch (SQLException sqle1) {
                    rollbackMessage = " (rollback failed: " + sqle1.getMessage() + ")";
                }
            }
            logger.error((Object)("deleteDelegationTable failed: cannot delete the delegation tables: " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : "")));
            throw new DelegationManagerException("Cannot delete the delegation tables: " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : ""));
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle2) {
                    logger.error((Object)("Problem in closing connection: " + sqle2.getMessage()));
                    throw new DelegationManagerException("Problem in closing connection: " + sqle2.getMessage());
                }
            }
        }
        logger.debug((Object)"END deleteDelegationTable");
    }

    private Connection getConnection() throws DelegationManagerException {
        Connection connection = null;
        try {
            connection = DatasourceManager.getConnection((String)"datasource_delegationdb");
        }
        catch (DatabaseException ex) {
            throw new DelegationManagerException(ex.getMessage());
        }
        if (connection == null) {
            logger.error((Object)"cannot get the database connection (datasourceName=datasource_delegationdb)");
            throw new DelegationManagerException("cannot get the database connection (datasourceName=datasource_delegationdb)");
        }
        return connection;
    }

    public Delegation getDelegation(String delegationId, String dn, String localUser) throws DelegationException, DelegationManagerException {
        if (delegationId == null || delegationId.length() == 0) {
            throw new DelegationException("delegationId not specified!");
        }
        if (dn == null || dn.length() == 0) {
            throw new DelegationException("user DN not specified!");
        }
        if (localUser == null || localUser.length() == 0) {
            throw new DelegationException("localUser not specified!");
        }
        logger.debug((Object)("BEGIN getDelegation for delegationId=" + delegationId + " dn=" + dn + " localUser=" + localUser));
        StringBuffer query = new StringBuffer("select ");
        query.append(DELEGATION_TABLE).append(".").append(ID_FIELD).append(" as ").append(ID_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(DN_FIELD).append(" as ").append(DN_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(FQAN_FIELD).append(" as ").append(FQAN_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(VO_FIELD).append(" as ").append(VO_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(VOMS_ATTRIBUTE_FIELD).append(" as ").append(VOMS_ATTRIBUTE_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(INFO_FIELD).append(" as ").append(INFO_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(CERTIFICATE_FIELD).append(" as ").append(CERTIFICATE_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(LOCAL_USER_FIELD).append(" as ").append(LOCAL_USER_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(LOCAL_USER_GROUP_FIELD).append(" as ").append(LOCAL_USER_GROUP_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(START_TIME_FIELD).append(" as ").append(START_TIME_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(EXPIRATION_TIME_FIELD).append(" as ").append(EXPIRATION_TIME_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(LAST_UPDATE_TIME_FIELD).append(" as ").append(LAST_UPDATE_TIME_FIELD).append(" from ");
        query.append(DELEGATION_TABLE).append(" where ").append(ID_FIELD).append(" = ? and ").append(DN_FIELD).append(" = ? and ");
        query.append(LOCAL_USER_FIELD).append(" = ? ");
        Delegation delegation = null;
        PreparedStatement getProxyStatement = null;
        ResultSet rs = null;
        Connection connection = this.getConnection();
        try {
            getProxyStatement = connection.prepareStatement(query.toString());
            getProxyStatement.setString(1, delegationId);
            getProxyStatement.setString(2, dn);
            getProxyStatement.setString(3, localUser);
            rs = getProxyStatement.executeQuery();
            if (rs.next()) {
                delegation = this.makeDelegation(rs);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on storage interaction", (Throwable)sqle);
            throw new DelegationException("Failure on storage interaction: " + sqle.getMessage());
        }
        finally {
            if (getProxyStatement != null) {
                try {
                    getProxyStatement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)("END getDelegation for delegationId=" + delegationId + " dn=" + dn + " localUser=" + localUser));
        return delegation;
    }

    public DelegationRequest getDelegationRequest(String delegationId, String dn, String localUser) throws DelegationException, DelegationManagerException {
        if (delegationId == null || delegationId.length() == 0) {
            throw new DelegationException("delegationId not specified!");
        }
        if (dn == null || dn.length() == 0) {
            throw new DelegationException("user DN not specified!");
        }
        if (localUser == null || localUser.length() == 0) {
            throw new DelegationException("localUser not specified!");
        }
        logger.debug((Object)("BEGIN getDelegationRequest for delegationId=" + delegationId + " dn=" + dn + " localUser=" + localUser));
        StringBuffer query = new StringBuffer("select ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(ID_FIELD).append(" as ").append(ID_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(DN_FIELD).append(" as ").append(DN_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(LOCAL_USER_FIELD).append(" as ").append(LOCAL_USER_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(CERTIFICATE_REQUEST_FIELD).append(" as ").append(CERTIFICATE_REQUEST_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(VOMS_ATTRIBUTE_FIELD).append(" as ").append(VOMS_ATTRIBUTE_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(TIMESTAMP_FIELD).append(" as ").append(TIMESTAMP_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(PUBLIC_KEY_FIELD).append(" as ").append(PUBLIC_KEY_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(PRIVATE_KEY_FIELD).append(" as ").append(PRIVATE_KEY_FIELD).append(" from ");
        query.append(DELEGATION_REQUEST_TABLE).append(" where ").append(ID_FIELD).append(" = ? and ").append(DN_FIELD).append(" = ? and ").append(LOCAL_USER_FIELD).append(" = ?");
        DelegationRequest delegationRequest = null;
        PreparedStatement getProxyStatement = null;
        ResultSet rs = null;
        Connection connection = this.getConnection();
        try {
            getProxyStatement = connection.prepareStatement(query.toString());
            getProxyStatement.setString(1, delegationId);
            getProxyStatement.setString(2, dn);
            getProxyStatement.setString(3, localUser);
            rs = getProxyStatement.executeQuery();
            if (rs.next()) {
                delegationRequest = this.makeDelegationRequest(rs);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on storage interaction", (Throwable)sqle);
            throw new DelegationException("Failure on storage interaction: " + sqle.getMessage());
        }
        finally {
            if (getProxyStatement != null) {
                try {
                    getProxyStatement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)("END getDelegationRequest for delegationId=" + delegationId + " dn=" + dn + " localUser=" + localUser));
        return delegationRequest;
    }

    public List<DelegationRequest> getDelegationRequests(String dn, String localUser) throws DelegationException, DelegationManagerException {
        if (dn == null || dn.length() == 0) {
            throw new IllegalArgumentException("user DN not specified!");
        }
        if (localUser == null || localUser.length() == 0) {
            throw new IllegalArgumentException("localUser not specified!");
        }
        logger.debug((Object)"BEGIN getDelegationRequests");
        StringBuffer query = new StringBuffer("select ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(ID_FIELD).append(" as ").append(ID_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(DN_FIELD).append(" as ").append(DN_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(LOCAL_USER_FIELD).append(" as ").append(LOCAL_USER_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(CERTIFICATE_REQUEST_FIELD).append(" as ").append(CERTIFICATE_REQUEST_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(VOMS_ATTRIBUTE_FIELD).append(" as ").append(VOMS_ATTRIBUTE_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(TIMESTAMP_FIELD).append(" as ").append(TIMESTAMP_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(PUBLIC_KEY_FIELD).append(" as ").append(PUBLIC_KEY_FIELD).append(", ");
        query.append(DELEGATION_REQUEST_TABLE).append(".").append(PRIVATE_KEY_FIELD).append(" as ").append(PRIVATE_KEY_FIELD).append(" from ");
        query.append(DELEGATION_REQUEST_TABLE).append(" where ").append(DN_FIELD).append(" = ? and ").append(LOCAL_USER_FIELD).append(" = ?");
        Connection connection = this.getConnection();
        ArrayList<DelegationRequest> result = new ArrayList<DelegationRequest>(0);
        PreparedStatement selectPreparedStatement = null;
        ResultSet rs = null;
        try {
            selectPreparedStatement = connection.prepareStatement(query.toString());
            selectPreparedStatement.setString(1, dn);
            selectPreparedStatement.setString(2, localUser);
            rs = selectPreparedStatement.executeQuery();
            while (rs.next()) {
                result.add(this.makeDelegationRequest(rs));
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on storage interaction", (Throwable)sqle);
            throw new DelegationException("Failure on storage interaction: " + sqle.getMessage());
        }
        finally {
            if (selectPreparedStatement != null) {
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)"END getDelegationRequests");
        return result;
    }

    public List<Delegation> getDelegations(Calendar expirationTime) throws DelegationException, DelegationManagerException {
        if (expirationTime == null) {
            throw new IllegalArgumentException("expirationTime not specified!");
        }
        logger.debug((Object)("BEGIN getDelegations [expirationTime < " + expirationTime.getTime() + "]"));
        StringBuffer query = new StringBuffer("select ");
        query.append(DELEGATION_TABLE).append(".").append(ID_FIELD).append(" as ").append(ID_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(DN_FIELD).append(" as ").append(DN_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(FQAN_FIELD).append(" as ").append(FQAN_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(VO_FIELD).append(" as ").append(VO_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(VOMS_ATTRIBUTE_FIELD).append(" as ").append(VOMS_ATTRIBUTE_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(INFO_FIELD).append(" as ").append(INFO_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(CERTIFICATE_FIELD).append(" as ").append(CERTIFICATE_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(LOCAL_USER_FIELD).append(" as ").append(LOCAL_USER_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(LOCAL_USER_GROUP_FIELD).append(" as ").append(LOCAL_USER_GROUP_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(START_TIME_FIELD).append(" as ").append(START_TIME_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(EXPIRATION_TIME_FIELD).append(" as ").append(EXPIRATION_TIME_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(LAST_UPDATE_TIME_FIELD).append(" as ").append(LAST_UPDATE_TIME_FIELD).append(" from ");
        query.append(DELEGATION_TABLE).append(" where ").append(EXPIRATION_TIME_FIELD).append(" <= ?");
        Connection connection = this.getConnection();
        ArrayList<Delegation> result = new ArrayList<Delegation>(0);
        PreparedStatement selectPreparedStatement = null;
        ResultSet rs = null;
        try {
            selectPreparedStatement = connection.prepareStatement(query.toString());
            selectPreparedStatement.setTimestamp(1, new Timestamp(expirationTime.getTimeInMillis()));
            rs = selectPreparedStatement.executeQuery();
            while (rs.next()) {
                result.add(this.makeDelegation(rs));
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on storage interaction", (Throwable)sqle);
            throw new DelegationException("Failure on storage interaction: " + sqle.getMessage());
        }
        finally {
            if (selectPreparedStatement != null) {
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)"END getDelegations");
        return result;
    }

    public List<Delegation> getDelegations(String dn, String localUser) throws DelegationException, DelegationManagerException {
        if (dn == null || dn.length() == 0) {
            throw new IllegalArgumentException("user DN not specified!");
        }
        if (localUser == null || localUser.length() == 0) {
            throw new IllegalArgumentException("localUser not specified!");
        }
        logger.debug((Object)"BEGIN getDelegations");
        StringBuffer query = new StringBuffer("select ");
        query.append(DELEGATION_TABLE).append(".").append(ID_FIELD).append(" as ").append(ID_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(DN_FIELD).append(" as ").append(DN_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(FQAN_FIELD).append(" as ").append(FQAN_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(VO_FIELD).append(" as ").append(VO_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(VOMS_ATTRIBUTE_FIELD).append(" as ").append(VOMS_ATTRIBUTE_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(INFO_FIELD).append(" as ").append(INFO_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(CERTIFICATE_FIELD).append(" as ").append(CERTIFICATE_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(LOCAL_USER_FIELD).append(" as ").append(LOCAL_USER_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(LOCAL_USER_GROUP_FIELD).append(" as ").append(LOCAL_USER_GROUP_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(START_TIME_FIELD).append(" as ").append(START_TIME_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(EXPIRATION_TIME_FIELD).append(" as ").append(EXPIRATION_TIME_FIELD).append(", ");
        query.append(DELEGATION_TABLE).append(".").append(LAST_UPDATE_TIME_FIELD).append(" as ").append(LAST_UPDATE_TIME_FIELD).append(" from ");
        query.append(DELEGATION_TABLE).append(" where ").append(DN_FIELD).append(" = ? and ").append(LOCAL_USER_FIELD).append(" = ?");
        Connection connection = this.getConnection();
        ArrayList<Delegation> result = new ArrayList<Delegation>(0);
        PreparedStatement selectPreparedStatement = null;
        ResultSet rs = null;
        try {
            selectPreparedStatement = connection.prepareStatement(query.toString());
            selectPreparedStatement.setString(1, dn);
            selectPreparedStatement.setString(2, localUser);
            rs = selectPreparedStatement.executeQuery();
            while (rs.next()) {
                result.add(this.makeDelegation(rs));
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on storage interaction", (Throwable)sqle);
            throw new DelegationException("Failure on storage interaction: " + sqle.getMessage());
        }
        finally {
            if (selectPreparedStatement != null) {
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)"END getDelegations");
        return result;
    }

    public String getDelegationSuffix() throws DelegationException, DelegationManagerException {
        try {
            return DBInfoManager.getDelegationSuffix((String)"datasource_delegationdb");
        }
        catch (IllegalArgumentException ex) {
            throw new DelegationManagerException(ex.getMessage());
        }
    }

    public List<Delegation> getExpiredDelegations() throws DelegationException, DelegationManagerException {
        logger.debug((Object)"BEGIN getExpiredDelegations");
        List<Delegation> result = this.getDelegations(Calendar.getInstance());
        logger.debug((Object)("END getExpiredDelegations (found " + result.size() + " delegations)"));
        return result;
    }

    public void init() throws DelegationManagerException {
        logger.info((Object)"Initializing the DelegationManager...");
        this.createDelegationTable();
        DelegationPurger.getInstance();
        logger.info((Object)"DelegationManager initialized!");
    }

    public void insert(Delegation delegation) throws DelegationException, DelegationManagerException {
        if (delegation == null) {
            throw new IllegalArgumentException("delegation not specified!");
        }
        logger.debug((Object)("BEGIN insertDelegation for delegationId=" + delegation.getId() + " dn=" + delegation.getDN() + " localUser=" + delegation.getLocalUser()));
        if (delegation.getLocalUser() == null) {
            delegation.setLocalUser(CEUtils.getLocalUser());
        }
        if (delegation.getLocalUserGroup() == null) {
            delegation.setLocalUserGroup(CEUtils.getLocalUserGroup());
        }
        StringBuffer query = new StringBuffer("insert into ");
        query.append(DELEGATION_TABLE).append(" (").append(ID_FIELD).append(", ");
        query.append(DN_FIELD).append(", ").append(FQAN_FIELD).append(", ").append(VO_FIELD).append(", ");
        query.append(LOCAL_USER_FIELD).append(", ").append(LOCAL_USER_GROUP_FIELD).append(", ");
        query.append(CERTIFICATE_FIELD).append(", ").append(INFO_FIELD).append(", ").append(VOMS_ATTRIBUTE_FIELD).append(", ");
        query.append(START_TIME_FIELD).append(", ").append(EXPIRATION_TIME_FIELD).append(", ").append(LAST_UPDATE_TIME_FIELD);
        query.append(") values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        PreparedStatement insertStatement = null;
        Connection connection = this.getConnection();
        try {
            insertStatement = connection.prepareStatement(query.toString());
            insertStatement.setString(1, delegation.getId());
            insertStatement.setString(2, delegation.getDN());
            insertStatement.setString(3, delegation.getFQAN());
            insertStatement.setString(4, delegation.getVO());
            insertStatement.setString(5, delegation.getLocalUser());
            insertStatement.setString(6, delegation.getLocalUserGroup());
            insertStatement.setString(7, delegation.getCertificate());
            insertStatement.setString(8, delegation.getInfo());
            if (!delegation.getVOMSAttributes().isEmpty()) {
                String vomsAttrsStr = "";
                for (String vomsAttribute : delegation.getVOMSAttributes()) {
                    vomsAttrsStr = vomsAttrsStr + "\t" + vomsAttribute;
                }
                insertStatement.setString(9, vomsAttrsStr);
            } else {
                insertStatement.setString(9, null);
            }
            if (delegation.getStartTime() != null) {
                insertStatement.setTimestamp(10, new Timestamp(delegation.getStartTime().getTime()));
            } else {
                insertStatement.setTimestamp(10, null);
            }
            if (delegation.getExpirationTime() != null) {
                insertStatement.setTimestamp(11, new Timestamp(delegation.getExpirationTime().getTime()));
            } else {
                insertStatement.setTimestamp(11, null);
            }
            if (delegation.getLastUpdateTime() != null) {
                insertStatement.setTimestamp(12, new Timestamp(delegation.getLastUpdateTime().getTime()));
            } else {
                insertStatement.setTimestamp(12, null);
            }
            insertStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on db interaction", (Throwable)sqle);
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            throw new DelegationException("Failure on db interaction: " + sqle.getMessage());
        }
        finally {
            if (insertStatement != null) {
                try {
                    insertStatement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)("END insertDelegation for delegationId=" + delegation.getId() + " dn=" + delegation.getDN() + " localUser=" + delegation.getLocalUser()));
    }

    public void insert(DelegationRequest delegationRequest) throws DelegationException, DelegationManagerException {
        if (delegationRequest == null) {
            throw new IllegalArgumentException("delegationRequest not specified!");
        }
        logger.debug((Object)("BEGIN insertDelegationRequest for delegationId=" + delegationRequest.getId() + " dn=" + delegationRequest.getDN()));
        StringBuffer query = new StringBuffer("insert into ");
        query.append(DELEGATION_REQUEST_TABLE).append(" (").append(ID_FIELD).append(", ");
        query.append(DN_FIELD).append(", ").append(VOMS_ATTRIBUTE_FIELD).append(", ");
        query.append(PUBLIC_KEY_FIELD).append(", ").append(PRIVATE_KEY_FIELD).append(", ");
        query.append(CERTIFICATE_REQUEST_FIELD).append(", ").append(LOCAL_USER_FIELD).append(", ");
        query.append(TIMESTAMP_FIELD).append(") values (?, ?, ?, ?, ?, ?, ?, ?)");
        PreparedStatement insertStatement = null;
        Connection connection = this.getConnection();
        try {
            insertStatement = connection.prepareStatement(query.toString());
            insertStatement.setString(1, delegationRequest.getId());
            insertStatement.setString(2, delegationRequest.getDN());
            insertStatement.setString(4, delegationRequest.getPublicKey());
            insertStatement.setString(5, delegationRequest.getPrivateKey());
            insertStatement.setString(6, delegationRequest.getCertificateRequest());
            insertStatement.setString(7, delegationRequest.getLocalUser());
            if (!delegationRequest.getVOMSAttributes().isEmpty()) {
                String vomsAttrsStr = "";
                for (String vomsAttribute : delegationRequest.getVOMSAttributes()) {
                    vomsAttrsStr = vomsAttrsStr + "\t" + vomsAttribute;
                }
                insertStatement.setString(3, vomsAttrsStr);
            } else {
                insertStatement.setString(3, null);
            }
            if (delegationRequest.getTimestamp() != null) {
                insertStatement.setTimestamp(8, new Timestamp(delegationRequest.getTimestamp().getTime()));
            } else {
                insertStatement.setTimestamp(8, new Timestamp(Calendar.getInstance().getTimeInMillis()));
            }
            insertStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on db interaction", (Throwable)sqle);
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            throw new DelegationManagerException("Failure on db interaction: " + sqle.getMessage());
        }
        finally {
            if (insertStatement != null) {
                try {
                    insertStatement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)("END insertDelegationRequest for delegationId=" + delegationRequest.getId() + " dn=" + delegationRequest.getDN()));
    }

    private Delegation makeDelegation(ResultSet rs) throws DelegationException {
        if (rs == null) {
            throw new DelegationException("rs new defined!");
        }
        try {
            Delegation delegation = new Delegation(rs.getString(ID_FIELD));
            delegation.setDN(rs.getString(DN_FIELD));
            delegation.setFQAN(rs.getString(FQAN_FIELD));
            delegation.setVO(rs.getString(VO_FIELD));
            delegation.setLocalUser(rs.getString(LOCAL_USER_FIELD));
            delegation.setLocalUserGroup(rs.getString(LOCAL_USER_GROUP_FIELD));
            delegation.setCertificate(rs.getString(CERTIFICATE_FIELD));
            delegation.setInfo(rs.getString(INFO_FIELD));
            delegation.setStartTime((Date)rs.getTimestamp(START_TIME_FIELD));
            delegation.setExpirationTime((Date)rs.getTimestamp(EXPIRATION_TIME_FIELD));
            delegation.setLastUpdateTime((Date)rs.getTimestamp(LAST_UPDATE_TIME_FIELD));
            String vomsAttr = rs.getString(VOMS_ATTRIBUTE_FIELD);
            if (vomsAttr != null) {
                StringTokenizer st = new StringTokenizer(vomsAttr, "\t");
                ArrayList<String> vomsAttributes = new ArrayList<String>(0);
                while (st.hasMoreTokens()) {
                    vomsAttributes.add(st.nextToken());
                }
                delegation.setVOMSAttributes(vomsAttributes);
            }
            return delegation;
        }
        catch (SQLException sqle) {
            logger.error((Object)"makeDelegation: failure on ResultSet: ", (Throwable)sqle);
            throw new DelegationException("Failure on ResultSet: " + sqle.getMessage());
        }
    }

    private DelegationRequest makeDelegationRequest(ResultSet rs) throws DelegationException {
        if (rs == null) {
            throw new DelegationException("rs new defined!");
        }
        try {
            DelegationRequest delegationRequest = new DelegationRequest(rs.getString(ID_FIELD));
            delegationRequest.setDN(rs.getString(DN_FIELD));
            delegationRequest.setLocalUser(rs.getString(LOCAL_USER_FIELD));
            delegationRequest.setPublicKey(rs.getString(PUBLIC_KEY_FIELD));
            delegationRequest.setPrivateKey(rs.getString(PRIVATE_KEY_FIELD));
            delegationRequest.setCertificateRequest(rs.getString(CERTIFICATE_REQUEST_FIELD));
            delegationRequest.setTimestamp((Date)rs.getTimestamp(TIMESTAMP_FIELD));
            String vomsAttr = rs.getString(VOMS_ATTRIBUTE_FIELD);
            if (vomsAttr != null) {
                StringTokenizer st = new StringTokenizer(rs.getString(VOMS_ATTRIBUTE_FIELD), "\t");
                ArrayList<String> vomsAttributes = new ArrayList<String>(0);
                while (st.hasMoreTokens()) {
                    vomsAttributes.add(st.nextToken());
                }
                delegationRequest.setVOMSAttributes(vomsAttributes);
            }
            return delegationRequest;
        }
        catch (SQLException sqle) {
            logger.error((Object)"makeDelegation: failure on ResultSet: ", (Throwable)sqle);
            throw new DelegationException("Failure on ResultSet: " + sqle.getMessage());
        }
    }

    public void terminate() {
        logger.info((Object)"terminate invoked!");
        DelegationPurger.getInstance().terminate();
        delegationManager = null;
        terminated = true;
        logger.info((Object)"terminated!");
    }

    public void update(Delegation delegation) throws DelegationException, DelegationManagerException {
        if (delegation == null) {
            throw new DelegationException("delegation not specified!");
        }
        logger.debug((Object)("BEGIN update " + delegation.toString()));
        delegation.setLastUpdateTime(Calendar.getInstance().getTime());
        StringBuffer query = new StringBuffer("update ");
        query.append(DELEGATION_TABLE).append(" set ").append(CERTIFICATE_FIELD).append(" = ?, ").append(INFO_FIELD).append(" = ?, ");
        query.append(VOMS_ATTRIBUTE_FIELD).append(" = ?, ").append(START_TIME_FIELD).append(" = ?, ");
        query.append(EXPIRATION_TIME_FIELD).append(" = ?, ").append(LAST_UPDATE_TIME_FIELD);
        query.append(" = ? where ").append(ID_FIELD).append(" = ? and ").append(DN_FIELD).append(" = ?");
        logger.info((Object)query.toString());
        Connection connection = this.getConnection();
        PreparedStatement updateStatement = null;
        try {
            updateStatement = connection.prepareStatement(query.toString());
            updateStatement.setString(1, delegation.getCertificate());
            updateStatement.setString(2, delegation.getInfo());
            updateStatement.setTimestamp(4, new Timestamp(delegation.getStartTime().getTime()));
            updateStatement.setTimestamp(5, new Timestamp(delegation.getExpirationTime().getTime()));
            updateStatement.setTimestamp(6, new Timestamp(delegation.getLastUpdateTime().getTime()));
            updateStatement.setString(7, delegation.getId());
            updateStatement.setString(8, delegation.getDN());
            if (!delegation.getVOMSAttributes().isEmpty()) {
                String vomsAttrsStr = "";
                for (String vomsAttribute : delegation.getVOMSAttributes()) {
                    vomsAttrsStr = vomsAttrsStr + "\t" + vomsAttribute;
                }
                updateStatement.setString(3, vomsAttrsStr);
            } else {
                updateStatement.setString(3, null);
            }
            updateStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on db interaction", (Throwable)sqle);
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            throw new DelegationException("Failure on db interaction: " + sqle.getMessage());
        }
        finally {
            if (updateStatement != null) {
                try {
                    updateStatement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)("END update " + delegation.toString()));
    }

    public void update(DelegationRequest delegationRequest) throws DelegationException, DelegationManagerException {
        if (delegationRequest == null) {
            throw new DelegationException("delegationRequest not specified!");
        }
        logger.debug((Object)("BEGIN updateDelegationRequest for delegationId=" + delegationRequest.getId() + " dn=" + delegationRequest.getDN() + " localUser=" + delegationRequest.getLocalUser()));
        StringBuffer query = new StringBuffer("update ");
        query.append(DELEGATION_REQUEST_TABLE).append(" set ").append(CERTIFICATE_REQUEST_FIELD).append(" = ?, ");
        query.append(PUBLIC_KEY_FIELD).append(" = ?, ").append(PRIVATE_KEY_FIELD).append(" = ?, ");
        query.append(VOMS_ATTRIBUTE_FIELD).append(" = ?, ");
        query.append(TIMESTAMP_FIELD).append(" = ? where ").append(ID_FIELD).append(" = ? and ").append(DN_FIELD).append(" = ?");
        Connection connection = this.getConnection();
        PreparedStatement updateStatement = null;
        try {
            updateStatement = connection.prepareStatement(query.toString());
            updateStatement.setString(1, delegationRequest.getCertificateRequest());
            updateStatement.setString(2, delegationRequest.getPublicKey());
            updateStatement.setString(3, delegationRequest.getPrivateKey());
            updateStatement.setString(5, delegationRequest.getId());
            updateStatement.setString(6, delegationRequest.getDN());
            updateStatement.setTimestamp(7, new Timestamp(delegationRequest.getTimestamp().getTime()));
            if (!delegationRequest.getVOMSAttributes().isEmpty()) {
                String vomsAttrsStr = "";
                for (String vomsAttribute : delegationRequest.getVOMSAttributes()) {
                    vomsAttrsStr = vomsAttrsStr + "\t" + vomsAttribute;
                }
                updateStatement.setString(4, vomsAttrsStr);
            } else {
                updateStatement.setString(4, null);
            }
            updateStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failure on db interaction", (Throwable)sqle);
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            throw new DelegationException("Failure on db interaction: " + sqle.getMessage());
        }
        finally {
            if (updateStatement != null) {
                try {
                    updateStatement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.debug((Object)("END updateDelegationRequest for delegationId=" + delegationRequest.getId() + " dn=" + delegationRequest.getDN() + " localUser=" + delegationRequest.getLocalUser()));
    }
}

