/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.configuration.xppm;

import java.io.File;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.glite.ce.commonj.configuration.xppm.ConfigurationManager;
import org.glite.ce.cream.configuration.CommandExecutorConfig;
import org.glite.ce.creamapi.cmdmanagement.Parameter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommandExecutorConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)CommandExecutorConfigHandler.class.getName());
    private static final String XPATH_STRING = "/service/commandexecutor";
    private static final String ID_ATTR = "id";
    private static final String CATEGORY_ATTR = "category";
    private static final String JARNAME_ATTR = "filename";
    private static final String POOL_SIZE_ATTR = "commandworkerpoolsize";
    private static final String QUEUE_SIZE_ATTR = "commandqueuesize";
    private static final String QUEUE_SHARED_ATTR = "commandqueueshared";
    private static final String PARAMETER_TAG = "parameter";
    private static final String PARA_NAME_ATTR = "name";
    private static final String PARA_VALUE_ATTR = "value";
    private static final String POLICY_TAG = "policy";
    private XPathExpression expr;
    private HashMap<String, CommandExecutorConfig> currentMap;
    private HashMap<String, CommandExecutorConfig> tmpMap;

    public CommandExecutorConfigHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
        this.currentMap = null;
        this.tmpMap = null;
    }

    public XPathExpression getXPath() {
        return this.expr;
    }

    public Class<?> getCategory() {
        return CommandExecutorConfig.class;
    }

    public Object[] getConfigurationElement() {
        if (this.currentMap == null) {
            return null;
        }
        Object[] result = new Object[this.currentMap.size()];
        int k = 0;
        for (CommandExecutorConfig item : this.currentMap.values()) {
            result[k] = item;
            ++k;
        }
        return result;
    }

    public boolean process(NodeList parsedElements) throws CommonConfigException {
        this.tmpMap = new HashMap();
        for (int k = 0; k < parsedElements.getLength(); ++k) {
            String queueSharedStr;
            String queueSizeStr;
            Element cmdElem = (Element)parsedElements.item(k);
            CommandExecutorConfig cmdConf = new CommandExecutorConfig();
            String id = cmdElem.getAttribute(ID_ATTR);
            cmdConf.setName(id);
            logger.debug((Object)("Parsing attributes for : " + id));
            cmdConf.setCategory(cmdElem.getAttribute(CATEGORY_ATTR));
            cmdConf.setJarFileName(cmdElem.getAttribute(JARNAME_ATTR));
            String poolSizeStr = cmdElem.getAttribute(POOL_SIZE_ATTR);
            if (poolSizeStr != "") {
                cmdConf.setCommandWorkerPoolSize(Integer.parseInt(poolSizeStr));
            }
            if ((queueSizeStr = cmdElem.getAttribute(QUEUE_SIZE_ATTR)) != "") {
                cmdConf.setCommandQueueSize(Integer.parseInt(queueSizeStr));
            }
            if ((queueSharedStr = cmdElem.getAttribute(QUEUE_SHARED_ATTR)).equalsIgnoreCase("true")) {
                cmdConf.setCommandQueueShared(true);
            }
            NodeList paraElemList = cmdElem.getElementsByTagName(PARAMETER_TAG);
            for (int j = 0; j < paraElemList.getLength(); ++j) {
                Element paraElement = (Element)paraElemList.item(j);
                String paraName = paraElement.getAttribute(PARA_NAME_ATTR);
                String paraValue = paraElement.getAttribute(PARA_VALUE_ATTR);
                if (paraName == "") continue;
                cmdConf.addParameter(new Parameter(paraName, (Object)paraValue));
                logger.debug((Object)("Parameter " + id + "[" + paraName + "] = " + paraValue));
            }
            this.tmpMap.put(id, cmdConf);
        }
        return !this.tmpMap.equals(this.currentMap);
    }

    public boolean processTriggers() throws CommonConfigException {
        return false;
    }

    public void commit() {
        this.currentMap = this.tmpMap;
        this.tmpMap = null;
    }

    public void rollback() {
        this.tmpMap = null;
    }

    public File[] getTriggers() {
        return null;
    }

    public void clean() {
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"/tmp/log4j.properties");
        try {
            ConfigurationManager cMan = new ConfigurationManager(args[0]);
            Object[] tmpArray = cMan.getConfigurationElements(CommandExecutorConfig.class);
            if (tmpArray == null) {
                logger.debug((Object)"Missing array");
                return;
            }
            logger.info((Object)("Found executors: " + tmpArray.length));
            for (Object obj : tmpArray) {
                CommandExecutorConfig item = (CommandExecutorConfig)obj;
                logger.debug((Object)("Found " + item.getName()));
                for (Parameter param : item.getParameters()) {
                    logger.debug((Object)("Parameter " + item.getName() + "[" + param.getName() + "] = " + param.getValue()));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

