/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.configuration;

import java.util.ArrayList;
import java.util.List;
import org.glite.ce.commonj.configuration.CEConfigResource;
import org.glite.ce.creamapi.cmdmanagement.Parameter;
import org.glite.ce.creamapi.cmdmanagement.Policy;

public class CommandExecutorConfig
implements CEConfigResource {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String category;
    protected String jarFileName;
    protected int commandWorkerPoolSize = 50;
    protected int commandQueueSize = 500;
    protected boolean isCommandQueueShared = false;
    protected List<Parameter> parameters = new ArrayList<Parameter>(0);
    protected List<Policy> policies = new ArrayList<Policy>(0);

    public void addParameter(Parameter parameter) {
        if (parameter == null) {
            return;
        }
        this.parameters.add(parameter);
    }

    public void addPolicy(Policy policy) {
        if (policy == null) {
            return;
        }
        this.policies.add(policy);
    }

    public Object clone() {
        CommandExecutorConfig result = new CommandExecutorConfig();
        result.setName(this.name);
        result.setCategory(this.category);
        result.setJarFileName(this.jarFileName);
        result.setCommandWorkerPoolSize(this.commandWorkerPoolSize);
        result.setCommandQueueSize(this.commandQueueSize);
        result.setCommandQueueShared(this.isCommandQueueShared);
        for (Parameter parameter : this.parameters) {
            result.addParameter(new Parameter(parameter.getName(), parameter.getValue()));
        }
        for (Policy policy : this.policies) {
            result.addPolicy(new Policy(policy.getName(), policy.getType(), policy.getValue(), policy.getTimeValue(), policy.getTimeUnit()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommandExecutorConfig) {
            return false;
        }
        CommandExecutorConfig cmdExConf = (CommandExecutorConfig)obj;
        return this.name.equals(cmdExConf.name) && this.category.equals(cmdExConf.category) && this.jarFileName.equals(cmdExConf.jarFileName) && this.commandWorkerPoolSize == cmdExConf.commandWorkerPoolSize && this.commandQueueSize == cmdExConf.commandQueueSize && !(this.isCommandQueueShared ^ cmdExConf.isCommandQueueShared) && ((Object)this.parameters).equals(cmdExConf.parameters) && ((Object)this.policies).equals(cmdExConf.policies);
    }

    public String getCategory() {
        return this.category;
    }

    public int getCommandQueueSize() {
        return this.commandQueueSize;
    }

    public int getCommandWorkerPollSize() {
        return this.commandWorkerPoolSize;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Policy> getPolicies() {
        return this.policies;
    }

    public boolean isCommandQueueShared() {
        return this.isCommandQueueShared;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setCommandQueueShared(boolean isShared) {
        this.isCommandQueueShared = isShared;
    }

    public void setCommandQueueSize(int size) {
        this.commandQueueSize = size;
    }

    public void setCommandWorkerPoolSize(int commandWorkerPollSize) {
        this.commandWorkerPoolSize = commandWorkerPollSize;
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters.clear();
        this.parameters.addAll(parameters);
    }

    public void setPolicies(List<Policy> policies) {
        this.policies.clear();
        this.policies.addAll(policies);
    }
}

