/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.cmdmanagement;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.utils.JarClassLoader;
import org.glite.ce.cream.configuration.CommandExecutorConfig;
import org.glite.ce.cream.configuration.ServiceConfig;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.cmdmanagement.CommandException;
import org.glite.ce.creamapi.cmdmanagement.CommandExecutorException;
import org.glite.ce.creamapi.cmdmanagement.CommandExecutorInterface;
import org.glite.ce.creamapi.cmdmanagement.CommandManagerException;
import org.glite.ce.creamapi.cmdmanagement.CommandManagerInterface;
import org.glite.ce.creamapi.cmdmanagement.queue.CommandQueueInterface;

public class CommandManager
extends Thread
implements CommandManagerInterface {
    private static final Logger logger = Logger.getLogger((String)CommandManager.class.getName());
    private static final int EVALUATION_RATE = 600000;
    private static final int INITIALIZATION_TBD = 0;
    private static final int INITIALIZATION_OK = 1;
    private static final int INITIALIZATION_ERROR = 2;
    private static int initialization = 0;
    private static boolean exit = false;
    private static CommandManager commandManager = null;
    private final Object lock = new Object();
    private final AtomicLong maxThroughput = new AtomicLong(0L);
    private final AtomicLong currentThroughput = new AtomicLong(0L);
    private final AtomicLong commandsCount = new AtomicLong(0L);
    private Calendar lastThroughputUpdate = null;
    private Hashtable<String, Hashtable<String, CommandExecutorInterface>> commandExecutorCategory;

    public static CommandManager getInstance() throws CommandManagerException {
        if (exit) {
            throw new CommandManagerException("CommandExecutor already terminated!");
        }
        if (initialization == 2) {
            throw new CommandManagerException("CommandManager configuration failed!");
        }
        if (commandManager == null) {
            commandManager = new CommandManager();
        }
        return commandManager;
    }

    private CommandManager() throws CommandManagerException {
        super("CommandManager");
        this.init();
        this.start();
    }

    public void addCommandExecutor(CommandExecutorConfig commandExecutorConfig) throws CommandManagerException {
        if (commandExecutorConfig == null) {
            throw new CommandManagerException("CommandExecutorConfig not specified!");
        }
        Hashtable<String, CommandExecutorInterface> executorTable = this.commandExecutorCategory.get(commandExecutorConfig.getCategory());
        if (executorTable != null && executorTable.containsKey(commandExecutorConfig.getName())) {
            logger.debug((Object)("CommandExecutor \"" + commandExecutorConfig.getName() + "\" already exists"));
            throw new CommandManagerException("CommandExecutor \"" + commandExecutorConfig.getName() + "\" already exists");
        }
        String jarFilePath = null;
        Class theClass = null;
        Object obj = null;
        try {
            jarFilePath = commandExecutorConfig.getJarFileName();
            logger.info((Object)("initializing a new CommandExecutor [name=" + commandExecutorConfig.getName() + "; category=" + commandExecutorConfig.getCategory() + "; JarFileName=" + commandExecutorConfig.getJarFileName() + "]"));
            File jarFile = new File(jarFilePath);
            try {
                if (!jarFile.getName().endsWith(".jar")) {
                    throw new RuntimeException("Cannot create a CommandExecutor instance from file \"" + jarFile.getAbsolutePath() + "\"");
                }
                URL commandExecutorURL = jarFile.toURI().toURL();
                JarClassLoader loader = new JarClassLoader("file:" + jarFile.getPath(), this.getClass().getClassLoader());
                loader.addJarURL(commandExecutorURL);
                String className = loader.getMainClassName(commandExecutorURL);
                if (className == null) {
                    throw new CommandManagerException("\"Main-Class\" attribute not found into the MANIFEST.MF of " + jarFile.getAbsolutePath() + ".jar");
                }
                theClass = loader.loadClass(className);
            }
            catch (Exception e) {
                throw new CommandManagerException("Cannot create the CommandExecutor class from file " + jarFile.getName() + ". Reason: " + jarFilePath + " " + e.getMessage());
            }
            if (theClass == null) {
                throw new RuntimeException("Cannot create the CommandExecutor class from path " + jarFilePath);
            }
            obj = theClass.newInstance();
            if (obj instanceof CommandExecutorInterface) {
                CommandExecutorInterface commandExecutor = obj;
                commandExecutor.addParameter(commandExecutorConfig.getParameters());
                commandExecutor.setCommandWorkerPoolSize(commandExecutorConfig.getCommandWorkerPollSize());
                commandExecutor.setCommandQueueSize(commandExecutorConfig.getCommandQueueSize());
                commandExecutor.setCommandQueueShared(commandExecutorConfig.isCommandQueueShared());
                logger.info((Object)("New CommandExecutor found! [name=" + commandExecutorConfig.getName() + "; category=" + commandExecutorConfig.getCategory() + "; commandWorkerPoolSize=" + commandExecutorConfig.getCommandWorkerPollSize() + "; commandQueueSize=" + commandExecutorConfig.getCommandQueueSize() + "; commandQueueShared=" + commandExecutorConfig.isCommandQueueShared() + "; parameterSize=" + commandExecutorConfig.getParameters().size() + "]"));
                this.addCommandExecutor(commandExecutor);
            }
        }
        catch (CommandManagerException e) {
            logger.error((Object)("initialization error: " + e.getMessage()));
            throw e;
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("initialization error: " + e.getMessage()));
            throw new CommandManagerException(e.getMessage());
        }
        catch (InstantiationException e) {
            logger.error((Object)("initialization error: cannot make an instance of " + jarFilePath + " commandExecutor! reason " + e.getMessage()));
            throw new CommandManagerException("initialization error: cannot make an instance of " + jarFilePath + " commandExecutor! reason " + e.getMessage());
        }
    }

    public void addCommandExecutor(CommandExecutorInterface commandExecutor) throws CommandManagerException {
        if (commandExecutor == null) {
            throw new CommandManagerException("CommandExecutor not specified!");
        }
        Hashtable<String, Object> executorTable = this.commandExecutorCategory.get(commandExecutor.getCategory());
        if (executorTable == null) {
            executorTable = new Hashtable(0);
            this.commandExecutorCategory.put(commandExecutor.getCategory(), executorTable);
        }
        if (executorTable.containsKey(commandExecutor.getName())) {
            logger.debug((Object)("CommandExecutor \"" + commandExecutor.getName() + "\" already exists"));
            throw new CommandManagerException("CommandExecutor \"" + commandExecutor.getName() + "\" already exists");
        }
        try {
            commandExecutor.setCommandManager((CommandManagerInterface)this);
            commandExecutor.initExecutor();
            commandExecutor.start();
            executorTable.put(commandExecutor.getName(), commandExecutor);
            logger.debug((Object)("New CommandExecutor \"" + commandExecutor.getName() + "\" added"));
        }
        catch (CommandExecutorException e) {
            logger.error((Object)("CommandExecutor \"" + commandExecutor.getName() + "\" initialization failed: " + e.getMessage()));
            throw new CommandManagerException("CommandExecutor \"" + commandExecutor.getName() + "\" initialization failed: " + e.getMessage());
        }
    }

    public void addCommandExecutor(List<CommandExecutorInterface> commandExecList) throws CommandManagerException {
        if (commandExecList == null) {
            throw new CommandManagerException("CommandExecutorInterface list not specified!");
        }
        for (CommandExecutorInterface commandExecutor : commandExecList) {
            this.addCommandExecutor(commandExecutor);
        }
    }

    public boolean checkCommandExecutor(String name, String category) {
        if (name == null) {
            return false;
        }
        if (category == null) {
            return false;
        }
        Hashtable<String, CommandExecutorInterface> executorTable = this.commandExecutorCategory.get(category);
        return executorTable != null && executorTable.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(Command command) throws CommandException, CommandManagerException {
        CommandManager.logger.debug((Object)"BEGIN execute");
        if (command == null) {
            throw new CommandException("command not specified!");
        }
        var2_2 = this.lastThroughputUpdate;
        synchronized (var2_2) {
            this.commandsCount.incrementAndGet();
        }
        if (command.getCategory() == null) {
            throw new CommandException("command category not defined!");
        }
        executorTable = this.commandExecutorCategory.get(command.getCategory());
        if (executorTable == null) {
            throw new CommandException("command category \"" + command.getCategory() + "\" not found!");
        }
        executor = null;
        if (command.getCommandExecutorName() == null) {
            commandExecutor = executorTable.values();
            list = new ArrayList<CommandExecutorInterface>(commandExecutor);
            index = 0;
            while (executor == null && index < list.size()) {
                executor = list.get(index++);
            }
            if (executor == null) {
                throw new CommandManagerException("none right executor can handle the command \"" + command.getName() + "\"");
            }
            command.setCommandExecutorName(executor.getName());
        } else {
            CommandManager.logger.debug((Object)("command.getCommandExecutorName() = " + command.getCommandExecutorName()));
            executor = executorTable.get(command.getCommandExecutorName());
            if (executor == null) {
                throw new CommandManagerException("CommandExecutor \"" + command.getCommandExecutorName() + "\" not found!");
            }
        }
        CommandManager.logger.debug((Object)("the \"" + executor.getName() + "\" executor selected for the execution of the command \"" + command.getName() + "\""));
        if (command.isInternal()) {
            CommandManager.logger.debug((Object)("new command [" + command.toString() + "]"));
        } else {
            CommandManager.logger.info((Object)("new command [" + command.toString() + "]"));
        }
        if (!executor.checkCommandSupport(command.getName())) {
            command.setFailureReason("command not supported by the \"" + executor.getName() + "\" executor!");
            command.setStatus(7);
            CommandManager.logger.info((Object)("new command [" + command.toString() + "]"));
            throw new CommandException("command \"" + command.getName() + "\" not supported by the \"" + executor.getName() + "\" executor!");
        }
        if (command.isAsynchronous()) {
            try {
                executor.getCommandQueue().enqueue(command);
                command.setStatus(1);
                if (!CommandManager.logger.isDebugEnabled()) ** GOTO lbl75
                CommandManager.logger.debug((Object)("status change for command [" + command.toString() + "]"));
            }
            catch (Throwable e) {
                CommandManager.logger.error((Object)("cannot enqueue the command " + command.getName() + ": " + e.getMessage()));
                command.setFailureReason(e.getMessage());
                command.setStatus(7);
                CommandManager.logger.info((Object)("status change for command [" + command.toString() + "]"));
                throw new CommandException("cannot enqueue the command " + command.getName() + ": " + e.getMessage());
            }
        } else {
            try {
                command.setId(Calendar.getInstance().getTimeInMillis());
                command.setStatus(2);
                if (CommandManager.logger.isDebugEnabled()) {
                    CommandManager.logger.debug((Object)("status change for command [" + command.toString() + "]"));
                }
                command.setStatus(4);
                if (CommandManager.logger.isDebugEnabled()) {
                    CommandManager.logger.debug((Object)("status change for command [" + command.toString() + "]"));
                }
                executor.execute(command);
                command.setStatus(5);
                if (CommandManager.logger.isDebugEnabled()) {
                    CommandManager.logger.debug((Object)("status change for command [" + command.toString() + "]"));
                }
            }
            catch (Exception e) {
                CommandManager.logger.error((Object)("CommandManager execute: " + command.getName() + " error " + e.getMessage()));
                command.setFailureReason(e.getMessage());
                command.setStatus(6);
                CommandManager.logger.info((Object)("status change for command [" + command.toString() + "]"));
                throw new CommandException(e.getMessage());
            }
        }
lbl75:
        // 3 sources

        CommandManager.logger.debug((Object)"END execute");
    }

    public void execute(List<Command> commandList) throws CommandException, CommandManagerException {
        if (commandList == null) {
            throw new CommandException("Command list not specified!");
        }
        for (Command command : commandList) {
            this.execute(command);
        }
    }

    public List<String> getCommandCategory() {
        ArrayList<String> categoryList = new ArrayList<String>(0);
        if (!this.commandExecutorCategory.isEmpty()) {
            categoryList.addAll(this.commandExecutorCategory.keySet());
        }
        return categoryList;
    }

    public CommandExecutorInterface getCommandExecutor(String name, String category) throws CommandManagerException {
        if (name == null) {
            throw new CommandManagerException("name not specified!");
        }
        if (category != null) {
            if (this.commandExecutorCategory.containsKey(category)) {
                Hashtable<String, CommandExecutorInterface> commandExecutortable = this.commandExecutorCategory.get(category);
                if (commandExecutortable.containsKey(name)) {
                    return commandExecutortable.get(name);
                }
                throw new CommandManagerException("CommandExecutor \"" + name + "\" not found!");
            }
            throw new CommandManagerException("Category \"" + category + "\" not found!");
        }
        for (Hashtable<String, CommandExecutorInterface> commandExecutortable : this.commandExecutorCategory.values()) {
            if (!commandExecutortable.containsKey(name)) continue;
            return commandExecutortable.get(name);
        }
        throw new CommandManagerException("CommandExecutor \"" + name + "\" not found!");
    }

    public List<CommandExecutorInterface> getCommandExecutors() {
        ArrayList<CommandExecutorInterface> commandExecutorList = new ArrayList<CommandExecutorInterface>(0);
        if (!this.commandExecutorCategory.isEmpty()) {
            for (Hashtable<String, CommandExecutorInterface> commandExecutortable : this.commandExecutorCategory.values()) {
                commandExecutorList.addAll(commandExecutortable.values());
            }
        }
        return commandExecutorList;
    }

    public long getCurrentThroughput() {
        return this.currentThroughput.get();
    }

    public Calendar getLastThroughputUpdate() {
        return this.lastThroughputUpdate;
    }

    public long getMaxThroughput() {
        return this.maxThroughput.get();
    }

    public void init() throws CommandManagerException {
        this.commandExecutorCategory = new Hashtable(0);
        this.lastThroughputUpdate = Calendar.getInstance();
        if (initialization == 1) {
            return;
        }
        ServiceConfig service = ServiceConfig.getConfiguration();
        if (service == null) {
            initialization = 2;
            throw new CommandManagerException("Cannot get instance of the Configuration Service");
        }
        List<CommandExecutorConfig> commandExecutorList = service.getCommandExecutorList();
        if (commandExecutorList == null || commandExecutorList.size() == 0) {
            initialization = 1;
            return;
        }
        try {
            for (CommandExecutorConfig commandExecutorConfig : commandExecutorList) {
                this.addCommandExecutor(commandExecutorConfig);
            }
        }
        catch (CommandManagerException e) {
            initialization = 2;
            this.terminate();
            logger.error((Object)("initialization error: " + e.getMessage()));
            throw e;
        }
        initialization = 1;
    }

    public void removeCommandExecutor(CommandExecutorInterface commandExecutor) throws CommandManagerException {
        if (commandExecutor == null) {
            throw new CommandManagerException("CommandExecutor not specified!");
        }
        this.removeCommandExecutor(commandExecutor.getName(), commandExecutor.getCategory());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeCommandExecutor(String name, String category) throws CommandManagerException {
        if (category == null) {
            throw new CommandManagerException("CommandExecutor's category not specified!");
        }
        if (name == null) {
            throw new CommandManagerException("CommandExecutor's name not specified!");
        }
        if (!this.commandExecutorCategory.containsKey(category)) throw new CommandManagerException("Category \"" + category + "\" not found!");
        Hashtable<String, CommandExecutorInterface> executorTable = this.commandExecutorCategory.get(category);
        CommandExecutorInterface commandExecutor = executorTable.remove(name);
        if (commandExecutor == null) throw new CommandManagerException("CommandExecutor \"" + name + "\" not found!");
        try {
            commandExecutor.destroy();
        }
        catch (CommandExecutorException e) {
            logger.error((Object)("failure on destroying the CommandExecutor \"" + name + "\""));
            throw new CommandManagerException("failure on destroying the CommandExecutor \"" + name + "\"");
        }
        logger.debug((Object)("CommandExecutorInterface \"" + name + "\" removed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long maxThroughputTmp = 0L;
        long currentThroughputTmp = 0L;
        long elapsedTimeInMillis = 0L;
        Calendar now = null;
        StringBuffer buff = null;
        while (!exit) {
            logger.debug((Object)"evaluating the throughput...");
            now = Calendar.getInstance();
            buff = new StringBuffer("throughput evaluated:\n");
            elapsedTimeInMillis = now.getTimeInMillis() - this.lastThroughputUpdate.getTimeInMillis();
            if (!this.commandExecutorCategory.isEmpty()) {
                Collection<Hashtable<String, CommandExecutorInterface>> executorCategoryList = this.commandExecutorCategory.values();
                Collection<CommandExecutorInterface> executorList = null;
                CommandQueueInterface queue = null;
                for (Hashtable<String, CommandExecutorInterface> executorCategory : executorCategoryList) {
                    executorList = executorCategory.values();
                    for (CommandExecutorInterface executor : executorList) {
                        queue = executor.getCommandQueue();
                        if (queue == null) continue;
                        try {
                            queue.evalutateThroughput();
                            buff.append("[queue=" + queue.getName() + "; currentInThroughput=" + queue.getCurrentInThroughput() + " cmd/min; maxInThroughput=" + queue.getMaxInThroughput() + " cmd/min; currentOutThroughput=" + queue.getCurrentOutThroughput() + " cmd/min; maxOutThroughput=" + queue.getMaxOutThroughput() + " cmd/min]\n");
                        }
                        catch (Throwable t) {
                            logger.error((Object)("failure on evalutating the throughput of the " + executor.getName() + "'s queue: " + t.getMessage()), t);
                        }
                    }
                }
            }
            Object object = this.lastThroughputUpdate;
            synchronized (object) {
                this.lastThroughputUpdate.setTime(now.getTime());
                maxThroughputTmp = this.maxThroughput.get();
                currentThroughputTmp = 0L;
                if (this.commandsCount.get() > 0L) {
                    currentThroughputTmp = this.commandsCount.get() * 60000L / elapsedTimeInMillis;
                }
                this.currentThroughput.set(currentThroughputTmp);
                if (maxThroughputTmp < currentThroughputTmp) {
                    maxThroughputTmp = currentThroughputTmp;
                    this.maxThroughput.set(maxThroughputTmp);
                }
                this.commandsCount.set(0L);
            }
            buff.append("[CommandManager currentThroughput=" + currentThroughputTmp + " cmd/min; maxThroughput=" + maxThroughputTmp + " cmd/min]");
            logger.info((Object)buff.toString());
            logger.debug((Object)"evaluating the throughput... done!");
            object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(600000L);
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        logger.info((Object)"terminate invoked!");
        exit = true;
        if (!this.commandExecutorCategory.isEmpty()) {
            Collection<Hashtable<String, CommandExecutorInterface>> executorCategoryList = this.commandExecutorCategory.values();
            Collection<CommandExecutorInterface> executorList = null;
            for (Hashtable<String, CommandExecutorInterface> executorCategory : executorCategoryList) {
                executorList = executorCategory.values();
                for (CommandExecutorInterface executor : executorList) {
                    try {
                        logger.info((Object)("terminating the " + executor.getName() + " executor"));
                        executor.destroy();
                        logger.info((Object)(executor.getName() + " executor termitated!"));
                    }
                    catch (Throwable t) {
                        logger.error((Object)("failure on terminating the CommandExecutor \": " + executor.getName() + "\": " + t.getMessage()), t);
                    }
                }
            }
        }
        this.commandExecutorCategory.clear();
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        commandManager = null;
        logger.info((Object)"terminated!");
    }
}

