/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.authz.argus;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.glite.ce.commonj.authz.AuthorizationException;
import org.glite.ce.commonj.authz.argus.ActionMappingInterface;

public class ActionMapping
implements ActionMappingInterface {
    private static final String CREAM_NS = "http://glite.org/2007/11/ce/cream";
    private static final String ES_NS = "http://www.eu-emi.eu/es/2010/12";
    private static final String DELEGATION_2_NS = "http://www.gridsite.org/namespaces/delegation-2";
    public static final String XACML_PREFIX = "http://glite.org/xacml/";
    public static final String ID_ATTRIBUTE_JOB_ADMIN = "http://glite.org/xacml/obligation/local-role/administrator";
    public static final String[] mandProperties = new String[]{"local.user.id", "local.group.id"};

    public String getXACMLAction(QName operation) {
        String opName = operation.getLocalPart();
        String opNS = operation.getNamespaceURI();
        if (opNS.startsWith(CREAM_NS)) {
            if (opName.equals("JobRegister") || opName.equals("JobStart") || opName.equals("JobSetLeaseId")) {
                return "http://glite.org/xacml/action/ce/job/submit";
            }
            if (opName.equals("JobCancel") || opName.equals("JobPurge")) {
                return "http://glite.org/xacml/action/ce/job/terminate";
            }
            if (opName.equals("JobInfo") || opName.equals("JobStatus") || opName.equals("JobList") || opName.equals("QueryEvent")) {
                return "http://glite.org/xacml/action/ce/job/get-info";
            }
            if (opName.equals("JobSuspend") || opName.equals("JobResume")) {
                return "http://glite.org/xacml/action/ce/job/manage";
            }
            if (opName.equals("getLease") || opName.equals("getLeaseList")) {
                return "http://glite.org/xacml/action/ce/lease/get-info";
            }
            if (opName.equals("setLease") || opName.equals("deleteLease")) {
                return "http://glite.org/xacml/action/ce/lease/manage";
            }
            if (opName.equals("getServiceInfo") || opName.equals("getVersion") || opName.equals("getInterfaceVersion") || opName.equals("getServiceMetadata")) {
                return "http://glite.org/xacml/action/ce/get-info";
            }
        } else if (opNS.equals(DELEGATION_2_NS)) {
            if (opName.equals("getTerminationTime")) {
                return "http://glite.org/xacml/action/ce/delegation/get-info";
            }
            if (opName.equals("getProxyReq") || opName.equals("getNewProxyReq") || opName.equals("putProxy") || opName.equals("renewProxyReq") || opName.equals("destroy")) {
                return "http://glite.org/xacml/action/ce/delegation/manage";
            }
        } else if (opNS.startsWith(ES_NS)) {
            if (opName.equals("CreateActivity")) {
                return "http://glite.org/xacml/action/ce/job/submit";
            }
            if (opName.equals("ListActivities") || opName.equals("GetActivityStatus") || opName.equals("GetActivityInfo")) {
                return "http://glite.org/xacml/action/ce/job/get-info";
            }
            if (opName.equals("CancelActivity") || opName.equals("WipeActivity")) {
                return "http://glite.org/xacml/action/ce/job/terminate";
            }
            if (opName.equals("PauseActivity") || opName.equals("ResumeActivity") || opName.equals("RestartActivity") || opName.equals("NotifyService")) {
                return "http://glite.org/xacml/action/ce/job/manage";
            }
            if (opName.equals("InitDelegation") || opName.equals("PutDelegation")) {
                return "http://glite.org/xacml/action/ce/delegation/manage";
            }
            if (opName.equals("GetDelegationInfo")) {
                return "http://glite.org/xacml/action/ce/delegation/get-info";
            }
            if (opName.equals("GetResourceInfo") || opName.equals("QueryResourceInfo")) {
                return "http://glite.org/xacml/action/ce/get-info";
            }
        }
        return null;
    }

    public String getAttributeMapping(String obId, String attrId) {
        if ("http://glite.org/xacml/obligation/local-environment-map/posix".equals(obId)) {
            if ("http://glite.org/xacml/attribute/user-id".equals(attrId)) {
                return "local.user.id";
            }
            if ("http://glite.org/xacml/attribute/group-id/primary".equals(attrId)) {
                return "local.group.id";
            }
        }
        if (ID_ATTRIBUTE_JOB_ADMIN.equals(obId)) {
            return "job.admin.role";
        }
        return null;
    }

    public String[] getMandatoryProperties() {
        return mandProperties;
    }

    public void checkMandatoryProperties(Iterator<String> props) throws AuthorizationException {
        boolean missingUser = true;
        boolean missingGroup = true;
        while (props.hasNext()) {
            String prop = props.next();
            if (prop.equals("local.user.id")) {
                missingUser = false;
                continue;
            }
            if (!prop.equals("local.group.id")) continue;
            missingGroup = false;
        }
        if (missingUser) {
            throw new AuthorizationException("Cannot map grid user onto a local account");
        }
        if (missingGroup) {
            throw new AuthorizationException("Cannot map grid user onto a local group");
        }
    }
}

