/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.delegationmanagement.cmdexecutor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.encoders.Hex;
import org.glite.ce.commonj.db.DatasourceManager;
import org.glite.ce.cream.configuration.ServiceConfig;
import org.glite.ce.cream.delegationmanagement.DelegationManager;
import org.glite.ce.cream.delegationmanagement.DelegationPurger;
import org.glite.ce.creamapi.cmdmanagement.AbstractCommandExecutor;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.cmdmanagement.CommandException;
import org.glite.ce.creamapi.cmdmanagement.CommandExecutorException;
import org.glite.ce.creamapi.delegationmanagement.Delegation;
import org.glite.ce.creamapi.delegationmanagement.DelegationRequest;
import org.glite.ce.creamapi.jobmanagement.db.DBInfoManager;
import org.glite.security.delegation.GrDPX509Util;
import org.glite.security.util.CertUtil;
import org.glite.security.util.FileCertReader;
import org.glite.security.util.PrivateKeyReader;
import org.glite.voms.PKIStore;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACValidator;
import org.glite.voms.ac.VOMSTrustStore;

public class DelegationExecutor
extends AbstractCommandExecutor {
    private static final Logger logger = Logger.getLogger((String)DelegationExecutor.class.getName());
    private static final Random delegationIdGenerator = new Random();
    private static String delegationSuffix = null;
    private static MessageDigest sDigester = null;
    private boolean initialized = false;
    private int keySize = 2048;
    private ACValidator acValidator;
    private VOMSTrustStore vomsStore = null;
    private static FileCertReader s_reader = null;
    public static final String DELEGATION_PURGE_RATE = "DELEGATION_PURGE_RATE";
    public static final String CREAM_SANDBOX_DIR = "CREAM_SANDBOX_DIR";
    public static final String CREAM_COPY_PROXY_TO_SANDBOX_BIN_PATH = "CREAM_COPY_PROXY_TO_SANDBOX_BIN_PATH";
    public static final String CREAM_PURGE_PROXY_FROM_SANDBOX_BIN_PATH = "CREAM_PURGE_PROXY_FROM_SANDBOX_BIN_PATH";

    public DelegationExecutor() throws CommandExecutorException {
        super("DelegationExecutor", "DELEGATION_MANAGEMENT");
        try {
            s_reader = new FileCertReader();
        }
        catch (CertificateException e3) {
            logger.error((Object)("Failed to initialize certificate reader: " + e3.getMessage()));
            throw new RuntimeException("Failed to initialize certificate reader: " + e3.getMessage());
        }
        ArrayList<String> commands = new ArrayList<String>(9);
        commands.add("DESTROY_DELEGATION");
        commands.add("GET_DATABASE_VERSION");
        commands.add("GET_DELEGATION");
        commands.add("GET_NEW_DELEGATION_REQUEST");
        commands.add("GET_DELEGATION_REQUEST");
        commands.add("GET_SERVICE_MEDATADA");
        commands.add("GET_TERMINATION_TIME");
        commands.add("PUT_DELEGATION");
        commands.add("RENEW_DELEGATION_REQUEST");
        this.setCommands(commands);
        this.addParameter(CREAM_SANDBOX_DIR, "/var/cream_sandbox");
        this.addParameter(CREAM_COPY_PROXY_TO_SANDBOX_BIN_PATH, "/usr/bin/glite-cream-copyProxyToSandboxDir.sh");
        this.addParameter(CREAM_PURGE_PROXY_FROM_SANDBOX_BIN_PATH, "/usr/bin/glite-ce-cream-purge-proxy");
        this.addParameter(DELEGATION_PURGE_RATE, "720");
        this.dataSourceName = "datasource_delegationdb";
    }

    private String createAndStoreCertificateRequest(X509Certificate parentCert, String delegationId, String dn, String localUser, List<VOMSAttribute> vomsAttributes) throws CommandException {
        logger.debug((Object)"BEGIN createAndStoreCertificateRequest");
        KeyPair keyPair = GrDPX509Util.getKeyPair((int)this.keySize);
        String privateKey = PrivateKeyReader.getPEM((PrivateKey)keyPair.getPrivate());
        logger.debug((Object)"KeyPair generation was successfull.");
        logger.debug((Object)("Public key is: " + keyPair.getPublic()));
        String certificateRequest = null;
        try {
            String sigAlgo = parentCert.getSigAlgName();
            logger.debug((Object)("Signature algorithm to be used for pkcs10: " + sigAlgo));
            certificateRequest = GrDPX509Util.createCertificateRequest((X509Certificate)parentCert, (String)sigAlgo, (KeyPair)keyPair);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException("Error while generating the certificate request [delegId=" + delegationId + "; dn=" + dn + "; localUser=" + localUser + "]: " + e.getMessage());
        }
        logger.debug((Object)"Certificate request generation was successfull.");
        String reqId = null;
        try {
            reqId = delegationId + '+' + GrDPX509Util.generateSessionID((PublicKey)keyPair.getPublic());
            logger.debug((Object)("DelegationRequestId (delegationId + sessionId): " + reqId));
        }
        catch (GeneralSecurityException e) {
            throw new CommandException("Error while generating the sessionId [delegId=" + delegationId + "; dn=" + dn + "; localUser=" + localUser + "]: " + e.getMessage());
        }
        ArrayList vomsAttributeList = new ArrayList(0);
        for (VOMSAttribute vomsAttr : vomsAttributes) {
            vomsAttributeList.addAll(vomsAttr.getFullyQualifiedAttributes());
        }
        DelegationRequest delegationRequest = null;
        try {
            boolean found = true;
            delegationRequest = DelegationManager.getInstance().getDelegationRequest(reqId, dn, localUser);
            if (delegationRequest == null) {
                delegationRequest = new DelegationRequest(reqId);
                found = false;
            }
            delegationRequest.setDN(dn);
            delegationRequest.setVOMSAttributes(vomsAttributeList);
            delegationRequest.setCertificateRequest(certificateRequest);
            delegationRequest.setPublicKey(keyPair.getPublic().toString());
            delegationRequest.setPrivateKey(privateKey);
            delegationRequest.setLocalUser(localUser);
            if (found) {
                DelegationManager.getInstance().update(delegationRequest);
            } else {
                DelegationManager.getInstance().insert(delegationRequest);
            }
        }
        catch (Exception e) {
            throw new CommandException("Failure on storage interaction [delegId=" + delegationId + "; dn=" + dn + "; localUser=" + localUser + "]: " + e.getMessage());
        }
        logger.debug((Object)"END createAndStoreCertificateRequest");
        return certificateRequest;
    }

    public void destroy() {
        logger.info((Object)"destroy invoked!");
        super.destroy();
        try {
            DelegationManager.getInstance().terminate();
        }
        catch (Throwable t) {
            logger.error((Object)("cannot get instance of DelegationManager: " + t.getMessage()));
        }
        if (this.vomsStore != null) {
            this.vomsStore.stopRefresh();
        }
        logger.info((Object)"destroyed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void destroyDelegation(Command command) throws CommandException {
        logger.debug((Object)"BEGIN destroy");
        Delegation delegation = this.getDelegation(command);
        if (delegation == null) {
            throw new CommandException("delegation [delegId=" + this.getParameterValueAsString(command, "DELEGATION_ID") + "; dn=" + this.getParameterValueAsString(command, "USER_DN_RFC2253") + "; localUser=" + this.getParameterValueAsString(command, "LOCAL_USER") + "] not found!");
        }
        String delegationId = delegation.getId();
        String dn = delegation.getDN();
        String userId = delegation.getUserId();
        String localUser = delegation.getLocalUser();
        String localUserGroup = delegation.getLocalUserGroup();
        logger.debug((Object)("removing the delegation from sandbox " + delegation.toString()));
        Process proc = null;
        String[] cmd = new String[]{"sudo", "-S", "-n", "-u", localUser, this.getParameterValueAsString(CREAM_PURGE_PROXY_FROM_SANDBOX_BIN_PATH), delegation.getFullPath()};
        try {
            proc = Runtime.getRuntime().exec(cmd);
            logger.debug((Object)("removed the delegation from sandbox " + delegation.toString()));
        }
        catch (Throwable e) {
            if (proc != null) {
                proc.destroy();
            }
        }
        finally {
            block67: {
                StringBuffer errorMessage;
                block68: {
                    block69: {
                        if (proc == null) break block67;
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException ioe) {
                            throw new CommandException(ioe.getMessage());
                        }
                        errorMessage = null;
                        if (proc.exitValue() == 0) break block68;
                        BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        errorMessage = new StringBuffer();
                        String inputLine = null;
                        while ((inputLine = readErr.readLine()) != null) {
                            errorMessage.append(inputLine);
                        }
                        try {
                            readErr.close();
                        }
                        catch (IOException e) {}
                        break block69;
                        catch (IOException ioe) {
                            try {
                                logger.error((Object)ioe.getMessage());
                            }
                            catch (Throwable throwable) {
                                try {
                                    readErr.close();
                                }
                                catch (IOException e) {}
                                throw throwable;
                            }
                            try {
                                readErr.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (errorMessage.length() > 0) {
                        errorMessage.append("\n");
                    }
                }
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ioe) {}
                if (errorMessage != null && errorMessage.length() > 0) {
                    logger.warn((Object)("failure on removing the delegation " + delegation.toString() + " from sandbox: " + errorMessage.toString()));
                }
            }
        }
        try {
            DelegationManager.getInstance().delete(delegation);
        }
        catch (Exception e) {
            throw new CommandException("Failure on deleting the delegation " + delegation.toString() + ": " + e.getMessage());
        }
        logger.debug((Object)"END destroy");
    }

    public void execute(Command command) throws CommandExecutorException, CommandException {
        logger.debug((Object)"BEGIN execute");
        if (!this.initialized) {
            throw new CommandExecutorException(this.getName() + " not initialized!");
        }
        if (command == null) {
            throw new IllegalArgumentException("command not defined!");
        }
        if (!command.getCategory().equalsIgnoreCase(this.getCategory())) {
            throw new CommandException("command category mismatch: found \"" + command.getCategory() + "\" required \"" + this.getCategory() + "\"");
        }
        if (command.containsParameterKey("USER_DN_RFC2253")) {
            command.addParameter("USER_DN_RFC2253", (Serializable)((Object)this.normalize(command.getParameterAsString("USER_DN_RFC2253"))));
        }
        try {
            if (command.getName().equalsIgnoreCase("DESTROY_DELEGATION")) {
                this.destroyDelegation(command);
            } else if (command.getName().equalsIgnoreCase("PUT_DELEGATION")) {
                this.putDelegation(command);
            } else if (command.getName().equalsIgnoreCase("GET_DELEGATION")) {
                Delegation delegation = this.getDelegation(command);
                if (delegation == null) {
                    throw new CommandException("delegation [delegId=" + this.getParameterValueAsString(command, "DELEGATION_ID") + "; dn=" + this.getParameterValueAsString(command, "USER_DN_RFC2253") + "; localUser=" + this.getParameterValueAsString(command, "LOCAL_USER") + "] not found!");
                }
            } else if (command.getName().equalsIgnoreCase("GET_DELEGATION_REQUEST")) {
                this.getDelegationRequest(command);
            } else if (command.getName().equalsIgnoreCase("GET_NEW_DELEGATION_REQUEST")) {
                this.getNewDelegationRequest(command);
            } else if (command.getName().equalsIgnoreCase("RENEW_DELEGATION_REQUEST")) {
                this.renewDelegationRequest(command);
            } else if (command.getName().equalsIgnoreCase("GET_TERMINATION_TIME")) {
                this.getTerminationTime(command);
            } else if (command.getName().equalsIgnoreCase("GET_DATABASE_VERSION")) {
                this.getDatabaseVersion(command);
            } else if (!command.getName().equalsIgnoreCase("GET_SERVICE_MEDATADA")) {
                logger.error((Object)("command \"" + command.getName() + "\" not found!"));
                throw new CommandExecutorException("command \"" + command.getName() + "\" not found!");
            }
        }
        catch (CommandException ex) {
            logger.error((Object)("Execution of the command \"" + command.getName() + "\" failed: " + ex.getMessage()));
            throw ex;
        }
        logger.debug((Object)"END execute");
    }

    public void execute(List<Command> commandList) throws CommandExecutorException, CommandException {
        if (commandList == null) {
            return;
        }
        for (Command command : commandList) {
            this.execute(command);
        }
    }

    private String getDatabaseVersion(Command command) throws CommandException {
        logger.debug((Object)"BEGIN getDatabaseVersion");
        String version = "N/A";
        try {
            version = DBInfoManager.getDBVersion((String)this.dataSourceName);
        }
        catch (Exception e) {
            throw new CommandException("Failure on storage interaction: " + e.getMessage());
        }
        command.getResult().addParameter("DATABASE_VERSION", (Object)version);
        logger.debug((Object)"END getDatabaseVersion");
        return version;
    }

    private Delegation getDelegation(Command command) throws CommandException {
        logger.debug((Object)"BEGIN getDelegation");
        String delegationId = this.getParameterValueAsString(command, "DELEGATION_ID");
        String userDN = this.getParameterValueAsString(command, "USER_DN_RFC2253");
        String localUser = this.getParameterValueAsString(command, "LOCAL_USER");
        Delegation delegation = null;
        try {
            delegation = DelegationManager.getInstance().getDelegation(delegationId, userDN, localUser);
        }
        catch (Exception e) {
            throw new CommandException("Failure on storage interaction [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: " + e.getMessage());
        }
        if (delegation != null) {
            delegation.setFileName(this.makeDelegationFileName(delegationId));
            delegation.setPath(this.makeDelegationPath(delegation));
            command.getResult().addParameter("DELEGATION", (Object)delegation);
        }
        logger.debug((Object)"END getDelegation");
        return delegation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNewDelegationRequest(Command command) throws CommandException {
        Object vomsAttr2;
        String userDN;
        logger.debug((Object)"BEGIN getNewDelegationRequest");
        String originalString = userDN = this.getParameterValueAsString(command, "USER_DN_RFC2253");
        List vomsAttributes = (List)this.getParameterValue(command, "VOMS_ATTRIBUTES");
        for (Object vomsAttr2 : vomsAttributes) {
            for (String attr : vomsAttr2.getFullyQualifiedAttributes()) {
                originalString = originalString + attr;
            }
        }
        byte[] hashDigest = null;
        vomsAttr2 = sDigester;
        synchronized (vomsAttr2) {
            hashDigest = sDigester.digest(originalString.getBytes());
        }
        byte[] resultDigest = new byte[20];
        for (int i = 0; i < 20; ++i) {
            resultDigest[i] = hashDigest[i];
        }
        GregorianCalendar now = new GregorianCalendar();
        command.addParameter("DELEGATION_ID", (Serializable)((Object)(new String(Hex.encode((byte[])resultDigest)) + now.getTimeInMillis())));
        this.getDelegationRequest(command);
        logger.debug((Object)"END getNewDelegationRequest");
    }

    private Object getParameterValue(Command command, String key) throws CommandException {
        if (command == null) {
            throw new CommandException("command not specified!");
        }
        if (key == null) {
            throw new CommandException("paramenter key not specified!");
        }
        Object value = command.getParameter(key);
        if (value == null) {
            throw new CommandException("parameter \"" + key + "\" not specified!");
        }
        return value;
    }

    private String getParameterValueAsString(Command command, String key) throws CommandException {
        if (command == null) {
            throw new CommandException("command not specified!");
        }
        if (key == null) {
            throw new CommandException("paramenter key not specified!");
        }
        Object value = command.getParameter(key);
        if (value == null) {
            throw new CommandException("parameter \"" + key + "\" not specified!");
        }
        if (!(value instanceof String)) {
            throw new CommandException("the value of the parameter \"" + key + "\" is not an instance of the String type!");
        }
        return (String)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDelegationRequest(Command command) throws CommandException {
        logger.debug((Object)"BEGIN getDelegationRequest");
        Delegation delegation = null;
        String delegationId = null;
        if (command.containsParameterKey("DELEGATION_ID")) {
            delegationId = command.getParameterAsString("DELEGATION_ID");
            delegation = this.getDelegation(command);
            if (delegation != null) {
                throw new CommandException("delegation [delegId=" + delegation.getId() + "; dn=" + delegation.getDN() + "; localUser=" + delegation.getLocalUser() + "] already exists! please invoke renewDelegationReq()");
            }
        } else {
            delegationId = "";
            Random random = delegationIdGenerator;
            synchronized (random) {
                delegationId = delegationId + delegationIdGenerator.nextDouble();
                delegationId = delegationId.substring(2);
            }
        }
        String userDN = this.getParameterValueAsString(command, "USER_DN_RFC2253");
        String localUser = this.getParameterValueAsString(command, "LOCAL_USER");
        X509Certificate userCertificate = (X509Certificate)this.getParameterValue(command, "USER_CERTIFICATE");
        List vomsAttributes = (List)this.getParameterValue(command, "VOMS_ATTRIBUTES");
        String certificateRequest = this.createAndStoreCertificateRequest(userCertificate, delegationId, userDN, localUser, vomsAttributes);
        command.getResult().addParameter("CERTIFICATE_REQUEST", (Object)certificateRequest);
        command.getResult().addParameter("DELEGATION_ID", (Object)delegationId);
        logger.debug((Object)"END getDelegationRequest");
        return certificateRequest;
    }

    private Calendar getTerminationTime(Command command) throws CommandException {
        logger.debug((Object)"BEGIN getTerminationTime");
        Delegation delegation = this.getDelegation(command);
        if (delegation == null) {
            throw new CommandException("delegation [delegId=" + this.getParameterValueAsString(command, "DELEGATION_ID") + "; dn=" + this.getParameterValueAsString(command, "USER_DN_RFC2253") + "; localUser=" + this.getParameterValueAsString(command, "LOCAL_USER") + "] not found!");
        }
        Calendar time = Calendar.getInstance();
        time.setTime(delegation.getExpirationTime());
        command.getResult().addParameter("TERMINATION_TIME", (Object)time);
        logger.debug((Object)"END getTerminationTime");
        return time;
    }

    public void initExecutor() throws CommandExecutorException {
        logger.debug((Object)"BEGIN initExecutor");
        if (!this.initialized) {
            logger.info((Object)("initalizing the " + this.getName() + " executor..."));
            ServiceConfig serviceConfig = ServiceConfig.getConfiguration();
            if (serviceConfig == null) {
                throw new CommandExecutorException("Configuration error: cannot initialize the ServiceConfig");
            }
            HashMap dataSources = serviceConfig.getDataSources();
            if (dataSources == null) {
                throw new CommandExecutorException("Datasource is empty!");
            }
            if (dataSources.containsKey(this.dataSourceName)) {
                if (DatasourceManager.addDataSource((String)this.dataSourceName, (DataSource)((DataSource)dataSources.get(this.dataSourceName)))) {
                    logger.info((Object)("new dataSource \"" + this.dataSourceName + "\" added to the DatasourceManager"));
                } else {
                    logger.info((Object)("the dataSource \"" + this.dataSourceName + "\" already exist!"));
                }
            } else {
                throw new CommandExecutorException("Datasource \"" + this.dataSourceName + "\" not found!");
            }
            try {
                this.vomsStore = new PKIStore(PKIStore.DEFAULT_VOMSDIR, 1, true);
                VOMSValidator.setTrustStore((VOMSTrustStore)this.vomsStore);
                this.acValidator = ACValidator.getInstance((VOMSTrustStore)this.vomsStore);
                logger.info((Object)"VOMS store initialized");
            }
            catch (Exception ex) {
                throw new CommandExecutorException("Cannot configure VOMS support");
            }
            try {
                DelegationManager.getInstance();
            }
            catch (Throwable t) {
                throw new CommandExecutorException("initialization error: cannot get instance of DelegationManager: " + t.getMessage());
            }
            try {
                sDigester = MessageDigest.getInstance("SHA-1");
            }
            catch (Throwable t) {
                throw new CommandExecutorException("initialization error: message digester implementation not found: " + t.getMessage());
            }
            try {
                delegationSuffix = DelegationManager.getInstance().getDelegationSuffix();
            }
            catch (Throwable t) {
                throw new CommandExecutorException("cannot get instance of DelegationManager: " + t.getMessage());
            }
            if (delegationSuffix == null || delegationSuffix.equals("")) {
                throw new CommandExecutorException("delegationSuffix not defined!");
            }
            logger.info((Object)("delegationSuffix = " + delegationSuffix));
            if (!this.containsParameterKey(CREAM_SANDBOX_DIR)) {
                throw new CommandExecutorException("parameter CREAM_SANDBOX_DIR not defined!");
            }
            if (!this.containsParameterKey(CREAM_COPY_PROXY_TO_SANDBOX_BIN_PATH)) {
                throw new CommandExecutorException("parameter CREAM_COPY_PROXY_TO_SANDBOX_BIN_PATH not defined!");
            }
            if (!this.containsParameterKey(CREAM_PURGE_PROXY_FROM_SANDBOX_BIN_PATH)) {
                throw new CommandExecutorException("parameter CREAM_PURGE_PROXY_FROM_SANDBOX_BIN_PATH not defined!");
            }
            if (this.containsParameterKey(DELEGATION_PURGE_RATE)) {
                int purgeRateInMinutes = 720;
                try {
                    purgeRateInMinutes = Integer.parseInt(this.getParameterValueAsString(DELEGATION_PURGE_RATE));
                    DelegationPurger.getInstance().setRate(purgeRateInMinutes);
                    logger.debug((Object)("found new value for DELEGATION_PURGE_RATE: " + purgeRateInMinutes + " min."));
                }
                catch (Throwable t) {
                    logger.warn((Object)("Configuration warning: wrong value for DELEGATION_PURGE_RATE parameter => using default " + purgeRateInMinutes));
                }
            }
            this.initialized = true;
            logger.info((Object)(this.getName() + " executor initialized!"));
        }
        logger.debug((Object)"END initExecutor");
    }

    private String makeDelegationFileName(String delegationId) throws CommandException {
        if (delegationId == null) {
            throw new CommandException("delegationId not specified!");
        }
        return this.normalize(delegationId + "_" + delegationSuffix);
    }

    private String makeDelegationPath(Delegation delegation) throws CommandException {
        if (delegation == null) {
            throw new CommandException("delegation not specified!");
        }
        String cream_sandbox_dir = this.getParameterValueAsString(CREAM_SANDBOX_DIR);
        if (cream_sandbox_dir == null) {
            throw new CommandException("parameter CREAM_SANDBOX_DIR not defined!");
        }
        return cream_sandbox_dir + File.separator + delegation.getLocalUserGroup() + File.separator + delegation.getUserId() + "_" + delegation.getLocalUser() + File.separator + "proxy" + File.separator;
    }

    private String normalize(String s) {
        if (s != null) {
            return s.replaceAll("\\W", "_");
        }
        return null;
    }

    private void putDelegation(Command command) throws CommandException {
        List fqanList;
        PKCS10CertificationRequest req;
        String clientDN;
        logger.debug((Object)"BEGIN putDelegation");
        String delegationId = this.getParameterValueAsString(command, "DELEGATION_ID");
        String deleg = this.getParameterValueAsString(command, "DELEGATION");
        String userDN = this.getParameterValueAsString(command, "USER_DN_RFC2253");
        String localUser = this.getParameterValueAsString(command, "LOCAL_USER");
        String localUserGroup = this.getParameterValueAsString(command, "LOCAL_USER_GROUP");
        X509Certificate[] certChain = null;
        try {
            certChain = s_reader.readCertChain(new BufferedInputStream(new ByteArrayInputStream(deleg.getBytes()))).toArray(new X509Certificate[0]);
        }
        catch (IOException ex) {
            throw new CommandException("Failed to load certificate chain [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: " + ex.getMessage());
        }
        if (certChain == null || certChain.length == 0) {
            throw new CommandException("Failed to load certificate chain [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: chain was null or size 0.");
        }
        logger.debug((Object)"Given proxy certificate loaded successfully.");
        Set<String> criticalSet = null;
        boolean isRFCproxy = false;
        for (int i = 0; i < certChain.length; ++i) {
            try {
                certChain[i].checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new CommandException("Validation failed [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: it expired on " + certChain[i].getNotAfter());
            }
            catch (CertificateNotYetValidException e) {
                throw new CommandException("Validation failed [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: it will be valid from " + certChain[i].getNotBefore());
            }
            if (isRFCproxy) continue;
            criticalSet = certChain[i].getCriticalExtensionOIDs();
            isRFCproxy = criticalSet != null && criticalSet.contains("1.3.6.1.5.5.7.1.14");
        }
        criticalSet = null;
        String subjectDN = certChain[0].getIssuerX500Principal().getName();
        String issuerDN = certChain[0].getSubjectX500Principal().getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("subject DN: " + subjectDN));
            logger.debug((Object)("issuer DN: " + issuerDN));
            logger.debug((Object)("chain length is: " + certChain.length));
            logger.debug((Object)("last cert is:" + certChain[certChain.length - 1]));
            for (int n = 0; n < certChain.length; ++n) {
                logger.debug((Object)("cert [" + n + "] is from " + certChain[n].getSubjectX500Principal().getName()));
            }
        }
        if (subjectDN == null || issuerDN == null) {
            throw new CommandException("Failed to get DN (subject or issuer) out of delegation [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: it came null");
        }
        try {
            clientDN = CertUtil.getUserDN((X509Certificate[])certChain).getRFCDN();
        }
        catch (IOException ex) {
            throw new CommandException("No user certificate found in the delegation chain [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: " + ex.getMessage());
        }
        if (clientDN == null) {
            throw new CommandException("Failed to get client DN [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: it came null");
        }
        if (!issuerDN.endsWith(clientDN)) {
            throw new CommandException("Client '" + clientDN + "' is not issuer of the delegation '" + issuerDN + "' [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]");
        }
        String reqId = delegationId;
        try {
            reqId = delegationId + '+' + GrDPX509Util.generateSessionID((PublicKey)certChain[0].getPublicKey());
            logger.debug((Object)("reqId (delegationId + sessionId): " + reqId));
        }
        catch (GeneralSecurityException e) {
            throw new CommandException("Failed to generate the session ID [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: " + e.getMessage());
        }
        DelegationRequest delegationRequest = null;
        try {
            delegationRequest = DelegationManager.getInstance().getDelegationRequest(reqId, userDN, localUser);
        }
        catch (Exception e) {
            throw new CommandException("Failure on storage interaction [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: " + e.getMessage());
        }
        if (delegationRequest == null) {
            throw new CommandException("Delegation request not found! [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]");
        }
        logger.debug((Object)("Got delegation request from cache [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]"));
        PEMReader pemReader = new PEMReader((Reader)new StringReader(delegationRequest.getCertificateRequest()));
        try {
            req = (PKCS10CertificationRequest)pemReader.readObject();
        }
        catch (IOException e1) {
            throw new CommandException("Could not load the original certificate request from cache [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: " + e1.getMessage());
        }
        if (req == null) {
            throw new CommandException("Could not load the original certificate request from cache [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]");
        }
        PublicKey publicKey = null;
        try {
            publicKey = req.getPublicKey();
        }
        catch (Exception e) {
            throw new CommandException("cannot get the public key [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: " + e.getMessage());
        }
        if (!publicKey.equals(certChain[0].getPublicKey())) {
            logger.error((Object)("The delegation and the original request's public key do not match [delegation public key: '" + certChain[0].getPublicKey() + "'; request public key: '" + publicKey + "']"));
            throw new CommandException("The delegation and the original request's public key do not match [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]");
        }
        String completeProxy = null;
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)certChain[0]);
            pemWriter.flush();
            writer.write(delegationRequest.getPrivateKey());
            writer.flush();
            for (int i = 1; i < certChain.length; ++i) {
                pemWriter.writeObject((Object)certChain[i]);
            }
            pemWriter.flush();
            completeProxy = writer.toString();
            pemWriter.close();
        }
        catch (IOException e) {
            throw new CommandException("Could not properly process given delegation [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: " + e.getMessage());
        }
        if (completeProxy == null) {
            throw new CommandException("Could not properly process given delegation [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        FieldPosition fp = new FieldPosition(1);
        StringBuffer buff = new StringBuffer("[ isRFC=\"");
        buff.append(isRFCproxy);
        buff.append("\"; valid from=\"");
        dateFormat.format(certChain[0].getNotBefore(), buff, fp);
        buff.append(" (GMT)\"; valid to=\"");
        dateFormat.format(certChain[0].getNotAfter(), buff, fp);
        buff.append(" (GMT)\"; holder DN=\"").append(clientDN);
        buff.append("\"; holder AC issuer=\"").append(issuerDN);
        HashMap<String, List> proxyVOAttrs = new HashMap<String, List>(0);
        ArrayList<String> vomsAttrituteList = new ArrayList<String>(0);
        VOMSValidator mainValidator = new VOMSValidator(certChain, this.acValidator);
        mainValidator.validate();
        for (VOMSAttribute vomsAttr : mainValidator.getVOMSAttributes()) {
            buff.append("\"; VO=\"").append(vomsAttr.getVO());
            buff.append("\"; AC issuer=\"").append(vomsAttr.getIssuer());
            buff.append("\"; VOMS attributes={ ");
            for (String attr : vomsAttr.getFullyQualifiedAttributes()) {
                buff.append(attr).append(", ");
                vomsAttrituteList.add(attr);
            }
            buff.replace(buff.length() - 2, buff.length() - 1, " }");
            proxyVOAttrs.put(vomsAttr.getVO(), vomsAttr.getFullyQualifiedAttributes());
        }
        buff.append("]");
        Delegation delegation = null;
        try {
            delegation = DelegationManager.getInstance().getDelegation(delegationId, userDN, localUser);
        }
        catch (Exception e) {
            throw new CommandException("Failure on storage interaction [delegId=" + delegationId + "; dn=" + userDN + "; localUser=" + localUser + "]: " + e.getMessage());
        }
        boolean found = true;
        if (delegation == null) {
            delegation = new Delegation(delegationId);
            found = false;
        }
        if (!proxyVOAttrs.values().isEmpty() && (fqanList = (List)proxyVOAttrs.values().iterator().next()) != null && fqanList.size() > 0) {
            delegation.setFQAN(((String)fqanList.get(0)).toString());
        }
        if (!proxyVOAttrs.keySet().isEmpty()) {
            delegation.setVO((String)proxyVOAttrs.keySet().iterator().next());
        }
        if (!vomsAttrituteList.isEmpty()) {
            delegation.setVOMSAttributes(vomsAttrituteList);
        }
        delegation.setRFC(isRFCproxy);
        delegation.setDN(userDN);
        delegation.setCertificate(completeProxy);
        delegation.setStartTime(certChain[0].getNotBefore());
        delegation.setExpirationTime(certChain[0].getNotAfter());
        delegation.setLastUpdateTime(Calendar.getInstance().getTime());
        delegation.setLocalUser(localUser);
        delegation.setLocalUserGroup(localUserGroup);
        delegation.setInfo(buff.toString());
        delegation.setFileName(this.makeDelegationFileName(delegationId));
        delegation.setPath(this.makeDelegationPath(delegation));
        try {
            this.storeLimitedDelegationProxy(delegation);
            logger.info((Object)("New delegation created " + delegation.toString()));
        }
        catch (CommandException e) {
            logger.error((Object)("Cannot store the limited delegation locally " + delegation.toString() + ": " + e.getMessage()));
            throw e;
        }
        try {
            if (found) {
                DelegationManager.getInstance().update(delegation);
            } else {
                DelegationManager.getInstance().insert(delegation);
            }
        }
        catch (Throwable t) {
            throw new CommandException("Failure on storage interaction " + delegation.toString() + ": " + t.getMessage());
        }
        logger.debug((Object)"Delegation finished successfully.");
        try {
            DelegationManager.getInstance().delete(delegationRequest);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to remove credential from storage " + delegation.toString() + ": " + e.getMessage()));
        }
        command.getResult().addParameter("DELEGATION", (Object)delegation);
        logger.debug((Object)"END putDelegation");
    }

    private String renewDelegationRequest(Command command) throws CommandException {
        logger.debug((Object)"BEGIN renewDelegationRequest");
        Delegation delegation = this.getDelegation(command);
        if (delegation == null) {
            throw new CommandException("delegation [delegId=" + this.getParameterValueAsString(command, "DELEGATION_ID") + "; dn=" + this.getParameterValueAsString(command, "USER_DN_RFC2253") + "; localUser=" + this.getParameterValueAsString(command, "LOCAL_USER") + "] not found!");
        }
        X509Certificate userCertificate = (X509Certificate)this.getParameterValue(command, "USER_CERTIFICATE");
        List vomsAttributes = (List)this.getParameterValue(command, "VOMS_ATTRIBUTES");
        String certificateRequest = this.createAndStoreCertificateRequest(userCertificate, delegation.getId(), delegation.getDN(), delegation.getLocalUser(), vomsAttributes);
        command.getResult().addParameter("CERTIFICATE_REQUEST", (Object)certificateRequest);
        command.getResult().addParameter("DELEGATION_ID", (Object)delegation.getId());
        logger.debug((Object)"END renewDelegationRequest");
        return certificateRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String storeLimitedDelegationProxy(Delegation delegation) throws CommandException {
        block64: {
            logger.debug((Object)("BEGIN storeLimitedDelegationProxy " + delegation.toString()));
            String[] cmd = new String[]{"sudo", "-S", "-n", "-u", delegation.getLocalUser(), this.getParameterValueAsString(CREAM_COPY_PROXY_TO_SANDBOX_BIN_PATH), delegation.getFileName(), delegation.getPath(), delegation.isRFC() ? "1" : "0"};
            Process proc = null;
            BufferedOutputStream os = null;
            try {
                proc = Runtime.getRuntime().exec(cmd);
                os = new BufferedOutputStream(proc.getOutputStream());
                os.write(delegation.getCertificate().getBytes());
                os.flush();
                os.close();
                os = null;
            }
            catch (IOException e) {
                logger.error((Object)("IOException caught: " + e.getMessage()));
                if (proc != null) {
                    proc.destroy();
                }
                throw new CommandException(e.getMessage());
            }
            catch (Throwable e) {
                if (proc != null) {
                    proc.destroy();
                }
            }
            finally {
                StringBuffer errorMessage;
                block65: {
                    block66: {
                        if (proc == null) break block64;
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException ioe) {
                            throw new CommandException(ioe.getMessage());
                        }
                        errorMessage = null;
                        if (proc.exitValue() == 0) break block65;
                        logger.error((Object)"proc.exitValue() != 0");
                        BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        errorMessage = new StringBuffer();
                        String inputLine = null;
                        while ((inputLine = readErr.readLine()) != null) {
                            errorMessage.append(inputLine);
                        }
                        try {
                            readErr.close();
                        }
                        catch (IOException e) {}
                        break block66;
                        catch (IOException ioe) {
                            try {
                                logger.error((Object)ioe.getMessage());
                            }
                            catch (Throwable throwable) {
                                try {
                                    readErr.close();
                                }
                                catch (IOException e) {}
                                throw throwable;
                            }
                            try {
                                readErr.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (errorMessage.length() > 0) {
                        errorMessage.append("\n");
                    }
                }
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ioe) {}
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ioe) {}
                if (errorMessage == null || errorMessage.length() <= 0) break block64;
                throw new CommandException("storeLimitedDelegationProxy error " + delegation.toString() + ": " + errorMessage);
            }
        }
        logger.debug((Object)("END storeLimitedDelegationProxy " + delegation.toString()));
        return delegation.getFullPath();
    }
}

