/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.blahmanagement;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.glite.ce.cream.blahmanagement.BLAHCommand;
import org.glite.ce.cream.blahmanagement.BLAHException;

public class BLAHProcess
extends ThreadLocal<Process> {
    private static final Logger logger = Logger.getLogger((String)BLAHProcess.class.getName());
    private static final int DELAY = 1000;
    private static final String commandResultAsString = new BLAHCommand("RESULTS").toString();
    private Runtime rt = Runtime.getRuntime();
    private String executablePath = null;
    private String scratchDirPath = null;
    private int commandTimeout = 300000;
    private boolean asynchronousMode = false;
    private List<BLAHCommand> pendingCommandList;

    protected BLAHProcess(String executablePath, String scratchDirPath, int commandTimeout) {
        this.executablePath = executablePath;
        this.scratchDirPath = scratchDirPath;
        this.commandTimeout = commandTimeout;
    }

    @Override
    protected Process initialValue() {
        return this.makeBLAHProcess();
    }

    private Process makeBLAHProcess() {
        try {
            HashMap<String, String> envMap = new HashMap<String, String>(System.getenv());
            envMap.put("TERM", "vanilla");
            String[] env = new String[envMap.size()];
            int index = 0;
            for (String key : envMap.keySet()) {
                env[index++] = key.concat("=").concat((String)envMap.get(key));
            }
            Process proc = this.rt.exec(this.executablePath, env, new File(this.scratchDirPath));
            BufferedReader readIn = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            readIn.readLine();
            logger.debug((Object)"makeBLAHProcess: made a new blah process");
            return proc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void killBLAHProcess() {
        Process proc = (Process)super.get();
        if (proc == null) {
            return;
        }
        try {
            proc.getInputStream().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            proc.getOutputStream().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            proc.getErrorStream().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            proc.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug((Object)"killBLAHProcess: blah process killed");
    }

    public void execute(List<BLAHCommand> commandList) throws BLAHException {
        if (commandList == null) {
            throw new BLAHException("command not specified!");
        }
        String blahOutput = null;
        Process proc = (Process)super.get();
        BufferedReader readIn = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        BufferedWriter writeOut = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream()));
        for (BLAHCommand command : commandList) {
            if (command == null) continue;
            logger.debug((Object)command.toString());
            if (this.commandTimeout != -1) {
                Calendar timeout = Calendar.getInstance();
                timeout.add(13, this.commandTimeout);
                command.setTimeout(timeout);
            }
            try {
                String cmdString = command.toString();
                writeOut.write(cmdString);
                writeOut.flush();
                if ("ASYNC_MODE_ON".equals(command.getName())) {
                    this.asynchronousMode = true;
                    if (this.pendingCommandList == null) {
                        this.pendingCommandList = new ArrayList<BLAHCommand>(0);
                    }
                } else if ("ASYNC_MODE_OFF".equals(command.getName())) {
                    this.asynchronousMode = false;
                    if (this.pendingCommandList != null) {
                        this.pendingCommandList.clear();
                        this.pendingCommandList = null;
                    }
                } else if ("QUIT".equals(command.getName())) {
                    logger.debug((Object)"quit");
                    break;
                }
                if (readErr.ready()) {
                    logger.warn((Object)(Calendar.getInstance().getTime() + " - BLAH stderr: " + this.getOutput(readErr, command)));
                }
                if ((blahOutput = this.getOutput(readIn, command)).startsWith("E")) {
                    command.setException(new BLAHException("blah error: " + blahOutput.replaceAll("\\\\", "")));
                    continue;
                }
                if (blahOutput.startsWith("F")) {
                    command.setException(new BLAHException("unknown error occurred!"));
                    continue;
                }
                if (!blahOutput.equalsIgnoreCase("S") || command.getReqId() == null) continue;
                if (this.asynchronousMode) {
                    this.pendingCommandList.add(command);
                    continue;
                }
                boolean done = false;
                while (!done) {
                    writeOut.write(commandResultAsString);
                    writeOut.flush();
                    if (readErr.ready()) {
                        logger.warn((Object)("BLAH stderr: " + this.getOutput(readErr, command)));
                    }
                    if ((blahOutput = this.getOutput(readIn, command)) == null) {
                        this.wait(1000);
                        continue;
                    }
                    int size = this.getResultSize(blahOutput);
                    if (size <= 0) continue;
                    for (int i = 0; i < this.getResultSize(blahOutput); ++i) {
                        blahOutput = this.getOutput(readIn, command);
                        this.parseBLAHOutput(blahOutput, command);
                    }
                    done = true;
                }
            }
            catch (BLAHException ex) {
                command.setException(ex);
            }
            catch (Exception e) {
                if (e.getMessage().equals("Broken pipe")) {
                    logger.warn((Object)"sendCommand: caught a \"Broken pipe\" exception (maybe the blah process is dead!) I am going to make a new one");
                    super.set(this.makeBLAHProcess());
                    continue;
                }
                logger.error((Object)e.getMessage(), (Throwable)e);
                command.setException(new BLAHException(e.getMessage()));
            }
        }
    }

    private int getResultSize(String blahOutput) {
        if (blahOutput == null) {
            return -1;
        }
        int size = 0;
        StringTokenizer strtok = new StringTokenizer(blahOutput);
        if (strtok.countTokens() == 2 && strtok.nextToken().equals("S")) {
            try {
                size = Integer.parseInt(strtok.nextToken());
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return size;
    }

    private void parseBLAHOutput(String blahOutput, BLAHCommand command) throws BLAHException {
        if (blahOutput == null) {
            throw new BLAHException("blahOutput not specified!");
        }
        if (command == null) {
            throw new BLAHException("command not specified!");
        }
        int index = blahOutput.indexOf(" ");
        if (index > -1) {
            String reqId = blahOutput.substring(0, index);
            if (reqId != null && !reqId.equals(command.getReqId())) {
                throw new BLAHException("reqId mismatch!");
            }
            int subId = 0;
            blahOutput = blahOutput.substring(index + 1, blahOutput.length());
            index = reqId.indexOf(".");
            if (index > -1) {
                subId = Integer.parseInt(reqId.substring(index + 1, reqId.length()));
                reqId = reqId.substring(0, index);
            }
            index = blahOutput.indexOf(" ");
            String errorCode = blahOutput.substring(0, index);
            String value = blahOutput.substring(index + 1, blahOutput.length());
            if (errorCode.startsWith("0")) {
                index = value.indexOf("error");
                if (index > 0 && value.length() >= 10) {
                    value = value.substring(10);
                }
                command.addResult(value.trim());
            } else {
                command.setException(new BLAHException(value.replaceAll("\\\\", "")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wait(int delay) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(delay);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public void waitForResult(BLAHCommand command) {
        if (!this.asynchronousMode) {
            return;
        }
        while (!command.isTimedOut() && this.pendingCommandList.contains(command)) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (command.isTimedOut()) {
            command.setException(new BLAHException("command timed out!"));
            this.pendingCommandList.remove(command);
        }
    }

    private String getOutput(BufferedReader readIn, BLAHCommand command) throws BLAHException {
        try {
            while (!readIn.ready()) {
                if (command.isTimedOut()) {
                    this.killBLAHProcess();
                    super.set(this.makeBLAHProcess());
                    throw new BLAHException("command timed out!");
                }
                this.wait(1000);
            }
            String result = readIn.readLine();
            logger.debug((Object)("getBlahOutput: " + result));
            return result;
        }
        catch (Throwable e) {
            throw new BLAHException("getBlahOutput error: " + e.getMessage());
        }
    }
}

