/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.blahmanagement;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.glite.ce.cream.blahmanagement.BLAHJobStatus;
import org.glite.ce.cream.blahmanagement.BLAHJobStatusChangeListener;

public class BLAHNotificationListener
extends Thread {
    private static final Logger logger = Logger.getLogger((String)BLAHNotificationListener.class.getName());
    private static final int THREAD_COUNT = 10;
    private ServerSocket serverSocket = null;
    private BLAHJobStatusChangeListener jobStatusChangeListener = null;
    private boolean working = true;
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(10, 10, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public BLAHNotificationListener(int port) {
        super("BLAHNotificationListener");
        this.setDaemon(true);
        try {
            this.serverSocket = new ServerSocket(port, 10);
            logger.info((Object)("Server listening on port " + port));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            this.pool.shutdownNow();
        }
    }

    public void startListener() {
        this.working = true;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListener() {
        this.working = false;
        this.pool.shutdownNow();
        this.pool.purge();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                this.serverSocket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)"started!");
        while (!this.isInterrupted() && this.working) {
            try {
                this.pool.execute(new Worker(this.serverSocket.accept()));
            }
            catch (IOException e) {
                logger.warn((Object)("BLAHNotificationListener interrupted: " + e.getMessage()));
            }
        }
        this.pool.shutdownNow();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                this.serverSocket = null;
            }
        }
        logger.info((Object)"terminated!");
    }

    public void setJobStatusChangeListener(BLAHJobStatusChangeListener jobStatusChangeListener) {
        this.jobStatusChangeListener = jobStatusChangeListener;
    }

    public BLAHJobStatusChangeListener getJobStatusChangeListener() {
        return this.jobStatusChangeListener;
    }

    private class Worker
    implements Runnable {
        private Socket clientSocket;

        public Worker(Socket s) {
            this.clientSocket = s;
            try {
                this.clientSocket.setKeepAlive(false);
                this.clientSocket.setTcpNoDelay(true);
                this.clientSocket.setSoLinger(true, 10);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader rd = null;
            StringBuffer msg = new StringBuffer();
            try {
                rd = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                String str = null;
                while ((str = rd.readLine()) != null) {
                    msg.append(str);
                }
                str = null;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (rd != null) {
                        rd.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.clientSocket.shutdownInput();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.clientSocket.shutdownOutput();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.clientSocket = null;
            }
            rd = null;
            if (BLAHNotificationListener.this.jobStatusChangeListener != null) {
                BLAHNotificationListener.this.jobStatusChangeListener.doOnJobStatusChange(new BLAHJobStatus(msg.toString(), 1));
            }
            msg = null;
        }
    }
}

