/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.blahmanagement;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class BLAHJobStatus {
    private static final Logger logger = Logger.getLogger((String)BLAHJobStatus.class.getName());
    private int source = -1;
    private int status = -1;
    private String reason = null;
    private String exitCode = null;
    private String lrmsJobId = null;
    private String workerNode = null;
    private String blahJobName = null;
    private String clientJobId = null;
    private Calendar changeTime = null;
    public static final int BLAH_NOTIFIER = 0;
    public static final int BLAH_NOTIFICATION_LISTENER = 1;
    public static final int IDLE = 1;
    public static final int RUNNING = 2;
    public static final int CANCELLED = 3;
    public static final int DONE = 4;
    public static final int HELD = 5;
    public static final int REALLY_RUNNING = 11;

    public BLAHJobStatus(String notification) {
        this(notification, -1);
    }

    public BLAHJobStatus(String notification, int source) {
        if (notification == null) {
            return;
        }
        this.source = source;
        logger.debug((Object)notification);
        Hashtable<String, String> attributeTable = new Hashtable<String, String>(0);
        if (notification.startsWith("[")) {
            notification = notification.substring(1);
        }
        if (notification.endsWith("]")) {
            notification = notification.substring(0, notification.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(notification, ";");
        String attribute = null;
        String value = null;
        int index = -1;
        while (st.hasMoreElements()) {
            attribute = st.nextToken();
            index = attribute.indexOf("=");
            if (index == -1) continue;
            value = attribute.substring(index + 1, attribute.length());
            if ((value = value.trim()).startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            attributeTable.put(attribute.substring(0, index).trim(), value.trim());
        }
        if (attributeTable.containsKey("ChangeTime")) {
            this.changeTime = new GregorianCalendar();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setCalendar(this.changeTime);
            try {
                dateFormat.parse((String)attributeTable.get("ChangeTime"));
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.reason = (String)attributeTable.get("Reason");
        this.exitCode = (String)attributeTable.get("ExitCode");
        this.workerNode = (String)attributeTable.get("WorkerNode");
        this.clientJobId = (String)attributeTable.get("ClientJobId");
        this.blahJobName = (String)attributeTable.get("BlahJobName");
        if (attributeTable.containsKey("JobStatus")) {
            this.status = Integer.parseInt((String)attributeTable.get("JobStatus"));
        }
    }

    public String getBlahJobName() {
        return this.blahJobName;
    }

    public Calendar getChangeTime() {
        return this.changeTime;
    }

    public String getClientJobId() {
        return this.clientJobId;
    }

    public String getExitCode() {
        return this.exitCode;
    }

    public int getStatus() {
        return this.status;
    }

    public String getLRMSJobId() {
        return this.lrmsJobId;
    }

    public String getReason() {
        return this.reason;
    }

    public int getSource() {
        return this.source;
    }

    public String getWorkerNode() {
        return this.workerNode;
    }

    public void setBlahJobName(String blahJobName) {
        this.blahJobName = blahJobName;
    }

    public void setChangeTime(Calendar changeTime) {
        this.changeTime = changeTime;
    }

    public void setClientJobId(String clientJobId) {
        this.clientJobId = clientJobId;
    }

    public void setExitCode(String exitCode) {
        this.exitCode = exitCode;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setLRMSJobId(String lrmsJobId) {
        this.lrmsJobId = lrmsJobId;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public void setWorkerNode(String workerNode) {
        this.workerNode = workerNode;
    }

    public String toString() {
        StringBuffer info = new StringBuffer();
        info.append("[clientJobId=").append(this.clientJobId);
        if (this.blahJobName != null) {
            info.append("; blahJobName=").append(this.blahJobName);
        }
        if (this.blahJobName != null) {
            info.append("; lrmsJobId=").append(this.lrmsJobId);
        }
        if (this.status > -1) {
            info.append("; status=").append(this.status);
        }
        if (this.reason != null) {
            info.append("; reason=\"").append(this.reason).append("\"");
        }
        if (this.workerNode != null) {
            info.append("; workerNode=").append(this.workerNode);
        }
        if (this.exitCode != null) {
            info.append("; exitCode=").append(this.exitCode);
        }
        if (this.changeTime != null) {
            info.append("; changeTime=").append(this.changeTime.getTime());
        }
        if (this.source > -1) {
            info.append("; source=").append(this.source == 0 ? "BLAH_NOTIFIER" : "BLAH_NOTIFICATION_LISTENER");
        }
        info.append("]");
        return info.toString();
    }
}

