/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.RemoteLoggingTableInterface;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.RemoteLogging;

public class RemoteLoggingTable
implements RemoteLoggingTableInterface {
    private static final Logger logger = Logger.getLogger((String)RemoteLoggingTable.class.getName());
    private static final String insertSP = "{call insertRemoteLoggingTable (?, ?, ?, ?)}";
    private static final String selectSP = "{call selectRemoteLoggingTable (?)}";

    public void executeInsert(String activityId, RemoteLogging remoteLogging, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(1, activityId);
            insertCS.setString(2, remoteLogging.getServiceType());
            insertCS.setString(3, remoteLogging.getURL());
            insertCS.setBoolean(4, remoteLogging.isOptional());
            insertCS.execute();
            logger.debug((Object)"insert into RemoteLoggingTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<RemoteLogging> executeSelect(String activityId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<RemoteLogging> remoteLoggingList = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setString(1, activityId);
            if (selectCS.execute()) {
                remoteLoggingList = new ArrayList<RemoteLogging>(0);
                RemoteLogging remoteLogging = null;
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    remoteLogging = new RemoteLogging();
                    remoteLogging.setServiceType(resultSet.getString("service_type"));
                    remoteLogging.setURL(resultSet.getString("url"));
                    remoteLogging.setOptional(Boolean.valueOf(resultSet.getBoolean("optional")));
                    remoteLoggingList.add(remoteLogging);
                }
            }
            logger.debug((Object)"select RemoteLoggingTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return remoteLoggingList;
    }
}

