/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.NotificationDB;
import org.glite.ce.creamapi.activitymanagement.db.table.NotificationTableInterface;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.Notification;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ProtocolTypeEnumeration;

public class NotificationTable
implements NotificationTableInterface {
    private static final Logger logger = Logger.getLogger((String)NotificationTable.class.getName());
    private static final String insertSP = "{call insertNotificationTable (?, ?, ?, ?)}";
    private static final String selectSP = "{call selectNotificationTable (?)}";

    public long executeInsert(String activityId, Notification notification, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        long notificationId = 0L;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(1, activityId);
            insertCS.setString(2, notification.getProtocol() != null ? notification.getProtocol().value() : null);
            insertCS.setBoolean(3, (boolean)notification.isOptional());
            insertCS.registerOutParameter(4, -5);
            insertCS.execute();
            notificationId = insertCS.getLong(4);
            logger.debug((Object)"insert into NotificationTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return notificationId;
    }

    public List<NotificationDB> executeSelect(String activityId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<NotificationDB> notificationDBList = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setString(1, activityId);
            if (selectCS.execute()) {
                notificationDBList = new ArrayList<NotificationDB>(0);
                NotificationDB notificationDB = null;
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    notificationDB = new NotificationDB();
                    notificationDB.setId(resultSet.getLong("id"));
                    notificationDB.setNotification(new Notification());
                    notificationDB.getNotification().setProtocol(ProtocolTypeEnumeration.fromValue((String)resultSet.getString("protocol")));
                    notificationDB.getNotification().setOptional(Boolean.valueOf(resultSet.getBoolean("optional")));
                    notificationDBList.add(notificationDB);
                }
            }
            logger.debug((Object)"select NotificationTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return notificationDBList;
    }
}

