/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.InputFileTableInterface;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.InputFile;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionType;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.Source;

public class InputFileTable
implements InputFileTableInterface {
    private static final Logger logger = Logger.getLogger((String)InputFileTable.class.getName());
    private static final String insertInputFileSP = "{call insertInputFileTable (?, ?, ?, ?, ?, ?)}";
    private static final String insertOptionTypeInputFileSP = "{call insertOptionTypeInputFileTable (?, ?, ?)}";
    private static final String selectInputFileSP = "{call selectInputFileTable (?)}";
    private static final String selectOptionTypeInputFileSP = "{call selectOptionTypeInputFileTable (?)}";

    public void executeInsert(String activityId, InputFile inputFile, Connection connection) throws SQLException {
        CallableStatement insertInputFileCS = null;
        CallableStatement insertOptionTypeInputFileCS = null;
        try {
            insertInputFileCS = connection.prepareCall(insertInputFileSP);
            insertOptionTypeInputFileCS = connection.prepareCall(insertOptionTypeInputFileSP);
            insertInputFileCS.setString(1, activityId);
            insertInputFileCS.setString(2, inputFile.getName());
            insertInputFileCS.setBoolean(3, (boolean)inputFile.isIsExecutable());
            long inputFileId = 0L;
            for (Source source : inputFile.getSource()) {
                insertInputFileCS.setString(4, source.getURI());
                insertInputFileCS.setString(5, source.getDelegationID());
                insertInputFileCS.registerOutParameter(6, -5);
                insertInputFileCS.execute();
                inputFileId = insertInputFileCS.getLong(6);
                if (source.getOption().size() == 0) continue;
                for (OptionType optionType : source.getOption()) {
                    insertOptionTypeInputFileCS.setLong(1, inputFileId);
                    insertOptionTypeInputFileCS.setString(2, optionType.getName());
                    insertOptionTypeInputFileCS.setString(3, optionType.getValue());
                    insertOptionTypeInputFileCS.execute();
                }
            }
            if (inputFileId == 0L) {
                insertInputFileCS.setString(4, null);
                insertInputFileCS.setString(5, null);
                insertInputFileCS.registerOutParameter(6, -5);
                insertInputFileCS.execute();
            }
            logger.debug((Object)"insert into InputFileTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertInputFileCS != null) {
                    insertInputFileCS.close();
                }
            }
            catch (SQLException se2) {}
            try {
                if (insertOptionTypeInputFileCS != null) {
                    insertOptionTypeInputFileCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<InputFile> executeSelect(String activityId, Connection connection) throws SQLException {
        CallableStatement selectInputFileCS = null;
        CallableStatement selectOptionTypeInputFileCS = null;
        ArrayList<InputFile> inputFileList = null;
        try {
            selectInputFileCS = connection.prepareCall(selectInputFileSP);
            selectOptionTypeInputFileCS = connection.prepareCall(selectOptionTypeInputFileSP);
            selectInputFileCS.setString(1, activityId);
            if (selectInputFileCS.execute()) {
                inputFileList = new ArrayList<InputFile>(0);
                InputFile inputFile = null;
                Source source = null;
                OptionType optionType = null;
                String fileNamePrec = null;
                ResultSet optionTypeResultSet = null;
                ResultSet resultSet = selectInputFileCS.getResultSet();
                while (resultSet.next()) {
                    if (resultSet.getString("name") != fileNamePrec) {
                        fileNamePrec = resultSet.getString("name");
                        inputFile = new InputFile();
                        inputFileList.add(inputFile);
                        inputFile.setName(resultSet.getString("name"));
                        inputFile.setIsExecutable(Boolean.valueOf(resultSet.getBoolean("is_executable")));
                    }
                    if (resultSet.getString("uri") == null) continue;
                    source = new Source();
                    inputFile.getSource().add(source);
                    source.setURI(resultSet.getString("uri"));
                    source.setDelegationID(resultSet.getString("delegation_id"));
                    selectOptionTypeInputFileCS.setLong(1, resultSet.getLong("id"));
                    if (!selectOptionTypeInputFileCS.execute()) continue;
                    optionTypeResultSet = selectOptionTypeInputFileCS.getResultSet();
                    while (optionTypeResultSet.next()) {
                        optionType = new OptionType();
                        optionType.setName(optionTypeResultSet.getString("name"));
                        optionType.setValue(optionTypeResultSet.getString("value"));
                        source.getOption().add(optionType);
                    }
                }
            }
            logger.debug((Object)"select InputFile done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectInputFileCS != null) {
                    selectInputFileCS.close();
                }
            }
            catch (SQLException se2) {}
            try {
                if (selectOptionTypeInputFileCS != null) {
                    selectOptionTypeInputFileCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return inputFileList;
    }
}

