/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.ExecutableTypeTableInterface;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ExecutableType;

public class ExecutableTypeTable
implements ExecutableTypeTableInterface {
    private static final Logger logger = Logger.getLogger((String)ExecutableTypeTable.class.getName());
    private static final String insertSP = "{call insertExecutableTypeTable (?, ?, ?)}";
    private static final String selectSP = "{call selectExecutableTypeTable (?)}";

    public long executeInsert(ExecutableType executableType, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        long executableTypeId = 0L;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(1, executableType.getPath());
            if (executableType.getFailIfExitCodeNotEqualTo() != null) {
                insertCS.setString(2, executableType.getFailIfExitCodeNotEqualTo().longValue() + "");
            } else {
                insertCS.setString(2, null);
            }
            insertCS.registerOutParameter(3, -5);
            insertCS.execute();
            executableTypeId = insertCS.getLong(3);
            logger.debug((Object)"insert into ExecutableTypeTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return executableTypeId;
    }

    public ExecutableType executeSelect(long executableTypeId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ExecutableType executableType = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setLong(1, executableTypeId);
            if (selectCS.execute()) {
                executableType = new ExecutableType();
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    executableType.setPath(resultSet.getString("path"));
                    executableType.setFailIfExitCodeNotEqualTo(BigInteger.valueOf(resultSet.getLong("failIfExitCodeNotEqualTo")));
                    if (resultSet.getString("failIfExitCodeNotEqualTo") != null) {
                        try {
                            long failIfExitCodeNotEqualToField = Long.parseLong(resultSet.getString("failIfExitCodeNotEqualTo"));
                            executableType.setFailIfExitCodeNotEqualTo(BigInteger.valueOf(failIfExitCodeNotEqualToField));
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            logger.error((Object)"FailIfExitCodeNotEqualTo field must be integer");
                            throw new SQLException("FailIfExitCodeNotEqualTo field must be integer");
                        }
                    }
                    executableType.setFailIfExitCodeNotEqualTo(null);
                }
            }
            logger.debug((Object)"select ExecutableTypeTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return executableType;
    }
}

