/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.AnnotationTableInterface;

public class AnnotationTable
implements AnnotationTableInterface {
    private static final Logger logger = Logger.getLogger((String)AnnotationTable.class.getName());
    private static final String insertSP = "{call insertAnnotationTable (?, ?)}";
    private static final String selectSP = "{call selectAnnotationTable (?)}";

    public void executeInsert(String activityId, String value, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(1, activityId);
            insertCS.setString(2, value);
            insertCS.execute();
            logger.debug((Object)"insert into AnnotationTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<String> executeSelect(String activityId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<String> annotation = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setString(1, activityId);
            if (selectCS.execute()) {
                annotation = new ArrayList<String>(0);
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    annotation.add(resultSet.getString("value"));
                }
            }
            logger.debug((Object)"select AnnotationTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return annotation;
    }
}

