/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.utils.CEUtils;
import org.glite.ce.creamapi.activitymanagement.ActivityStatus;
import org.glite.ce.creamapi.activitymanagement.ListActivitiesResult;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityStatusTableInterface;

public class ActivityStatusTable
implements ActivityStatusTableInterface {
    private static final Logger logger = Logger.getLogger((String)ActivityStatusTable.class.getName());
    private static final String insertSP = "{call insertActivityStatusTable (?, ?, ?, ?, ?, ?)}";
    private static final String selectSP = "{call selectActivityStatusTable (?, ?)}";
    private static final String updateSP = "{call updateActivityStatusTable (?, ?)}";
    private static final String selectListActivitiesSP = "{call selectListActivities (?, ?, ?, ?, ?, ?)}";
    private static final String selectRetrieveOlderActivityIdSP = "{call selectRetrieveOlderActivityId (?, ?)}";
    private static final String selectListActivitiesForStatusSP = "{call selectListActivitiesForStatus (?, ?, ?)}";

    public long executeInsert(String activityId, ActivityStatus activityStatus, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        long activityStatusId = 0L;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(1, activityId);
            insertCS.setString(2, activityStatus.getStatusName().getName());
            insertCS.setTimestamp(3, new Timestamp(activityStatus.getTimestamp().toGregorianCalendar().getTimeInMillis()));
            insertCS.setString(4, activityStatus.getDescription());
            insertCS.setBoolean(5, (boolean)activityStatus.isTransient());
            insertCS.registerOutParameter(6, -5);
            insertCS.execute();
            activityStatusId = insertCS.getLong(6);
            logger.debug((Object)"insert into ActivityStatusTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return activityStatusId;
    }

    public List<ActivityStatus> executeSelect(String activityId, String userId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<ActivityStatus> activityStatusList = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setString(1, activityId);
            selectCS.setString(2, userId);
            if (selectCS.execute()) {
                activityStatusList = new ArrayList<ActivityStatus>(0);
                ActivityStatus activityStatus = null;
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    activityStatus = new ActivityStatus();
                    activityStatus.setId(resultSet.getLong("id"));
                    activityStatus.setStatusName(ActivityStatus.StatusName.fromValue((String)resultSet.getString("status")));
                    activityStatus.setDescription(resultSet.getString("description"));
                    Timestamp timeStampField = null;
                    timeStampField = resultSet.getTimestamp("timestamp");
                    if (timeStampField != null) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(timeStampField.getTime());
                        activityStatus.setTimestamp(CEUtils.getXMLGregorianCalendar((Calendar)calendar));
                    }
                    activityStatus.setIsTransient(Boolean.valueOf(resultSet.getBoolean("is_transient")));
                    activityStatusList.add(activityStatus);
                }
            }
            logger.debug((Object)"select ActivityStatusTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return activityStatusList;
    }

    public ListActivitiesResult executeListActivities(XMLGregorianCalendar fromDate, XMLGregorianCalendar toDate, List<ActivityStatus> statusList, int limit, String userId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeListActivities");
        ListActivitiesResult listActivitiesResult = new ListActivitiesResult();
        CallableStatement selectListActivitiesCS = null;
        try {
            int activityToBeFound;
            selectListActivitiesCS = connection.prepareCall(selectListActivitiesSP);
            if (fromDate != null) {
                selectListActivitiesCS.setTimestamp(1, new Timestamp(fromDate.toGregorianCalendar().getTimeInMillis()));
            } else {
                selectListActivitiesCS.setTimestamp(1, null);
            }
            if (toDate != null) {
                selectListActivitiesCS.setTimestamp(2, new Timestamp(toDate.toGregorianCalendar().getTimeInMillis()));
            } else {
                selectListActivitiesCS.setTimestamp(2, null);
            }
            selectListActivitiesCS.setString(5, userId);
            String statusString = null;
            List statusAttributeNameList = null;
            String statusAttributeNameListString = null;
            StringBuffer statusAttributeNameListStringBuffer = null;
            int index = 0;
            ActivityStatus activityStatus = null;
            ResultSet resultSet = null;
            ArrayList<String> activityIdList = new ArrayList<String>(0);
            if (statusList == null || statusList.size() == 0) {
                selectListActivitiesCS.setString(3, statusString);
                selectListActivitiesCS.setString(4, statusAttributeNameListString);
                selectListActivitiesCS.setInt(6, activityToBeFound);
                if (selectListActivitiesCS.execute()) {
                    resultSet = selectListActivitiesCS.getResultSet();
                    for (activityToBeFound = limit + 1; resultSet.next() && activityToBeFound > 0; --activityToBeFound) {
                        activityIdList.add(resultSet.getString("activityId"));
                    }
                }
            } else {
                while (index < statusList.size() && activityToBeFound > 0) {
                    activityStatus = statusList.get(index++);
                    statusAttributeNameListString = null;
                    statusString = activityStatus.getStatusName().getName();
                    selectListActivitiesCS.setString(3, statusString);
                    statusAttributeNameList = activityStatus.getStatusAttributes();
                    if (statusAttributeNameList != null && statusAttributeNameList.size() > 0) {
                        statusAttributeNameListStringBuffer = new StringBuffer();
                        for (ActivityStatus.StatusAttributeName statusAttributeName : statusAttributeNameList) {
                            statusAttributeNameListStringBuffer.append(", '").append(statusAttributeName.getName()).append("'");
                        }
                        statusAttributeNameListString = statusAttributeNameListStringBuffer.substring(2);
                    }
                    selectListActivitiesCS.setString(4, statusAttributeNameListString);
                    selectListActivitiesCS.setInt(6, activityToBeFound);
                    if (!selectListActivitiesCS.execute()) continue;
                    resultSet = selectListActivitiesCS.getResultSet();
                    while (resultSet.next() && activityToBeFound > 0) {
                        activityIdList.add(resultSet.getString("activityId"));
                        --activityToBeFound;
                    }
                }
            }
            if (activityIdList.size() > 0) {
                if (activityIdList.size() > limit) {
                    activityIdList.remove(limit);
                    listActivitiesResult.setIsTruncated(Boolean.valueOf(true));
                } else {
                    listActivitiesResult.setIsTruncated(Boolean.valueOf(false));
                }
                listActivitiesResult.setActivityIdList(activityIdList);
            }
            logger.debug((Object)"select ListActivities done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectListActivitiesCS != null) {
                    selectListActivitiesCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        logger.debug((Object)"End executeListActivities");
        return listActivitiesResult;
    }

    public void executeUpdate(ActivityStatus activityStatus, Connection connection) throws SQLException {
        CallableStatement updateCS = null;
        try {
            updateCS = connection.prepareCall(updateSP);
            updateCS.setLong(1, activityStatus.getId());
            updateCS.setBoolean(2, (boolean)activityStatus.isTransient());
            updateCS.execute();
            logger.debug((Object)"update ActivityStatusTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (updateCS != null) {
                    updateCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public String executeRetrieveOlderActivityId(List<ActivityStatus.StatusName> statusList, String userId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeRetrieveOlderActivityId");
        String activityIdResult = null;
        CallableStatement selectRetrieveOlderActivityIdCS = null;
        try {
            selectRetrieveOlderActivityIdCS = connection.prepareCall(selectRetrieveOlderActivityIdSP);
            String statusListString = null;
            StringBuffer statusListStringBuffer = null;
            if (statusList != null) {
                statusListStringBuffer = new StringBuffer();
                for (ActivityStatus.StatusName statusName : statusList) {
                    statusListStringBuffer.append(", '" + statusName.getName() + "'");
                }
                statusListString = statusListStringBuffer.substring(2);
            }
            selectRetrieveOlderActivityIdCS.setString(1, statusListString);
            selectRetrieveOlderActivityIdCS.setString(2, userId);
            if (selectRetrieveOlderActivityIdCS.execute()) {
                ResultSet resultSet = selectRetrieveOlderActivityIdCS.getResultSet();
                while (resultSet.next()) {
                    activityIdResult = resultSet.getString("activityId");
                }
            }
            logger.debug((Object)"select executeRetrieveOlderActivityId done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectRetrieveOlderActivityIdCS != null) {
                    selectRetrieveOlderActivityIdCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        logger.debug((Object)"End executeRetrieveOlderActivityId");
        return activityIdResult;
    }

    public List<String> executeListActivitiesForStatus(List<ActivityStatus.StatusName> statusList, String userId, int dateValue, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeListActivitiesForStatus");
        ArrayList<String> listActivitiesResult = null;
        CallableStatement selectListActivitiesForStatusCS = null;
        try {
            selectListActivitiesForStatusCS = connection.prepareCall(selectListActivitiesForStatusSP);
            String statusListString = null;
            StringBuffer statusListStringBuffer = null;
            if (statusList != null) {
                statusListStringBuffer = new StringBuffer();
                for (ActivityStatus.StatusName statusName : statusList) {
                    statusListStringBuffer.append(", '" + statusName.getName() + "'");
                }
                statusListString = statusListStringBuffer.substring(2);
            }
            selectListActivitiesForStatusCS.setString(1, statusListString);
            selectListActivitiesForStatusCS.setString(2, userId);
            selectListActivitiesForStatusCS.setInt(3, dateValue);
            if (selectListActivitiesForStatusCS.execute()) {
                listActivitiesResult = new ArrayList<String>(0);
                ResultSet resultSet = selectListActivitiesForStatusCS.getResultSet();
                while (resultSet.next()) {
                    listActivitiesResult.add(resultSet.getString("activityId"));
                }
            }
            logger.debug((Object)"select executeListActivitiesForStatus done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectListActivitiesForStatusCS != null) {
                    selectListActivitiesForStatusCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        logger.debug((Object)"End executeListActivitiesForStatus");
        return listActivitiesResult;
    }
}

