/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.ActivityStatus;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityStatusAttributeTableInterface;

public class ActivityStatusAttributeTable
implements ActivityStatusAttributeTableInterface {
    private static final Logger logger = Logger.getLogger((String)ActivityStatusAttributeTable.class.getName());
    private static final String insertSP = "{call insertActivityStatusAttributeTable (?, ?)}";
    private static final String selectSP = "{call selectActivityStatusAttributeTable (?)}";
    private static final String deleteSP = "{call deleteActivityStatusAttributeTable (?)}";

    public void executeInsert(long activityStatusId, List<ActivityStatus.StatusAttributeName> listStatusAttributeName, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setLong(1, activityStatusId);
            for (ActivityStatus.StatusAttributeName statusAttributeName : listStatusAttributeName) {
                insertCS.setString(2, statusAttributeName.getName());
                insertCS.execute();
            }
            logger.debug((Object)"insert into ActivityStatusAttributeTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public List<ActivityStatus.StatusAttributeName> executeSelect(long activityStatusId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<ActivityStatus.StatusAttributeName> activityStatusAttributeNameList = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setLong(1, activityStatusId);
            if (selectCS.execute()) {
                activityStatusAttributeNameList = new ArrayList<ActivityStatus.StatusAttributeName>(0);
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    activityStatusAttributeNameList.add(ActivityStatus.StatusAttributeName.fromValue((String)resultSet.getString("attribute")));
                }
            }
            logger.debug((Object)"select ActivityStatusAttributeTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return activityStatusAttributeNameList;
    }

    public void executeUpdate(long activityStatusId, List<ActivityStatus.StatusAttributeName> listStatusAttributeName, Connection connection) throws SQLException {
        this.executeDelete(activityStatusId, connection);
        if (listStatusAttributeName != null && !listStatusAttributeName.isEmpty()) {
            this.executeInsert(activityStatusId, listStatusAttributeName, connection);
        }
        logger.debug((Object)"update ActivityStatusAttributeTable done");
    }

    private void executeDelete(long activityStatusId, Connection connection) throws SQLException {
        CallableStatement deleteCS = null;
        try {
            deleteCS = connection.prepareCall(deleteSP);
            deleteCS.setLong(1, activityStatusId);
            deleteCS.execute();
            logger.debug((Object)"delete ActivityStatusAttributeTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (deleteCS != null) {
                    deleteCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }
}

