/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityPropertyTableInterface;

public class ActivityPropertyTable
implements ActivityPropertyTableInterface {
    private static final Logger logger = Logger.getLogger((String)ActivityPropertyTable.class.getName());
    private static final String insertSP = "{call insertActivityPropertyTable (?, ?, ?)}";
    private static final String selectSP = "{call selectActivityPropertyTable (?)}";
    private static final String deleteSP = "{call deleteActivityPropertyTable (?)}";

    public void executeInsert(String activityId, Hashtable<String, String> properties, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(1, activityId);
            for (String key : properties.keySet()) {
                insertCS.setString(2, key);
                insertCS.setString(3, properties.get(key));
                insertCS.execute();
            }
            logger.debug((Object)"insert into ActivityPropertyTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public Hashtable<String, String> executeSelect(String activityId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        Hashtable<String, String> activityProperty = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setString(1, activityId);
            if (selectCS.execute()) {
                activityProperty = new Hashtable<String, String>(0);
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    activityProperty.put(resultSet.getString("name"), resultSet.getString("value"));
                }
            }
            logger.debug((Object)"select ActivityPropertyTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return activityProperty;
    }

    private void executeDelete(String activityId, Connection connection) throws SQLException {
        CallableStatement deleteCS = null;
        try {
            deleteCS = connection.prepareCall(deleteSP);
            deleteCS.setString(1, activityId);
            deleteCS.execute();
            logger.debug((Object)"delete ActivityPropertyTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (deleteCS != null) {
                    deleteCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }

    public void executeUpdate(String activityId, Hashtable<String, String> properties, Connection connection) throws SQLException {
        this.executeDelete(activityId, connection);
        if (properties != null && !properties.isEmpty()) {
            this.executeInsert(activityId, properties, connection);
        }
        logger.debug((Object)"update ActivityPropertyTable done");
    }
}

