/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.activitymanagement.db.table;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.utils.CEUtils;
import org.glite.ce.creamapi.activitymanagement.ActivityCommand;
import org.glite.ce.creamapi.activitymanagement.db.table.ActivityCommandTableInterface;

public class ActivityCommandTable
implements ActivityCommandTableInterface {
    private static final Logger logger = Logger.getLogger((String)ActivityCommandTable.class.getName());
    private static final String insertSP = "{call insertActivityCommandTable (?, ?, ?, ?, ?)}";
    private static final String selectSP = "{call selectActivityCommandTable (?, ?)}";
    private static final String updateSP = "{call updateActivityCommandTable (?, ?)}";

    public long executeInsert(String activityId, ActivityCommand activityCommand, Connection connection) throws SQLException {
        CallableStatement insertCS = null;
        long activityCommandId = 0L;
        try {
            insertCS = connection.prepareCall(insertSP);
            insertCS.setString(1, activityId);
            insertCS.setString(2, activityCommand.getName());
            insertCS.setTimestamp(3, new Timestamp(activityCommand.getTimestamp().toGregorianCalendar().getTimeInMillis()));
            insertCS.setBoolean(4, (boolean)activityCommand.isSuccess());
            insertCS.registerOutParameter(5, -5);
            insertCS.execute();
            activityCommandId = insertCS.getLong(5);
            logger.debug((Object)"insert into ActivityCommandTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (insertCS != null) {
                    insertCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return activityCommandId;
    }

    public List<ActivityCommand> executeSelect(String activityId, String userId, Connection connection) throws SQLException {
        CallableStatement selectCS = null;
        ArrayList<ActivityCommand> activityCommandList = null;
        try {
            selectCS = connection.prepareCall(selectSP);
            selectCS.setString(1, activityId);
            selectCS.setString(2, userId);
            if (selectCS.execute()) {
                activityCommandList = new ArrayList<ActivityCommand>(0);
                ActivityCommand activityCommand = null;
                ResultSet resultSet = selectCS.getResultSet();
                while (resultSet.next()) {
                    activityCommand = new ActivityCommand();
                    activityCommand.setName(resultSet.getString("name"));
                    Timestamp timeStampField = null;
                    timeStampField = resultSet.getTimestamp("timestamp");
                    if (timeStampField != null) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(timeStampField.getTime());
                        activityCommand.setTimestamp(CEUtils.getXMLGregorianCalendar((Calendar)calendar));
                    }
                    activityCommand.setIsSuccess(Boolean.valueOf(resultSet.getBoolean("is_success")));
                    activityCommandList.add(activityCommand);
                }
            }
            logger.debug((Object)"select ActivityCommandTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (selectCS != null) {
                    selectCS.close();
                }
            }
            catch (SQLException se2) {}
        }
        return activityCommandList;
    }

    public void executeUpdate(ActivityCommand activityCommand, Connection connection) throws SQLException {
        CallableStatement updateCS = null;
        try {
            updateCS = connection.prepareCall(updateSP);
            updateCS.setLong(1, activityCommand.getId());
            updateCS.setBoolean(2, (boolean)activityCommand.isSuccess());
            updateCS.execute();
            logger.debug((Object)"update ActivityCommandTable done");
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            try {
                if (updateCS != null) {
                    updateCS.close();
                }
            }
            catch (SQLException se2) {}
        }
    }
}

