/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client.es;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.glite.ce.cream.client.es.ActivityCommand;
import org.glite.ce.creamapi.ws.es.delegation.DelegationExceptionException;
import org.glite.ce.creamapi.ws.es.delegation.Destroy;
import org.glite.ce.creamapi.ws.es.delegation.GetInterfaceVersion;
import org.glite.ce.creamapi.ws.es.delegation.GetInterfaceVersionResponse;
import org.glite.ce.creamapi.ws.es.delegation.GetNewProxyReq;
import org.glite.ce.creamapi.ws.es.delegation.GetNewProxyReqResponse;
import org.glite.ce.creamapi.ws.es.delegation.GetProxyReq;
import org.glite.ce.creamapi.ws.es.delegation.GetProxyReqResponse;
import org.glite.ce.creamapi.ws.es.delegation.GetTerminationTime;
import org.glite.ce.creamapi.ws.es.delegation.GetTerminationTimeResponse;
import org.glite.ce.creamapi.ws.es.delegation.GetVersion;
import org.glite.ce.creamapi.ws.es.delegation.GetVersionResponse;
import org.glite.ce.creamapi.ws.es.delegation.PutProxy;
import org.glite.ce.creamapi.ws.es.delegation.RenewProxyReq;
import org.glite.ce.creamapi.ws.es.delegation.RenewProxyReqResponse;

public class DelegationClient
extends ActivityCommand {
    public DelegationClient(String[] args, List<String> options) throws RuntimeException {
        super(args, options);
    }

    @Override
    public void execute() {
        if (this.isGetVersion()) {
            try {
                GetVersionResponse response = this.getDelegationServiceStub().getVersion(new GetVersion());
                System.out.println("version: " + response.getGetVersionReturn());
            }
            catch (AxisFault e) {
                System.out.println("AxisFault: " + e.getMessage());
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
            }
            catch (DelegationExceptionException e) {
                System.out.println("(DelegationException: " + e.getMessage());
            }
        } else if (this.isGetInterfaceVersion()) {
            try {
                GetInterfaceVersionResponse response = this.getDelegationServiceStub().getInterfaceVersion(new GetInterfaceVersion());
                System.out.println("version: " + response.getGetInterfaceVersionReturn());
            }
            catch (AxisFault e) {
                System.out.println("AxisFault: " + e.getMessage());
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
            }
            catch (DelegationExceptionException e) {
                System.out.println("(DelegationException: " + e.getMessage());
            }
        } else if (this.isGetTerminationTime()) {
            try {
                GetTerminationTimeResponse response = this.getDelegationServiceStub().getTerminationTime(new GetTerminationTime());
                System.out.println("time: " + response.getGetTerminationTimeReturn());
            }
            catch (AxisFault e) {
                System.out.println("AxisFault: " + e.getMessage());
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
            }
            catch (DelegationExceptionException e) {
                System.out.println("(DelegationException: " + e.getMessage());
            }
        } else if (this.isGetProxyRequest()) {
            List<String> idList = this.getIdList();
            if (idList.size() == 0) {
                this.printUsage();
                return;
            }
            try {
                GetProxyReq req = new GetProxyReq();
                req.setDelegationID(idList.get(0));
                GetProxyReqResponse response = this.getDelegationServiceStub().getProxyReq(req);
                System.out.println("request: " + response.getGetProxyReqReturn());
                PutProxy putProxyReq = new PutProxy();
                putProxyReq.setDelegationID(idList.get(0));
                putProxyReq.setProxy(this.signRequest(response.getGetProxyReqReturn()));
                this.getDelegationServiceStub().putProxy(putProxyReq);
            }
            catch (AxisFault e) {
                System.out.println("AxisFault: " + e.getMessage());
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
            }
            catch (DelegationExceptionException e) {
                System.out.println("(DelegationException: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("(IOException: " + e.getMessage());
            }
        } else if (this.isGetNewProxyRequest()) {
            try {
                GetNewProxyReqResponse response = this.getDelegationServiceStub().getNewProxyReq(new GetNewProxyReq());
                System.out.println("id: " + response.getDelegationID());
                PutProxy putProxyReq = new PutProxy();
                putProxyReq.setDelegationID(response.getDelegationID());
                putProxyReq.setProxy(this.signRequest(response.getProxyRequest()));
                this.getDelegationServiceStub().putProxy(putProxyReq);
            }
            catch (AxisFault e) {
                System.out.println("AxisFault: " + e.getMessage());
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
            }
            catch (DelegationExceptionException e) {
                System.out.println("(DelegationException: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("(IOException: " + e.getMessage());
            }
        } else if (this.isRenewProxyRequest()) {
            List<String> idList = this.getIdList();
            if (idList.size() == 0) {
                this.printUsage();
                return;
            }
            try {
                RenewProxyReq req = new RenewProxyReq();
                req.setDelegationID(idList.get(0));
                RenewProxyReqResponse response = this.getDelegationServiceStub().renewProxyReq(req);
                PutProxy putProxyReq = new PutProxy();
                putProxyReq.setDelegationID(idList.get(0));
                putProxyReq.setProxy(this.signRequest(response.getRenewProxyReqReturn()));
                this.getDelegationServiceStub().putProxy(putProxyReq);
            }
            catch (AxisFault e) {
                System.out.println("AxisFault: " + e.getMessage());
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
            }
            catch (DelegationExceptionException e) {
                System.out.println("(DelegationException: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("(IOException: " + e.getMessage());
            }
        } else if (this.isDestroy()) {
            List<String> idList = this.getIdList();
            if (idList.size() == 0) {
                this.printUsage();
                return;
            }
            try {
                Destroy req = new Destroy();
                req.setDelegationID(idList.get(0));
                this.getDelegationServiceStub().destroy(req);
            }
            catch (AxisFault e) {
                System.out.println("AxisFault: " + e.getMessage());
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
            }
            catch (DelegationExceptionException e) {
                System.out.println("(DelegationException: " + e.getMessage());
            }
        } else {
            this.printUsage();
        }
    }

    public static void main(String[] args) {
        ArrayList<String> options = new ArrayList<String>(9);
        options.add("EPR");
        options.add("PROXY");
        options.add("GET_INTERFACE_VERSION");
        options.add("GET_NEW_PROXY_REQUEST");
        options.add("GET_PROXY_REQUEST");
        options.add("GET_TERMINATION_TIME");
        options.add("GET_VERSION");
        options.add("RENEW_PROXY_REQUEST");
        options.add("DESTROY");
        new DelegationClient(args, options);
    }
}

