/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client.es;

import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.UnsignedLong;
import org.glite.ce.cream.client.es.ActivityCommand;
import org.glite.ce.creamapi.ws.es.activitymanagement.AccessControlFault;
import org.glite.ce.creamapi.ws.es.activitymanagement.InternalBaseFault;
import org.glite.ce.creamapi.ws.es.activitymanagement.InternalNotificationFault;
import org.glite.ce.creamapi.ws.es.activitymanagement.UnknownAttributeFault;
import org.glite.ce.creamapi.ws.es.activitymanagement.VectorLimitExceededFault;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ActivityInfoDocument_t;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ActivityInfoItemChoice_type1;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ActivityInfoItem_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ActivityStatusAttribute;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ActivityStatusItemChoice_type1;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ActivityStatusItem_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ActivityStatus_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.AttributeInfoItem_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.CancelActivity;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.CancelActivityResponse;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.CancelActivityResponseItemChoice_type1;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.CancelActivityResponseItem_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ComputingActivityHistory_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.GetActivityInfo;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.GetActivityInfoResponse;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.GetActivityStatus;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.GetActivityStatusResponse;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.InternalBaseFault_Type;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.NotifyMessageType;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.NotifyRequestItem_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.NotifyResponseItemChoice_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.NotifyResponseItem_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.NotifyService;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.NotifyServiceResponse;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.Operation_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.PauseActivity;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.PauseActivityResponse;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.PauseActivityResponseItemChoice_type1;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.PauseActivityResponseItem_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ResumeActivity;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ResumeActivityResponse;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ResumeActivityResponseItemChoice_type1;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.ResumeActivityResponseItem_type0;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.WipeActivity;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.WipeActivityResponse;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.WipeActivityResponseItemChoice_type1;
import org.glite.ce.creamapi.ws.es.activitymanagement.types.WipeActivityResponseItem_type0;
import org.glite.ce.creamapi.ws.es.glue.ComputingActivityState_t;
import org.glite.ce.creamapi.ws.es.glue.ComputingActivityType_t;
import org.glite.ce.creamapi.ws.es.glue.JobDescription_t;

public class ActivityManagementClient
extends ActivityCommand {
    public static void main(String[] args) {
        ArrayList<String> options = new ArrayList<String>(9);
        options.add("EPR");
        options.add("PROXY");
        options.add("GET_ACTIVITY_INFO");
        options.add("GET_ACTIVITY_STATUS");
        options.add("CANCEL_ACTIVITY");
        options.add("PAUSE_ACTIVITY");
        options.add("RESUME_ACTIVITY");
        options.add("WIPE_ACTIVITY");
        options.add("NOTIFY_SERVICE");
        new ActivityManagementClient(args, options);
    }

    public ActivityManagementClient(String[] args, List<String> options) throws RuntimeException {
        super(args, options);
    }

    private String checkAttribute(String name, BigInteger value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value.toString();
    }

    private String checkAttribute(String name, ComputingActivityState_t[] state) {
        if (state == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < state.length; ++i) {
            buffer.append(state[i].getComputingActivityState_t()).append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length(), " ]");
        return "\n" + name + " = " + buffer.toString();
    }

    private String checkAttribute(String name, ComputingActivityType_t type) {
        if (type == null) {
            return "";
        }
        return "\n" + name + " = " + type.getValue();
    }

    private String checkAttribute(String name, Integer value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value.toString();
    }

    private String checkAttribute(String name, JobDescription_t jobDescription) {
        if (jobDescription == null) {
            return "";
        }
        return "\n" + name + " = " + jobDescription.getJobDescription_t();
    }

    private String checkAttribute(String name, List<String> value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value.toString();
    }

    private String checkAttribute(String name, String value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value;
    }

    private String checkAttribute(String name, String[] values) {
        if (values == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i]).append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length(), " ]");
        return "\n" + name + " = " + buffer.toString();
    }

    private String checkAttribute(String name, URI[] values) {
        if (values == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i]).append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length(), " ]");
        return "\n" + name + " = " + buffer.toString();
    }

    private String checkAttribute(String name, UnsignedLong value) {
        if (value == null) {
            return "";
        }
        return "\n" + name + " = " + value.toString();
    }

    private String checkAttribute(String name, URI uri) {
        if (uri == null) {
            return "";
        }
        return "\n" + name + " = " + uri.toString();
    }

    private String checkAttribute(String name, Calendar time) {
        if (time == null) {
            return "";
        }
        return "\n" + name + " = " + time.getTime();
    }

    @Override
    public void execute() {
        if (this.isNotifyService()) {
            String messageType = this.getNotifyMessageType();
            if (this.getIdList().size() == 0 || messageType == null) {
                this.printUsage();
                return;
            }
            NotifyMessageType notifyMessageType = null;
            if (messageType.equals("dataPullDone")) {
                notifyMessageType = NotifyMessageType.value1;
            } else if (messageType.equals("dataPushDone")) {
                notifyMessageType = NotifyMessageType.value2;
            } else {
                this.printUsage();
                return;
            }
            NotifyService req = new NotifyService();
            NotifyRequestItem_type0[] notifyRequestItem = new NotifyRequestItem_type0[this.getIdList().size()];
            int index = 0;
            for (String activityId : this.getIdList()) {
                System.out.println("notifying the message " + messageType + " for the activity " + activityId);
                notifyRequestItem[index] = new NotifyRequestItem_type0();
                notifyRequestItem[index].setActivityID(activityId);
                notifyRequestItem[index++].setNotifyMessage(notifyMessageType);
            }
            req.setNotifyRequestItem(notifyRequestItem);
            NotifyServiceResponse response = null;
            try {
                response = this.getActivityManagementServiceStub().notifyService(req);
            }
            catch (AxisFault e) {
                System.out.println(e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println("AccessControlFault: " + e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println("InternalBaseFault:" + e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (InternalNotificationFault e) {
                System.out.println("InternalNotificationFault " + e.getFaultMessage().getMessage());
                return;
            }
            catch (VectorLimitExceededFault e) {
                System.out.println("VectorLimitExceededFault " + e.getFaultMessage().getMessage());
                return;
            }
            if (response == null) {
                System.out.println("none response received!");
                return;
            }
            this.printResultItems(response.getNotifyResponseItem());
        } else if (this.isCancelActivity()) {
            if (this.getIdList().size() == 0) {
                this.printUsage();
                return;
            }
            CancelActivity req = new CancelActivity();
            req.setActivityID(this.getIdArray());
            CancelActivityResponse response = null;
            try {
                response = this.getActivityManagementServiceStub().cancelActivity(req);
            }
            catch (AxisFault e) {
                System.out.println(e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println("AccessControlFault: " + e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println("InternalBaseFault:" + e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (VectorLimitExceededFault e) {
                System.out.println("VectorLimitExceededFault " + e.getFaultMessage().getMessage());
                return;
            }
            this.printResultItems(response.getCancelActivityResponseItem());
        } else if (this.isPauseActivity()) {
            if (this.getIdList().size() == 0) {
                this.printUsage();
                return;
            }
            PauseActivity req = new PauseActivity();
            req.setActivityID(this.getIdArray());
            PauseActivityResponse response = null;
            try {
                response = this.getActivityManagementServiceStub().pauseActivity(req);
            }
            catch (AxisFault e) {
                System.out.println(e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println("AccessControlFault: " + e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println("InternalBaseFault:" + e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (VectorLimitExceededFault e) {
                System.out.println("VectorLimitExceededFault " + e.getFaultMessage().getMessage());
                return;
            }
            this.printResultItems(response.getPauseActivityResponseItem());
        } else if (this.isResumeActivity()) {
            if (this.getIdList().size() == 0) {
                this.printUsage();
                return;
            }
            ResumeActivity req = new ResumeActivity();
            req.setActivityID(this.getIdArray());
            ResumeActivityResponse response = null;
            try {
                response = this.getActivityManagementServiceStub().resumeActivity(req);
            }
            catch (AxisFault e) {
                System.out.println(e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println("AccessControlFault: " + e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println("InternalBaseFault:" + e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (VectorLimitExceededFault e) {
                System.out.println("VectorLimitExceededFault " + e.getFaultMessage().getMessage());
                return;
            }
            this.printResultItems(response.getResumeActivityResponseItem());
        } else if (this.isWipeActivity()) {
            if (this.getIdList().size() == 0) {
                this.printUsage();
                return;
            }
            WipeActivity req = new WipeActivity();
            req.setActivityID(this.getIdArray());
            WipeActivityResponse response = null;
            try {
                response = this.getActivityManagementServiceStub().wipeActivity(req);
            }
            catch (AxisFault e) {
                System.out.println(e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println("AccessControlFault: " + e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println("InternalBaseFault:" + e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (VectorLimitExceededFault e) {
                System.out.println("VectorLimitExceededFault " + e.getFaultMessage().getMessage());
                return;
            }
            this.printResultItems(response.getWipeActivityResponseItem());
        } else if (this.isGetActivityStatus()) {
            if (this.getIdList().size() == 0) {
                this.printUsage();
                return;
            }
            GetActivityStatus req = new GetActivityStatus();
            req.setActivityID(this.getIdArray());
            GetActivityStatusResponse response = null;
            try {
                response = this.getActivityManagementServiceStub().getActivityStatus(req);
            }
            catch (AxisFault e) {
                System.out.println(e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println("AccessControlFault: " + e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println("InternalBaseFault:" + e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (VectorLimitExceededFault e) {
                System.out.println("VectorLimitExceededFault " + e.getFaultMessage().getMessage());
                return;
            }
            ActivityStatus_type0 status = null;
            ActivityStatusItemChoice_type1 choice = null;
            ActivityStatusAttribute[] statusAttributes = null;
            ActivityStatusItem_type0[] activityStatusItems = response.getActivityStatusItem();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < activityStatusItems.length; ++i) {
                buffer.append("\n").append(i).append(") activityId = ");
                buffer.append(activityStatusItems[i].getActivityID());
                choice = activityStatusItems[i].getActivityStatusItemChoice_type1();
                if (choice.isActivityStatusSpecified()) {
                    status = choice.getActivityStatus();
                    buffer.append("\nstatus = ").append(status.getStatus().getValue());
                    if (status.isAttributeSpecified()) {
                        buffer.append("\nattributes = { ");
                        statusAttributes = status.getAttribute();
                        for (int j = 0; j < statusAttributes.length; ++j) {
                            buffer.append(statusAttributes[j].getValue()).append(", ");
                        }
                        buffer.replace(buffer.length() - 2, buffer.length() - 1, " }");
                    }
                    if (status.getDescription() != null) {
                        buffer.append("\ndescription = \"" + status.getDescription()).append("\"");
                    }
                    buffer.append("\ntimestamp = " + status.getTimestamp().getTime());
                } else if (choice.isAccessControlFaultSpecified()) {
                    buffer.append("\nfault = AccessControlFault");
                } else if (choice.isActivityNotFoundFaultSpecified()) {
                    buffer.append("\nfault = ActivityNotFoundFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getActivityNotFoundFault()));
                } else if (choice.isInternalBaseFaultSpecified()) {
                    buffer.append("\nfault = InternalBaseFault");
                    buffer.append(this.printFault(choice.getInternalBaseFault()));
                } else if (choice.isOperationNotAllowedFaultSpecified()) {
                    buffer.append("\nfault = OperationNotAllowedFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getOperationNotAllowedFault()));
                } else if (choice.isOperationNotPossibleFaultSpecified()) {
                    buffer.append("\nfault = OperationNotPossibleFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getOperationNotPossibleFault()));
                } else if (choice.isUnableToRetrieveStatusFaultSpecified()) {
                    buffer.append("\nfault = UnableToRetrieveStatusFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getUnableToRetrieveStatusFault()));
                }
                buffer.append("\n");
            }
            System.out.println(buffer.toString());
        } else if (this.isGetActivityInfo()) {
            if (this.getIdList().size() == 0) {
                this.printUsage();
                return;
            }
            GetActivityInfo req = new GetActivityInfo();
            req.setActivityID(this.getIdArray());
            for (String attribute : this.getAttributeList()) {
                req.addAttributeName(new QName(attribute));
            }
            GetActivityInfoResponse response = null;
            try {
                response = this.getActivityManagementServiceStub().getActivityInfo(req);
            }
            catch (AxisFault e) {
                System.out.println("AxisFault: " + e.getMessage());
                return;
            }
            catch (RemoteException e) {
                System.out.println("RemoteException: " + e.getMessage());
                return;
            }
            catch (AccessControlFault e) {
                System.out.println("AccessControlFault: " + e.getFaultMessage().getMessage());
                return;
            }
            catch (InternalBaseFault e) {
                System.out.println("InternalBaseFault:" + e.getFaultMessage().getInternalBaseFault().getMessage());
                return;
            }
            catch (UnknownAttributeFault e) {
                System.out.println("UnknownAttributeFault: " + e.getFaultMessage().getUnknownAttributeFault().getMessage());
                return;
            }
            catch (VectorLimitExceededFault e) {
                System.out.println("VectorLimitExceededFault " + e.getFaultMessage().getMessage());
                return;
            }
            if (response == null) {
                System.out.println("none response received!");
                return;
            }
            ActivityInfoDocument_t activityInfoDocument = null;
            ActivityInfoItemChoice_type1 choice = null;
            ActivityInfoItem_type0[] activityInfoItems = response.getActivityInfoItem();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < activityInfoItems.length; ++i) {
                buffer.append("\n").append(i).append(") activityId = ");
                buffer.append(activityInfoItems[i].getActivityID());
                choice = activityInfoItems[i].getActivityInfoItemChoice_type1();
                if (choice.isAttributeInfoItemSpecified()) {
                    AttributeInfoItem_type0[] attributeInfoItem = choice.getAttributeInfoItem();
                    for (int x = 0; x < attributeInfoItem.length; ++x) {
                        buffer.append("\n").append(attributeInfoItem[x].getAttributeName().getLocalPart()).append(" = ").append(attributeInfoItem[x].getAttributeValue());
                    }
                } else if (choice.isActivityInfoDocumentSpecified()) {
                    ComputingActivityHistory_type0 history;
                    activityInfoDocument = choice.getActivityInfoDocument();
                    buffer.append(this.checkAttribute("id", activityInfoDocument.getID()));
                    buffer.append(this.checkAttribute("idFromEndpoint", activityInfoDocument.getIDFromEndpoint()));
                    buffer.append(this.checkAttribute("localIDFromManager", activityInfoDocument.getLocalIDFromManager()));
                    buffer.append(this.checkAttribute("baseType", activityInfoDocument.getType()));
                    buffer.append(this.checkAttribute("type", activityInfoDocument.getType().toString()));
                    buffer.append(this.checkAttribute("name", activityInfoDocument.getName()));
                    buffer.append(this.checkAttribute("description", activityInfoDocument.getJobDescription()));
                    buffer.append(this.checkAttribute("computingManagerExitCode", activityInfoDocument.getComputingManagerExitCode()));
                    buffer.append(this.checkAttribute("localOwner", activityInfoDocument.getLocalOwner()));
                    buffer.append(this.checkAttribute("owner", activityInfoDocument.getOwner()));
                    buffer.append(this.checkAttribute("userDomain", activityInfoDocument.getUserDomain()));
                    buffer.append(this.checkAttribute("logDir", activityInfoDocument.getLogDir()));
                    buffer.append(this.checkAttribute("queue", activityInfoDocument.getQueue()));
                    buffer.append(this.checkAttribute("stdIn", activityInfoDocument.getStdIn()));
                    buffer.append(this.checkAttribute("stdOut", activityInfoDocument.getStdOut()));
                    buffer.append(this.checkAttribute("stdErr", activityInfoDocument.getStdErr()));
                    buffer.append(this.checkAttribute("sessionDirectory", activityInfoDocument.getSessionDirectory()));
                    buffer.append(this.checkAttribute("stageInDirectory", activityInfoDocument.getStageInDirectory()));
                    buffer.append(this.checkAttribute("stageOutDirectory", activityInfoDocument.getStageOutDirectory()));
                    buffer.append(this.checkAttribute("submissionClientName", activityInfoDocument.getSubmissionClientName()));
                    buffer.append(this.checkAttribute("submissionHost", activityInfoDocument.getSubmissionHost()));
                    if (activityInfoDocument.isExitCodeSpecified()) {
                        buffer.append(this.checkAttribute("exitCode", activityInfoDocument.getExitCode()));
                    }
                    buffer.append(this.checkAttribute("creationTime", activityInfoDocument.getCreationTime()));
                    buffer.append(this.checkAttribute("startTime", activityInfoDocument.getStartTime()));
                    buffer.append(this.checkAttribute("submissionTime ", activityInfoDocument.getSubmissionTime()));
                    buffer.append(this.checkAttribute("computingManagerSubmissionTime", activityInfoDocument.getComputingManagerSubmissionTime()));
                    buffer.append(this.checkAttribute("computingManagerEndTime", activityInfoDocument.getComputingManagerEndTime()));
                    buffer.append(this.checkAttribute("endTime", activityInfoDocument.getEndTime()));
                    buffer.append(this.checkAttribute("workingAreaEraseTime", activityInfoDocument.getWorkingAreaEraseTime()));
                    buffer.append(this.checkAttribute("proxyExpirationTime", activityInfoDocument.getProxyExpirationTime()));
                    buffer.append(this.checkAttribute("state", activityInfoDocument.getState()));
                    buffer.append(this.checkAttribute("restartState", activityInfoDocument.getRestartState()));
                    buffer.append(this.checkAttribute("error", activityInfoDocument.getError()));
                    buffer.append(this.checkAttribute("otherInfo", activityInfoDocument.getOtherInfo()));
                    buffer.append(this.checkAttribute("otherMessages", activityInfoDocument.getOtherMessages()));
                    buffer.append(this.checkAttribute("executionNode", activityInfoDocument.getExecutionNode()));
                    buffer.append(this.checkAttribute("requestedApplicationEnvironment", activityInfoDocument.getRequestedApplicationEnvironment()));
                    if (activityInfoDocument.isRequestedSlotsSpecified()) {
                        buffer.append("\nrequestedSlots = ").append(activityInfoDocument.getRequestedSlots());
                    }
                    buffer.append(this.checkAttribute("requestedTotalCPUTime", activityInfoDocument.getRequestedTotalCPUTime()));
                    buffer.append(this.checkAttribute("requestedTotalWallTime", activityInfoDocument.getRequestedTotalWallTime()));
                    buffer.append(this.checkAttribute("usedMainMemory", activityInfoDocument.getUsedMainMemory()));
                    buffer.append(this.checkAttribute("usedTotalCPUTime", activityInfoDocument.getUsedTotalCPUTime()));
                    buffer.append(this.checkAttribute("usedTotalWallTime", activityInfoDocument.getUsedTotalWallTime()));
                    buffer.append(this.checkAttribute("validity", activityInfoDocument.getValidity()));
                    if (activityInfoDocument.isWaitingPositionSpecified()) {
                        buffer.append("\nwaitingPosition = ").append(activityInfoDocument.getWaitingPosition());
                    }
                    if ((history = activityInfoDocument.getComputingActivityHistory()) != null) {
                        int x;
                        if (history.getActivityStatus() != null) {
                            ActivityStatus_type0[] activityStatusArray = history.getActivityStatus();
                            for (x = 0; x < activityStatusArray.length; ++x) {
                                ActivityStatusAttribute[] attributes;
                                buffer.append("\n[ status = ").append(activityStatusArray[x].getStatus().getValue());
                                buffer.append("; timestamp = ").append(activityStatusArray[x].getTimestamp().getTime());
                                if (activityStatusArray[x].isDescriptionSpecified()) {
                                    buffer.append("; description = \"").append(activityStatusArray[x].getDescription()).append("\"");
                                }
                                if ((attributes = activityStatusArray[x].getAttribute()) != null && attributes.length > 0) {
                                    buffer.append("; attributes = { ");
                                    for (int y = 0; y < attributes.length; ++y) {
                                        buffer.append(attributes[y].getValue()).append(", ");
                                    }
                                    buffer.replace(buffer.length() - 2, buffer.length(), " }");
                                }
                                buffer.append(" ]");
                            }
                        }
                        if (history.isOperationSpecified()) {
                            Operation_type0[] operationArray = history.getOperation();
                            for (x = 0; x < operationArray.length; ++x) {
                                buffer.append("\n[ operation = ").append(operationArray[x].getRequestedOperation().toString());
                                buffer.append("; timestamp = ").append(operationArray[x].getTimestamp().getTime());
                                buffer.append("; success = ").append(operationArray[x].getSuccess());
                                buffer.append(" ]");
                            }
                        }
                    }
                } else if (choice.isAccessControlFaultSpecified()) {
                    buffer.append("\nfault = AccessControlFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getAccessControlFault()));
                } else if (choice.isActivityNotFoundFaultSpecified()) {
                    buffer.append("\nfault = ActivityNotFoundFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getActivityNotFoundFault()));
                } else if (choice.isInternalBaseFaultSpecified()) {
                    buffer.append("\nfault = InternalBaseFault");
                    buffer.append(this.printFault(choice.getInternalBaseFault()));
                } else if (choice.isOperationNotAllowedFaultSpecified()) {
                    buffer.append("\nfault = OperationNotAllowedFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getOperationNotAllowedFault()));
                } else if (choice.isOperationNotPossibleFaultSpecified()) {
                    buffer.append("\nfault = OperationNotPossibleFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getOperationNotPossibleFault()));
                } else if (choice.isUnableToRetrieveStatusFaultSpecified()) {
                    buffer.append("\nfault = UnableToRetrieveStatusFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getUnableToRetrieveStatusFault()));
                } else if (choice.isUnknownAttributeFaultSpecified()) {
                    buffer.append("\nfault = UnknownAttributeFault");
                    buffer.append(this.printFault((InternalBaseFault_Type)choice.getUnknownAttributeFault()));
                }
                buffer.append("\n");
            }
            System.out.println(buffer.toString());
        } else {
            this.printUsage();
        }
    }

    private void printResultItems(CancelActivityResponseItem_type0[] responseItems) {
        if (responseItems == null) {
            System.out.println("none result received");
        }
        CancelActivityResponseItemChoice_type1 choice = null;
        for (int i = 0; i < responseItems.length; ++i) {
            System.out.println("activityId = " + responseItems[i].getActivityID());
            choice = responseItems[i].getCancelActivityResponseItemChoice_type1();
            if (choice == null) {
                System.out.println("SUCCESS");
                continue;
            }
            if (choice.isEstimatedTimeSpecified()) {
                Calendar esTime = Calendar.getInstance();
                esTime.setTimeInMillis(choice.getEstimatedTime().longValue());
                System.out.println("SUCCESS\nestimated time = " + esTime.getTime());
                continue;
            }
            if (choice.isAccessControlFaultSpecified()) {
                System.out.println("fault = AccessControlFault" + this.printFault((InternalBaseFault_Type)choice.getAccessControlFault()));
                continue;
            }
            if (choice.isActivityNotFoundFaultSpecified()) {
                System.out.println("fault = ActivityNotFoundFault" + this.printFault((InternalBaseFault_Type)choice.getActivityNotFoundFault()));
                continue;
            }
            if (choice.isInternalBaseFaultSpecified()) {
                System.out.println("fault = InternalBaseFault" + this.printFault(choice.getInternalBaseFault()));
                continue;
            }
            if (choice.isOperationNotAllowedFaultSpecified()) {
                System.out.println("fault = OperationNotAllowedFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotAllowedFault()));
                continue;
            }
            if (!choice.isOperationNotPossibleFaultSpecified()) continue;
            System.out.println("fault = OperationNotPossibleFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotPossibleFault()));
        }
    }

    private void printResultItems(NotifyResponseItem_type0[] responseItems) {
        if (responseItems == null) {
            System.out.println("none result received");
        }
        for (int i = 0; i < responseItems.length; ++i) {
            System.out.println("activityId = " + responseItems[i].getActivityID());
            NotifyResponseItemChoice_type0 choice = responseItems[i].getNotifyResponseItemChoice_type0();
            if (choice == null) {
                System.out.println("SUCCESS");
                continue;
            }
            if (choice.isAccessControlFaultSpecified()) {
                System.out.println("fault = AccessControlFault" + this.printFault((InternalBaseFault_Type)choice.getAccessControlFault()));
                continue;
            }
            if (choice.isActivityNotFoundFaultSpecified()) {
                System.out.println("fault = ActivityNotFoundFault" + this.printFault((InternalBaseFault_Type)choice.getActivityNotFoundFault()));
                continue;
            }
            if (choice.isInternalBaseFaultSpecified()) {
                System.out.println("fault = InternalBaseFault" + this.printFault(choice.getInternalBaseFault()));
                continue;
            }
            if (choice.isOperationNotAllowedFaultSpecified()) {
                System.out.println("fault = OperationNotAllowedFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotAllowedFault()));
                continue;
            }
            if (choice.isOperationNotPossibleFaultSpecified()) {
                System.out.println("fault = OperationNotPossibleFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotPossibleFault()));
                continue;
            }
            if (!choice.isAcknowledgementSpecified()) continue;
            System.out.println("SUCCESS\nack = " + choice.getAcknowledgement());
        }
    }

    private void printResultItems(PauseActivityResponseItem_type0[] responseItems) {
        if (responseItems == null) {
            System.out.println("none result received");
        }
        PauseActivityResponseItemChoice_type1 choice = null;
        for (int i = 0; i < responseItems.length; ++i) {
            System.out.println("activityId = " + responseItems[i].getActivityID());
            choice = responseItems[i].getPauseActivityResponseItemChoice_type1();
            if (choice == null) {
                System.out.println("SUCCESS");
                continue;
            }
            if (choice.isEstimatedTimeSpecified()) {
                Calendar esTime = Calendar.getInstance();
                esTime.setTimeInMillis(choice.getEstimatedTime().longValue());
                System.out.println("SUCCESS\nestimated time = " + esTime.getTime());
                continue;
            }
            if (choice.isAccessControlFaultSpecified()) {
                System.out.println("fault = AccessControlFault" + this.printFault((InternalBaseFault_Type)choice.getAccessControlFault()));
                continue;
            }
            if (choice.isActivityNotFoundFaultSpecified()) {
                System.out.println("fault = ActivityNotFoundFault" + this.printFault((InternalBaseFault_Type)choice.getActivityNotFoundFault()));
                continue;
            }
            if (choice.isInternalBaseFaultSpecified()) {
                System.out.println("fault = InternalBaseFault" + this.printFault(choice.getInternalBaseFault()));
                continue;
            }
            if (choice.isOperationNotAllowedFaultSpecified()) {
                System.out.println("fault = OperationNotAllowedFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotAllowedFault()));
                continue;
            }
            if (!choice.isOperationNotPossibleFaultSpecified()) continue;
            System.out.println("fault = OperationNotPossibleFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotPossibleFault()));
        }
    }

    private void printResultItems(ResumeActivityResponseItem_type0[] responseItems) {
        if (responseItems == null) {
            System.out.println("none result received");
        }
        ResumeActivityResponseItemChoice_type1 choice = null;
        for (int i = 0; i < responseItems.length; ++i) {
            System.out.println("activityId = " + responseItems[i].getActivityID());
            choice = responseItems[i].getResumeActivityResponseItemChoice_type1();
            if (choice == null) {
                System.out.println("SUCCESS");
                continue;
            }
            if (choice.isEstimatedTimeSpecified()) {
                Calendar esTime = Calendar.getInstance();
                esTime.setTimeInMillis(choice.getEstimatedTime().longValue());
                System.out.println("SUCCESS\nestimated time = " + esTime.getTime());
                continue;
            }
            if (choice.isAccessControlFaultSpecified()) {
                System.out.println("fault = AccessControlFault" + this.printFault((InternalBaseFault_Type)choice.getAccessControlFault()));
                continue;
            }
            if (choice.isActivityNotFoundFaultSpecified()) {
                System.out.println("fault = ActivityNotFoundFault" + this.printFault((InternalBaseFault_Type)choice.getActivityNotFoundFault()));
                continue;
            }
            if (choice.isInternalBaseFaultSpecified()) {
                System.out.println("fault = InternalBaseFault" + this.printFault(choice.getInternalBaseFault()));
                continue;
            }
            if (choice.isOperationNotAllowedFaultSpecified()) {
                System.out.println("fault = OperationNotAllowedFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotAllowedFault()));
                continue;
            }
            if (!choice.isOperationNotPossibleFaultSpecified()) continue;
            System.out.println("fault = OperationNotPossibleFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotPossibleFault()));
        }
    }

    private void printResultItems(WipeActivityResponseItem_type0[] responseItems) {
        if (responseItems == null) {
            System.out.println("none result received");
        }
        WipeActivityResponseItemChoice_type1 choice = null;
        for (int i = 0; i < responseItems.length; ++i) {
            System.out.println("activityId = " + responseItems[i].getActivityID());
            choice = responseItems[i].getWipeActivityResponseItemChoice_type1();
            if (choice == null) {
                System.out.println("SUCCESS");
                continue;
            }
            if (choice.isEstimatedTimeSpecified()) {
                Calendar esTime = Calendar.getInstance();
                esTime.setTimeInMillis(choice.getEstimatedTime().longValue());
                System.out.println("SUCCESS\nestimated time = " + esTime.getTime());
                continue;
            }
            if (choice.isAccessControlFaultSpecified()) {
                System.out.println("fault = AccessControlFault" + this.printFault((InternalBaseFault_Type)choice.getAccessControlFault()));
                continue;
            }
            if (choice.isActivityNotFoundFaultSpecified()) {
                System.out.println("fault = ActivityNotFoundFault" + this.printFault((InternalBaseFault_Type)choice.getActivityNotFoundFault()));
                continue;
            }
            if (choice.isInternalBaseFaultSpecified()) {
                System.out.println("fault = InternalBaseFault" + this.printFault(choice.getInternalBaseFault()));
                continue;
            }
            if (choice.isOperationNotAllowedFaultSpecified()) {
                System.out.println("fault = OperationNotAllowedFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotAllowedFault()));
                continue;
            }
            if (!choice.isOperationNotPossibleFaultSpecified()) continue;
            System.out.println("fault = OperationNotPossibleFault" + this.printFault((InternalBaseFault_Type)choice.getOperationNotPossibleFault()));
        }
    }

    private String printFault(InternalBaseFault_Type fault) {
        StringBuffer buffer = new StringBuffer();
        if (fault != null) {
            buffer.append("\nmessage = \"").append(fault.getMessage()).append("\"");
            buffer.append("\ntimestamp = " + fault.getTimestamp().getTime());
            if (fault.getDescription() != null) {
                buffer.append("\ndescription = \"" + fault.getDescription()).append("\"");
            }
        }
        return buffer.toString();
    }
}

