/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client.es;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.axis2.AxisFault;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.glite.ce.cream.client.CmdLineParser;
import org.glite.ce.creamapi.ws.es.activityinfo.ActivityInfoServiceStub;
import org.glite.ce.creamapi.ws.es.activitymanagement.ActivityManagementServiceStub;
import org.glite.ce.creamapi.ws.es.creation.ActivityCreationServiceStub;
import org.glite.ce.creamapi.ws.es.delegation.DelegationServiceStub;
import org.glite.ce.creamapi.ws.es.resourceinfo.ResourceInfoServiceStub;
import org.glite.security.delegation.GrDPX509Util;
import org.glite.security.delegation.GrDProxyDlgorOptions;
import org.glite.security.delegation.GrDProxyGenerator;
import org.glite.security.trustmanager.axis2.AXIS2SocketFactory;

public abstract class ActivityCommand {
    public static final String ADL = "ADL";
    public static final String CANCEL_ACTIVITY = "CANCEL_ACTIVITY";
    public static final String DELEGATION_ID = "DELEGATION_ID";
    public static final String DESTROY = "DESTROY";
    public static final String EPR = "EPR";
    public static final String GET_ACTIVITY_INFO = "GET_ACTIVITY_INFO";
    public static final String GET_ACTIVITY_STATUS = "GET_ACTIVITY_STATUS";
    public static final String GET_INTERFACE_VERSION = "GET_INTERFACE_VERSION";
    public static final String GET_NEW_PROXY_REQUEST = "GET_NEW_PROXY_REQUEST";
    public static final String GET_PROXY_REQUEST = "GET_PROXY_REQUEST";
    public static final String GET_RESOURCE_INFO = "GET_RESOURCE_INFO";
    public static final String GET_TERMINATION_TIME = "GET_TERMINATION_TIME";
    public static final String GET_VERSION = "GET_VERSION";
    public static final String LIST_ACTIVITIES = "LIST_ACTIVITIES";
    public static final String NOTIFY_SERVICE = "NOTIFY_SERVICE";
    public static final String PAUSE_ACTIVITY = "PAUSE_ACTIVITY";
    public static final String PROXY = "PROXY";
    public static final String QUERY_RESOURCE_INFO = "QUERY_RESOURCE_INFO";
    public static final String RENEW_PROXY_REQUEST = "RENEW_PROXY_REQUEST";
    public static final String RESUME_ACTIVITY = "RESUME_ACTIVITY";
    public static final String STATUS = "STATUS";
    public static final String WIPE_ACTIVITY = "WIPE_ACTIVITY";
    private List<String> activityDescFileList = null;
    private List<String> attributeList = null;
    private String epr = null;
    private Calendar fromDate = null;
    private List<String> idList = null;
    private boolean isCancelActivity = false;
    private boolean isDestroy = false;
    private boolean isGetActivityInfo = false;
    private boolean isGetActivityStatus = false;
    private boolean isGetDelegationInfo = false;
    private boolean isGetInterfaceVersion = false;
    private boolean isGetNewProxyRequest = false;
    private boolean isGetProxyRequest = false;
    private boolean isGetResourceInfo = false;
    private boolean isGetTerminationTime = false;
    private boolean isGetVersion = false;
    private boolean isListActivities = false;
    private boolean isPauseActivity = false;
    private boolean isQueryResourceInfo = false;
    private boolean isRenew = false;
    private boolean isRenewProxyRequest = false;
    private boolean isResumeActivity = false;
    private boolean isWipeActivity = false;
    private int limit = 0;
    private String notifyMessageType = null;
    private List<String> options = null;
    private String proxy = null;
    private String query = null;
    private List<String> statusList = null;
    private Calendar toDate = null;

    public ActivityCommand(String[] args, List<String> options) throws IllegalArgumentException {
        if (options == null || options.size() == 0) {
            throw new IllegalArgumentException("options not specified!");
        }
        this.options = options;
        this.parseArguments(args, this.options);
        this.execute();
    }

    protected abstract void execute();

    public ActivityCreationServiceStub getActivityCreationServiceStub() throws AxisFault {
        if (this.epr == null) {
            throw new AxisFault("epr not specified!");
        }
        if (this.epr.startsWith("https")) {
            this.setSSLProperties();
        }
        return new ActivityCreationServiceStub(this.epr);
    }

    public List<String> getActivityDescFileList() {
        if (this.activityDescFileList == null) {
            this.activityDescFileList = new ArrayList<String>(0);
        }
        return this.activityDescFileList;
    }

    public ActivityInfoServiceStub getActivityInfoServiceStub() throws AxisFault {
        if (this.epr == null) {
            throw new AxisFault("epr not specified!");
        }
        if (this.epr.startsWith("https")) {
            this.setSSLProperties();
        }
        return new ActivityInfoServiceStub(this.epr);
    }

    public ActivityManagementServiceStub getActivityManagementServiceStub() throws AxisFault {
        if (this.epr == null) {
            throw new AxisFault("epr not specified!");
        }
        if (this.epr.startsWith("https")) {
            this.setSSLProperties();
        }
        return new ActivityManagementServiceStub(this.epr);
    }

    public DelegationServiceStub getDelegationServiceStub() throws AxisFault {
        if (this.epr == null) {
            throw new AxisFault("epr not specified!");
        }
        if (this.epr.startsWith("https")) {
            this.setSSLProperties();
        }
        return new DelegationServiceStub(this.epr);
    }

    public String getEpr() {
        return this.epr;
    }

    public Calendar getFromDate() {
        return this.fromDate;
    }

    public String[] getIdArray() {
        String[] array = null;
        if (this.idList != null) {
            array = new String[this.idList.size()];
            array = this.idList.toArray(array);
        }
        return array;
    }

    public List<String> getIdList() {
        if (this.idList == null) {
            this.idList = new ArrayList<String>(0);
        }
        return this.idList;
    }

    public List<String> getAttributeList() {
        if (this.attributeList == null) {
            this.attributeList = new ArrayList<String>(0);
        }
        return this.attributeList;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getNotifyMessageType() {
        return this.notifyMessageType;
    }

    public String getQuery() {
        return this.query;
    }

    public ResourceInfoServiceStub getResourceInfoServiceStub() throws AxisFault {
        if (this.epr == null) {
            throw new AxisFault("epr not specified!");
        }
        if (this.epr.startsWith("https")) {
            this.setSSLProperties();
        }
        return new ResourceInfoServiceStub(this.epr);
    }

    public List<String> getStatusList() {
        if (this.statusList == null) {
            this.statusList = new ArrayList<String>(0);
        }
        return this.statusList;
    }

    public Calendar getToDate() {
        return this.toDate;
    }

    public boolean isCancelActivity() {
        return this.isCancelActivity;
    }

    public boolean isDestroy() {
        return this.isDestroy;
    }

    public boolean isGetActivityInfo() {
        return this.isGetActivityInfo;
    }

    public boolean isGetActivityStatus() {
        return this.isGetActivityStatus;
    }

    public boolean isGetDelegationInfo() {
        return this.isGetDelegationInfo;
    }

    public boolean isGetInterfaceVersion() {
        return this.isGetInterfaceVersion;
    }

    public boolean isGetNewProxyRequest() {
        return this.isGetNewProxyRequest;
    }

    public boolean isGetProxyRequest() {
        return this.isGetProxyRequest;
    }

    public boolean isGetResourceInfo() {
        return this.isGetResourceInfo;
    }

    public boolean isGetTerminationTime() {
        return this.isGetTerminationTime;
    }

    public boolean isGetVersion() {
        return this.isGetVersion;
    }

    public boolean isListActivities() {
        return this.isListActivities;
    }

    public boolean isNotifyService() {
        return this.notifyMessageType != null;
    }

    public boolean isPauseActivity() {
        return this.isPauseActivity;
    }

    public boolean isQueryResourceInfo() {
        return this.isQueryResourceInfo;
    }

    public boolean isRenew() {
        return this.isRenew;
    }

    public boolean isRenewProxyRequest() {
        return this.isRenewProxyRequest;
    }

    public boolean isResumeActivity() {
        return this.isResumeActivity;
    }

    public boolean isWipeActivity() {
        return this.isWipeActivity;
    }

    private void parseArguments(String[] args, List<String> options) {
        String[] opt;
        StringTokenizer st;
        String statuses;
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option getHelpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option eprOpt = null;
        CmdLineParser.Option statusOpt = null;
        CmdLineParser.Option fromOpt = null;
        CmdLineParser.Option toOpt = null;
        CmdLineParser.Option limitOpt = null;
        CmdLineParser.Option proxyOpt = null;
        CmdLineParser.Option renewOpt = null;
        CmdLineParser.Option activityInfoOpt = null;
        CmdLineParser.Option getVersionOpt = null;
        CmdLineParser.Option getInterfaceVersionOpt = null;
        CmdLineParser.Option getTerminationTimeOpt = null;
        CmdLineParser.Option getNewProxyRequestOpt = null;
        CmdLineParser.Option getProxyRequestOpt = null;
        CmdLineParser.Option renewProxyRequestOpt = null;
        CmdLineParser.Option destroyOpt = null;
        CmdLineParser.Option cancelOpt = null;
        CmdLineParser.Option pauseOpt = null;
        CmdLineParser.Option resumeOpt = null;
        CmdLineParser.Option wipeOpt = null;
        CmdLineParser.Option getStatusOpt = null;
        CmdLineParser.Option notifyServiceOpt = null;
        CmdLineParser.Option listActivitiesOpt = null;
        CmdLineParser.Option getResourceInfoOpt = null;
        CmdLineParser.Option queryResourceInfoOpt = null;
        CmdLineParser.Option attributeListOpt = null;
        if (options.contains(PROXY)) {
            proxyOpt = parser.addStringOption('x', "proxy");
        }
        if (options.contains(EPR)) {
            eprOpt = parser.addStringOption('e', "epr");
        }
        if (options.contains(STATUS)) {
            statusOpt = parser.addStringOption('s', "status");
        }
        if (options.contains(GET_ACTIVITY_INFO)) {
            activityInfoOpt = parser.addBooleanOption('i', "info");
            attributeListOpt = parser.addStringOption('a', "attributes");
        }
        if (options.contains(GET_VERSION)) {
            getVersionOpt = parser.addBooleanOption('v', "version");
        }
        if (options.contains(GET_INTERFACE_VERSION)) {
            getInterfaceVersionOpt = parser.addBooleanOption('i', "interfaceversion");
        }
        if (options.contains(GET_TERMINATION_TIME)) {
            getTerminationTimeOpt = parser.addBooleanOption('t', "termination");
        }
        if (options.contains(GET_PROXY_REQUEST)) {
            getProxyRequestOpt = parser.addBooleanOption('g', "getreq");
        }
        if (options.contains(GET_NEW_PROXY_REQUEST)) {
            getNewProxyRequestOpt = parser.addBooleanOption('n', "newreq");
        }
        if (options.contains(RENEW_PROXY_REQUEST)) {
            renewProxyRequestOpt = parser.addBooleanOption('r', "renewreq");
        }
        if (options.contains(DESTROY)) {
            destroyOpt = parser.addBooleanOption('d', "destroy");
        }
        if (options.contains(GET_RESOURCE_INFO)) {
            getResourceInfoOpt = parser.addBooleanOption('i', "info");
        }
        if (options.contains(QUERY_RESOURCE_INFO)) {
            queryResourceInfoOpt = parser.addStringOption('q', "query");
        }
        if (options.contains(LIST_ACTIVITIES)) {
            listActivitiesOpt = parser.addBooleanOption('l', "listActivities");
            fromOpt = parser.addStringOption('f', "fromDate");
            toOpt = parser.addStringOption('t', "toDate");
            limitOpt = parser.addIntegerOption("limit");
        }
        if (options.contains(NOTIFY_SERVICE)) {
            notifyServiceOpt = parser.addStringOption('n', "notify");
        }
        if (options.contains(CANCEL_ACTIVITY)) {
            cancelOpt = parser.addBooleanOption('c', "cancel");
        }
        if (options.contains(PAUSE_ACTIVITY)) {
            pauseOpt = parser.addBooleanOption('p', "pause");
        }
        if (options.contains(RESUME_ACTIVITY)) {
            resumeOpt = parser.addBooleanOption('r', "resume");
        }
        if (options.contains(WIPE_ACTIVITY)) {
            wipeOpt = parser.addBooleanOption('w', "wipe");
        }
        if (options.contains(GET_ACTIVITY_STATUS)) {
            getStatusOpt = parser.addBooleanOption('s', "getStatus");
        }
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            this.printUsage();
        }
        Boolean getHelp = (Boolean)parser.getOptionValue(getHelpOpt, Boolean.FALSE);
        if (getHelp.booleanValue()) {
            this.printUsage();
        }
        if (proxyOpt != null) {
            this.proxy = (String)parser.getOptionValue(proxyOpt);
        }
        if (eprOpt != null) {
            this.epr = (String)parser.getOptionValue(eprOpt);
            if (this.epr == null) {
                this.printUsage();
            }
        }
        if (queryResourceInfoOpt != null) {
            this.isQueryResourceInfo = true;
            this.setQuery((String)parser.getOptionValue(queryResourceInfoOpt));
        }
        if (statusOpt != null && (statuses = (String)parser.getOptionValue(statusOpt, null)) != null && (st = new StringTokenizer(statuses, ":")).countTokens() > 0) {
            this.statusList = new ArrayList<String>(st.countTokens());
            while (st.hasMoreTokens()) {
                this.statusList.add(st.nextToken());
            }
        }
        if (renewOpt != null) {
            this.isRenew = (Boolean)parser.getOptionValue(renewOpt, Boolean.FALSE);
        }
        if (activityInfoOpt != null) {
            this.isGetActivityInfo = (Boolean)parser.getOptionValue(activityInfoOpt, Boolean.FALSE);
            String attributes = (String)parser.getOptionValue(attributeListOpt);
            if (attributes != null) {
                st = new StringTokenizer(attributes, ":");
                this.attributeList = new ArrayList<String>(0);
                while (st.hasMoreTokens()) {
                    this.attributeList.add(st.nextToken());
                }
            }
        }
        if (listActivitiesOpt != null) {
            this.isListActivities = (Boolean)parser.getOptionValue(listActivitiesOpt, Boolean.FALSE);
            this.limit = (Integer)parser.getOptionValue(limitOpt, -1);
            String dateStr = (String)parser.getOptionValue(toOpt, null);
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy-HH:mm:ss");
            if (dateStr != null) {
                try {
                    this.toDate = new GregorianCalendar();
                    this.toDate.setTime(df.parse(dateStr));
                }
                catch (ParseException e) {
                    this.toDate = null;
                    System.err.println("Invalid --end date " + dateStr + "; ignored");
                }
            }
            if ((dateStr = (String)parser.getOptionValue(fromOpt, null)) != null) {
                try {
                    this.fromDate = new GregorianCalendar();
                    this.fromDate.setTime(df.parse(dateStr));
                }
                catch (ParseException e) {
                    this.fromDate = null;
                    System.err.println("Invalid --from date " + dateStr + "; ignored");
                }
            }
        }
        if (notifyServiceOpt != null) {
            this.notifyMessageType = (String)parser.getOptionValue(notifyServiceOpt);
        }
        if (cancelOpt != null) {
            this.isCancelActivity = (Boolean)parser.getOptionValue(cancelOpt, Boolean.FALSE);
        }
        if (pauseOpt != null) {
            this.isPauseActivity = (Boolean)parser.getOptionValue(pauseOpt, Boolean.FALSE);
        }
        if (resumeOpt != null) {
            this.isResumeActivity = (Boolean)parser.getOptionValue(resumeOpt, Boolean.FALSE);
        }
        if (wipeOpt != null) {
            this.isWipeActivity = (Boolean)parser.getOptionValue(wipeOpt, Boolean.FALSE);
        }
        if (getStatusOpt != null) {
            this.isGetActivityStatus = (Boolean)parser.getOptionValue(getStatusOpt, Boolean.FALSE);
        }
        if (getResourceInfoOpt != null) {
            this.isGetResourceInfo = (Boolean)parser.getOptionValue(getResourceInfoOpt, Boolean.FALSE);
        }
        if (getVersionOpt != null) {
            this.isGetVersion = (Boolean)parser.getOptionValue(getVersionOpt, Boolean.FALSE);
        }
        if (getInterfaceVersionOpt != null) {
            this.isGetInterfaceVersion = (Boolean)parser.getOptionValue(getInterfaceVersionOpt, Boolean.FALSE);
        }
        if (getTerminationTimeOpt != null) {
            this.isGetTerminationTime = (Boolean)parser.getOptionValue(getTerminationTimeOpt, Boolean.FALSE);
        }
        if (getNewProxyRequestOpt != null) {
            this.isGetNewProxyRequest = (Boolean)parser.getOptionValue(getNewProxyRequestOpt, Boolean.FALSE);
        }
        if (getProxyRequestOpt != null) {
            this.isGetProxyRequest = (Boolean)parser.getOptionValue(getProxyRequestOpt, Boolean.FALSE);
        }
        if (renewProxyRequestOpt != null) {
            this.isRenewProxyRequest = (Boolean)parser.getOptionValue(renewProxyRequestOpt, Boolean.FALSE);
        }
        if (destroyOpt != null) {
            this.isDestroy = (Boolean)parser.getOptionValue(destroyOpt, Boolean.FALSE);
        }
        if ((opt = parser.getRemainingArgs()).length > 0) {
            this.idList = new ArrayList<String>(opt.length);
            for (int i = 0; i < opt.length; ++i) {
                this.idList.add(opt[i]);
            }
        }
    }

    protected void printUsage() {
        System.err.print("usage: " + this.getClass().getName() + " -e|--epr <endpoint> [-h|--help]");
        if (this.options == null) {
            System.err.println();
        } else {
            for (int i = 0; i < this.options.size(); ++i) {
                if (this.options.get(i).equals(ADL)) {
                    System.err.print(" file.adl");
                    continue;
                }
                if (this.options.get(i).equals(PROXY)) {
                    System.err.print(" [-x|--proxy <filePath>]");
                    continue;
                }
                if (this.options.get(i).equals(STATUS)) {
                    System.err.print(" [-s|--status]");
                    continue;
                }
                if (this.options.get(i).equals(DELEGATION_ID)) {
                    System.err.print(" [-d|--delegId <id>]");
                    continue;
                }
                if (this.options.get(i).equals(GET_PROXY_REQUEST)) {
                    System.err.print(" [-g|--getreq id]");
                    continue;
                }
                if (this.options.get(i).equals(GET_NEW_PROXY_REQUEST)) {
                    System.err.print(" [-n|--newreq]");
                    continue;
                }
                if (this.options.get(i).equals(RENEW_PROXY_REQUEST)) {
                    System.err.print(" [-r|--renewreq id]");
                    continue;
                }
                if (this.options.get(i).equals(DESTROY)) {
                    System.err.print(" [-d|--destroy id]");
                    continue;
                }
                if (this.options.get(i).equals(GET_VERSION)) {
                    System.err.print(" [-v|--version]");
                    continue;
                }
                if (this.options.get(i).equals(GET_INTERFACE_VERSION)) {
                    System.err.print(" [-i|--interfaceversion");
                    continue;
                }
                if (this.options.get(i).equals(GET_ACTIVITY_INFO)) {
                    System.err.print(" [-i|--info -a|--attributes attr1:attr2:... <id1 id2 ...>]");
                    continue;
                }
                if (this.options.get(i).equals(GET_RESOURCE_INFO)) {
                    System.err.print(" [-i|--info]");
                    continue;
                }
                if (this.options.get(i).equals(QUERY_RESOURCE_INFO)) {
                    System.err.print(" [-q| --query xpath_query]");
                    continue;
                }
                if (this.options.get(i).equals(NOTIFY_SERVICE)) {
                    System.err.print(" [-n|--notify {dataPushDone | dataPullDone} <id1 id2 ...>]");
                    continue;
                }
                if (this.options.get(i).equals(CANCEL_ACTIVITY)) {
                    System.err.print(" [-c|--cancel <id1 id2 ...>]");
                    continue;
                }
                if (this.options.get(i).equals(PAUSE_ACTIVITY)) {
                    System.err.print(" [-p|--pause <id1 id2 ...>]");
                    continue;
                }
                if (this.options.get(i).equals(RESUME_ACTIVITY)) {
                    System.err.print(" [-r|--resume <id1 id2 ...>]");
                    continue;
                }
                if (this.options.get(i).equals(WIPE_ACTIVITY)) {
                    System.err.print(" [-w|--wipe <id1 id2 ...>]");
                    continue;
                }
                if (this.options.get(i).equals(GET_ACTIVITY_STATUS)) {
                    System.err.print(" [-s|--getStatus <id1 id2 ...>]");
                    continue;
                }
                if (!this.options.get(i).equals(LIST_ACTIVITIES)) continue;
                System.err.print(" [-l|--listActivities -f|--fromDate dd/MM/yyyy-HH:mm:ss -t|--toDate dd/MM/yyyy-HH:mm:ss --limit x <status1:attr1:attr2:.. status2 ...>]");
            }
            System.err.println();
        }
        System.exit(0);
    }

    public void setCancelActivity(boolean isCancelActivity) {
        this.isCancelActivity = isCancelActivity;
    }

    public void setEpr(String epr) {
        this.epr = epr;
    }

    public void setFromDate(Calendar fromDate) {
        this.fromDate = fromDate;
    }

    public void setIsActivityInfo(boolean isGetActivityInfo) {
        this.isGetActivityInfo = isGetActivityInfo;
    }

    public void setIsGetActivityStatus(boolean isGetActivityStatus) {
        this.isGetActivityStatus = isGetActivityStatus;
    }

    public void setIsGetDelegationInfo(boolean isGetDelegationInfo) {
        this.isGetDelegationInfo = isGetDelegationInfo;
    }

    public void setIsPauseActivity(boolean isPauseActivity) {
        this.isPauseActivity = isPauseActivity;
    }

    public void setIsRenew(boolean isRenew) {
        this.isRenew = isRenew;
    }

    public void setisRResumeActivity(boolean isResumeActivity) {
        this.isResumeActivity = isResumeActivity;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private void setSSLProperties() throws AxisFault {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new AXIS2SocketFactory(), 8443));
        Properties sslConfig = new Properties();
        sslConfig.put("sslProtocol", "SSLv3");
        sslConfig.put("sslCAFiles", "/etc/grid-security/certificates/*.0");
        sslConfig.put("crlEnabled", "true");
        sslConfig.put("crlFiles", "/etc/grid-security/certificates/*.r0");
        sslConfig.put("crlUpdateInterval", "0s");
        if (this.proxy != null) {
            sslConfig.put("gridProxyFile", this.proxy);
        } else {
            GrDProxyDlgorOptions dlgorOpt;
            String confFileName = System.getProperty("user.home") + "/.glite/dlgor.properties";
            try {
                dlgorOpt = new GrDProxyDlgorOptions(confFileName);
            }
            catch (IOException e) {
                throw new AxisFault(e.getMessage());
            }
            String proxyFilename = dlgorOpt.getDlgorProxyFile();
            if (proxyFilename != null) {
                sslConfig.put("gridProxyFile", proxyFilename);
            } else {
                String certFilename = dlgorOpt.getDlgorCertFile();
                if (certFilename == null || "".equals(certFilename)) {
                    throw new AxisFault("Missing user credentials: issuerCertFile not found in " + confFileName);
                }
                String keyFilename = dlgorOpt.getDlgorKeyFile();
                if (certFilename == null || "".equals(certFilename)) {
                    throw new AxisFault("Missing user credentials: issuerKeyFile not found in " + confFileName);
                }
                String passwd = dlgorOpt.getDlgorPass();
                passwd = passwd == null ? "" : passwd;
                sslConfig.put("sslCertFile", certFilename);
                sslConfig.put("sslKey", keyFilename);
                sslConfig.put("sslKeyPasswd", passwd);
            }
        }
        AXIS2SocketFactory.setCurrentProperties((Properties)sslConfig);
    }

    public void setStatus(List<String> statusList) {
        this.statusList = statusList;
    }

    public void setToDate(Calendar toDate) {
        this.toDate = toDate;
    }

    public void setWipeActivity(boolean isWipeActivity) {
        this.isWipeActivity = isWipeActivity;
    }

    protected String signRequest(String certReq) throws IOException {
        String strX509CertChain = null;
        String proxyFile = this.proxy;
        if (proxyFile == null) {
            String confFileName = System.getProperty("user.home") + "/.glite/dlgor.properties";
            GrDProxyDlgorOptions dlgorOpt = new GrDProxyDlgorOptions(confFileName);
            proxyFile = dlgorOpt.getDlgorCertFile();
        }
        try {
            GrDProxyGenerator proxyGenerator = new GrDProxyGenerator();
            byte[] x509Cert = proxyGenerator.x509MakeProxyCert(certReq.getBytes(), GrDPX509Util.getFilesBytes((File)new File(proxyFile)), "null");
            strX509CertChain = new String(x509Cert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strX509CertChain;
    }
}

