/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.glite.ce.cream.client.JobCommand;
import org.glite.ce.creamapi.ws.cream2.Authorization_Fault;
import org.glite.ce.creamapi.ws.cream2.Generic_Fault;
import org.glite.ce.creamapi.ws.cream2.InvalidArgument_Fault;
import org.glite.ce.creamapi.ws.cream2.types.BaseFaultType;
import org.glite.ce.creamapi.ws.cream2.types.JobStatusResult;
import org.glite.ce.creamapi.ws.cream2.types.Status;

public class JobStatus
extends JobCommand {
    public JobStatus(String[] args, List<String> options) throws RuntimeException {
        super(args, options);
    }

    @Override
    public void execute() {
        JobStatusResult[] result = null;
        try {
            result = this.getCREAMStub().jobStatus(this.getJobIdList(), this.getStatus(), this.getFromDate(), this.getToDate(), this.getDelegationId(), this.getLeaseId());
        }
        catch (Authorization_Fault e) {
            this.printFault((BaseFaultType)e.getFaultMessage());
        }
        catch (Generic_Fault gf) {
            if (gf.getFaultMessage() != null) {
                this.printFault((BaseFaultType)gf.getFaultMessage().getGenericFault());
            }
        }
        catch (InvalidArgument_Fault e) {
            this.printFault((BaseFaultType)e.getFaultMessage());
        }
        catch (AxisFault e) {
            this.printFault(e);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return;
        }
        for (int i = 0; i < result.length; ++i) {
            System.out.println("-----------------------------------------------------------------------------");
            System.out.println("" + i + ") " + result[i].getJobDescriptionId() + "\n");
            if (result[i].getJobStatus() != null) {
                Status status = result[i].getJobStatus();
                System.out.println("jobId = " + status.getJobId().getId());
                System.out.println("name = " + status.getName());
                System.out.println("timestamp = " + status.getTimestamp().getTime());
                if (status.getDescription() != null) {
                    System.out.println("description = " + status.getDescription());
                }
                if (status.getFailureReason() != null) {
                    System.out.println("failure reason = " + status.getFailureReason());
                }
                if (status.getExitCode() == null) continue;
                System.out.println("exit code = " + status.getExitCode());
                continue;
            }
            if (result[i].getDateMismatchFault() != null) {
                this.printFault((BaseFaultType)result[i].getDateMismatchFault());
                continue;
            }
            if (result[i].getDelegationIdMismatchFault() != null) {
                this.printFault((BaseFaultType)result[i].getDelegationIdMismatchFault());
                continue;
            }
            if (result[i].getGenericFault() != null) {
                this.printFault((BaseFaultType)result[i].getGenericFault());
                continue;
            }
            if (result[i].getJobStatusInvalidFault() != null) {
                this.printFault((BaseFaultType)result[i].getJobStatusInvalidFault());
                continue;
            }
            if (result[i].getJobUnknownFault() != null) {
                this.printFault((BaseFaultType)result[i].getJobUnknownFault());
                continue;
            }
            if (result[i].getLeaseIdMismatchFault() == null) continue;
            this.printFault((BaseFaultType)result[i].getLeaseIdMismatchFault());
        }
    }

    public static void main(String[] args) {
        ArrayList<String> options = new ArrayList<String>(8);
        options.add("epr");
        options.add("proxy");
        options.add("status");
        options.add("allJobs");
        options.add("delegationId");
        options.add("leaseId");
        options.add("fromDate");
        options.add("toDate");
        new JobStatus(args, options);
    }
}

