/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client;

import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.glite.ce.cream.client.JobCommand;
import org.glite.ce.creamapi.ws.cream2.Authorization_Fault;
import org.glite.ce.creamapi.ws.cream2.Generic_Fault;
import org.glite.ce.creamapi.ws.cream2.InvalidArgument_Fault;
import org.glite.ce.creamapi.ws.cream2.JobSubmissionDisabled_Fault;
import org.glite.ce.creamapi.ws.cream2.types.BaseFaultType;
import org.glite.ce.creamapi.ws.cream2.types.JobDescription;
import org.glite.ce.creamapi.ws.cream2.types.JobId;
import org.glite.ce.creamapi.ws.cream2.types.JobRegisterResult;
import org.glite.ce.creamapi.ws.cream2.types.Property;
import org.glite.ce.security.delegation.DelegationException_Fault;
import org.glite.ce.security.delegation.DelegationServiceStub;

public class JobRegister
extends JobCommand {
    public JobRegister(String[] args, List<String> options) throws RuntimeException {
        super(args, options);
    }

    @Override
    protected void execute() {
        String delegProxy = null;
        if (this.isDelegate()) {
            try {
                DelegationServiceStub delegationServiceStub = this.getDelegationServiceStub();
                String pkcs10 = delegationServiceStub.getProxyReq(this.getDelegationId());
                delegProxy = this.signRequest(pkcs10, this.getDelegationId());
            }
            catch (DelegationException_Fault e) {
                System.out.println(e.getFaultMessage());
            }
            catch (AxisFault e) {
                this.printFault(e);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                System.out.println("error: " + e.getMessage());
            }
        }
        try {
            String[] jdlFileArray = this.getJdlFileArray();
            if (jdlFileArray == null) {
                System.out.println("no jdl specified!");
                return;
            }
            JobDescription[] jobDescr = new JobDescription[jdlFileArray.length];
            for (int i = 0; i < jdlFileArray.length; ++i) {
                String jdl = this.readFile(jdlFileArray[i]);
                jobDescr[i] = new JobDescription();
                jobDescr[i].setJobDescriptionId("" + i);
                jobDescr[i].setJDL(jdl);
                jobDescr[i].setAutoStart(this.isAutostart());
                jobDescr[i].setDelegationId(this.getDelegationId());
                jobDescr[i].setDelegationProxy(delegProxy);
                jobDescr[i].setLeaseId(this.getLeaseId());
            }
            JobRegisterResult[] result = this.getCREAMStub().jobRegister(jobDescr, null);
            for (int i = 0; i < result.length; ++i) {
                System.out.println("job descrption id: " + result[i].getJobDescriptionId());
                if (result[i].getJobId() != null) {
                    JobId jobId = result[i].getJobId();
                    System.out.println("jobId: " + jobId.getId());
                    System.out.println("cream url: " + jobId.getCreamURL());
                    Property[] property = jobId.getProperty();
                    if (property == null) continue;
                    for (int x = 0; x < property.length; ++x) {
                        System.out.println("property: name=" + property[x].getName() + " value=\"" + property[x].getValue());
                    }
                    continue;
                }
                System.out.println("fault returned: ");
                if (result[i].getDelegationProxyFault() != null) {
                    this.printFault((BaseFaultType)result[i].getDelegationProxyFault());
                    continue;
                }
                if (result[i].getDelegationIdMismatchFault() != null) {
                    this.printFault((BaseFaultType)result[i].getDelegationIdMismatchFault());
                    continue;
                }
                if (result[i].getGenericFault() != null) {
                    this.printFault((BaseFaultType)result[i].getGenericFault());
                    continue;
                }
                if (result[i].getLeaseIdMismatchFault() == null) continue;
                this.printFault((BaseFaultType)result[i].getLeaseIdMismatchFault());
            }
        }
        catch (Authorization_Fault e) {
            this.printFault((BaseFaultType)e.getFaultMessage());
        }
        catch (JobSubmissionDisabled_Fault e) {
            this.printFault((BaseFaultType)e.getFaultMessage());
        }
        catch (Generic_Fault gf) {
            if (gf.getFaultMessage() != null) {
                this.printFault((BaseFaultType)gf.getFaultMessage().getGenericFault());
            }
        }
        catch (InvalidArgument_Fault e) {
            this.printFault((BaseFaultType)e.getFaultMessage());
        }
        catch (AxisFault e) {
            this.printFault(e);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("error: " + e.getMessage());
        }
    }

    private String readFile(String filename) throws IOException {
        String res = "";
        FileReader in = new FileReader(filename);
        char[] buffer = new char[1024];
        int n = 1;
        while (n > 0) {
            n = in.read(buffer, 0, buffer.length);
            if (n <= 0) continue;
            res = res + new String(buffer, 0, n);
        }
        in.close();
        return res;
    }

    public static void main(String[] args) {
        ArrayList<String> options = new ArrayList<String>(7);
        options.add("epr");
        options.add("proxy");
        options.add("delegationId");
        options.add("leaseId");
        options.add("autostart");
        options.add("delegate");
        options.add("jdlFile");
        new JobRegister(args, options);
    }
}

