/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glite.ce.cream.client.CmdLineParser;
import org.glite.ce.cream.configuration.CommandExecutorConfig;
import org.glite.ce.cream.configuration.ServiceConfig;
import org.glite.ce.cream.jobmanagement.db.table.ArgumentTable;
import org.glite.ce.cream.jobmanagement.db.table.EnviromentTable;
import org.glite.ce.cream.jobmanagement.db.table.ExtraAttributeTable;
import org.glite.ce.cream.jobmanagement.db.table.InputFileTable;
import org.glite.ce.cream.jobmanagement.db.table.JobChildTable;
import org.glite.ce.cream.jobmanagement.db.table.JobCommandTable;
import org.glite.ce.cream.jobmanagement.db.table.JobStatusTable;
import org.glite.ce.cream.jobmanagement.db.table.JobTable;
import org.glite.ce.cream.jobmanagement.db.table.JobTableJobStatusTable;
import org.glite.ce.cream.jobmanagement.db.table.OutputFileTable;
import org.glite.ce.cream.jobmanagement.db.table.OutputSandboxDestURITable;
import org.glite.ce.creamapi.cmdmanagement.CommandException;
import org.glite.ce.creamapi.cmdmanagement.Parameter;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.JobStatus;
import org.glite.ce.creamapi.jobmanagement.db.table.ArgumentTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.EnviromentTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.ExtraAttributeTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.InputFileTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobChildTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobCommandTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobStatusTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.JobTableJobStatusInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.OutputFileTableInterface;
import org.glite.ce.creamapi.jobmanagement.db.table.OutputSandboxDestURITableInterface;

public class JobDBAdminPurger {
    public static final String STATUS = "status";
    public static final String JOB_IDS = "jobIds";
    public static final String CONF_PATH = "conf";
    public static final String FILE_JOB_IDS = "fileJobIds";
    private JobTableInterface jobTable = null;
    private JobTableJobStatusInterface jobTableJobStatusTable = null;
    private EnviromentTableInterface enviromentTable = null;
    private ExtraAttributeTableInterface extraAttributeTable = null;
    private ArgumentTableInterface argumentTable = null;
    private JobChildTableInterface jobChildTable = null;
    private InputFileTableInterface inputFileTable = null;
    private OutputFileTableInterface outputFileTable = null;
    private OutputSandboxDestURITableInterface outputSandboxDestURITable = null;
    private JobCommandTableInterface jobCommandTable = null;
    private JobStatusTableInterface jobStatusTable = null;
    private Hashtable<String, Integer> statusTable = null;
    private Connection connection = null;
    private String userId = null;
    private String creamPurgeSandboxBinPath = null;
    private List<String> options = null;
    private List<String> jobIdL = new ArrayList<String>(0);
    private int[] jobStatusType = null;
    private int[] jobStatusTimestamp = null;
    private String confPathFromCommandLine = null;
    private String fileNameJobIds = null;

    public JobDBAdminPurger(String[] args) throws IllegalArgumentException, CommandException {
        this.options = new ArrayList<String>();
        this.options.add(STATUS);
        this.options.add(JOB_IDS);
        this.options.add(CONF_PATH);
        this.options.add(FILE_JOB_IDS);
        this.statusTable = new Hashtable();
        for (int index = 0; index < JobStatus.statusName.length; ++index) {
            this.statusTable.put(JobStatus.statusName[index].toUpperCase().trim(), index);
        }
        try {
            this.parseArguments(args, this.options);
            this.init();
            this.jobAdminPurger(this.jobIdL, this.jobStatusType);
        }
        catch (Exception ne) {
            throw new CommandException(ne.getMessage());
        }
        finally {
            this.destroy();
        }
    }

    public void jobAdminPurger(List<String> jobIdList, int[] jobStatusType) throws CommandException {
        System.out.println("START jobAdminPurger");
        List<Object> jobIdListToCancel = new ArrayList(0);
        try {
            this.jobTable = new JobTable();
            this.jobTableJobStatusTable = new JobTableJobStatusTable();
            this.enviromentTable = new EnviromentTable();
            this.extraAttributeTable = new ExtraAttributeTable();
            this.argumentTable = new ArgumentTable();
            this.jobChildTable = new JobChildTable();
            this.inputFileTable = new InputFileTable();
            this.outputFileTable = new OutputFileTable();
            this.outputSandboxDestURITable = new OutputSandboxDestURITable();
            this.jobCommandTable = new JobCommandTable();
            this.jobStatusTable = new JobStatusTable();
        }
        catch (SQLException de) {
            throw new CommandException(de.getMessage());
        }
        Calendar endStatusDate = null;
        if (jobStatusType != null) {
            Object var5_6 = null;
            for (int index = 0; index < jobStatusType.length; ++index) {
                try {
                    List list;
                    endStatusDate = null;
                    if (this.jobStatusTimestamp[index] != 0) {
                        endStatusDate = GregorianCalendar.getInstance();
                        endStatusDate.add(5, -this.jobStatusTimestamp[index]);
                    }
                    if ((list = this.jobTableJobStatusTable.executeSelectToRetrieveJobId(this.userId, jobIdList, null, new int[]{jobStatusType[index]}, null, null, endStatusDate, null, null, this.connection)) == null) continue;
                    jobIdListToCancel.addAll(list);
                    continue;
                }
                catch (SQLException de) {
                    throw new CommandException("Problem to retrieve jobIds from cream database! " + de.getMessage());
                }
            }
        } else {
            jobIdListToCancel = jobIdList;
        }
        if (jobIdListToCancel != null && jobIdListToCancel.size() > 0) {
            Object var5_9 = null;
            Job job = null;
            for (String string : jobIdListToCancel) {
                System.out.println("-----------------------------------------------------------");
                System.out.println("Job " + string + " is going to be purged ...");
                try {
                    try {
                        job = this.jobTable.executeSelectJobTable(string, this.userId, this.connection);
                    }
                    catch (SQLException de) {
                        throw new CommandException(de.getMessage());
                    }
                    this.purge(job);
                    System.out.println(string + " has been purged!");
                }
                catch (CommandException ce) {
                    System.err.println("Job " + string + ": ERROR -> " + ce.getMessage());
                }
                System.out.println("-----------------------------------------------------------");
                System.out.println();
            }
        } else {
            System.out.println("No jobs to purge!");
        }
        System.out.println("STOP jobAdminPurger");
    }

    private void parseArguments(String[] args, List<String> options) throws IllegalArgumentException {
        String statuses;
        StringTokenizer st;
        String jobIds;
        if (args == null || args.length == 0) {
            this.printUsage();
        }
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option getHelpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option confPathOpt = null;
        CmdLineParser.Option jobIdOpt = null;
        CmdLineParser.Option fileNameJobIdsOpt = null;
        CmdLineParser.Option jobStatusOpt = null;
        if (options.contains(CONF_PATH)) {
            confPathOpt = parser.addStringOption('c', CONF_PATH);
        }
        if (options.contains(JOB_IDS)) {
            jobIdOpt = parser.addStringOption('j', JOB_IDS);
        }
        if (options.contains(FILE_JOB_IDS)) {
            fileNameJobIdsOpt = parser.addStringOption('f', "file");
        }
        if (options.contains(STATUS)) {
            jobStatusOpt = parser.addStringOption('s', STATUS);
        }
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            this.printUsage();
        }
        Boolean getHelp = (Boolean)parser.getOptionValue(getHelpOpt, Boolean.FALSE);
        if (getHelp.booleanValue()) {
            this.printUsage();
        }
        if (confPathOpt != null) {
            this.confPathFromCommandLine = (String)parser.getOptionValue(confPathOpt, null);
        }
        if (jobIdOpt != null && (jobIds = (String)parser.getOptionValue(jobIdOpt, null)) != null && (st = new StringTokenizer(jobIds, ":")).countTokens() > 0) {
            while (st.hasMoreTokens()) {
                this.jobIdL.add(st.nextToken());
            }
        }
        if (fileNameJobIdsOpt != null) {
            this.fileNameJobIds = (String)parser.getOptionValue(fileNameJobIdsOpt, null);
            if (this.fileNameJobIds != null && this.jobIdL.size() == 0) {
                this.jobIdL = this.readFileJobIds(this.fileNameJobIds);
            }
        }
        if (jobStatusOpt != null && (statuses = (String)parser.getOptionValue(jobStatusOpt, null)) != null && (st = new StringTokenizer(statuses, ":")).countTokens() > 0) {
            this.jobStatusType = new int[st.countTokens()];
            this.jobStatusTimestamp = new int[st.countTokens()];
            int index = 0;
            String status = null;
            Integer statusInt = 0;
            String statusTimestamp = null;
            while (st.hasMoreTokens()) {
                status = st.nextToken();
                if (status.indexOf(",") != -1) {
                    statusTimestamp = status.substring(status.indexOf(",") + 1);
                    status = status.substring(0, status.indexOf(","));
                    try {
                        this.jobStatusTimestamp[index] = Integer.parseInt(statusTimestamp);
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("StatusTimestamp must be integer!");
                        throw new IllegalArgumentException("StatusTimestamp must be integer!");
                    }
                } else {
                    this.jobStatusTimestamp[index] = 0;
                }
                status = status.toUpperCase().trim();
                statusInt = this.statusTable.get(status);
                if (statusInt != null) {
                    this.jobStatusType[index++] = statusInt;
                    continue;
                }
                throw new IllegalArgumentException("StatusType " + status + " unknown!");
            }
        }
    }

    private List<String> readFileJobIds(String fileNameJobIds) throws IllegalArgumentException {
        ArrayList<String> jobIdLFromFile = new ArrayList<String>(0);
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(fileNameJobIds);
            br = new BufferedReader(fr);
            String jobId = br.readLine();
            while (jobId != null) {
                jobIdLFromFile.add(jobId.trim());
                jobId = br.readLine();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalArgumentException("The " + fileNameJobIds + " file doesn't exist");
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error reading the " + fileNameJobIds + " file.");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
        return jobIdLFromFile;
    }

    private void printUsage() {
        System.err.println("JobDBAdminPurger\n\n");
        System.err.println("Usage: JobDBAdminPurger.sh  [-c|--conf CREAMConfPath] [-j|--jobIds jobId1:jobId2:...] | [-f|--filejobIds filenameJobIds] | [-s|--status statusType0,deltaTime:statusType1:...] [-h|--help]");
        System.err.println();
        System.err.println("Examples:");
        System.err.println("JobDBAdminPurger.sh  -j CREAM217901296:CREAM324901232");
        System.err.println("JobDBAdminPurger.sh  -s registered:pending:idle");
        System.err.println("JobDBAdminPurger.sh  -s registered,3:pending:idle,5");
        System.err.println("JobDBAdminPurger.sh  -c /etc/glite-ce-cream/cream-config.xml --status registered:idle");
        System.err.println("JobDBAdminPurger.sh  --jobIds CREAM217901296:CREAM324901232");
        System.err.println("JobDBAdminPurger.sh  -f /tmp/jobIdsToPurge.txt");
        System.err.println("where for example jobIdsToPurge.txt contains:");
        System.err.println("CREAM217901296");
        System.err.println("CREAM324901232");
        System.err.println();
        System.err.println();
        System.err.println("Status types:");
        for (int i = 0; i < JobStatus.statusName.length; ++i) {
            System.err.println(JobStatus.statusName[i]);
        }
        System.err.println();
        System.exit(-1);
    }

    private void init() throws Exception {
        String confPath = "/etc/glite-ce-cream/cream-config.xml";
        if (this.confPathFromCommandLine != null) {
            confPath = this.confPathFromCommandLine;
        }
        System.setProperty("cream.configuration.path", confPath);
        ServiceConfig serviceConfiguration = ServiceConfig.getConfiguration();
        if (serviceConfiguration == null) {
            throw new NamingException("Problem to retrieve service configuration!");
        }
        Iterator executorIterator = serviceConfiguration.getCommandExecutorList().iterator();
        boolean executorFound = false;
        CommandExecutorConfig executor = null;
        block0: while (executorIterator.hasNext() && !executorFound) {
            executor = (CommandExecutorConfig)executorIterator.next();
            if (!"BLAH executor".equals(executor.getName())) continue;
            executorFound = true;
            for (Parameter parameter : executor.getParameters()) {
                if (!"CREAM_PURGE_SANDBOX_BIN_PATH".equals(parameter.getName())) continue;
                this.creamPurgeSandboxBinPath = parameter.getValueAsString();
                continue block0;
            }
        }
        DataSource dataSource = (DataSource)serviceConfiguration.getDataSources().get("datasource_creamdb");
        if (dataSource == null) {
            throw new Exception("Datasource for the creamdb database not specified in the configuration file " + confPath);
        }
        this.connection = dataSource.getConnection();
        this.connection.setAutoCommit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void purge(Job job) throws CommandException, IllegalArgumentException {
        block66: {
            if (job == null) {
                throw new CommandException("job not found!");
            }
            String workingDir = job.getWorkingDirectory();
            if (this.isEmptyField(workingDir)) break block66;
            if (this.creamPurgeSandboxBinPath == null) {
                throw new CommandException("CREAM_PURGE_SANDBOX_BIN_PATH parameter not found!");
            }
            Process proc = null;
            try {
                String[] cmd = new String[]{this.creamPurgeSandboxBinPath, workingDir};
                proc = Runtime.getRuntime().exec(cmd);
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
            }
            finally {
                block67: {
                    StringBuffer errorMessage;
                    block68: {
                        block69: {
                            if (proc == null) break block67;
                            try {
                                proc.waitFor();
                            }
                            catch (InterruptedException e) {}
                            errorMessage = null;
                            if (proc.exitValue() == 0) break block68;
                            BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            errorMessage = new StringBuffer();
                            String inputLine = null;
                            while ((inputLine = readErr.readLine()) != null) {
                                errorMessage.append(inputLine);
                            }
                            try {
                                readErr.close();
                            }
                            catch (IOException ioe) {}
                            break block69;
                            catch (IOException ioe) {
                                try {
                                    System.err.println(ioe.getMessage());
                                }
                                catch (Throwable throwable) {
                                    try {
                                        readErr.close();
                                    }
                                    catch (IOException ioe2) {}
                                    throw throwable;
                                }
                                try {
                                    readErr.close();
                                }
                                catch (IOException ioe3) {}
                            }
                        }
                        if (errorMessage.length() > 0) {
                            errorMessage.append("\n");
                        }
                    }
                    try {
                        proc.getInputStream().close();
                    }
                    catch (IOException ioe) {}
                    try {
                        proc.getErrorStream().close();
                    }
                    catch (IOException ioe) {}
                    try {
                        proc.getOutputStream().close();
                    }
                    catch (IOException ioe) {}
                    if (errorMessage != null) {
                        throw new CommandException(errorMessage.toString());
                    }
                }
            }
        }
        try {
            this.deleteJob(job.getId(), this.connection);
        }
        catch (SQLException e) {
            throw new CommandException(e.getMessage());
        }
    }

    private boolean isEmptyField(String field) {
        return field == null || "N/A".equals(field) || field.length() == 0;
    }

    private void deleteJob(String jobId, Connection connection) throws SQLException {
        try {
            this.enviromentTable.executeDelete(jobId, connection);
            this.extraAttributeTable.executeDelete(jobId, connection);
            this.argumentTable.executeDelete(jobId, connection);
            this.jobChildTable.executeDelete(jobId, connection);
            this.inputFileTable.executeDelete(jobId, connection);
            this.outputFileTable.executeDelete(jobId, connection);
            this.outputSandboxDestURITable.executeDelete(jobId, connection);
            this.jobCommandTable.executeDelete(jobId, connection);
            this.jobStatusTable.executeDelete(jobId, connection);
            this.jobTable.executeDelete(jobId, connection);
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sqle) {
                throw new SQLException("Rollback is fault. ERRORCODE = " + sqle.getErrorCode() + "Message =  " + sqle.getMessage());
            }
            throw new SQLException("Rollback executed due to: " + e.getMessage());
        }
    }

    private void destroy() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws IllegalArgumentException {
        try {
            JobDBAdminPurger jobDBAdminPurger = new JobDBAdminPurger(args);
        }
        catch (CommandException ce) {
            System.err.println("JobDBAdminPurger error: " + ce.getMessage());
        }
    }
}

