/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.glite.ce.cream.client.JobCommand;
import org.glite.ce.creamapi.ws.cream2.Authorization_Fault;
import org.glite.ce.creamapi.ws.cream2.Generic_Fault;
import org.glite.ce.creamapi.ws.cream2.InvalidArgument_Fault;
import org.glite.ce.creamapi.ws.cream2.types.BaseFaultType;
import org.glite.ce.creamapi.ws.cream2.types.Lease;

public class GetLease
extends JobCommand {
    public GetLease(String[] args, List<String> options) throws RuntimeException {
        super(args, options);
    }

    @Override
    public void execute() {
        try {
            if (this.getLeaseId() != null) {
                this.printLease(this.getCREAMStub().getLease(this.getLeaseId()));
            } else {
                Lease[] lease = this.getCREAMStub().getLeaseList();
                if (lease != null) {
                    for (int i = 0; i < lease.length; ++i) {
                        this.printLease(lease[i]);
                    }
                }
            }
        }
        catch (Authorization_Fault e) {
            this.printFault((BaseFaultType)e.getFaultMessage());
        }
        catch (Generic_Fault gf) {
            if (gf.getFaultMessage() != null) {
                this.printFault((BaseFaultType)gf.getFaultMessage().getGenericFault());
            }
        }
        catch (InvalidArgument_Fault e) {
            this.printFault((BaseFaultType)e.getFaultMessage());
        }
        catch (AxisFault e) {
            this.printFault(e);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void printLease(Lease lease) {
        if (lease == null) {
            return;
        }
        System.out.println("lease id = " + lease.getLeaseId() + " time = " + lease.getLeaseTime().getTime());
    }

    public static void main(String[] args) {
        ArrayList<String> options = new ArrayList<String>(3);
        options.add("epr");
        options.add("proxy");
        options.add("leaseId");
        new GetLease(args, options);
    }
}

