/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.client;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.glite.ce.cream.client.JobCommand;
import org.glite.ce.security.delegation.DelegationException_Fault;
import org.glite.ce.security.delegation.DelegationServiceStub;

public class DelegationClient
extends JobCommand {
    public DelegationClient(String[] args, List<String> options) throws RuntimeException {
        super(args, options);
    }

    @Override
    public void execute() {
        if (this.getDelegationId() == null) {
            this.printUsage();
        }
        try {
            String pkcs10 = null;
            DelegationServiceStub delegationServiceStub = this.getDelegationServiceStub();
            pkcs10 = this.isRenew() ? delegationServiceStub.renewProxyReq(this.getDelegationId()) : delegationServiceStub.getProxyReq(this.getDelegationId());
            if (pkcs10 == null) {
                System.out.println("cannot get the certificate request!");
                System.exit(0);
            }
            String request = this.signRequest(pkcs10, this.getDelegationId());
            delegationServiceStub.putProxy(this.getDelegationId(), request);
        }
        catch (DelegationException_Fault e) {
            System.out.println(e.getFaultMessage());
        }
        catch (AxisFault e) {
            this.printFault(e);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("error: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        ArrayList<String> options = new ArrayList<String>(4);
        options.add("epr");
        options.add("proxy");
        options.add("delegationId");
        options.add("renew");
        new DelegationClient(args, options);
    }
}

