/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.db.table.OutputSandboxDestURITableInterface;

public class OutputSandboxDestURITable
implements OutputSandboxDestURITableInterface {
    public static final String NAME_TABLE = "output_sandbox_dest_URI";
    public static final String VALUE_FIELD = "value";
    public static final String JOB_ID_FIELD = "jobId";
    private static final String insertQuery = OutputSandboxDestURITable.getInsertQuery();
    private static final String selectQuery = OutputSandboxDestURITable.getSelectQuery();
    private static final String deleteQuery = OutputSandboxDestURITable.getDeleteQuery();
    private static final Logger logger = Logger.getLogger(OutputSandboxDestURITable.class);

    public OutputSandboxDestURITable() throws SQLException {
        logger.debug((Object)"Call OutputSandboxDestURITable constructor");
    }

    public int executeInsert(String jobId, List<String> outputSandboxDestURIList, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeInsert");
        PreparedStatement insertPreparedStatement = null;
        int rowCountTot = 0;
        try {
            insertPreparedStatement = connection.prepareStatement(insertQuery);
            int rowCount = 0;
            for (String outputSandboxDestURI : outputSandboxDestURIList) {
                insertPreparedStatement = this.fillInsertPreparedStatement(jobId, outputSandboxDestURI, insertPreparedStatement);
                rowCount = insertPreparedStatement.executeUpdate();
                insertPreparedStatement.clearParameters();
                rowCountTot += rowCount;
            }
            logger.debug((Object)("Rows inserted: " + rowCountTot));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (insertPreparedStatement != null) {
                try {
                    insertPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeInsert");
        return rowCountTot;
    }

    public List<String> executeSelect(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)("Begin executeSelect for jobId = " + jobId));
        ArrayList<String> outputSandboxDestURIList = new ArrayList<String>(0);
        Object outputSandboxDestURI = null;
        PreparedStatement selectPreparedStatement = null;
        try {
            selectPreparedStatement = connection.prepareStatement(selectQuery);
            selectPreparedStatement = this.fillSelectPreparedStatement(jobId, selectPreparedStatement);
            ResultSet resultSet = selectPreparedStatement.executeQuery();
            while (resultSet.next()) {
                outputSandboxDestURIList.add(resultSet.getString(VALUE_FIELD));
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectPreparedStatement != null) {
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)("End executeSelect for jobId = " + jobId));
        return outputSandboxDestURIList;
    }

    public int executeDelete(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)("Begin executeDelete for jobid = " + jobId));
        PreparedStatement deletePreparedStatement = null;
        int rowCount = 0;
        try {
            deletePreparedStatement = connection.prepareStatement(deleteQuery);
            deletePreparedStatement = this.fillDeletePreparedStatement(jobId, deletePreparedStatement);
            rowCount = deletePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)("End executeDelete for jobid = " + jobId));
        return rowCount;
    }

    private PreparedStatement fillInsertPreparedStatement(String jobId, String outputSandboxDestURI, PreparedStatement insertPreparedStatement) throws SQLException {
        insertPreparedStatement.setString(1, outputSandboxDestURI);
        insertPreparedStatement.setString(2, jobId);
        return insertPreparedStatement;
    }

    private PreparedStatement fillDeletePreparedStatement(String jobId, PreparedStatement deletePreparedStatement) throws SQLException {
        deletePreparedStatement.setString(1, jobId);
        return deletePreparedStatement;
    }

    private PreparedStatement fillSelectPreparedStatement(String jobId, PreparedStatement selectPreparedStatement) throws SQLException {
        selectPreparedStatement.setString(1, jobId);
        return selectPreparedStatement;
    }

    private static String getInsertQuery() {
        StringBuffer insertQuery = new StringBuffer();
        insertQuery.append("insert into ");
        insertQuery.append(NAME_TABLE);
        insertQuery.append(" ( ");
        insertQuery.append("value, ");
        insertQuery.append(JOB_ID_FIELD);
        insertQuery.append(" ) ");
        insertQuery.append("values(?, ?)");
        return insertQuery.toString();
    }

    private static String getDeleteQuery() {
        StringBuffer deleteQuery = new StringBuffer();
        deleteQuery.append("delete from ");
        deleteQuery.append(NAME_TABLE);
        deleteQuery.append(" where ");
        deleteQuery.append("jobId = ?");
        return deleteQuery.toString();
    }

    private static String getSelectQuery() {
        StringBuffer selectQuery = new StringBuffer();
        selectQuery.append("select ");
        selectQuery.append(VALUE_FIELD);
        selectQuery.append(" from output_sandbox_dest_URI");
        selectQuery.append(" where ");
        selectQuery.append("jobId = ?");
        return selectQuery.toString();
    }
}

