/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.command.JobCommand;
import org.glite.ce.creamapi.jobmanagement.db.table.JobTableJobStatusJobCommandInterface;

public class JobTableJobStatusTableJobCommandTable
implements JobTableJobStatusJobCommandInterface {
    private static final Logger logger = Logger.getLogger((String)JobTableJobStatusTableJobCommandTable.class.getName());

    public JobTableJobStatusTableJobCommandTable() throws SQLException {
        logger.debug((Object)"Call JobTableJobStatusTableJobCommandTable constructor");
    }

    public void executeInsert(JobCommand jobCommand, String delegationId, int[] jobStatusType, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeInsert");
        StringBuffer insertQuery = new StringBuffer("insert into ");
        insertQuery.append("job_command").append(" (");
        insertQuery.append("jobId").append(", ");
        insertQuery.append("statusType").append(", ");
        insertQuery.append("type").append(", ");
        insertQuery.append("description").append(", ");
        insertQuery.append("failureReason").append(", ");
        insertQuery.append("cmdExecutorName").append(", ");
        insertQuery.append("startSchedulingTime").append(", ");
        insertQuery.append("startProcessingTime").append(", ");
        insertQuery.append("executionCompletedTime").append(", ");
        insertQuery.append("creationTime").append(", ");
        insertQuery.append("userId").append(") select js.jobId, '").append(jobCommand.getStatus()).append("', '");
        insertQuery.append(jobCommand.getType()).append("', ");
        if (jobCommand.getDescription() != null) {
            insertQuery.append("'").append(jobCommand.getDescription()).append("', ");
        } else {
            insertQuery.append(" null, ");
        }
        if (jobCommand.getFailureReason() != null) {
            insertQuery.append("'").append(jobCommand.getFailureReason()).append("', ");
        } else {
            insertQuery.append(" null, ");
        }
        if (jobCommand.getCommandExecutorName() != null) {
            insertQuery.append("'").append(jobCommand.getCommandExecutorName()).append("', ");
        } else {
            insertQuery.append(" null, ");
        }
        if (jobCommand.getStartSchedulingTime() != null) {
            insertQuery.append("'").append(new Timestamp(jobCommand.getStartSchedulingTime().getTimeInMillis())).append("', ");
        } else {
            insertQuery.append(" null, ");
        }
        if (jobCommand.getStartProcessingTime() != null) {
            insertQuery.append("'").append(new Timestamp(jobCommand.getStartProcessingTime().getTimeInMillis())).append("', ");
        } else {
            insertQuery.append(" null, ");
        }
        if (jobCommand.getExecutionCompletedTime() != null) {
            insertQuery.append("'").append(new Timestamp(jobCommand.getExecutionCompletedTime().getTimeInMillis())).append("', ");
        } else {
            insertQuery.append(" null, ");
        }
        if (jobCommand.getCreationTime() != null) {
            insertQuery.append("'").append(new Timestamp(jobCommand.getCreationTime().getTimeInMillis())).append("', ");
        } else {
            insertQuery.append(" null, ");
        }
        String userId = jobCommand.getUserId();
        if (userId == null) {
            userId = "ADMINISTRATOR";
        }
        insertQuery.append("'").append(userId).append("'");
        insertQuery.append(" from ").append("job_status").append(" as js left outer join (");
        insertQuery.append("job_status").append(" as jslatest) on jslatest.").append("jobId").append(" = js.").append("jobId");
        insertQuery.append(" and js.").append("id").append(" < jslatest.").append("id");
        insertQuery.append(" where jslatest.").append("id").append(" is null");
        if (jobStatusType != null && jobStatusType.length > 0) {
            insertQuery.append(" and js.").append("type").append(" in (");
            for (int i = 0; i < jobStatusType.length; ++i) {
                insertQuery.append("'" + jobStatusType[i] + "', ");
            }
            insertQuery.replace(insertQuery.length() - 2, insertQuery.length(), ")");
        }
        insertQuery.append(" and js.").append("jobId").append(" in (select ");
        insertQuery.append("job").append(".").append("id").append(" from ").append("job");
        insertQuery.append(" where ").append("job").append(".").append("delegationProxyId").append(" = '").append(delegationId).append("' and ");
        insertQuery.append("job").append(".").append("userId").append(" = '").append(userId).append("')");
        logger.debug((Object)("insertQuery = " + insertQuery.toString()));
        PreparedStatement st = null;
        try {
            st = connection.prepareStatement(insertQuery.toString());
            int rowCount = st.executeUpdate();
            logger.debug((Object)("" + rowCount + " jobCommand items inserted!"));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeInsert");
    }

    public List<String> executeSelectToRetrieveJobId(String userId, String delegationId, int[] jobStatusType, String leaseId, Calendar startStatusDate, Calendar endStatusDate, Calendar startRegisterCommandDate, Calendar endRegisterCommandDate, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobId");
        ArrayList<String> jobIdList = new ArrayList<String>(0);
        String selectQuery = JobTableJobStatusTableJobCommandTable.getSelectToRetrieveJobIdQuery(userId, delegationId, jobStatusType, leaseId, startStatusDate, endStatusDate, startRegisterCommandDate, endRegisterCommandDate);
        logger.debug((Object)("selectQuery = " + selectQuery));
        PreparedStatement selectToRetrieveJobIdPreparedStatement = connection.prepareStatement(selectQuery);
        ResultSet rs = selectToRetrieveJobIdPreparedStatement.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                jobIdList.add(rs.getString("id"));
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobId");
        return jobIdList;
    }

    private static String getSelectToRetrieveJobIdQuery(String userId, String delegationId, int[] jobStatusType, String leaseId, Calendar startStatusDate, Calendar endStatusDate, Calendar startRegisterCommandDate, Calendar endRegisterCommandDate) {
        StringBuffer selectToRetrieveJobIdQuery = new StringBuffer();
        selectToRetrieveJobIdQuery.append("select distinct ");
        selectToRetrieveJobIdQuery.append("job.id AS id");
        selectToRetrieveJobIdQuery.append(" from job");
        selectToRetrieveJobIdQuery.append(", job_command");
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToRetrieveJobIdQuery.append(", job_status AS job_status LEFT OUTER JOIN job_status AS jslatest ");
            selectToRetrieveJobIdQuery.append("ON jslatest.jobId = job_status.jobId");
            selectToRetrieveJobIdQuery.append(" and job_status.id < jslatest.id");
        }
        selectToRetrieveJobIdQuery.append(" where true ");
        if (userId != null && delegationId != null) {
            selectToRetrieveJobIdQuery.append("and (");
            selectToRetrieveJobIdQuery.append("(iceId IS NOT NULL ");
            selectToRetrieveJobIdQuery.append(" and myProxyServer IS NOT NULL) or (");
            selectToRetrieveJobIdQuery.append("iceId");
            selectToRetrieveJobIdQuery.append(" IS  NULL))");
        }
        if (userId != null) {
            selectToRetrieveJobIdQuery.append(" and job.userId = '" + userId + "'");
        }
        if (delegationId != null) {
            selectToRetrieveJobIdQuery.append(" and delegationProxyId = '" + delegationId + "'");
        }
        if (leaseId != null) {
            selectToRetrieveJobIdQuery.append(" and leaseId = '" + leaseId + "'");
        }
        selectToRetrieveJobIdQuery.append(" and job_command.type = 0 ");
        if (startRegisterCommandDate != null) {
            Timestamp startDateTimestampField = new Timestamp(startRegisterCommandDate.getTimeInMillis());
            selectToRetrieveJobIdQuery.append(" and job_command.creationTime >= '" + startDateTimestampField.toString() + "'");
        }
        if (endRegisterCommandDate != null) {
            Timestamp endDateTimestampField = new Timestamp(endRegisterCommandDate.getTimeInMillis());
            selectToRetrieveJobIdQuery.append(" and job_command.creationTime <= '" + endDateTimestampField.toString() + "'");
        }
        selectToRetrieveJobIdQuery.append(" and job.id = job_command.jobId");
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToRetrieveJobIdQuery.append(" and jslatest.id IS NULL");
            StringBuffer jobStatusTypeList = new StringBuffer();
            for (int i = 0; i < jobStatusType.length; ++i) {
                jobStatusTypeList.append(", '" + jobStatusType[i] + "'");
            }
            jobStatusTypeList.deleteCharAt(0);
            if (startStatusDate != null) {
                Timestamp startStatusDateTimestampField = new Timestamp(startStatusDate.getTimeInMillis());
                selectToRetrieveJobIdQuery.append(" and job_status.time_stamp > '" + startStatusDateTimestampField.toString() + "'");
            }
            if (endStatusDate != null) {
                Timestamp endStatusDateTimestampField = new Timestamp(endStatusDate.getTimeInMillis());
                selectToRetrieveJobIdQuery.append(" and job_status.time_stamp <= '" + endStatusDateTimestampField.toString() + "'");
            }
            selectToRetrieveJobIdQuery.append(" and job_status.type IN (" + jobStatusTypeList.toString() + ")");
            selectToRetrieveJobIdQuery.append(" and job_status.jobId = job.id");
        }
        logger.debug((Object)("selectToRetrieveJobIdQuery = " + selectToRetrieveJobIdQuery.toString()));
        return selectToRetrieveJobIdQuery.toString();
    }
}

