/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.db.table.JobTableJobStatusInterface;

public class JobTableJobStatusTable
implements JobTableJobStatusInterface {
    private static final Logger logger = Logger.getLogger(JobTableJobStatusTable.class);
    private static final String COUNT_JOB = "COUNT_JOB";

    public JobTableJobStatusTable() throws SQLException {
        logger.debug((Object)"Call JobTableJobStatusTable constructor");
    }

    public List<String> executeSelectToRetrieveJobId(String userId, List<String> jobId, String delegationId, int[] jobStatusType, String leaseId, Calendar startStatusDate, Calendar endStatusDate, String queueName, String batchSystem, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobId");
        ArrayList<String> jobIdList = new ArrayList<String>(0);
        String selectQuery = JobTableJobStatusTable.getSelectToRetrieveJobIdQuery(userId, jobId, delegationId, jobStatusType, leaseId, startStatusDate, endStatusDate, queueName, batchSystem);
        logger.debug((Object)("selectQuery = " + selectQuery));
        PreparedStatement selectToRetrieveJobIdPreparedStatement = connection.prepareStatement(selectQuery);
        ResultSet rs = selectToRetrieveJobIdPreparedStatement.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                jobIdList.add(rs.getString("id"));
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobId");
        return jobIdList;
    }

    private static String getSelectToRetrieveJobIdQuery(String userId, List<String> jobId, String delegationId, int[] jobStatusType, String leaseId, Calendar startStatusDate, Calendar endStatusDate, String queueName, String batchSystem) {
        int i;
        StringBuffer selectToRetrieveJobIdQuery = new StringBuffer();
        selectToRetrieveJobIdQuery.append("select ");
        selectToRetrieveJobIdQuery.append("job.id AS id");
        selectToRetrieveJobIdQuery.append(" from job");
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToRetrieveJobIdQuery.append(", job_status AS job_status LEFT OUTER JOIN job_status AS jslatest ");
            selectToRetrieveJobIdQuery.append("ON jslatest.jobId = job_status.jobId");
            selectToRetrieveJobIdQuery.append(" and job_status.id < jslatest.id");
        }
        selectToRetrieveJobIdQuery.append(" where true ");
        if (userId != null && delegationId != null) {
            selectToRetrieveJobIdQuery.append(" and (");
            selectToRetrieveJobIdQuery.append("(iceId IS NOT NULL ");
            selectToRetrieveJobIdQuery.append(" and myProxyServer IS NOT NULL ) ");
            selectToRetrieveJobIdQuery.append(" or (");
            selectToRetrieveJobIdQuery.append("iceId IS  NULL )");
            selectToRetrieveJobIdQuery.append(")");
        }
        if (userId != null) {
            selectToRetrieveJobIdQuery.append(" and userId = '" + userId + "'");
        }
        if (delegationId != null) {
            selectToRetrieveJobIdQuery.append(" and delegationProxyId = '" + delegationId + "'");
        }
        if (leaseId != null) {
            selectToRetrieveJobIdQuery.append(" and leaseId = '" + leaseId + "'");
        }
        if (jobId != null && jobId.size() > 0) {
            StringBuffer jobIdList = new StringBuffer();
            for (i = 0; i < jobId.size(); ++i) {
                jobIdList.append(", '" + jobId.get(i) + "'");
            }
            jobIdList.deleteCharAt(0);
            selectToRetrieveJobIdQuery.append(" and job.id IN (" + jobIdList.toString() + ")");
        }
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToRetrieveJobIdQuery.append(" and jslatest.id IS NULL");
            StringBuffer jobStatusTypeList = new StringBuffer();
            for (i = 0; i < jobStatusType.length; ++i) {
                jobStatusTypeList.append(", '" + jobStatusType[i] + "'");
            }
            jobStatusTypeList.deleteCharAt(0);
            if (startStatusDate != null) {
                Timestamp startStatusDateTimestampField = new Timestamp(startStatusDate.getTimeInMillis());
                selectToRetrieveJobIdQuery.append(" and job_status.time_stamp >= '" + startStatusDateTimestampField.toString() + "'");
            }
            if (endStatusDate != null) {
                Timestamp endStatusDateTimestampField = new Timestamp(endStatusDate.getTimeInMillis());
                selectToRetrieveJobIdQuery.append(" and job_status.time_stamp <= '" + endStatusDateTimestampField.toString() + "'");
            }
            selectToRetrieveJobIdQuery.append(" and job_status.type IN (" + jobStatusTypeList.toString() + ")");
            selectToRetrieveJobIdQuery.append(" and job_status.jobId = job.id");
        }
        if (queueName != null) {
            selectToRetrieveJobIdQuery.append(" and queue = '" + queueName + "'");
        }
        if (batchSystem != null) {
            selectToRetrieveJobIdQuery.append(" and batchSystem = '" + batchSystem + "'");
        }
        logger.debug((Object)("selectToRetrieveJobIdQuery = " + selectToRetrieveJobIdQuery.toString()));
        return selectToRetrieveJobIdQuery.toString();
    }

    public String executeSelectToRetrieveOlderJobIdQuery(int[] jobStatusType, String batchSystem, String userId, Connection connection) throws SQLException {
        String jobId = null;
        String selectToRetrieveOlderJobIdQuery = JobTableJobStatusTable.getSelectToRetrieveOlderJobIdQuery(userId, jobStatusType, batchSystem);
        logger.debug((Object)("SelectToRetrieveOlderJobIdQuery = " + selectToRetrieveOlderJobIdQuery));
        PreparedStatement ps = connection.prepareStatement(selectToRetrieveOlderJobIdQuery);
        ResultSet rs = ps.executeQuery();
        if (rs != null && rs.next()) {
            jobId = rs.getString("jobId");
        }
        return jobId;
    }

    private static String getSelectToRetrieveOlderJobIdQuery(String userId, int[] jobStatusType, String batchSystem) {
        StringBuffer selectToRetrieveOlderJobIdQuery = new StringBuffer();
        selectToRetrieveOlderJobIdQuery.append("select ");
        selectToRetrieveOlderJobIdQuery.append("job_status.jobId");
        selectToRetrieveOlderJobIdQuery.append(" from  ");
        selectToRetrieveOlderJobIdQuery.append("job");
        selectToRetrieveOlderJobIdQuery.append(", job_status AS job_status LEFT OUTER JOIN job_status AS jslatest ");
        selectToRetrieveOlderJobIdQuery.append("ON jslatest.jobId = job_status.jobId");
        selectToRetrieveOlderJobIdQuery.append(" and job_status.id < jslatest.id");
        selectToRetrieveOlderJobIdQuery.append(" where ");
        selectToRetrieveOlderJobIdQuery.append("job_status.jobId = job.id");
        if (userId != null) {
            selectToRetrieveOlderJobIdQuery.append(" and job.userId = '" + userId + "'");
        }
        if (batchSystem != null) {
            selectToRetrieveOlderJobIdQuery.append(" and job.batchSystem = '" + batchSystem + "'");
        }
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToRetrieveOlderJobIdQuery.append(" and jslatest.id IS NULL");
            StringBuffer jobStatusTypeList = new StringBuffer();
            for (int i = 0; i < jobStatusType.length; ++i) {
                jobStatusTypeList.append(", '" + jobStatusType[i] + "'");
            }
            jobStatusTypeList.deleteCharAt(0);
            selectToRetrieveOlderJobIdQuery.append(" and job_status.type IN (" + jobStatusTypeList.toString() + ")");
        }
        selectToRetrieveOlderJobIdQuery.append(" order by ");
        selectToRetrieveOlderJobIdQuery.append("job_status.time_stamp");
        selectToRetrieveOlderJobIdQuery.append(" limit 1");
        return selectToRetrieveOlderJobIdQuery.toString();
    }

    public List<String> executeSelectToRetrieveJobIdByLeaseTimeExpiredQuery(String userId, String delegationId, int[] jobStatusType, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobIdByLeaseTimeExpiredQuery");
        ArrayList<String> jobIdList = new ArrayList<String>();
        String selectQuery = JobTableJobStatusTable.getSelectToRetrieveJobIdByLeaseTimeExpiredQuery(userId, delegationId, jobStatusType);
        logger.debug((Object)("selectQuery = " + selectQuery));
        PreparedStatement selectToRetrieveJobIdByLeaseTimeExpiredPreparedStatement = connection.prepareStatement(selectQuery);
        ResultSet rs = selectToRetrieveJobIdByLeaseTimeExpiredPreparedStatement.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                jobIdList.add(rs.getString("id"));
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobIdByLeaseTimeExpiredQuery");
        return jobIdList;
    }

    private static String getSelectToRetrieveJobIdByLeaseTimeExpiredQuery(String userId, String delegationId, int[] jobStatusType) {
        StringBuffer selectToRetrieveJobIdByLeaseTimeExpiredQuery = new StringBuffer();
        selectToRetrieveJobIdByLeaseTimeExpiredQuery.append("select ");
        selectToRetrieveJobIdByLeaseTimeExpiredQuery.append("job.id AS id");
        selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(" from job");
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(", job_status AS job_status LEFT OUTER JOIN job_status AS jslatest ");
            selectToRetrieveJobIdByLeaseTimeExpiredQuery.append("ON jslatest.jobId = job_status.jobId");
            selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(" and job_status.id < jslatest.id");
        }
        selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(" where true ");
        if (userId != null) {
            selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(" and userId = '" + userId + "'");
        }
        if (delegationId != null) {
            selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(" and delegationProxyId = '" + delegationId + "'");
        }
        selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(" and leaseTime IS NOT NULL");
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(" and jslatest.id IS NULL");
            StringBuffer jobStatusTypeList = new StringBuffer();
            for (int i = 0; i < jobStatusType.length; ++i) {
                jobStatusTypeList.append(", '" + jobStatusType[i] + "'");
            }
            jobStatusTypeList.deleteCharAt(0);
            selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(" and job_status.type IN (" + jobStatusTypeList.toString() + ")");
            selectToRetrieveJobIdByLeaseTimeExpiredQuery.append(" and job_status.jobId = job.id");
        }
        logger.debug((Object)("selectToRetrieveJobIdByLeaseTimeExpiredQuery = " + selectToRetrieveJobIdByLeaseTimeExpiredQuery.toString()));
        return selectToRetrieveJobIdByLeaseTimeExpiredQuery.toString();
    }

    public long executeSelectToJobCountByStatus(int[] jobStatusType, String userId, Connection connection) throws SQLException {
        long jobCountByStatus = 0L;
        String selectToJobCountByStatusQuery = JobTableJobStatusTable.getSelectToJobCountByStatusQuery(jobStatusType, userId);
        logger.debug((Object)("selectToJobCountByStatusQuery = " + selectToJobCountByStatusQuery));
        PreparedStatement selectToJobCountByStatusPreparedStatement = connection.prepareStatement(selectToJobCountByStatusQuery);
        ResultSet rs = selectToJobCountByStatusPreparedStatement.executeQuery();
        if (rs != null && rs.next()) {
            jobCountByStatus = rs.getLong(COUNT_JOB);
        }
        return jobCountByStatus;
    }

    public void executeUpdateDelegationProxyInfo(String delegationId, String delegationProxyInfo, String userId, Connection connection) throws SQLException, IllegalArgumentException {
        if (delegationId == null || "".equals(delegationId)) {
            logger.error((Object)"delegationId not specified!");
            throw new IllegalArgumentException("delegationId not specified!");
        }
        if (delegationProxyInfo == null || "".equals(delegationProxyInfo)) {
            logger.error((Object)"delegationProxyInfo not specified!");
            throw new IllegalArgumentException("delegationProxyInfo not specified!");
        }
        if (userId == null || "".equals(userId)) {
            logger.error((Object)"userId not specified!");
            throw new IllegalArgumentException("userId not specified!");
        }
        if (connection == null) {
            logger.error((Object)"connection not specified!");
            throw new IllegalArgumentException("connection not specified!");
        }
        String jobTableJobId = "job.id";
        String jobTableUserId = "job.userId";
        String jobTableDelegationProxyId = "job.delegationProxyId";
        String jobStatusTableJobId = "job_status.jobId";
        String jobStatusTableId = "job_status.id";
        String jobStatusTableType = "job_status.type";
        String jslatestId = "jslatest.id";
        StringBuffer updateDelegationProxyInfoQuery = new StringBuffer("update ");
        updateDelegationProxyInfoQuery.append("job").append(" set ").append("delegationProxyInfo");
        updateDelegationProxyInfoQuery.append(" = '").append(delegationProxyInfo).append("' where ").append("id").append(" = (select ");
        updateDelegationProxyInfoQuery.append("job_status.jobId").append(" from ").append("job_status").append(" AS ");
        updateDelegationProxyInfoQuery.append("job_status").append(" LEFT OUTER JOIN ").append("job_status").append(" AS jslatest ON jslatest.");
        updateDelegationProxyInfoQuery.append("jobId").append(" = ").append("job_status.jobId");
        updateDelegationProxyInfoQuery.append(" and ").append("job_status.id").append(" < ").append("jslatest.id");
        updateDelegationProxyInfoQuery.append(" where ").append("jslatest.id").append(" IS NULL and ").append("job_status.type");
        updateDelegationProxyInfoQuery.append(" IN ('").append(0).append("', '");
        updateDelegationProxyInfoQuery.append(6).append("', '").append(2).append("', '");
        updateDelegationProxyInfoQuery.append(1).append("', '").append(4).append("', '");
        updateDelegationProxyInfoQuery.append(3).append("') and ").append("job_status.jobId").append(" = ");
        updateDelegationProxyInfoQuery.append("job.id").append(" and ").append("job.delegationProxyId");
        updateDelegationProxyInfoQuery.append(" = '").append(delegationId).append("' and ");
        updateDelegationProxyInfoQuery.append("job.userId").append(" = '").append(userId).append("')");
        logger.debug((Object)("updateDelegationProxyInfoQuery = " + updateDelegationProxyInfoQuery.toString()));
        PreparedStatement updateDelegationProxyInfoPreparedStatement = null;
        try {
            updateDelegationProxyInfoPreparedStatement = connection.prepareStatement(updateDelegationProxyInfoQuery.toString());
            updateDelegationProxyInfoPreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (updateDelegationProxyInfoPreparedStatement != null) {
                try {
                    updateDelegationProxyInfoPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
    }

    private static String getSelectToJobCountByStatusQuery(int[] jobStatusType, String userId) {
        StringBuffer selectToJobCountByStatusQuery = new StringBuffer();
        selectToJobCountByStatusQuery.append("select count(*) AS COUNT_JOB");
        selectToJobCountByStatusQuery.append(" from job");
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToJobCountByStatusQuery.append(", job_status AS job_status LEFT OUTER JOIN job_status AS jslatest ");
            selectToJobCountByStatusQuery.append("ON jslatest.jobId = job_status.jobId");
            selectToJobCountByStatusQuery.append(" and job_status.id < jslatest.id");
        }
        selectToJobCountByStatusQuery.append(" where true ");
        if (userId != null) {
            selectToJobCountByStatusQuery.append(" and userId = '" + userId + "'");
        }
        if (jobStatusType != null && jobStatusType.length > 0) {
            selectToJobCountByStatusQuery.append(" and jslatest.id IS NULL");
            StringBuffer jobStatusTypeList = new StringBuffer();
            for (int i = 0; i < jobStatusType.length; ++i) {
                jobStatusTypeList.append(", '" + jobStatusType[i] + "'");
            }
            jobStatusTypeList.deleteCharAt(0);
            selectToJobCountByStatusQuery.append(" and job_status.type IN (" + jobStatusTypeList.toString() + ")");
            selectToJobCountByStatusQuery.append(" and job_status.jobId = job.id");
        }
        return selectToJobCountByStatusQuery.toString();
    }
}

