/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.Lease;
import org.glite.ce.creamapi.jobmanagement.db.table.JobTableInterface;

public class JobTable
implements JobTableInterface {
    public static final String NAME_TABLE = "job";
    public static final String CREAM_URL_FIELD = "creamURL";
    public static final String ID_FIELD = "id";
    public static final String CEREQUIREMENTS_FIELD = "cerequirements";
    public static final String VIRTUAL_ORGANIZATION_FIELD = "virtualOrganization";
    public static final String USER_ID_FIELD = "userId";
    public static final String BATCH_SYSTEM_FIELD = "batchSystem";
    public static final String QUEUE_FIELD = "queue";
    public static final String STANDARD_INPUT_FIELD = "standardInput";
    public static final String STANDARD_OUTPUT_FIELD = "standardOutput";
    public static final String STANDARD_ERROR_FIELD = "standardError";
    public static final String EXECUTABLE_FIELD = "executable";
    public static final String DELEGATION_PROXY_CERT_PATH_FIELD = "delegationProxyCertPath";
    public static final String AUTHN_PROXY_CERT_PATH_FIELD = "authNProxyCertPath";
    public static final String HLR_LOCATION_FIELD = "hlrLocation";
    public static final String LOGGER_DEST_URI_FIELD = "loggerDestURI";
    public static final String TOKEN_URL_FIELD = "tokenURL";
    public static final String PERUSAL_FILES_DEST_URI_FIELD = "perusalFilesDestURI";
    public static final String PERUSAL_LIST_FILE_URI_FIELD = "perusalListFileURI";
    public static final String PERUSAL_TIME_INTERVAL_FIELD = "perusalTimeInterval";
    public static final String NODES_FIELD = "nodes";
    public static final String PROLOGUE_ARGUMENTS_FIELD = "prologueArguments";
    public static final String PROLOGUE_FIELD = "prologue";
    public static final String EPILOGUE_FIELD = "epilogue";
    public static final String EPILOGUE_ARGUMENTS_FIELD = "epilogueArguments";
    public static final String SEQUENCE_CODE_FIELD = "sequenceCode";
    public static final String LRMS_JOB_ID_FIELD = "lrmsJobId";
    public static final String LRMS_ABS_LAYER_JOB_ID_FIELD = "lrmsAbsLayerJobId";
    public static final String GRID_JOB_ID_FIELD = "gridJobId";
    public static final String ICE_ID_FIELD = "iceId";
    public static final String FATHER_JOB_ID_FIELD = "fatherJobId";
    public static final String CE_ID_FIELD = "ceId";
    public static final String TYPE_FIELD = "type";
    public static final String CREAM_INPUT_SANDBOX_URI_FIELD = "creamInputSandboxURI";
    public static final String CREAM_OUTPUT_SANDBOX_URI_FIELD = "creamOutputSandboxURI";
    public static final String SANDBOX_BASE_PATH_FIELD = "sandboxBasePath";
    public static final String INPUT_SANDBOX_BASE_URI_FIELD = "inputSandboxBaseURI";
    public static final String OUTPUT_SANDBOX_BASE_DEST_URI_FIELD = "outputSandboxBaseDestURI";
    public static final String WORKER_NODE_FIELD = "workerNode";
    public static final String JDL_FIELD = "jdl";
    public static final String LOCAL_USER_FIELD = "localUser";
    public static final String DELEGATION_PROXY_ID_FIELD = "delegationProxyId";
    public static final String DELEGATION_PROXY_INFO_FIELD = "delegationProxyInfo";
    public static final String WORKING_DIRECTORY_FIELD = "workingDirectory";
    public static final String LEASE_ID_FIELD = "leaseId";
    public static final String LEASE_TIME_FIELD = "leaseTime";
    public static final String MY_PROXY_SERVER_FIELD = "myProxyServer";
    public static final String LEASEID_EXPIRED = "LEASEID_EXPIRED";
    public static final String JOB_NOT_FOUND = "JOB_NOT_FOUND";
    private static final String insertQuery = JobTable.getInsertQuery();
    private static final String deleteQuery = JobTable.getDeleteQuery();
    private static final Logger logger = Logger.getLogger(JobTable.class);

    public JobTable() throws SQLException {
        logger.debug((Object)"Call JobTable constructor");
    }

    public String executeSelectUserId(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectUserId");
        String userId = null;
        PreparedStatement selectUserIdPreparedStatement = null;
        try {
            selectUserIdPreparedStatement = connection.prepareStatement(JobTable.getSelectUserIdQuery());
            selectUserIdPreparedStatement = this.fillSelectUserIdPreparedStatement(jobId, selectUserIdPreparedStatement);
            ResultSet resultSet = selectUserIdPreparedStatement.executeQuery();
            if (resultSet != null && resultSet.next()) {
                userId = resultSet.getString(USER_ID_FIELD);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectUserIdPreparedStatement != null) {
                try {
                    selectUserIdPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeSelectUserId");
        return userId;
    }

    public boolean isUserEnable(String jobId, String userId, Connection connection) {
        logger.debug((Object)"Begin isUserEnable");
        boolean isEnable = false;
        if (userId == null) {
            isEnable = true;
        } else {
            try {
                String userIdFromDB = this.executeSelectUserId(jobId, connection);
                logger.debug((Object)("userIdFromDB = " + userIdFromDB + " for jobId = " + jobId));
                if (userId.equals(userIdFromDB)) {
                    isEnable = true;
                }
            }
            catch (SQLException sqle) {
                logger.error((Object)("Problem to retrieve userId from DB : " + sqle.getMessage()));
            }
        }
        logger.debug((Object)"End isUserEnable");
        return isEnable;
    }

    public int executeDelete(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeDelete");
        PreparedStatement deletePreparedStatement = null;
        int rowCount = 0;
        try {
            deletePreparedStatement = connection.prepareStatement(deleteQuery);
            deletePreparedStatement = this.fillDeletePreparedStatement(jobId, deletePreparedStatement);
            rowCount = deletePreparedStatement.executeUpdate();
            logger.info((Object)("Job deleted. JobId = " + jobId));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeDelete");
        return rowCount;
    }

    private PreparedStatement fillDeletePreparedStatement(String jobId, PreparedStatement deletePreparedStatement) throws SQLException {
        deletePreparedStatement.setString(1, jobId);
        return deletePreparedStatement;
    }

    private PreparedStatement fillSelectUserIdPreparedStatement(String jobId, PreparedStatement selectUserIdPreparedStatement) throws SQLException {
        selectUserIdPreparedStatement.setString(1, jobId);
        return selectUserIdPreparedStatement;
    }

    public int executeUpdate(Job job, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeUpdate");
        PreparedStatement updatePreparedStatement = null;
        int rowCount = 0;
        try {
            updatePreparedStatement = connection.prepareStatement(JobTable.getUpdateQuery(job));
            updatePreparedStatement = this.fillUpdatePreparedStatement(job, updatePreparedStatement);
            rowCount = updatePreparedStatement.executeUpdate();
            logger.debug((Object)("Job updated. (rowCount = " + rowCount + ")"));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (updatePreparedStatement != null) {
                try {
                    updatePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeUpdate");
        return rowCount;
    }

    public int executeInsert(Job job, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeInsert");
        PreparedStatement insertPreparedStatement = null;
        int rowCount = 0;
        try {
            insertPreparedStatement = connection.prepareStatement(insertQuery);
            insertPreparedStatement = this.fillInsertPreparedStatement(job, insertPreparedStatement);
            rowCount = insertPreparedStatement.executeUpdate();
            logger.info((Object)("Job inserted. JobId = " + job.getId()));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (insertPreparedStatement != null) {
                try {
                    insertPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeInsert");
        return rowCount;
    }

    private PreparedStatement fillInsertPreparedStatement(Job job, PreparedStatement insertPreparedStatement) throws SQLException {
        insertPreparedStatement.setString(1, job.getId());
        insertPreparedStatement.setString(2, job.getCreamURL());
        insertPreparedStatement.setString(3, job.getCeRequirements());
        insertPreparedStatement.setString(4, job.getVirtualOrganization());
        insertPreparedStatement.setString(5, job.getUserId());
        insertPreparedStatement.setString(6, job.getBatchSystem());
        insertPreparedStatement.setString(7, job.getQueue());
        insertPreparedStatement.setString(8, job.getStandardInput());
        insertPreparedStatement.setString(9, job.getStandardOutput());
        insertPreparedStatement.setString(10, job.getStandardError());
        insertPreparedStatement.setString(11, job.getExecutable());
        insertPreparedStatement.setString(12, job.getDelegationProxyCertPath());
        insertPreparedStatement.setString(13, job.getAuthNProxyCertPath());
        insertPreparedStatement.setString(14, job.getHlrLocation());
        insertPreparedStatement.setString(15, job.getLoggerDestURI());
        insertPreparedStatement.setString(16, job.getTokenURL());
        insertPreparedStatement.setString(17, job.getPerusalFilesDestURI());
        insertPreparedStatement.setString(18, job.getPerusalListFileURI());
        insertPreparedStatement.setInt(19, job.getPerusalTimeInterval());
        insertPreparedStatement.setInt(20, job.getNodeNumber());
        insertPreparedStatement.setString(21, job.getPrologueArguments());
        insertPreparedStatement.setString(22, job.getPrologue());
        insertPreparedStatement.setString(23, job.getEpilogue());
        insertPreparedStatement.setString(24, job.getEpilogueArguments());
        insertPreparedStatement.setString(25, job.getSequenceCode());
        insertPreparedStatement.setString(26, job.getLRMSJobId());
        insertPreparedStatement.setString(27, job.getLRMSAbsLayerJobId());
        insertPreparedStatement.setString(28, job.getGridJobId());
        insertPreparedStatement.setString(29, job.getICEId());
        insertPreparedStatement.setString(30, job.getFatherJobId());
        insertPreparedStatement.setString(31, job.getCeId());
        insertPreparedStatement.setString(32, job.getType());
        insertPreparedStatement.setString(33, job.getCREAMInputSandboxURI());
        insertPreparedStatement.setString(34, job.getCREAMOutputSandboxURI());
        insertPreparedStatement.setString(35, job.getSandboxBasePath());
        insertPreparedStatement.setString(36, job.getInputSandboxBaseURI());
        insertPreparedStatement.setString(37, job.getOutputSandboxBaseDestURI());
        insertPreparedStatement.setString(38, job.getWorkerNode());
        insertPreparedStatement.setString(39, job.getJDL());
        insertPreparedStatement.setString(40, job.getLocalUser());
        insertPreparedStatement.setString(41, job.getDelegationProxyId());
        insertPreparedStatement.setString(42, job.getDelegationProxyInfo());
        insertPreparedStatement.setString(43, job.getWorkingDirectory());
        if (job.getLease() != null && job.getLease().getLeaseId() != null) {
            insertPreparedStatement.setString(44, job.getLease().getLeaseId());
        } else {
            insertPreparedStatement.setNull(44, 12);
        }
        insertPreparedStatement.setTimestamp(45, null);
        if (job.getMyProxyServer() != null && !"".equals(job.getMyProxyServer())) {
            insertPreparedStatement.setString(46, job.getMyProxyServer());
        } else {
            insertPreparedStatement.setNull(46, 12);
        }
        return insertPreparedStatement;
    }

    private PreparedStatement fillUpdatePreparedStatement(Job job, PreparedStatement updatePreparedStatement) throws SQLException {
        updatePreparedStatement.setString(1, job.getCreamURL());
        updatePreparedStatement.setString(2, job.getCeRequirements());
        updatePreparedStatement.setString(3, job.getBatchSystem());
        updatePreparedStatement.setString(4, job.getQueue());
        updatePreparedStatement.setString(5, job.getStandardInput());
        updatePreparedStatement.setString(6, job.getStandardOutput());
        updatePreparedStatement.setString(7, job.getStandardError());
        updatePreparedStatement.setString(8, job.getExecutable());
        updatePreparedStatement.setString(9, job.getDelegationProxyCertPath());
        updatePreparedStatement.setString(10, job.getAuthNProxyCertPath());
        updatePreparedStatement.setString(11, job.getHlrLocation());
        updatePreparedStatement.setString(12, job.getLoggerDestURI());
        updatePreparedStatement.setString(13, job.getTokenURL());
        updatePreparedStatement.setString(14, job.getPerusalFilesDestURI());
        updatePreparedStatement.setString(15, job.getPerusalListFileURI());
        updatePreparedStatement.setInt(16, job.getPerusalTimeInterval());
        updatePreparedStatement.setInt(17, job.getNodeNumber());
        updatePreparedStatement.setString(18, job.getPrologueArguments());
        updatePreparedStatement.setString(19, job.getPrologue());
        updatePreparedStatement.setString(20, job.getEpilogue());
        updatePreparedStatement.setString(21, job.getEpilogueArguments());
        updatePreparedStatement.setString(22, job.getSequenceCode());
        updatePreparedStatement.setString(23, job.getICEId());
        updatePreparedStatement.setString(24, job.getCeId());
        updatePreparedStatement.setString(25, job.getType());
        updatePreparedStatement.setString(26, job.getCREAMInputSandboxURI());
        updatePreparedStatement.setString(27, job.getCREAMOutputSandboxURI());
        updatePreparedStatement.setString(28, job.getSandboxBasePath());
        updatePreparedStatement.setString(29, job.getInputSandboxBaseURI());
        updatePreparedStatement.setString(30, job.getOutputSandboxBaseDestURI());
        updatePreparedStatement.setString(31, job.getWorkerNode());
        updatePreparedStatement.setString(32, job.getJDL());
        updatePreparedStatement.setString(33, job.getLocalUser());
        updatePreparedStatement.setString(34, job.getDelegationProxyId());
        updatePreparedStatement.setString(35, job.getDelegationProxyInfo());
        updatePreparedStatement.setString(36, job.getWorkingDirectory());
        int index = 37;
        if (job.getLRMSJobId() != null && !"N/A".equals(job.getLRMSJobId())) {
            updatePreparedStatement.setString(index, job.getLRMSJobId());
            ++index;
        }
        if (job.getLRMSAbsLayerJobId() != null && !"N/A".equals(job.getLRMSAbsLayerJobId())) {
            updatePreparedStatement.setString(index, job.getLRMSAbsLayerJobId());
            ++index;
        }
        updatePreparedStatement.setString(index, job.getId());
        return updatePreparedStatement;
    }

    public Job executeSelectJobTable(String jobId, String userId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectJobTable");
        Job job = null;
        PreparedStatement selectPreparedStatement = null;
        try {
            selectPreparedStatement = connection.prepareStatement(JobTable.getSelectQuery(jobId, userId));
            ResultSet rs = selectPreparedStatement.executeQuery();
            if (rs != null && rs.next()) {
                job = this.buildJobTableObj(rs);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectPreparedStatement != null) {
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeSelectJobTable");
        return job;
    }

    private Job buildJobTableObj(ResultSet rs) throws SQLException {
        String myProxyServer;
        Job job = new Job();
        job.setId(rs.getString(ID_FIELD));
        job.setCreamURL(rs.getString(CREAM_URL_FIELD));
        job.setCeRequirements(rs.getString(CEREQUIREMENTS_FIELD));
        job.setVirtualOrganization(rs.getString(VIRTUAL_ORGANIZATION_FIELD));
        job.setUserId(rs.getString(USER_ID_FIELD));
        job.setBatchSystem(rs.getString(BATCH_SYSTEM_FIELD));
        job.setQueue(rs.getString(QUEUE_FIELD));
        job.setStandardInput(rs.getString(STANDARD_INPUT_FIELD));
        job.setStandardOutput(rs.getString(STANDARD_OUTPUT_FIELD));
        job.setStandardError(rs.getString(STANDARD_ERROR_FIELD));
        job.setExecutable(rs.getString(EXECUTABLE_FIELD));
        job.setDelegationProxyCertPath(rs.getString(DELEGATION_PROXY_CERT_PATH_FIELD));
        job.setAuthNProxyCertPath(rs.getString(AUTHN_PROXY_CERT_PATH_FIELD));
        job.setHlrLocation(rs.getString(HLR_LOCATION_FIELD));
        job.setLoggerDestURI(rs.getString(LOGGER_DEST_URI_FIELD));
        job.setTokenURL(rs.getString(TOKEN_URL_FIELD));
        job.setPerusalFilesDestURI(rs.getString(PERUSAL_FILES_DEST_URI_FIELD));
        job.setPerusalListFileURI(rs.getString(PERUSAL_LIST_FILE_URI_FIELD));
        job.setPerusalTimeInterval(rs.getInt(PERUSAL_TIME_INTERVAL_FIELD));
        job.setNodeNumber(rs.getInt(NODES_FIELD));
        job.setPrologueArguments(rs.getString(PROLOGUE_ARGUMENTS_FIELD));
        job.setPrologue(rs.getString(PROLOGUE_FIELD));
        job.setEpilogue(rs.getString(EPILOGUE_FIELD));
        job.setEpilogueArguments(rs.getString(EPILOGUE_ARGUMENTS_FIELD));
        job.setSequenceCode(rs.getString(SEQUENCE_CODE_FIELD));
        job.setLRMSJobId(rs.getString(LRMS_JOB_ID_FIELD));
        job.setLRMSAbsLayerJobId(rs.getString(LRMS_ABS_LAYER_JOB_ID_FIELD));
        job.setGridJobId(rs.getString(GRID_JOB_ID_FIELD));
        job.setICEId(rs.getString(ICE_ID_FIELD));
        job.setFatherJobId(rs.getString(FATHER_JOB_ID_FIELD));
        job.setCeId(rs.getString(CE_ID_FIELD));
        job.setType(rs.getString(TYPE_FIELD));
        job.setCREAMInputSandboxURI(rs.getString(CREAM_INPUT_SANDBOX_URI_FIELD));
        job.setCREAMOutputSandboxURI(rs.getString(CREAM_OUTPUT_SANDBOX_URI_FIELD));
        job.setSandboxBasePath(rs.getString(SANDBOX_BASE_PATH_FIELD));
        job.setInputSandboxBaseURI(rs.getString(INPUT_SANDBOX_BASE_URI_FIELD));
        job.setOutputSandboxBaseDestURI(rs.getString(OUTPUT_SANDBOX_BASE_DEST_URI_FIELD));
        job.setWorkerNode(rs.getString(WORKER_NODE_FIELD));
        job.setJDL(rs.getString(JDL_FIELD));
        job.setLocalUser(rs.getString(LOCAL_USER_FIELD));
        job.setDelegationProxyId(rs.getString(DELEGATION_PROXY_ID_FIELD));
        job.setDelegationProxyInfo(rs.getString(DELEGATION_PROXY_INFO_FIELD));
        job.setWorkingDirectory(rs.getString(WORKING_DIRECTORY_FIELD));
        String leaseId = rs.getString(LEASE_ID_FIELD);
        if (leaseId != null) {
            Timestamp leaseTimeExpiredField = rs.getTimestamp(LEASE_TIME_FIELD);
            Calendar leaseTimeExpired = null;
            if (leaseTimeExpiredField != null) {
                leaseTimeExpired = Calendar.getInstance();
                leaseTimeExpired.setTimeInMillis(leaseTimeExpiredField.getTime());
            }
            Lease lease = this.getLeaseObj(leaseId, leaseTimeExpired, job.getUserId());
            job.setLease(lease);
        }
        if ((myProxyServer = rs.getString(MY_PROXY_SERVER_FIELD)) != null) {
            job.setMyProxyServer(myProxyServer);
        }
        return job;
    }

    private Lease getLeaseObj(String leaseId, Calendar leaseTimeExpired, String userId) {
        Lease lease = new Lease();
        lease.setUserId(userId);
        if (leaseTimeExpired != null) {
            lease.setLeaseTime(leaseTimeExpired);
        }
        lease.setLeaseId(leaseId);
        return lease;
    }

    private static String getSelectQuery(String jobId, String userId) {
        StringBuffer selectQuery = new StringBuffer();
        selectQuery.append("select ");
        selectQuery.append("id AS id, ");
        selectQuery.append("creamURL AS creamURL, ");
        selectQuery.append("cerequirements AS cerequirements, ");
        selectQuery.append("virtualOrganization AS virtualOrganization, ");
        selectQuery.append("userId AS userId, ");
        selectQuery.append("batchSystem AS batchSystem, ");
        selectQuery.append("queue AS queue, ");
        selectQuery.append("standardInput AS standardInput, ");
        selectQuery.append("standardOutput AS standardOutput, ");
        selectQuery.append("standardError AS standardError, ");
        selectQuery.append("executable AS executable, ");
        selectQuery.append("delegationProxyCertPath AS delegationProxyCertPath, ");
        selectQuery.append("authNProxyCertPath AS authNProxyCertPath, ");
        selectQuery.append("hlrLocation AS hlrLocation, ");
        selectQuery.append("loggerDestURI AS loggerDestURI, ");
        selectQuery.append("tokenURL AS tokenURL, ");
        selectQuery.append("perusalFilesDestURI AS perusalFilesDestURI, ");
        selectQuery.append("perusalListFileURI AS perusalListFileURI, ");
        selectQuery.append("perusalTimeInterval AS perusalTimeInterval, ");
        selectQuery.append("nodes AS nodes, ");
        selectQuery.append("prologueArguments AS prologueArguments, ");
        selectQuery.append("prologue AS prologue, ");
        selectQuery.append("epilogue AS epilogue, ");
        selectQuery.append("epilogueArguments AS epilogueArguments, ");
        selectQuery.append("sequenceCode AS sequenceCode, ");
        selectQuery.append("lrmsJobId AS lrmsJobId, ");
        selectQuery.append("lrmsAbsLayerJobId AS lrmsAbsLayerJobId, ");
        selectQuery.append("gridJobId AS gridJobId, ");
        selectQuery.append("iceId AS iceId, ");
        selectQuery.append("fatherJobId AS fatherJobId, ");
        selectQuery.append("ceId AS ceId, ");
        selectQuery.append("type AS type, ");
        selectQuery.append("creamInputSandboxURI AS creamInputSandboxURI, ");
        selectQuery.append("creamOutputSandboxURI AS creamOutputSandboxURI, ");
        selectQuery.append("sandboxBasePath AS sandboxBasePath, ");
        selectQuery.append("inputSandboxBaseURI AS inputSandboxBaseURI, ");
        selectQuery.append("outputSandboxBaseDestURI AS outputSandboxBaseDestURI, ");
        selectQuery.append("workerNode AS workerNode, ");
        selectQuery.append("jdl AS jdl, ");
        selectQuery.append("localUser AS localUser, ");
        selectQuery.append("delegationProxyId AS delegationProxyId, ");
        selectQuery.append("delegationProxyInfo AS delegationProxyInfo, ");
        selectQuery.append("workingDirectory AS workingDirectory, ");
        selectQuery.append("leaseId AS leaseId, ");
        selectQuery.append("leaseTime AS leaseTime, ");
        selectQuery.append("myProxyServer AS myProxyServer");
        selectQuery.append(" from job");
        selectQuery.append(" where ");
        selectQuery.append("id = '" + jobId + "'");
        if (userId != null) {
            selectQuery.append(" and userId = '" + userId + "'");
        }
        return selectQuery.toString();
    }

    public List<String> executeSelectToRetrieveJobId(String userId, List<String> jobId, String leaseId, String delegationId, List<String> gridJobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelectToRetrieveJobId");
        ArrayList<String> jobIdList = new ArrayList<String>();
        Statement selectToRetrieveJobIdPreparedStatement = null;
        try {
            selectToRetrieveJobIdPreparedStatement = connection.prepareStatement(JobTable.getSelectToRetrieveJobIdQuery(userId, jobId, leaseId, delegationId, gridJobId));
            ResultSet rs = selectToRetrieveJobIdPreparedStatement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    jobIdList.add(rs.getString(ID_FIELD));
                }
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectToRetrieveJobIdPreparedStatement != null) {
                try {
                    selectToRetrieveJobIdPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeSelectToRetrieveJobId");
        return jobIdList;
    }

    private static String getSelectToRetrieveJobIdQuery(String userId, List<String> jobId, String leaseId, String delegationId, List<String> gridJobId) {
        int i;
        StringBuffer selectToRetrieveJobIdQuery = new StringBuffer();
        selectToRetrieveJobIdQuery.append("select ");
        selectToRetrieveJobIdQuery.append("id AS id");
        selectToRetrieveJobIdQuery.append(" from job");
        selectToRetrieveJobIdQuery.append(" where true ");
        if (userId != null && delegationId != null) {
            selectToRetrieveJobIdQuery.append(" and (");
            selectToRetrieveJobIdQuery.append("(iceId IS NOT NULL ");
            selectToRetrieveJobIdQuery.append(" and myProxyServer IS NOT NULL ) ");
            selectToRetrieveJobIdQuery.append(" or (");
            selectToRetrieveJobIdQuery.append("iceId IS  NULL )");
            selectToRetrieveJobIdQuery.append(")");
        }
        if (userId != null) {
            selectToRetrieveJobIdQuery.append(" and userId = '" + userId + "'");
        }
        if (delegationId != null) {
            selectToRetrieveJobIdQuery.append(" and delegationProxyId = '" + delegationId + "'");
        }
        if (leaseId != null) {
            selectToRetrieveJobIdQuery.append(" and leaseId = '" + leaseId + "'");
        }
        if (jobId != null && jobId.size() > 0) {
            StringBuffer jobIdList = new StringBuffer();
            for (i = 0; i < jobId.size(); ++i) {
                jobIdList.append(", '" + jobId.get(i) + "'");
            }
            jobIdList.deleteCharAt(0);
            selectToRetrieveJobIdQuery.append(" and id IN (" + jobIdList.toString() + ")");
        }
        if (gridJobId != null && gridJobId.size() > 0) {
            StringBuffer gridJobIdList = new StringBuffer();
            for (i = 0; i < gridJobId.size(); ++i) {
                gridJobIdList.append(", '" + gridJobId.get(i) + "'");
            }
            gridJobIdList.deleteCharAt(0);
            selectToRetrieveJobIdQuery.append(" and gridJobId IN (" + gridJobIdList.toString() + ")");
        }
        return selectToRetrieveJobIdQuery.toString();
    }

    private static String getDeleteQuery() {
        StringBuffer deleteQuery = new StringBuffer();
        deleteQuery.append("delete from ");
        deleteQuery.append(NAME_TABLE);
        deleteQuery.append(" where ");
        deleteQuery.append("id = ?");
        return deleteQuery.toString();
    }

    private static String getSelectUserIdQuery() {
        StringBuffer selectUserIdQuery = new StringBuffer();
        selectUserIdQuery.append("select userId");
        selectUserIdQuery.append(" from ");
        selectUserIdQuery.append(NAME_TABLE);
        selectUserIdQuery.append(" where ");
        selectUserIdQuery.append("id = ?");
        return selectUserIdQuery.toString();
    }

    private static String getInsertQuery() {
        StringBuffer insertQuery = new StringBuffer();
        insertQuery.append("insert into ");
        insertQuery.append(NAME_TABLE);
        insertQuery.append(" ( ");
        insertQuery.append("id, ");
        insertQuery.append("creamURL, ");
        insertQuery.append("cerequirements, ");
        insertQuery.append("virtualOrganization, ");
        insertQuery.append("userId, ");
        insertQuery.append("batchSystem, ");
        insertQuery.append("queue, ");
        insertQuery.append("standardInput, ");
        insertQuery.append("standardOutput, ");
        insertQuery.append("standardError, ");
        insertQuery.append("executable, ");
        insertQuery.append("delegationProxyCertPath, ");
        insertQuery.append("authNProxyCertPath, ");
        insertQuery.append("hlrLocation, ");
        insertQuery.append("loggerDestURI, ");
        insertQuery.append("tokenURL, ");
        insertQuery.append("perusalFilesDestURI, ");
        insertQuery.append("perusalListFileURI, ");
        insertQuery.append("perusalTimeInterval, ");
        insertQuery.append("nodes, ");
        insertQuery.append("prologueArguments, ");
        insertQuery.append("prologue, ");
        insertQuery.append("epilogue, ");
        insertQuery.append("epilogueArguments, ");
        insertQuery.append("sequenceCode, ");
        insertQuery.append("lrmsJobId, ");
        insertQuery.append("lrmsAbsLayerJobId, ");
        insertQuery.append("gridJobId, ");
        insertQuery.append("iceId, ");
        insertQuery.append("fatherJobId, ");
        insertQuery.append("ceId, ");
        insertQuery.append("type, ");
        insertQuery.append("creamInputSandboxURI, ");
        insertQuery.append("creamOutputSandboxURI, ");
        insertQuery.append("sandboxBasePath, ");
        insertQuery.append("inputSandboxBaseURI, ");
        insertQuery.append("outputSandboxBaseDestURI, ");
        insertQuery.append("workerNode, ");
        insertQuery.append("jdl, ");
        insertQuery.append("localUser, ");
        insertQuery.append("delegationProxyId, ");
        insertQuery.append("delegationProxyInfo, ");
        insertQuery.append("workingDirectory, ");
        insertQuery.append("leaseId, ");
        insertQuery.append("leaseTime, ");
        insertQuery.append(MY_PROXY_SERVER_FIELD);
        insertQuery.append(" ) ");
        insertQuery.append("values(");
        insertQuery.append(" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,");
        insertQuery.append(" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,");
        insertQuery.append(" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,");
        insertQuery.append(" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,");
        insertQuery.append(" ?, ?, ?, ?, ?, ?)");
        return insertQuery.toString();
    }

    private static String getUpdateQuery(Job job) {
        StringBuffer updateQuery = new StringBuffer();
        updateQuery.append("update ");
        updateQuery.append(NAME_TABLE);
        updateQuery.append(" set ");
        updateQuery.append("creamURL = ?, ");
        updateQuery.append("cerequirements = ?, ");
        updateQuery.append("batchSystem = ?, ");
        updateQuery.append("queue = ?, ");
        updateQuery.append("standardInput = ?, ");
        updateQuery.append("standardOutput = ?, ");
        updateQuery.append("standardError = ?, ");
        updateQuery.append("executable = ?, ");
        updateQuery.append("delegationProxyCertPath = ?, ");
        updateQuery.append("authNProxyCertPath = ?, ");
        updateQuery.append("hlrLocation = ?, ");
        updateQuery.append("loggerDestURI = ?, ");
        updateQuery.append("tokenURL = ?, ");
        updateQuery.append("perusalFilesDestURI = ?, ");
        updateQuery.append("perusalListFileURI = ?, ");
        updateQuery.append("perusalTimeInterval = ?, ");
        updateQuery.append("nodes = ?, ");
        updateQuery.append("prologueArguments = ?, ");
        updateQuery.append("prologue = ?, ");
        updateQuery.append("epilogue = ?, ");
        updateQuery.append("epilogueArguments = ?, ");
        updateQuery.append("sequenceCode = ?, ");
        updateQuery.append("iceId = ?, ");
        updateQuery.append("ceId = ?, ");
        updateQuery.append("type = ?, ");
        updateQuery.append("creamInputSandboxURI = ?, ");
        updateQuery.append("creamOutputSandboxURI = ?, ");
        updateQuery.append("sandboxBasePath = ?, ");
        updateQuery.append("inputSandboxBaseURI = ?, ");
        updateQuery.append("outputSandboxBaseDestURI = ?, ");
        updateQuery.append("workerNode = ?, ");
        updateQuery.append("jdl = ?, ");
        updateQuery.append("localUser = ?, ");
        updateQuery.append("delegationProxyId = ?, ");
        updateQuery.append("delegationProxyInfo = ?, ");
        updateQuery.append("workingDirectory = ?  ");
        if (job.getLRMSJobId() != null && !"N/A".equals(job.getLRMSJobId())) {
            updateQuery.append(", ");
            updateQuery.append("lrmsJobId = ?  ");
        }
        if (job.getLRMSAbsLayerJobId() != null && !"N/A".equals(job.getLRMSAbsLayerJobId())) {
            updateQuery.append(", ");
            updateQuery.append("lrmsAbsLayerJobId = ?  ");
        }
        updateQuery.append(" where ");
        updateQuery.append("id = ? ");
        return updateQuery.toString();
    }

    private static String getUpdateLeaseExpiredQuery(Calendar leaseTimeExpired, String userId, String leaseId, String jobId) {
        StringBuffer updateQuery = new StringBuffer();
        Timestamp leaseTimestampField = null;
        if (leaseTimeExpired != null) {
            leaseTimestampField = new Timestamp(leaseTimeExpired.getTimeInMillis());
        }
        updateQuery.append("update  ");
        updateQuery.append(NAME_TABLE);
        updateQuery.append(" set ");
        updateQuery.append("leaseTime = '" + leaseTimestampField.toString() + "'");
        updateQuery.append(" where ");
        updateQuery.append("userId = '" + userId + "'");
        updateQuery.append(" and leaseId = '" + leaseId + "'");
        if (jobId != null) {
            updateQuery.append(" and id = '" + jobId + "'");
        }
        return updateQuery.toString();
    }

    public void setLeaseExpired(String jobId, Lease jobLease, Connection connection) throws SQLException {
        logger.debug((Object)"Begin setLeaseExpired");
        Statement updateLeaseExpiredPreparedStatement = null;
        int rowCount = 0;
        try {
            updateLeaseExpiredPreparedStatement = connection.prepareStatement(JobTable.getUpdateLeaseExpiredQuery(jobLease.getLeaseTime(), jobLease.getUserId(), jobLease.getLeaseId(), jobId));
            rowCount = updateLeaseExpiredPreparedStatement.executeUpdate();
            logger.debug((Object)("LeaseExpired updated.  (rowCount = " + rowCount + ")"));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (updateLeaseExpiredPreparedStatement != null) {
                try {
                    updateLeaseExpiredPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End setLeaseExpired");
    }

    public String getLeaseId(String jobId, String userId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin getLeaseId");
        String leaseId = null;
        PreparedStatement selectToRetrieveLeaseIdPreparedStatement = null;
        try {
            selectToRetrieveLeaseIdPreparedStatement = connection.prepareStatement(JobTable.getSelectToRetrieveLeaseIdQuery(jobId, userId));
            ResultSet rs = selectToRetrieveLeaseIdPreparedStatement.executeQuery();
            if (rs != null && rs.next()) {
                leaseId = rs.getString(LEASE_ID_FIELD);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectToRetrieveLeaseIdPreparedStatement != null) {
                try {
                    selectToRetrieveLeaseIdPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End getLeaseId");
        return leaseId;
    }

    public String getReasonFaultSetLeaseId(String jobId, String userId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin getReasonFaultSetLeaseId");
        String faultReason = null;
        PreparedStatement selectToRetrieveReasonFaultSetLeaseIdPreparedStatement = null;
        try {
            selectToRetrieveReasonFaultSetLeaseIdPreparedStatement = connection.prepareStatement(JobTable.getSelectToRetrieveReasonFaultSetLeaseIdQuery(jobId, userId));
            ResultSet rs = selectToRetrieveReasonFaultSetLeaseIdPreparedStatement.executeQuery();
            faultReason = rs != null && rs.next() ? LEASEID_EXPIRED : JOB_NOT_FOUND;
            logger.debug((Object)("faultReason = " + faultReason));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectToRetrieveReasonFaultSetLeaseIdPreparedStatement != null) {
                try {
                    selectToRetrieveReasonFaultSetLeaseIdPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End getReasonFaultSetLeaseId");
        return faultReason;
    }

    private static String getSelectToRetrieveLeaseIdQuery(String jobId, String userId) {
        StringBuffer selectToRetrieveLeaseId = new StringBuffer();
        selectToRetrieveLeaseId.append("select leaseId AS leaseId");
        selectToRetrieveLeaseId.append(" from job");
        selectToRetrieveLeaseId.append(" where ");
        selectToRetrieveLeaseId.append("userId = '" + userId + "'");
        selectToRetrieveLeaseId.append(" and id = '" + jobId + "'");
        return selectToRetrieveLeaseId.toString();
    }

    private static String getSelectToRetrieveReasonFaultSetLeaseIdQuery(String jobId, String userId) {
        StringBuffer selectToRetrieveLeaseId = new StringBuffer();
        selectToRetrieveLeaseId.append("select leaseTime AS leaseTime");
        selectToRetrieveLeaseId.append(" from job");
        selectToRetrieveLeaseId.append(" where ");
        selectToRetrieveLeaseId.append("userId = '" + userId + "'");
        selectToRetrieveLeaseId.append(" and id = '" + jobId + "'");
        return selectToRetrieveLeaseId.toString();
    }
}

