/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.db.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.db.table.ExtraAttributeTableInterface;

public class ExtraAttributeTable
implements ExtraAttributeTableInterface {
    public static final String NAME_TABLE = "extra_attribute";
    public static final String NAME_FIELD = "name";
    public static final String VALUE_FIELD = "value";
    public static final String JOB_ID_FIELD = "jobId";
    private static final String insertQuery = ExtraAttributeTable.getInsertQuery();
    private static final String selectQuery = ExtraAttributeTable.getSelectQuery();
    private static final String deleteQuery = ExtraAttributeTable.getDeleteQuery();
    private static final Logger logger = Logger.getLogger(ExtraAttributeTable.class);

    public ExtraAttributeTable() throws SQLException {
        logger.debug((Object)"Call ExtraAttributeTable constructor");
    }

    public int executeInsert(String jobId, Hashtable<String, String> extraAttribute, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeInsert");
        int rowCountTot = 0;
        PreparedStatement insertPreparedStatement = null;
        try {
            insertPreparedStatement = connection.prepareStatement(insertQuery);
            int rowCount = 0;
            String name = null;
            String value = null;
            Enumeration<String> e = extraAttribute.keys();
            while (e.hasMoreElements()) {
                name = e.nextElement();
                value = extraAttribute.get(name);
                insertPreparedStatement = this.fillInsertPreparedStatement(jobId, name, value, insertPreparedStatement);
                rowCount = insertPreparedStatement.executeUpdate();
                insertPreparedStatement.clearParameters();
                rowCountTot += rowCount;
            }
            logger.debug((Object)("Rows inserted: " + rowCountTot));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (insertPreparedStatement != null) {
                try {
                    insertPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeInsert");
        return rowCountTot;
    }

    public int executeInsert(String jobId, String name, String value, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeInsert");
        int rowCount = 0;
        PreparedStatement insertPreparedStatement = null;
        try {
            insertPreparedStatement = connection.prepareStatement(insertQuery);
            insertPreparedStatement = this.fillInsertPreparedStatement(jobId, name, value, insertPreparedStatement);
            rowCount = insertPreparedStatement.executeUpdate();
            insertPreparedStatement.clearParameters();
            logger.debug((Object)("Rows inserted: " + rowCount));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (insertPreparedStatement != null) {
                try {
                    insertPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeInsert");
        return rowCount;
    }

    public Hashtable<String, String> executeSelect(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeSelect");
        Hashtable<String, String> extraAttribute = new Hashtable<String, String>(0);
        PreparedStatement selectPreparedStatement = null;
        try {
            selectPreparedStatement = connection.prepareStatement(selectQuery);
            selectPreparedStatement = this.fillSelectPreparedStatement(jobId, selectPreparedStatement);
            ResultSet resultSet = selectPreparedStatement.executeQuery();
            String name = null;
            String value = null;
            while (resultSet.next()) {
                name = resultSet.getString(NAME_FIELD);
                value = resultSet.getString(VALUE_FIELD);
                extraAttribute.put(name, value);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (selectPreparedStatement != null) {
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeSelect");
        return extraAttribute;
    }

    public int executeDelete(String jobId, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeDelete");
        PreparedStatement deletePreparedStatement = null;
        int rowCount = 0;
        try {
            deletePreparedStatement = connection.prepareStatement(deleteQuery);
            deletePreparedStatement = this.fillDeletePreparedStatement(jobId, deletePreparedStatement);
            rowCount = deletePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (deletePreparedStatement != null) {
                try {
                    deletePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeDelete");
        return rowCount;
    }

    public void executeUpdate(String jobId, Hashtable<String, String> extraAttribute, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeUpdate");
        PreparedStatement updatePreparedStatement = null;
        try {
            updatePreparedStatement = connection.prepareStatement(ExtraAttributeTable.getUpdateQuery());
            String name = null;
            String value = null;
            Enumeration<String> e = extraAttribute.keys();
            while (e.hasMoreElements()) {
                updatePreparedStatement.clearParameters();
                name = e.nextElement();
                value = extraAttribute.get(name);
                updatePreparedStatement = this.fillUpdatePreparedStatement(jobId, name, value, updatePreparedStatement);
                updatePreparedStatement.executeUpdate();
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (updatePreparedStatement != null) {
                try {
                    updatePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeUpdate");
    }

    public int executeUpdate(String jobId, String name, String value, Connection connection) throws SQLException {
        logger.debug((Object)"Begin executeUpdate");
        int rowUpdated = 0;
        PreparedStatement updatePreparedStatement = null;
        try {
            updatePreparedStatement = connection.prepareStatement(ExtraAttributeTable.getUpdateQuery());
            updatePreparedStatement.clearParameters();
            updatePreparedStatement = this.fillUpdatePreparedStatement(jobId, name, value, updatePreparedStatement);
            rowUpdated = updatePreparedStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (updatePreparedStatement != null) {
                try {
                    updatePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
        }
        logger.debug((Object)"End executeUpdate");
        return rowUpdated;
    }

    private PreparedStatement fillInsertPreparedStatement(String jobId, String name, String value, PreparedStatement insertPreparedStatement) throws SQLException {
        insertPreparedStatement.setString(1, name);
        insertPreparedStatement.setString(2, value);
        insertPreparedStatement.setString(3, jobId);
        return insertPreparedStatement;
    }

    private PreparedStatement fillDeletePreparedStatement(String jobId, PreparedStatement deletePreparedStatement) throws SQLException {
        deletePreparedStatement.setString(1, jobId);
        return deletePreparedStatement;
    }

    private PreparedStatement fillSelectPreparedStatement(String jobId, PreparedStatement selectPreparedStatement) throws SQLException {
        selectPreparedStatement.setString(1, jobId);
        return selectPreparedStatement;
    }

    private PreparedStatement fillUpdatePreparedStatement(String jobId, String attributeName, String attributeValue, PreparedStatement updatePreparedStatement) throws SQLException {
        updatePreparedStatement.setString(1, attributeValue);
        updatePreparedStatement.setString(2, jobId);
        updatePreparedStatement.setString(3, attributeName);
        return updatePreparedStatement;
    }

    private static String getInsertQuery() {
        StringBuffer insertQuery = new StringBuffer();
        insertQuery.append("insert into ");
        insertQuery.append(NAME_TABLE);
        insertQuery.append(" ( ");
        insertQuery.append("name, ");
        insertQuery.append("value, ");
        insertQuery.append(JOB_ID_FIELD);
        insertQuery.append(" ) ");
        insertQuery.append("values(?, ?, ?)");
        return insertQuery.toString();
    }

    private static String getDeleteQuery() {
        StringBuffer deleteQuery = new StringBuffer();
        deleteQuery.append("delete from ");
        deleteQuery.append(NAME_TABLE);
        deleteQuery.append(" where ");
        deleteQuery.append("jobId = ?");
        return deleteQuery.toString();
    }

    private static String getSelectQuery() {
        StringBuffer selectQuery = new StringBuffer();
        selectQuery.append("select ");
        selectQuery.append("name, ");
        selectQuery.append(VALUE_FIELD);
        selectQuery.append(" from extra_attribute");
        selectQuery.append(" where ");
        selectQuery.append("jobId = ?");
        return selectQuery.toString();
    }

    private static String getUpdateQuery() {
        StringBuffer queryUpdateJobStatusTable = new StringBuffer();
        queryUpdateJobStatusTable.append("update ");
        queryUpdateJobStatusTable.append(NAME_TABLE);
        queryUpdateJobStatusTable.append(" set value = ? ");
        queryUpdateJobStatusTable.append(" where ");
        queryUpdateJobStatusTable.append("jobId = ? ");
        queryUpdateJobStatusTable.append(" and name = ? ");
        return queryUpdateJobStatusTable.toString();
    }
}

