/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.cmdexecutor.blah;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.glite.ce.cream.cmdmanagement.CommandManager;
import org.glite.ce.cream.jobmanagement.cmdexecutor.blah.BLAHExecutor;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.jobmanagement.JobStatus;

public class LRMSEventsProcessor {
    private static Logger logger = Logger.getLogger((String)LRMSEventsProcessor.class.getName());
    private BLAHExecutor blahExec = null;

    public LRMSEventsProcessor(BLAHExecutor blahExec) {
        this.blahExec = blahExec;
    }

    public void processEvent(String line) {
        int creamJobStatusType;
        if (line == null) {
            return;
        }
        logger.debug((Object)("processing event: " + line));
        int jobStatus = -1;
        String creamJobId = null;
        String exitCode = null;
        Hashtable<String, String> attributeTable = new Hashtable<String, String>(0);
        if (line.startsWith("[")) {
            line = line.substring(1);
        }
        if (line.endsWith("]")) {
            line = line.substring(0, line.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(line, ";");
        String attribute = null;
        String value = null;
        int index = -1;
        while (st.hasMoreElements()) {
            attribute = st.nextToken();
            index = attribute.indexOf("=");
            if (index == -1) continue;
            value = attribute.substring(index + 1, attribute.length());
            if ((value = value.trim()).startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            attributeTable.put(attribute.substring(0, index).trim(), value.trim());
        }
        if (attributeTable.containsKey("JobStatus")) {
            jobStatus = Integer.parseInt((String)attributeTable.get("JobStatus"));
        }
        if (attributeTable.containsKey("ClientJobId")) {
            creamJobId = "CREAM" + (String)attributeTable.get("ClientJobId");
        } else if (attributeTable.containsKey("BlahJobName")) {
            creamJobId = "CREAM" + (String)attributeTable.get("BlahJobName");
        } else {
            logger.error((Object)("ClientJobId or BlahJobName not present in this line: " + line));
            return;
        }
        switch (jobStatus) {
            case 1: {
                creamJobStatusType = 2;
                break;
            }
            case 2: {
                creamJobStatusType = 3;
                break;
            }
            case 3: {
                creamJobStatusType = 5;
                break;
            }
            case 4: {
                String reason = (String)attributeTable.get("Reason");
                if (reason == null || reason.endsWith("reason=0")) {
                    creamJobStatusType = 7;
                    reason = null;
                    exitCode = "W";
                    if (!attributeTable.containsKey("ExitCode")) break;
                    exitCode = (String)attributeTable.get("ExitCode");
                    break;
                }
                if (reason.endsWith("reason=999")) {
                    exitCode = "999";
                    reason = "job not found!";
                    creamJobStatusType = 10;
                    break;
                }
                exitCode = "W";
                creamJobStatusType = 8;
                break;
            }
            case 5: {
                creamJobStatusType = 6;
                break;
            }
            case 11: {
                creamJobStatusType = 4;
                break;
            }
            default: {
                logger.warn((Object)("invalid status " + line));
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("LRMSEVENTPARSER new status " + JobStatus.getNameByType((int)creamJobStatusType) + " for job " + creamJobId + (attributeTable.containsKey("ChangeTime") ? " at time " + (String)attributeTable.get("ChangeTime") : "")));
        }
        Command statusCmd = new Command("SET_JOB_STATUS", this.blahExec.getCategory());
        statusCmd.setAsynchronous(true);
        statusCmd.setUserId("admin");
        statusCmd.addParameter("JOB_ID", (Serializable)((Object)creamJobId));
        statusCmd.addParameter("STATUS_TYPE", (Serializable)((Object)("" + creamJobStatusType)));
        statusCmd.addParameter("STATUS_CHANGE_TIME", (Serializable)attributeTable.get("ChangeTime"));
        statusCmd.addParameter("WORKER_NODE", (Serializable)attributeTable.get("WorkerNode"));
        statusCmd.addParameter("LRMS_JOB_ID", (Serializable)attributeTable.get("BatchJobId"));
        statusCmd.addParameter("EXIT_CODE", (Serializable)((Object)exitCode));
        statusCmd.addParameter("FAILURE_REASON", (Serializable)attributeTable.get("Reason"));
        statusCmd.addParameter("IS_ADMIN", (Serializable)((Object)"true"));
        statusCmd.setPriorityLevel(2);
        statusCmd.setExecutionMode(Command.ExecutionModeValues.SERIAL);
        statusCmd.setCommandGroupId(creamJobId);
        long startTime = 0L;
        if (logger.isDebugEnabled()) {
            startTime = Calendar.getInstance().getTimeInMillis();
        }
        try {
            CommandManager.getInstance().execute(statusCmd);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)("processor time (msec): " + (Calendar.getInstance().getTimeInMillis() - startTime)));
        }
    }
}

