/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.cream.jobmanagement.cmdexecutor.blah;

import java.io.Serializable;
import java.util.Calendar;
import org.glite.ce.cream.jobmanagement.cmdexecutor.blah.BLAHCommandResult;

public class BlahCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int QUIT = 0;
    public static final int RESULTS = 1;
    public static final int VERSION = 2;
    public static final int ASYNC_MODE_ON = 3;
    public static final int ASYNC_MODE_OFF = 4;
    public static final int BLAH_JOB_CANCEL = 5;
    public static final int BLAH_JOB_STATUS = 6;
    public static final int BLAH_JOB_SUBMIT = 7;
    public static final int BLAH_JOB_HOLD = 8;
    public static final int BLAH_JOB_RESUME = 9;
    public static final int BLAH_JOB_REFRESH_PROXY = 10;
    public static final int BLAH_JOB_SEND_PROXY_TO_WORKER_NODE = 11;
    public static final int BLAH_GET_HOSTPORT = 12;
    public static final int BLAH_SET_GLEXEC_DN = 13;
    public static final int BLAH_SET_GLEXEC_OFF = 14;
    public static final int BLAH_SET_SUDO_ID = 15;
    public static final String[] commands = new String[]{"QUIT", "RESULTS", "VERSION", "ASYNC_MODE_ON", "ASYNC_MODE_OFF", "BLAH_JOB_CANCEL", "BLAH_JOB_STATUS", "BLAH_JOB_SUBMIT", "BLAH_JOB_HOLD", "BLAH_JOB_RESUME", "BLAH_JOB_REFRESH_PROXY", "BLAH_JOB_SEND_PROXY_TO_WORKER_NODE", "BLAH_GET_HOSTPORT", "BLAH_SET_GLEXEC_DN", "BLAH_SET_GLEXEC_OFF", "BLAH_SET_SUDO_ID"};
    private String reqId;
    private String[] parameter;
    private String[] jobId;
    private BLAHCommandResult[] result;
    private int cmdType = 0;
    private Exception exception;
    private Calendar startTime;
    private Calendar stopTime;

    public BlahCommand(int cmdType) {
        this(cmdType, null);
    }

    public BlahCommand(int cmdType, String reqId) {
        this.cmdType = cmdType;
        this.reqId = reqId;
        this.jobId = null;
        this.parameter = null;
        this.result = new BLAHCommandResult[]{new BLAHCommandResult()};
    }

    public BlahCommand(int cmdType, String reqId, String jobId) {
        this(cmdType, reqId, new String[]{jobId});
    }

    public BlahCommand(int cmdType, String reqId, String[] jobId) {
        this.cmdType = cmdType;
        this.reqId = reqId;
        this.jobId = jobId;
        this.parameter = null;
        if (jobId != null) {
            this.result = new BLAHCommandResult[jobId.length];
            for (int i = 0; i < jobId.length; ++i) {
                this.result[i] = new BLAHCommandResult(jobId[i]);
            }
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public String getName() {
        return commands[this.cmdType];
    }

    public String[] getParameter() {
        return this.parameter;
    }

    public String getReqId() {
        return this.reqId;
    }

    public BLAHCommandResult[] getResult() {
        return this.result;
    }

    public BLAHCommandResult getResultAt(int i) {
        if (this.result != null && i < this.result.length) {
            return this.result[i];
        }
        return null;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getStopTime() {
        return this.stopTime;
    }

    public long getTime() {
        long diffTime = this.stopTime.getTimeInMillis() - this.startTime.getTimeInMillis();
        return diffTime;
    }

    public int getType() {
        return this.cmdType;
    }

    public boolean isCompleted() {
        boolean completed = true;
        for (int i = 0; i < this.result.length && completed; ++i) {
            if (this.result[i] != null && this.result[i].getResult() != null) continue;
            completed = false;
        }
        return completed;
    }

    public boolean isExceptionOccurred() {
        return this.exception != null;
    }

    private String makeCommandParameter(String[] values) {
        String result = "";
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                result = result + " " + values[i];
            }
        }
        return result;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setParameter(String parameter) {
        this.setParameter(new String[]{parameter});
    }

    public void setParameter(String[] parameter) {
        this.parameter = parameter;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public void setResult(BLAHCommandResult[] result) {
        this.result = result;
    }

    public void setResult(int index, BLAHCommandResult cr) {
        if (this.result != null && index < this.result.length) {
            this.result[index] = cr;
        }
    }

    public void setType(int cmdType) {
        this.cmdType = cmdType;
    }

    public Calendar start() {
        this.startTime = Calendar.getInstance();
        return this.startTime;
    }

    public Calendar stop() {
        this.stopTime = Calendar.getInstance();
        return this.stopTime;
    }

    public String toString() {
        String cmd = commands[this.cmdType];
        if (this.reqId != null) {
            cmd = cmd + " " + this.reqId;
        }
        switch (this.cmdType) {
            case 7: 
            case 12: 
            case 13: 
            case 15: {
                cmd = cmd + this.makeCommandParameter(this.parameter);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                cmd = cmd + this.makeCommandParameter(this.jobId);
                break;
            }
            case 10: 
            case 11: {
                cmd = cmd + this.makeCommandParameter(this.jobId) + " " + this.makeCommandParameter(this.parameter);
            }
        }
        return cmd + "\n";
    }
}

