/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement.jdl;

import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.ListExpr;
import condor.classad.RecordExpr;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.utils.CEUtils;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.jdl.OutputDataRecord;
import org.glite.jdl.JobAd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NormalJob {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)NormalJob.class.getName());

    private static String getAttributeValue(JobAd jab, String attribute) {
        String value = null;
        Expr result = jab.lookup(attribute);
        if (result != null && (value = result.toString()).length() > 0 && value.charAt(0) == '\"') {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static String getAttributeValue(JobAd jab, String attribute, String fault) throws IllegalArgumentException, Exception {
        if (jab == null) {
            throw new IllegalArgumentException("JobAd not defined!");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("attribute not defined!");
        }
        String result = NormalJob.getAttributeValue(jab, attribute);
        if (result == null) {
            throw new Exception(fault);
        }
        return result;
    }

    private static String getBaseURL(JobAd jab, String attribute) throws IllegalArgumentException, Exception {
        if (attribute == null) {
            return null;
        }
        if (jab == null) {
            throw new IllegalArgumentException("JobAd not defined!");
        }
        String uriValue = NormalJob.getAttributeValue(jab, attribute);
        if (uriValue != null) {
            String uriValueWithoutDN = uriValue;
            if (uriValue.indexOf("?DN=") != -1) {
                uriValueWithoutDN = CEUtils.getURIWithoutDN((String)uriValue);
            }
            URI uri = null;
            try {
                uri = new URI(uriValueWithoutDN);
            }
            catch (URISyntaxException use) {
                logger.error((Object)("Illegal character for the URI: " + uriValue), (Throwable)use);
                throw new IllegalArgumentException("Illegal character for the URI: " + uriValue);
            }
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.startsWith("gsiftp") && !scheme.startsWith("file") && !scheme.startsWith("http") && !scheme.startsWith("https")) {
                throw new IllegalArgumentException("invalid argument: the URI \"" + uriValue + "\" doesn't present an allowed scheme (gsiftp, file, http, https)");
            }
            return uriValue;
        }
        return null;
    }

    private static List<String> getBaseURLs(JobAd jab, String sb) throws IllegalArgumentException, Exception {
        if (sb == null) {
            return null;
        }
        if (jab == null) {
            throw new IllegalArgumentException("JobAd not defined!");
        }
        ArrayList<String> uriArray = new ArrayList<String>(0);
        Expr expression = jab.lookup(sb);
        if (expression == null) {
            return null;
        }
        if (expression instanceof ListExpr) {
            Iterator iter2 = ((ListExpr)expression).iterator();
            String uriValue = null;
            String uriValueWithoutDN = null;
            URI uri = null;
            String scheme = null;
            while (iter2.hasNext()) {
                uriValue = ((Constant)iter2.next()).stringValue();
                if (uriValue == null) continue;
                uriValueWithoutDN = uriValue;
                if (uriValue.indexOf("?DN=") != -1) {
                    uriValueWithoutDN = CEUtils.getURIWithoutDN((String)uriValue);
                }
                try {
                    uri = new URI(uriValueWithoutDN);
                }
                catch (URISyntaxException use) {
                    logger.error((Object)("Illegal character for the URI: " + uriValue), (Throwable)use);
                    throw new IllegalArgumentException("Illegal character for the URI: " + uriValue);
                }
                scheme = uri.getScheme();
                if (scheme == null || !scheme.startsWith("gsiftp") && !scheme.startsWith("file") && !scheme.startsWith("http") && !scheme.startsWith("https")) {
                    throw new IllegalArgumentException("invalid argument: the URI \"" + uriValue + "\" doesn't present an allowed scheme (gsiftp, file, http, https)");
                }
                uriArray.add(uriValue);
            }
        } else {
            String uriValue = ((Constant)expression).stringValue();
            if (uriValue != null) {
                String uriValueWithoutDN = uriValue;
                if (uriValue.indexOf("?DN=") != -1) {
                    uriValueWithoutDN = CEUtils.getURIWithoutDN((String)uriValue);
                }
                URI uri = null;
                try {
                    uri = new URI(uriValueWithoutDN);
                }
                catch (URISyntaxException use) {
                    logger.error((Object)("Illegal character for the URI: " + uriValue), (Throwable)use);
                    throw new IllegalArgumentException("Illegal character for the URI: " + uriValue);
                }
                String scheme = uri.getScheme();
                if (scheme == null || !scheme.startsWith("gsiftp") && !scheme.startsWith("file") && !scheme.startsWith("http") && !scheme.startsWith("https")) {
                    throw new IllegalArgumentException("invalid argument: the URI \"" + uriValue + "\" doesn't present an allowed scheme (gsiftp, file, http, https)");
                }
                uriArray.add(uriValue);
            }
        }
        return uriArray;
    }

    private static List<String> getFiles(JobAd jab, String sb) throws IllegalArgumentException {
        if (sb == null) {
            return null;
        }
        if (jab == null) {
            throw new IllegalArgumentException("JobAd not defined!");
        }
        ArrayList<String> fileArray = new ArrayList<String>(0);
        Expr expression = jab.lookup(sb);
        if (expression == null) {
            return null;
        }
        if (expression instanceof ListExpr) {
            Iterator iter2 = ((ListExpr)expression).iterator();
            while (iter2.hasNext()) {
                String uri = ((Constant)iter2.next()).stringValue();
                fileArray.add(uri);
            }
        } else {
            String uri = ((Constant)expression).stringValue();
            fileArray.add(uri);
        }
        return fileArray;
    }

    public static Job makeJob(String jdl) throws Exception {
        if (jdl == null) {
            throw new IllegalArgumentException("JDL not defined!");
        }
        return NormalJob.makeJob(new JobAd(jdl));
    }

    private static ArrayList<OutputDataRecord> getOutputData(JobAd jab, String sb) throws IllegalArgumentException {
        if (sb == null) {
            return null;
        }
        if (jab == null) {
            throw new IllegalArgumentException("JobAd not defined!");
        }
        Expr expression = jab.lookup(sb);
        if (expression == null) {
            return null;
        }
        ArrayList<OutputDataRecord> outputDataAttribute = new ArrayList<OutputDataRecord>(0);
        if (expression instanceof ListExpr) {
            Iterator iteratorExpr = ((ListExpr)expression).iterator();
            RecordExpr jdlRecExpr = null;
            Expr exprTmp = null;
            OutputDataRecord outputDataRecord = null;
            while (iteratorExpr.hasNext()) {
                outputDataRecord = new OutputDataRecord();
                jdlRecExpr = (RecordExpr)iteratorExpr.next();
                exprTmp = jdlRecExpr.lookup("OutputFile");
                if (exprTmp == null) {
                    throw new IllegalArgumentException("OutputFile is mandatory for the OutputData jdl attribute.");
                }
                outputDataRecord.setODOutputFile(exprTmp.stringValue());
                exprTmp = jdlRecExpr.lookup("LogicalFileName");
                outputDataRecord.setODLogicalFilename(exprTmp != null ? exprTmp.stringValue() : "");
                exprTmp = jdlRecExpr.lookup("StorageElement");
                outputDataRecord.setODStorageElement(exprTmp != null ? exprTmp.stringValue() : "");
                outputDataAttribute.add(outputDataRecord);
            }
        } else {
            throw new IllegalArgumentException("Bad format for 'OutputData' jdl attribute.");
        }
        return outputDataAttribute;
    }

    public static Job makeJob(JobAd jobAd) throws Exception {
        Expr expression;
        String edg_jobid;
        String args;
        String maxOutputSandboxSize;
        String wmsHostname;
        ArrayList<OutputDataRecord> outputData;
        if (jobAd == null) {
            throw new IllegalArgumentException("JobAd not defined!");
        }
        jobAd.setLocalAccess(false);
        jobAd.checkAll(new String[]{"Executable", "QueueName", "JobType", "BatchSystem"});
        Job job = new Job();
        job.setLRMSAbsLayerJobId("N/A");
        job.setLRMSJobId("N/A");
        job.setWorkerNode("N/A");
        job.setType(NormalJob.getAttributeValue(jobAd, "JobType"));
        job.setBatchSystem(NormalJob.getAttributeValue(jobAd, "BatchSystem"));
        job.setQueue(NormalJob.getAttributeValue(jobAd, "QueueName"));
        job.setVirtualOrganization(NormalJob.getAttributeValue(jobAd, "VirtualOrganisation"));
        job.setStandardError(NormalJob.getAttributeValue(jobAd, "StdError"));
        job.setStandardInput(NormalJob.getAttributeValue(jobAd, "StdInput"));
        job.setStandardOutput(NormalJob.getAttributeValue(jobAd, "StdOutput"));
        job.setExecutable(NormalJob.getAttributeValue(jobAd, "Executable"));
        job.setCeRequirements(NormalJob.getAttributeValue(jobAd, "cerequirements"));
        job.setInputSandboxBaseURI(NormalJob.getBaseURL(jobAd, "InputSandboxBaseURI"));
        job.setOutputSandboxBaseDestURI(NormalJob.getBaseURL(jobAd, "OutputSandboxBaseDestURI"));
        job.setOutputSandboxDestURI(NormalJob.getBaseURLs(jobAd, "OutputSandboxDestURI"));
        job.setInputFiles(NormalJob.getFiles(jobAd, "InputSandbox"));
        job.setOutputFiles(NormalJob.getFiles(jobAd, "OutputSandbox"));
        job.setHlrLocation(NormalJob.getAttributeValue(jobAd, "HLRLocation"));
        job.setMyProxyServer(NormalJob.getAttributeValue(jobAd, "MyProxyServer"));
        job.setPrologue(NormalJob.getAttributeValue(jobAd, "Prologue"));
        job.setPrologueArguments(NormalJob.getAttributeValue(jobAd, "PrologueArguments"));
        job.setEpilogue(NormalJob.getAttributeValue(jobAd, "Epilogue"));
        job.setEpilogueArguments(NormalJob.getAttributeValue(jobAd, "EpilogueArguments"));
        job.setSequenceCode(NormalJob.getAttributeValue(jobAd, "LB_sequence_code"));
        job.setTokenURL(NormalJob.getAttributeValue(jobAd, "ReallyRunningToken"));
        String mwVersion = NormalJob.getAttributeValue(jobAd, "MwVersion");
        if (mwVersion != null) {
            job.addExtraAttribute("MwVersion", mwVersion);
        }
        if ((outputData = NormalJob.getOutputData(jobAd, "OutputData")) != null) {
            job.addVolatileProperty("OUTPUT_DATA", outputData);
        }
        if ((wmsHostname = NormalJob.getAttributeValue(jobAd, "WMSHostname")) != null) {
            job.addVolatileProperty("WMS_HOSTNAME", wmsHostname);
        }
        if ((maxOutputSandboxSize = NormalJob.getAttributeValue(jobAd, "MaxOutputSandboxSize")) != null) {
            job.addVolatileProperty("MAX_OUTPUT_SANDBOX_SIZE", maxOutputSandboxSize);
        }
        if (job.getOutputFiles().size() > 0) {
            if (job.getOutputSandboxBaseDestURI() != null && job.getOutputSandboxBaseDestURI().length() > 0) {
                if (job.getOutputSandboxDestURI().size() > 0) {
                    throw new Exception("the OutputSandboxDestURI and OutputSandboxBaseDestURI attributes cannot be specified together in the same JDL");
                }
            } else {
                if (job.getOutputSandboxDestURI().size() == 0) {
                    throw new Exception("the OutputSandbox attribute requires the specification in the same JDL of one of the following attributes: OutputSandboxDestURI or OutputSandboxBaseDestURI");
                }
                if (job.getOutputSandboxDestURI().size() != job.getOutputFiles().size()) {
                    throw new Exception("the OutputSandbox and OutputSandboxDestURI attributes must have the same cardinality");
                }
            }
        }
        if ((args = NormalJob.getAttributeValue(jobAd, "Arguments")) != null && args.length() > 0) {
            ArrayList<String> argsList = new ArrayList<String>(1);
            argsList.add(args);
            job.setArguments(argsList);
        }
        if ((edg_jobid = NormalJob.getAttributeValue(jobAd, "edg_jobid")) == null) {
            edg_jobid = "N/A";
        }
        job.setGridJobId(edg_jobid);
        if (job.getType() == null) {
            job.setType("normal");
        }
        if ((expression = jobAd.lookup("Environment")) != null && expression instanceof ListExpr) {
            Iterator item = ((ListExpr)expression).iterator();
            while (item.hasNext()) {
                String tmps = ((Constant)item.next()).stringValue();
                String[] tokens = tmps.split("=", 2);
                job.addEnvironmentAttribute(tokens[0].trim(), tokens[1].trim());
            }
        }
        job.setNodeNumber(1);
        expression = jobAd.lookup("CpuNumber");
        if (expression != null) {
            if (expression.type != 3 || expression.intValue() <= 0) {
                throw new Exception("wrong value for CpuNumber: it must be >=1");
            }
            job.setNodeNumber(expression.intValue());
        } else {
            expression = jobAd.lookup("NodeNumber");
            if (expression != null) {
                if (expression.type != 3 || expression.intValue() <= 0) {
                    throw new Exception("wrong value for NodeNumber: it must be >=1");
                }
                job.setNodeNumber(expression.intValue());
            }
        }
        boolean wholeNodes = false;
        expression = jobAd.lookup("WholeNodes");
        if (expression != null && expression.type == 2 && expression.isTrue()) {
            wholeNodes = true;
        }
        job.addExtraAttribute("WholeNodes", Boolean.toString(wholeNodes));
        expression = jobAd.lookup("SMPGranularity");
        if (expression != null) {
            if (expression.type != 3 || expression.intValue() <= 0) {
                throw new Exception("wrong value for SMPGranularity: it must be >=1");
            }
            job.addExtraAttribute("SMPGranularity", "" + expression.intValue());
        }
        if ((expression = jobAd.lookup("HostNumber")) != null) {
            if (expression.type != 3 || expression.intValue() <= 0) {
                throw new Exception("wrong value for HostNumber: it must be >=1");
            }
            job.addExtraAttribute("HostNumber", "" + expression.intValue());
        }
        if (!wholeNodes && job.containsExtraAttribute("SMPGranularity") && job.containsExtraAttribute("HostNumber")) {
            throw new Exception("the SMPGranularity and HostNumber attributes cannot be specified together when WholeNodes=false");
        }
        expression = jobAd.lookup("PerusalFileEnable");
        if (expression != null && expression.type == 2 && expression.isTrue()) {
            expression = jobAd.lookup("PerusalTimeInterval");
            if (expression != null && expression instanceof Constant) {
                job.setPerusalTimeInterval(expression.intValue());
            } else {
                job.setPerusalTimeInterval(5);
            }
            job.setPerusalFilesDestURI(NormalJob.getAttributeValue(jobAd, "PerusalFilesDestURI"));
            job.setPerusalListFileURI(NormalJob.getAttributeValue(jobAd, "PerusalListFileURI"));
        } else {
            job.setPerusalFilesDestURI(null);
        }
        return job;
    }
}

