/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.commonj.db.DatasourceManager;

public class DBInfoManager {
    private static final Logger logger = Logger.getLogger(DBInfoManager.class);
    public static final String NAME_TABLE = "db_info";
    public static final String VERSION_FIELD = "version";
    public static final String STORED_PROCEDURE_VERSION_FIELD = "stored_proc_version";
    public static final String CREATIONTIME_FIELD = "creationTime";
    public static final String STARTUPTIME_FIELD = "startUpTime";
    public static final String DELEGATIONSUFFIX_FIELD = "delegationSuffix";
    public static final String SUBMISSIONENABLED_FIELD = "submissionEnabled";
    private static final String selectVersionQuery = DBInfoManager.getSelectVersionQuery();
    private static final String selectCreationTimeQuery = DBInfoManager.getSelectCreationTimeQuery();
    private static final String selectDelegationSuffixQuery = DBInfoManager.getSelectDelegationSuffixQuery();
    private static final String selectSubmissionEnabledQuery = DBInfoManager.getSelectSubmissionEnabledQuery();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void updateSubmissionEnabled(String datasourceName, int submissionEnabled) throws IllegalArgumentException {
        block20: {
            PreparedStatement updatePreparedStatement;
            Connection connection;
            block18: {
                if (datasourceName == null) {
                    throw new IllegalArgumentException("datasourceName not specified!");
                }
                logger.debug((Object)("Begin updateSubmissionEnabled for " + datasourceName + " and submissionEnabled = " + submissionEnabled));
                connection = null;
                updatePreparedStatement = null;
                connection = DatasourceManager.getConnection((String)datasourceName);
                updatePreparedStatement = connection.prepareStatement(DBInfoManager.getUpdateSubmissionEnabledQuery(submissionEnabled));
                updatePreparedStatement.executeUpdate();
                connection.commit();
                logger.info((Object)("set submissionEnabled to " + submissionEnabled + " in the database"));
                Object var6_4 = null;
                if (updatePreparedStatement == null) break block18;
                try {
                    updatePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
            break block20;
            {
                catch (Exception e) {
                    logger.warn((Object)"Problem to update submissionEnabled in the database");
                    Object var6_5 = null;
                    if (updatePreparedStatement != null) {
                        try {
                            updatePreparedStatement.close();
                        }
                        catch (SQLException sqle1) {
                            logger.error((Object)sqle1);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sqle) {
                            logger.error((Object)sqle);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (updatePreparedStatement != null) {
                    try {
                        updatePreparedStatement.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
                throw throwable;
            }
        }
        logger.debug((Object)("End updateSubmissionEnabled for " + datasourceName + " and submissionEnabled = " + submissionEnabled));
    }

    /*
     * Loose catch block
     */
    public static void updateStartUpTime(String datasourceName, Calendar startUpTime) throws DatabaseException {
        block17: {
            PreparedStatement updatePreparedStatement;
            Connection connection;
            block16: {
                if (datasourceName == null) {
                    throw new IllegalArgumentException("datasourceName not specified!");
                }
                logger.debug((Object)"Begin updateStartUpTime");
                connection = null;
                updatePreparedStatement = null;
                connection = DatasourceManager.getConnection((String)datasourceName);
                updatePreparedStatement = connection.prepareStatement(DBInfoManager.getUpdateStartUpTimeQuery());
                if (startUpTime == null) {
                    updatePreparedStatement.setTimestamp(1, null);
                } else {
                    updatePreparedStatement.setTimestamp(1, new Timestamp(startUpTime.getTimeInMillis()));
                }
                updatePreparedStatement.executeUpdate();
                connection.commit();
                logger.info((Object)"set startUpTime in the database");
                Object var6_4 = null;
                if (updatePreparedStatement == null) break block16;
                try {
                    updatePreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
            break block17;
            {
                catch (Exception e) {
                    logger.warn((Object)"Problem to update the startUpTime in the database");
                    throw new DatabaseException("Problem to update the startUpTime in the database");
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (updatePreparedStatement != null) {
                    try {
                        updatePreparedStatement.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
                throw throwable;
            }
        }
        logger.debug((Object)"End updateStartUpTime");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getSubmissionEnabled(String datasourceName) throws IllegalArgumentException {
        int submissionEnabled;
        block21: {
            PreparedStatement selectPreparedStatement;
            Connection connection;
            block19: {
                block18: {
                    if (datasourceName == null) {
                        throw new IllegalArgumentException("datasourceName not specified!");
                    }
                    logger.debug((Object)("Begin getSubmissionEnabled for " + datasourceName));
                    submissionEnabled = 0;
                    connection = null;
                    selectPreparedStatement = null;
                    connection = DatasourceManager.getConnection((String)datasourceName);
                    selectPreparedStatement = connection.prepareStatement(selectSubmissionEnabledQuery);
                    ResultSet resultSet = selectPreparedStatement.executeQuery();
                    if (!resultSet.next()) break block18;
                    submissionEnabled = resultSet.getInt(SUBMISSIONENABLED_FIELD);
                }
                Object var6_6 = null;
                if (selectPreparedStatement == null) break block19;
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
            break block21;
            {
                catch (Exception e) {
                    logger.error((Object)(e.getMessage() + " It will be used the default value (=true). Submissions enabled!"));
                    submissionEnabled = 0;
                    Object var6_7 = null;
                    if (selectPreparedStatement != null) {
                        try {
                            selectPreparedStatement.close();
                        }
                        catch (SQLException sqle1) {
                            logger.error((Object)sqle1);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sqle) {
                            logger.error((Object)sqle);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (selectPreparedStatement != null) {
                    try {
                        selectPreparedStatement.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
                throw throwable;
            }
        }
        logger.info((Object)("submissionEnabled = " + submissionEnabled + " for " + datasourceName));
        logger.debug((Object)("End getSubmissionEnabled for " + datasourceName));
        return submissionEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getDelegationSuffix(String datasourceName) throws IllegalArgumentException {
        String delegationSuffix;
        block21: {
            PreparedStatement selectPreparedStatement;
            Connection connection;
            block19: {
                block18: {
                    if (datasourceName == null) {
                        throw new IllegalArgumentException("datasourceName not specified!");
                    }
                    logger.debug((Object)("Begin getDelegationSuffix for " + datasourceName));
                    delegationSuffix = null;
                    connection = null;
                    selectPreparedStatement = null;
                    connection = DatasourceManager.getConnection((String)datasourceName);
                    selectPreparedStatement = connection.prepareStatement(selectDelegationSuffixQuery);
                    ResultSet resultSet = selectPreparedStatement.executeQuery();
                    if (!resultSet.next()) break block18;
                    delegationSuffix = resultSet.getString(DELEGATIONSUFFIX_FIELD);
                }
                Object var6_6 = null;
                if (selectPreparedStatement == null) break block19;
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
            break block21;
            {
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    delegationSuffix = null;
                    Object var6_7 = null;
                    if (selectPreparedStatement != null) {
                        try {
                            selectPreparedStatement.close();
                        }
                        catch (SQLException sqle1) {
                            logger.error((Object)sqle1);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sqle) {
                            logger.error((Object)sqle);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (selectPreparedStatement != null) {
                    try {
                        selectPreparedStatement.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
                throw throwable;
            }
        }
        logger.info((Object)("delegationSuffix = " + delegationSuffix + " for " + datasourceName));
        logger.debug((Object)("End getDelegationSuffix for " + datasourceName));
        return delegationSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getDBVersion(String datasourceName) throws IllegalArgumentException {
        String dbVersion;
        block21: {
            PreparedStatement selectPreparedStatement;
            Connection connection;
            block19: {
                block18: {
                    if (datasourceName == null) {
                        throw new IllegalArgumentException("datasourceName not specified!");
                    }
                    logger.debug((Object)("Begin getDBVersion for " + datasourceName));
                    dbVersion = null;
                    connection = null;
                    selectPreparedStatement = null;
                    connection = DatasourceManager.getConnection((String)datasourceName);
                    selectPreparedStatement = connection.prepareStatement(selectVersionQuery);
                    ResultSet resultSet = selectPreparedStatement.executeQuery();
                    if (!resultSet.next()) break block18;
                    dbVersion = resultSet.getString(VERSION_FIELD);
                }
                Object var6_6 = null;
                if (selectPreparedStatement == null) break block19;
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
            break block21;
            {
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    dbVersion = null;
                    Object var6_7 = null;
                    if (selectPreparedStatement != null) {
                        try {
                            selectPreparedStatement.close();
                        }
                        catch (SQLException sqle1) {
                            logger.error((Object)sqle1);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sqle) {
                            logger.error((Object)sqle);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (selectPreparedStatement != null) {
                    try {
                        selectPreparedStatement.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
                throw throwable;
            }
        }
        logger.info((Object)("DB version = " + dbVersion + " for " + datasourceName));
        logger.debug((Object)("End getDBVersion for " + datasourceName));
        return dbVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getStoredProcedureVersion(String datasourceName) throws IllegalArgumentException {
        String storedProcedureVersion;
        block21: {
            PreparedStatement selectPreparedStatement;
            Connection connection;
            block19: {
                block18: {
                    if (datasourceName == null) {
                        throw new IllegalArgumentException("datasourceName not specified!");
                    }
                    logger.debug((Object)("Begin getStoredProcedureVersion for " + datasourceName));
                    storedProcedureVersion = null;
                    connection = null;
                    selectPreparedStatement = null;
                    connection = DatasourceManager.getConnection((String)datasourceName);
                    selectPreparedStatement = connection.prepareStatement(DBInfoManager.getSelectStoredProcedureVersionQuery());
                    ResultSet resultSet = selectPreparedStatement.executeQuery();
                    if (!resultSet.next()) break block18;
                    storedProcedureVersion = resultSet.getString(STORED_PROCEDURE_VERSION_FIELD);
                }
                Object var6_6 = null;
                if (selectPreparedStatement == null) break block19;
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
            break block21;
            {
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    storedProcedureVersion = null;
                    Object var6_7 = null;
                    if (selectPreparedStatement != null) {
                        try {
                            selectPreparedStatement.close();
                        }
                        catch (SQLException sqle1) {
                            logger.error((Object)sqle1);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sqle) {
                            logger.error((Object)sqle);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (selectPreparedStatement != null) {
                    try {
                        selectPreparedStatement.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
                throw throwable;
            }
        }
        logger.info((Object)("Stored Procedure Version = " + storedProcedureVersion + " for " + datasourceName));
        logger.debug((Object)("End getStoredProcedureVersion for " + datasourceName));
        return storedProcedureVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long getCreationTime(String datasourceName) throws IllegalArgumentException {
        long creationTime;
        block21: {
            PreparedStatement selectPreparedStatement;
            Connection connection;
            block19: {
                block18: {
                    if (datasourceName == null) {
                        throw new IllegalArgumentException("datasourceName not specified!");
                    }
                    logger.debug((Object)("Begin getCreationTime for " + datasourceName));
                    creationTime = -1L;
                    connection = null;
                    selectPreparedStatement = null;
                    connection = DatasourceManager.getConnection((String)datasourceName);
                    selectPreparedStatement = connection.prepareStatement(selectCreationTimeQuery);
                    ResultSet resultSet = selectPreparedStatement.executeQuery();
                    if (!resultSet.next()) break block18;
                    creationTime = resultSet.getTimestamp(CREATIONTIME_FIELD).getTime();
                }
                Object var7_6 = null;
                if (selectPreparedStatement == null) break block19;
                try {
                    selectPreparedStatement.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                }
            }
            break block21;
            {
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    creationTime = -1L;
                    Object var7_7 = null;
                    if (selectPreparedStatement != null) {
                        try {
                            selectPreparedStatement.close();
                        }
                        catch (SQLException sqle1) {
                            logger.error((Object)sqle1);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sqle) {
                            logger.error((Object)sqle);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (selectPreparedStatement != null) {
                    try {
                        selectPreparedStatement.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)sqle);
                    }
                }
                throw throwable;
            }
        }
        logger.info((Object)("CreationTime DB = " + creationTime + " for " + datasourceName));
        logger.debug((Object)("End getCreationTime for " + datasourceName));
        return creationTime;
    }

    private static String getUpdateStartUpTimeQuery() {
        StringBuffer updateStartUpTimeQuery = new StringBuffer();
        updateStartUpTimeQuery.append("update db_info");
        updateStartUpTimeQuery.append(" SET startUpTime = ?");
        return updateStartUpTimeQuery.toString();
    }

    private static String getUpdateSubmissionEnabledQuery(int submissionEnabled) {
        StringBuffer updateSubmissionEnabledQuery = new StringBuffer();
        updateSubmissionEnabledQuery.append("update db_info");
        updateSubmissionEnabledQuery.append(" SET submissionEnabled = " + submissionEnabled);
        logger.debug((Object)("updateSubmissionEnabledQuery = " + updateSubmissionEnabledQuery.toString()));
        return updateSubmissionEnabledQuery.toString();
    }

    private static String getSelectSubmissionEnabledQuery() {
        StringBuffer selectSubmissionEnabledQuery = new StringBuffer();
        selectSubmissionEnabledQuery.append("select submissionEnabled AS submissionEnabled");
        selectSubmissionEnabledQuery.append(" from db_info");
        logger.debug((Object)("selectSubmissionEnabledQuery = " + selectSubmissionEnabledQuery.toString()));
        return selectSubmissionEnabledQuery.toString();
    }

    private static String getSelectDelegationSuffixQuery() {
        StringBuffer selectDelegationSuffixQuery = new StringBuffer();
        selectDelegationSuffixQuery.append("select delegationSuffix AS delegationSuffix");
        selectDelegationSuffixQuery.append(" from db_info");
        logger.debug((Object)("selectDelegationSuffixQuery = " + selectDelegationSuffixQuery.toString()));
        return selectDelegationSuffixQuery.toString();
    }

    private static String getSelectVersionQuery() {
        StringBuffer selectVersionQuery = new StringBuffer();
        selectVersionQuery.append("select version AS version");
        selectVersionQuery.append(" from db_info");
        logger.debug((Object)("selectVersionQuery = " + selectVersionQuery.toString()));
        return selectVersionQuery.toString();
    }

    private static String getSelectStoredProcedureVersionQuery() {
        StringBuffer selectStoredProcedureVersionQuery = new StringBuffer();
        selectStoredProcedureVersionQuery.append("select stored_proc_version AS stored_proc_version");
        selectStoredProcedureVersionQuery.append(" from db_info");
        logger.debug((Object)("selectStoredProcedureVersionQuery = " + selectStoredProcedureVersionQuery.toString()));
        return selectStoredProcedureVersionQuery.toString();
    }

    private static String getSelectCreationTimeQuery() {
        StringBuffer selectCreationTimeQuery = new StringBuffer();
        selectCreationTimeQuery.append("select creationTime AS creationTime");
        selectCreationTimeQuery.append(" from db_info");
        logger.debug((Object)("selectCreationTimeQuery = " + selectCreationTimeQuery.toString()));
        return selectCreationTimeQuery.toString();
    }
}

